package com.ejianc.business.control.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.control.vo.ControlDetailVO;
import com.ejianc.business.control.vo.ControlDetailTwoVO;
import com.ejianc.business.control.vo.ControlDetailThreeVO;
import com.ejianc.business.control.vo.ControlDetailFourVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分包招标控制价审核表
 * 
 * @author generator
 * 
 */
public class ControlVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // billCode
    private Long projectId; // 项目名称id
    private String projectCode; // 项目名称code
    private String projectName; // 项目名称name
    private Long orgId; // orgId
    private String orgCode; // orgCode
    private String orgName; // orgName
    private Long parentOrgId; // parentOrgId
    private String parentOrgCode; // parentOrgCode
    private String parentOrgName; // parentOrgName
    private Integer billState; // billState
    private String billStateName; // billState
    private Long employeeId; // 编制人id
    private String employeeName; // 编制人name
    private Long deptId; // deptId
    private String deptName; // deptName
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date tenderTime; // 采购策划招标时间
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date planTime; // 计划招标时间
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date createDate; // 编制日期
    private String subContent; // 分包内容
    private BigDecimal taxRate; // 税率
    private BigDecimal provisionTaxMny; // 各标段含税暂估总包价
    private BigDecimal provisionMny; // 各标段无税暂估总包价(无税)
    private BigDecimal costTaxMny; // 各标段含税策划成本
    private BigDecimal costMny; // 各标段无税策划成本(无税)
    private BigDecimal controlTaxMny; // 各标段含税策划成本
    private BigDecimal controlMny; // 各标段无税策划成本(无税)
    private String description; // 项目概述
    private String character; // 项目特征
    private Integer changeState; // 变更状态
    private String changeStateName; // 变更状态
    private Long changeId; // 当前对应的变更计划Id
    private String createUserName; // 创建人名称
    private String modifyUserName; // 修改人名称
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private String changeVersion; // 变更版本
    private BigDecimal oneProvisionTaxMny; // 1标段含税暂估总包价
    private BigDecimal oneProvisionMny; // 1标段无税暂估总包价(无税)
    private BigDecimal twoProvisionTaxMny; // 2标段含税暂估总包价
    private BigDecimal twoProvisionMny; // 2标段无税暂估总包价(无税)
    private BigDecimal threeProvisionTaxMny; // 3标段含税暂估总包价
    private BigDecimal threeProvisionMny; // 3标段无税暂估总包价(无税)
    private BigDecimal fourProvisionTaxMny; // 4标段含税暂估总包价
    private BigDecimal fourProvisionMny; // 4标段无税暂估总包价(无税)
    private BigDecimal oneCostTaxMny; // 1标段含税策划成本
    private BigDecimal oneCostMny; // 1标段无税控制价(无税)
    private BigDecimal twoCostTaxMny; // 2标段含税策划成本
    private BigDecimal twoCostMny; // 2标段无税控制价(无税)
    private BigDecimal threeCostTaxMny; // 3标段含税策划成本
    private BigDecimal threeCostMny; // 3标段无税控制价(无税)
    private BigDecimal fourCostTaxMny; // 4标段含税策划成本
    private BigDecimal fourCostMny; // 4标段无税控制价(无税)
    private BigDecimal oneControlTaxMny; // 1标段含税控制价
    private BigDecimal oneControlMny; // 1标段无税控制价(无税)
    private BigDecimal twoControlTaxMny; // 2标段含税控制价
    private BigDecimal twoControlMny; // 2标段无税控制价(无税)
    private BigDecimal threeControlTaxMny; // 3标段含税控制价
    private BigDecimal threeControlMny; // 3标段无税控制价(无税)
    private BigDecimal fourControlTaxMny; // 4标段含税控制价
    private BigDecimal fourControlMny; // 4标段无税控制价(无税)
    private Integer subType; // 分包类别, 1-专业分包,2-劳务分包
    private String subTypeName; // 分包类别, 1-专业分包,2-劳务分包
    private List<ControlDetailVO> controlDetailList = new ArrayList<>(); // 分包招标控制价审核表-标段1
    private List<ControlDetailTwoVO> controlDetailTwoList = new ArrayList<>(); // 分包招标控制价审核表-标段2
    private List<ControlDetailThreeVO> controlDetailThreeList = new ArrayList<>(); // 分包招标控制价审核表-标段3
    private List<ControlDetailFourVO> controlDetailFourList = new ArrayList<>(); // 分包招标控制价审核表-标段4

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getSubTypeName() {
        return subTypeName;
    }

    public void setSubTypeName(String subTypeName) {
        this.subTypeName = subTypeName;
    }

    public BigDecimal getOneProvisionTaxMny() {
        return oneProvisionTaxMny;
    }

    public void setOneProvisionTaxMny(BigDecimal oneProvisionTaxMny) {
        this.oneProvisionTaxMny = oneProvisionTaxMny;
    }

    public BigDecimal getOneProvisionMny() {
        return oneProvisionMny;
    }

    public void setOneProvisionMny(BigDecimal oneProvisionMny) {
        this.oneProvisionMny = oneProvisionMny;
    }

    public BigDecimal getTwoProvisionTaxMny() {
        return twoProvisionTaxMny;
    }

    public void setTwoProvisionTaxMny(BigDecimal twoProvisionTaxMny) {
        this.twoProvisionTaxMny = twoProvisionTaxMny;
    }

    public BigDecimal getTwoProvisionMny() {
        return twoProvisionMny;
    }

    public void setTwoProvisionMny(BigDecimal twoProvisionMny) {
        this.twoProvisionMny = twoProvisionMny;
    }

    public BigDecimal getThreeProvisionTaxMny() {
        return threeProvisionTaxMny;
    }

    public void setThreeProvisionTaxMny(BigDecimal threeProvisionTaxMny) {
        this.threeProvisionTaxMny = threeProvisionTaxMny;
    }

    public BigDecimal getThreeProvisionMny() {
        return threeProvisionMny;
    }

    public void setThreeProvisionMny(BigDecimal threeProvisionMny) {
        this.threeProvisionMny = threeProvisionMny;
    }

    public BigDecimal getFourProvisionTaxMny() {
        return fourProvisionTaxMny;
    }

    public void setFourProvisionTaxMny(BigDecimal fourProvisionTaxMny) {
        this.fourProvisionTaxMny = fourProvisionTaxMny;
    }

    public BigDecimal getFourProvisionMny() {
        return fourProvisionMny;
    }

    public void setFourProvisionMny(BigDecimal fourProvisionMny) {
        this.fourProvisionMny = fourProvisionMny;
    }

    public BigDecimal getOneCostTaxMny() {
        return oneCostTaxMny;
    }

    public void setOneCostTaxMny(BigDecimal oneCostTaxMny) {
        this.oneCostTaxMny = oneCostTaxMny;
    }

    public BigDecimal getOneCostMny() {
        return oneCostMny;
    }

    public void setOneCostMny(BigDecimal oneCostMny) {
        this.oneCostMny = oneCostMny;
    }

    public BigDecimal getTwoCostTaxMny() {
        return twoCostTaxMny;
    }

    public void setTwoCostTaxMny(BigDecimal twoCostTaxMny) {
        this.twoCostTaxMny = twoCostTaxMny;
    }

    public BigDecimal getTwoCostMny() {
        return twoCostMny;
    }

    public void setTwoCostMny(BigDecimal twoCostMny) {
        this.twoCostMny = twoCostMny;
    }

    public BigDecimal getThreeCostTaxMny() {
        return threeCostTaxMny;
    }

    public void setThreeCostTaxMny(BigDecimal threeCostTaxMny) {
        this.threeCostTaxMny = threeCostTaxMny;
    }

    public BigDecimal getThreeCostMny() {
        return threeCostMny;
    }

    public void setThreeCostMny(BigDecimal threeCostMny) {
        this.threeCostMny = threeCostMny;
    }

    public BigDecimal getFourCostTaxMny() {
        return fourCostTaxMny;
    }

    public void setFourCostTaxMny(BigDecimal fourCostTaxMny) {
        this.fourCostTaxMny = fourCostTaxMny;
    }

    public BigDecimal getFourCostMny() {
        return fourCostMny;
    }

    public void setFourCostMny(BigDecimal fourCostMny) {
        this.fourCostMny = fourCostMny;
    }

    public BigDecimal getOneControlTaxMny() {
        return oneControlTaxMny;
    }

    public void setOneControlTaxMny(BigDecimal oneControlTaxMny) {
        this.oneControlTaxMny = oneControlTaxMny;
    }

    public BigDecimal getOneControlMny() {
        return oneControlMny;
    }

    public void setOneControlMny(BigDecimal oneControlMny) {
        this.oneControlMny = oneControlMny;
    }

    public BigDecimal getTwoControlTaxMny() {
        return twoControlTaxMny;
    }

    public void setTwoControlTaxMny(BigDecimal twoControlTaxMny) {
        this.twoControlTaxMny = twoControlTaxMny;
    }

    public BigDecimal getTwoControlMny() {
        return twoControlMny;
    }

    public void setTwoControlMny(BigDecimal twoControlMny) {
        this.twoControlMny = twoControlMny;
    }

    public BigDecimal getThreeControlTaxMny() {
        return threeControlTaxMny;
    }

    public void setThreeControlTaxMny(BigDecimal threeControlTaxMny) {
        this.threeControlTaxMny = threeControlTaxMny;
    }

    public BigDecimal getThreeControlMny() {
        return threeControlMny;
    }

    public void setThreeControlMny(BigDecimal threeControlMny) {
        this.threeControlMny = threeControlMny;
    }

    public BigDecimal getFourControlTaxMny() {
        return fourControlTaxMny;
    }

    public void setFourControlTaxMny(BigDecimal fourControlTaxMny) {
        this.fourControlTaxMny = fourControlTaxMny;
    }

    public BigDecimal getFourControlMny() {
        return fourControlMny;
    }

    public void setFourControlMny(BigDecimal fourControlMny) {
        this.fourControlMny = fourControlMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getTenderTime() {
        return tenderTime;
    }

    public void setTenderTime(Date tenderTime) {
        this.tenderTime = tenderTime;
    }
    public Date getPlanTime() {
        return planTime;
    }

    public void setPlanTime(Date planTime) {
        this.planTime = planTime;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getProvisionTaxMny() {
        return provisionTaxMny;
    }

    public void setProvisionTaxMny(BigDecimal provisionTaxMny) {
        this.provisionTaxMny = provisionTaxMny;
    }
    public BigDecimal getProvisionMny() {
        return provisionMny;
    }

    public void setProvisionMny(BigDecimal provisionMny) {
        this.provisionMny = provisionMny;
    }
    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getControlTaxMny() {
        return controlTaxMny;
    }

    public void setControlTaxMny(BigDecimal controlTaxMny) {
        this.controlTaxMny = controlTaxMny;
    }
    public BigDecimal getControlMny() {
        return controlMny;
    }

    public void setControlMny(BigDecimal controlMny) {
        this.controlMny = controlMny;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getCharacter() {
        return character;
    }

    public void setCharacter(String character) {
        this.character = character;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(String changeVersion) {
        this.changeVersion = changeVersion;
    }
    
     public List<ControlDetailVO> getControlDetailList() {
        return controlDetailList;
     }

     public void setControlDetailList(List<ControlDetailVO> controlDetailList) {
        this.controlDetailList = controlDetailList;
     }
     public List<ControlDetailTwoVO> getControlDetailTwoList() {
        return controlDetailTwoList;
     }

     public void setControlDetailTwoList(List<ControlDetailTwoVO> controlDetailTwoList) {
        this.controlDetailTwoList = controlDetailTwoList;
     }
     public List<ControlDetailThreeVO> getControlDetailThreeList() {
        return controlDetailThreeList;
     }

     public void setControlDetailThreeList(List<ControlDetailThreeVO> controlDetailThreeList) {
        this.controlDetailThreeList = controlDetailThreeList;
     }
     public List<ControlDetailFourVO> getControlDetailFourList() {
        return controlDetailFourList;
     }

     public void setControlDetailFourList(List<ControlDetailFourVO> controlDetailFourList) {
        this.controlDetailFourList = controlDetailFourList;
     }
}
