package com.ejianc.business.settle.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.business.prosub.settlePayment.SettlePaymentVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 结算主实体
 *
 * @author generator
 */
public class SettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 乙方签字状态：未签字
     */
    public static final Integer SUP_UNSIGN_STATUS = 0;

    /**
     * 乙方签字状态：已签字
     */
    public static final Integer SUP_HAS_SIGNED_STATUS = 1;

    /**
     * 制单人Id
     */
    private Long createUserId;
    @ConvertField(targetField = "billCode")
    private String billCode; // 单据编码
    @ConvertField(targetField = "billState")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @ConvertField(targetField = "billStateName")
    private String billStateName; // 单据状态名称
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    private String commitUserCode; // 提交人账号
    private String commitUserName; // 提交人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private Date effectiveDate; // 生效日期
    @ConvertField(targetField = "orgId")
    private Long orgId; // 项目部id
    @ConvertField(targetField = "orgCode")
    private String orgCode; // 项目部编码
    @ConvertField(targetField = "orgName")
    private String orgName; // 项目部名称
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId; // 项目部所属组织id
    @ConvertField(targetField = "parentOrgCode")
    private String parentOrgCode; // 项目部所属组织编码
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName; // 项目部所属组织名称
    @ConvertField(targetField = "contractId")
    private Long contractId; // 合同id
    @ConvertField(targetField = "contractName")
    private String contractName; // 合同名称
    @ConvertField(targetField = "contractCode")
    private String contractCode; // 合同编码
//    @ConvertField
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @ConvertField(targetField = "supplementFlag")
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    @ConvertField(targetField = "projectId")
    private Long projectId; // 项目Id
    @ConvertField(targetField = "projectName")
    private String projectName; // 项目名称
    @ConvertField(targetField = "projectCode")
    private String projectCode; // 项目编号
    @ConvertField(targetField = "partyaId")
    private Long firstPartyId;// 甲方Id
    @ConvertField(targetField = "partyaName")
    private String firstPartyName;// 甲方名称
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 乙方id
    @ConvertField(targetField = "partybName")
    private String supplierName; // 乙方名称
    private Integer supplierSignStatus; // 乙方签字状态:已签字-1,未签字-0
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lastSettleDate; // 上次结算日期
    @ConvertField(targetField = "settleDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期：默认显示当天,必须大于该合同的最近一次生效的结算日期（含过程结算、节点结算）；
    @ConvertField(targetField = "employeeId")
    private Long employeeId; // 经办人id
    @ConvertField(targetField = "employeeName")
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long departmentId; // 经办部门id
    @ConvertField(targetField = "departmentName")
    private String departmentName; // 经办部门名称
    @ConvertField(targetField = "memo")
    private String memo; // 非必填，0-300字
    private String signStatusName; // 签字状态名称
    private Integer signatureStatus; // 签章状态：1-未签章、2-待乙方签章、3-待甲方签章、4-已签章
    private String signatureStatusName; // 签章状态名称
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal taxMny; // 本期结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额
    @ConvertField(targetField = "curMny")
    private BigDecimal mny; // 本期结算金额(无税)
    @ConvertField(targetField = "curTax")
    private BigDecimal tax; // 本期结算税额
    private BigDecimal detailTaxMny; // 分包清单金额
    private BigDecimal detailMny; // 分包清单金额(无税)
    private BigDecimal detailTax; // 分包清单税额
    private BigDecimal pickingTaxMny; // 领料扣款金额
    private BigDecimal pickingMny; // 领料扣款金额(无税)
    private BigDecimal pickingTax; // 领料扣款税额
    private BigDecimal oddjobTaxMny; // 零工金额金额
    private BigDecimal oddjobMny; // 零工金额金额(无税)
    private BigDecimal oddjobTax; // 零工金额税额
    private BigDecimal deductTaxMny; // 奖罚扣款单金额
    private BigDecimal deductMny; // 奖罚扣款单金额(无税)
    private BigDecimal deductTax; // 奖罚扣款单税额
    private BigDecimal otherTaxMny; // 其他金额
    private BigDecimal otherMny; // 其他金额(无税)
    private BigDecimal otherTax; // 其他税额
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal salaryMny; // 工人工资金额
    private BigDecimal totalTaxMny; // 累计过程结算金额
    private BigDecimal totalMny; // 累计过程结算金额(无税)
    private BigDecimal lastTaxMny; // 不含本期累计过程结算金额
    private BigDecimal lastMny; // 不含本期累计过程结算金额(无税)
    private BigDecimal contractPayMny; // 合同已付金额
    private BigDecimal contractBillTaxMny; // 合同收票金额
    private BigDecimal contractBillMny; // 合同收票金额(无税)
    private BigDecimal pickingProcessTaxMny; // 领料过程结算金额
    private BigDecimal pickingProcessMny; // 领料过程结算金额（无税）
    private BigDecimal pickingCurrentTaxMny; // 领料本期结算金额
    private BigDecimal pickingCurrentMny; // 领料本期结算金额（无税）
    private BigDecimal oddjobProcessTaxMny; // 零工登记过程结算金额
    private BigDecimal oddjobProcessMny; // 零工登记过程结算金额（无税）
    private BigDecimal oddjobCurrentTaxMny; // 零工登记本期结算金额
    private BigDecimal oddjobCurrentMny; // 零工登记本期结算金额（无税）
    private BigDecimal deductProcessTaxMny; // 奖罚扣款单过程结算金额
    private BigDecimal deductProcessMny; // 奖罚扣款单过程结算金额（无税）
    private BigDecimal deductCurrentTaxMny; // 奖罚扣款单本期结算金额
    private BigDecimal deductCurrentMny; // 奖罚扣款单本期结算金额（无税）
    private BigDecimal otherProcessTaxMny; // 其他过程结算金额
    private BigDecimal otherProcessMny; // 其他过程结算金额（无税）
    private BigDecimal otherCurrentTaxMny; // 其他本期结算金额
    private BigDecimal otherCurrentMny; // 其他本期结算金额（无税）
    @ConvertField(targetField = "totalProcessTaxMny")
    private BigDecimal totalProcessTaxMny; // 完工用累计过程结算金额
    @ConvertField(targetField = "totalProcessMny")
    private BigDecimal totalProcessMny; // 完工用过程结算金额(无税)

    @ConvertField(targetField = "totalProcessTaxDifference")
    private BigDecimal totalProcessTaxDifference; // 过程结算差额
    @ConvertField(targetField = "totalProcessDifference")
    private BigDecimal totalProcessDifference; // 过程结算差额（无税）
    @ConvertField(targetField = "totalNodeTaxMny")
    private BigDecimal totalNodeTaxMny; // 累计节点结算金额
    @ConvertField(targetField = "totalNodeMny")
    private BigDecimal totalNodeMny; // 累计节点结算金额(无税)
    private BigDecimal lastNodeTaxMny; // 不含本期累计节点结算金额
    private BigDecimal lastNodeMny; // 不含本期累计节点结算金额(无税)
    @ConvertField(targetField = "totalNodeTaxDifference")
    private BigDecimal totalNodeTaxDifference; // 节点结算差额
    @ConvertField(targetField = "totalNodeDifference")
    private BigDecimal totalNodeDifference; // 节点结算差额（无税）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date minSettleDate; //最小可用结算日期
    private BigDecimal artificialTaxMny; // 人工费金额（含税）
    private Integer settleTimes; // 累计结算次数
    private String contractSettleNum; // 合同结算次数（节点结算使用字段）

    private List<SettleDeductVO> settleDeductList = new ArrayList<>(); // 结算子表-奖罚扣款单
    private List<SettleDetailVO> settleDetailList = new ArrayList<>(); // 结算子表-分包清单
    private List<SettleOddjobVO> settleOddjobList = new ArrayList<>(); // 结算子表-零工登记
    private List<SettleOtherVO> settleOtherList = new ArrayList<>(); // 结算子表-其他费用
    private List<SettlePickingVO> settlePickingList = new ArrayList<>(); // 结算子表-领料结算
    private List<SettleSalaryVO> settleSalaryList = new ArrayList<>(); // 结算子表-工人工资单
    private List<SettlePriceVO> settlePriceList = new ArrayList<>(); // 结算子表-价格调整及增补
    private List<SettleProgressVO> settleProgressList = new ArrayList<>();// 结算子表-形象进度

    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    private Long supOperateFileId;

    /**
     * 来源业务系统id
     */
    private String sourceSystemId;

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;

    /**
     * 推送结算池标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String pushPoolFlag;


    /**
     * 合同高亮附件路径
     */
    private String contractFileHighlightPath;

    /**
     * 合同高亮附件Id
     */
    private Long contractFileHighlightId;

    /**
     * 合同附件路径
     */
    private String contractFilePath;

    /**
     * 合同附件Id
     */
    private Long contractFileId;


    private String relationFlag; // 关联状态(1:是，0：否)
    private String proportionFlag; // 分摊状态(1:是，0：否)
    private BigDecimal pushCostTaxMny;//推送成本金额
    private BigDecimal pushCostMny;//推送成本金额（无税）
    private BigDecimal pushCostTax;//推送成本金额税额

    private BigDecimal settlePaymentTaxMny; // 本期结算支付金额（含税）
    private BigDecimal settlePaymentMny; // 本期结算支付金额（无税）
    private BigDecimal totalSettlePaymentTaxMny;//累计结算支付金额（含税）
    private BigDecimal totalSettlePaymentMny;//累计结算支付金额（无税）
    private BigDecimal totalDetailSettlePaymentTaxMny;//清单中本期结算支付金额之和（含税）
    private BigDecimal totalDetailSettlePaymentMny;//清单中本期结算支付金额之和（无税）
    private List<SettlePaymentVO> settlePaymentList;//结算支付比例确认单列表
    private List<ShareDetailVO> shareDetailList;//结算支付比例确认单列表



    @ConvertField(targetField = "sourceId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    @ConvertField
    private Integer filingStatus;//是否归档 1：是；0：否

    /**
     * 财务组织
     */
    private Long financialOrgId;
    /**
     * 财务组织name
     */
    private String financialOrgName;
    /**
     * 财务组织code
     */
    private String financialOrgCode;
    /**
     * 合同类型
     */
    private Long categoryTypeId;
    /**
     * 合同类型
     */
    private String categoryTypeName;
    /**
     * 是否传会计平台 1：是； 0：否
     */
    private Integer financialCrossFlag;
    /**
     * 是否简易征收 1：是； 0：否
     */
    private Integer levyFlag;;
    /**
     * 凭证号
     */
    private String financialNumber;

    // 华泰增加字段
    private BigDecimal totalApproveTaxMny; // 上期累计审批金额
    private BigDecimal totalApproveMny; // 上期累计审批金额(无税)
    private BigDecimal approveTaxMny; // 本期申报金额
    private BigDecimal approveMny; // 本期申报金额(无税)
    private BigDecimal projectApproveTaxMny; // (项目部)本期审批金额
    private BigDecimal projectApproveMny; // (项目部)本期审批金额(无税)
    private BigDecimal totalProjectApproveTaxMny; // (项目部)本期累计审批金额
    private BigDecimal totalProjectApproveMny; // (项目部)本期累计审批金额(无税)

    private BigDecimal corpApproveTaxMny; // (分公司)本期审批金额
    private BigDecimal corpApproveMny; // (分公司)本期审批金额(无税)
    private BigDecimal totalCorpApproveTaxMny; // (分公司)本期累计审批金额
    private BigDecimal totalCorpApproveMny; // (分公司)本期累计审批金额(无税)
    private BigDecimal totalCompletionRate; // 累计完成率

    public Date getLastSettleDate() {
        return lastSettleDate;
    }

    public void setLastSettleDate(Date lastSettleDate) {
        this.lastSettleDate = lastSettleDate;
    }

    public List<SettleProgressVO> getSettleProgressList() {
        return settleProgressList;
    }

    public void setSettleProgressList(List<SettleProgressVO> settleProgressList) {
        this.settleProgressList = settleProgressList;
    }

    public BigDecimal getTotalApproveTaxMny() {
        return totalApproveTaxMny;
    }

    public void setTotalApproveTaxMny(BigDecimal totalApproveTaxMny) {
        this.totalApproveTaxMny = totalApproveTaxMny;
    }

    public BigDecimal getTotalApproveMny() {
        return totalApproveMny;
    }

    public void setTotalApproveMny(BigDecimal totalApproveMny) {
        this.totalApproveMny = totalApproveMny;
    }

    public BigDecimal getApproveTaxMny() {
        return approveTaxMny;
    }

    public void setApproveTaxMny(BigDecimal approveTaxMny) {
        this.approveTaxMny = approveTaxMny;
    }

    public BigDecimal getApproveMny() {
        return approveMny;
    }

    public void setApproveMny(BigDecimal approveMny) {
        this.approveMny = approveMny;
    }

    public BigDecimal getProjectApproveTaxMny() {
        return projectApproveTaxMny;
    }

    public void setProjectApproveTaxMny(BigDecimal projectApproveTaxMny) {
        this.projectApproveTaxMny = projectApproveTaxMny;
    }

    public BigDecimal getProjectApproveMny() {
        return projectApproveMny;
    }

    public void setProjectApproveMny(BigDecimal projectApproveMny) {
        this.projectApproveMny = projectApproveMny;
    }

    public BigDecimal getTotalProjectApproveTaxMny() {
        return totalProjectApproveTaxMny;
    }

    public void setTotalProjectApproveTaxMny(BigDecimal totalProjectApproveTaxMny) {
        this.totalProjectApproveTaxMny = totalProjectApproveTaxMny;
    }

    public BigDecimal getTotalProjectApproveMny() {
        return totalProjectApproveMny;
    }

    public void setTotalProjectApproveMny(BigDecimal totalProjectApproveMny) {
        this.totalProjectApproveMny = totalProjectApproveMny;
    }

    public BigDecimal getCorpApproveTaxMny() {
        return corpApproveTaxMny;
    }

    public void setCorpApproveTaxMny(BigDecimal corpApproveTaxMny) {
        this.corpApproveTaxMny = corpApproveTaxMny;
    }

    public BigDecimal getCorpApproveMny() {
        return corpApproveMny;
    }

    public void setCorpApproveMny(BigDecimal corpApproveMny) {
        this.corpApproveMny = corpApproveMny;
    }

    public BigDecimal getTotalCorpApproveTaxMny() {
        return totalCorpApproveTaxMny;
    }

    public void setTotalCorpApproveTaxMny(BigDecimal totalCorpApproveTaxMny) {
        this.totalCorpApproveTaxMny = totalCorpApproveTaxMny;
    }

    public BigDecimal getTotalCorpApproveMny() {
        return totalCorpApproveMny;
    }

    public void setTotalCorpApproveMny(BigDecimal totalCorpApproveMny) {
        this.totalCorpApproveMny = totalCorpApproveMny;
    }

    public BigDecimal getTotalCompletionRate() {
        return totalCompletionRate;
    }

    public void setTotalCompletionRate(BigDecimal totalCompletionRate) {
        this.totalCompletionRate = totalCompletionRate;
    }

    public Long getFinancialOrgId() {
        return financialOrgId;
    }
    @ReferDeserialTransfer
    public void setFinancialOrgId(Long financialOrgId) {
        this.financialOrgId = financialOrgId;
    }

    public String getFinancialOrgName() {
        return financialOrgName;
    }

    public void setFinancialOrgName(String financialOrgName) {
        this.financialOrgName = financialOrgName;
    }

    public String getFinancialOrgCode() {
        return financialOrgCode;
    }

    public void setFinancialOrgCode(String financialOrgCode) {
        this.financialOrgCode = financialOrgCode;
    }

    public Long getCategoryTypeId() {
        return categoryTypeId;
    }
    @ReferDeserialTransfer
    public void setCategoryTypeId(Long categoryTypeId) {
        this.categoryTypeId = categoryTypeId;
    }

    public String getCategoryTypeName() {
        return categoryTypeName;
    }

    public void setCategoryTypeName(String categoryTypeName) {
        this.categoryTypeName = categoryTypeName;
    }

    public Integer getFinancialCrossFlag() {
        return financialCrossFlag;
    }

    public void setFinancialCrossFlag(Integer financialCrossFlag) {
        this.financialCrossFlag = financialCrossFlag;
    }

    public Integer getLevyFlag() {
        return levyFlag;
    }

    public void setLevyFlag(Integer levyFlag) {
        this.levyFlag = levyFlag;;
    }

    public String getFinancialNumber() {
        return financialNumber;
    }

    public void setFinancialNumber(String financialNumber) {
        this.financialNumber = financialNumber;
    }


    public List<ShareDetailVO> getShareDetailList() {
        return shareDetailList;
    }

    public void setShareDetailList(List<ShareDetailVO> shareDetailList) {
        this.shareDetailList = shareDetailList;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }
    @Override
    public Long getId() {
        return id;
    }

    public BigDecimal getPushCostTaxMny() {
        return pushCostTaxMny;
    }

    public void setPushCostTaxMny(BigDecimal pushCostTaxMny) {
        this.pushCostTaxMny = pushCostTaxMny;
    }

    public BigDecimal getPushCostMny() {
        return pushCostMny;
    }

    public void setPushCostMny(BigDecimal pushCostMny) {
        this.pushCostMny = pushCostMny;
    }

    public BigDecimal getPushCostTax() {
        return pushCostTax;
    }

    public void setPushCostTax(BigDecimal pushCostTax) {
        this.pushCostTax = pushCostTax;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    /***  协同需要字段 END  ***/

    /**
     * 完成签章附件Id
     */
    private Long signedFileId;

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getSignatureStatusName() {
        return signatureStatusName;
    }

    public void setSignatureStatusName(String signatureStatusName) {
        this.signatureStatusName = signatureStatusName;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getPickingTaxMny() {
        return pickingTaxMny;
    }

    public void setPickingTaxMny(BigDecimal pickingTaxMny) {
        this.pickingTaxMny = pickingTaxMny;
    }

    public BigDecimal getPickingMny() {
        return pickingMny;
    }

    public void setPickingMny(BigDecimal pickingMny) {
        this.pickingMny = pickingMny;
    }

    public BigDecimal getPickingTax() {
        return pickingTax;
    }

    public void setPickingTax(BigDecimal pickingTax) {
        this.pickingTax = pickingTax;
    }

    public BigDecimal getOddjobTaxMny() {
        return oddjobTaxMny;
    }

    public void setOddjobTaxMny(BigDecimal oddjobTaxMny) {
        this.oddjobTaxMny = oddjobTaxMny;
    }

    public BigDecimal getOddjobMny() {
        return oddjobMny;
    }

    public void setOddjobMny(BigDecimal oddjobMny) {
        this.oddjobMny = oddjobMny;
    }

    public BigDecimal getOddjobTax() {
        return oddjobTax;
    }

    public void setOddjobTax(BigDecimal oddjobTax) {
        this.oddjobTax = oddjobTax;
    }

    public BigDecimal getDeductTaxMny() {
        return deductTaxMny;
    }

    public void setDeductTaxMny(BigDecimal deductTaxMny) {
        this.deductTaxMny = deductTaxMny;
    }

    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }

    public BigDecimal getDeductTax() {
        return deductTax;
    }

    public void setDeductTax(BigDecimal deductTax) {
        this.deductTax = deductTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getSalaryMny() {
        return salaryMny;
    }

    public void setSalaryMny(BigDecimal salaryMny) {
        this.salaryMny = salaryMny;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getLastTaxMny() {
        return lastTaxMny;
    }

    public void setLastTaxMny(BigDecimal lastTaxMny) {
        this.lastTaxMny = lastTaxMny;
    }

    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }

    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }

    public BigDecimal getContractBillTaxMny() {
        return contractBillTaxMny;
    }

    public void setContractBillTaxMny(BigDecimal contractBillTaxMny) {
        this.contractBillTaxMny = contractBillTaxMny;
    }

    public BigDecimal getContractBillMny() {
        return contractBillMny;
    }

    public void setContractBillMny(BigDecimal contractBillMny) {
        this.contractBillMny = contractBillMny;
    }

    public BigDecimal getPickingProcessTaxMny() {
        return pickingProcessTaxMny;
    }

    public void setPickingProcessTaxMny(BigDecimal pickingProcessTaxMny) {
        this.pickingProcessTaxMny = pickingProcessTaxMny;
    }

    public BigDecimal getPickingProcessMny() {
        return pickingProcessMny;
    }

    public void setPickingProcessMny(BigDecimal pickingProcessMny) {
        this.pickingProcessMny = pickingProcessMny;
    }

    public BigDecimal getPickingCurrentTaxMny() {
        return pickingCurrentTaxMny;
    }

    public void setPickingCurrentTaxMny(BigDecimal pickingCurrentTaxMny) {
        this.pickingCurrentTaxMny = pickingCurrentTaxMny;
    }

    public BigDecimal getPickingCurrentMny() {
        return pickingCurrentMny;
    }

    public void setPickingCurrentMny(BigDecimal pickingCurrentMny) {
        this.pickingCurrentMny = pickingCurrentMny;
    }

    public BigDecimal getOddjobProcessTaxMny() {
        return oddjobProcessTaxMny;
    }

    public void setOddjobProcessTaxMny(BigDecimal oddjobProcessTaxMny) {
        this.oddjobProcessTaxMny = oddjobProcessTaxMny;
    }

    public BigDecimal getOddjobProcessMny() {
        return oddjobProcessMny;
    }

    public void setOddjobProcessMny(BigDecimal oddjobProcessMny) {
        this.oddjobProcessMny = oddjobProcessMny;
    }

    public BigDecimal getOddjobCurrentTaxMny() {
        return oddjobCurrentTaxMny;
    }

    public void setOddjobCurrentTaxMny(BigDecimal oddjobCurrentTaxMny) {
        this.oddjobCurrentTaxMny = oddjobCurrentTaxMny;
    }

    public BigDecimal getOddjobCurrentMny() {
        return oddjobCurrentMny;
    }

    public void setOddjobCurrentMny(BigDecimal oddjobCurrentMny) {
        this.oddjobCurrentMny = oddjobCurrentMny;
    }

    public BigDecimal getDeductProcessTaxMny() {
        return deductProcessTaxMny;
    }

    public void setDeductProcessTaxMny(BigDecimal deductProcessTaxMny) {
        this.deductProcessTaxMny = deductProcessTaxMny;
    }

    public BigDecimal getDeductProcessMny() {
        return deductProcessMny;
    }

    public void setDeductProcessMny(BigDecimal deductProcessMny) {
        this.deductProcessMny = deductProcessMny;
    }

    public BigDecimal getDeductCurrentTaxMny() {
        return deductCurrentTaxMny;
    }

    public void setDeductCurrentTaxMny(BigDecimal deductCurrentTaxMny) {
        this.deductCurrentTaxMny = deductCurrentTaxMny;
    }

    public BigDecimal getDeductCurrentMny() {
        return deductCurrentMny;
    }

    public void setDeductCurrentMny(BigDecimal deductCurrentMny) {
        this.deductCurrentMny = deductCurrentMny;
    }

    public BigDecimal getOtherProcessTaxMny() {
        return otherProcessTaxMny;
    }

    public void setOtherProcessTaxMny(BigDecimal otherProcessTaxMny) {
        this.otherProcessTaxMny = otherProcessTaxMny;
    }

    public BigDecimal getOtherProcessMny() {
        return otherProcessMny;
    }

    public void setOtherProcessMny(BigDecimal otherProcessMny) {
        this.otherProcessMny = otherProcessMny;
    }

    public BigDecimal getOtherCurrentTaxMny() {
        return otherCurrentTaxMny;
    }

    public void setOtherCurrentTaxMny(BigDecimal otherCurrentTaxMny) {
        this.otherCurrentTaxMny = otherCurrentTaxMny;
    }

    public BigDecimal getOtherCurrentMny() {
        return otherCurrentMny;
    }

    public void setOtherCurrentMny(BigDecimal otherCurrentMny) {
        this.otherCurrentMny = otherCurrentMny;
    }

    public BigDecimal getTotalProcessTaxMny() {
        return totalProcessTaxMny;
    }

    public void setTotalProcessTaxMny(BigDecimal totalProcessTaxMny) {
        this.totalProcessTaxMny = totalProcessTaxMny;
    }

    public BigDecimal getTotalProcessMny() {
        return totalProcessMny;
    }

    public void setTotalProcessMny(BigDecimal totalProcessMny) {
        this.totalProcessMny = totalProcessMny;
    }

    public BigDecimal getTotalProcessTaxDifference() {
        return totalProcessTaxDifference;
    }

    public void setTotalProcessTaxDifference(BigDecimal totalProcessTaxDifference) {
        this.totalProcessTaxDifference = totalProcessTaxDifference;
    }

    public BigDecimal getTotalProcessDifference() {
        return totalProcessDifference;
    }

    public void setTotalProcessDifference(BigDecimal totalProcessDifference) {
        this.totalProcessDifference = totalProcessDifference;
    }

    public BigDecimal getTotalNodeTaxMny() {
        return totalNodeTaxMny;
    }

    public void setTotalNodeTaxMny(BigDecimal totalNodeTaxMny) {
        this.totalNodeTaxMny = totalNodeTaxMny;
    }

    public BigDecimal getTotalNodeMny() {
        return totalNodeMny;
    }

    public void setTotalNodeMny(BigDecimal totalNodeMny) {
        this.totalNodeMny = totalNodeMny;
    }

    public BigDecimal getLastNodeTaxMny() {
        return lastNodeTaxMny;
    }

    public void setLastNodeTaxMny(BigDecimal lastNodeTaxMny) {
        this.lastNodeTaxMny = lastNodeTaxMny;
    }

    public BigDecimal getLastNodeMny() {
        return lastNodeMny;
    }

    public void setLastNodeMny(BigDecimal lastNodeMny) {
        this.lastNodeMny = lastNodeMny;
    }

    public BigDecimal getTotalNodeTaxDifference() {
        return totalNodeTaxDifference;
    }

    public void setTotalNodeTaxDifference(BigDecimal totalNodeTaxDifference) {
        this.totalNodeTaxDifference = totalNodeTaxDifference;
    }

    public BigDecimal getTotalNodeDifference() {
        return totalNodeDifference;
    }

    public void setTotalNodeDifference(BigDecimal totalNodeDifference) {
        this.totalNodeDifference = totalNodeDifference;
    }

    public Date getMinSettleDate() {
        return minSettleDate;
    }

    public void setMinSettleDate(Date minSettleDate) {
        this.minSettleDate = minSettleDate;
    }

    public List<SettleDeductVO> getSettleDeductList() {
        return settleDeductList;
    }

    public void setSettleDeductList(List<SettleDeductVO> settleDeductList) {
        this.settleDeductList = settleDeductList;
    }

    public List<SettleDetailVO> getSettleDetailList() {
        return settleDetailList;
    }

    public void setSettleDetailList(List<SettleDetailVO> settleDetailList) {
        this.settleDetailList = settleDetailList;
    }

    public List<SettleOddjobVO> getSettleOddjobList() {
        return settleOddjobList;
    }

    public void setSettleOddjobList(List<SettleOddjobVO> settleOddjobList) {
        this.settleOddjobList = settleOddjobList;
    }

    public List<SettleOtherVO> getSettleOtherList() {
        return settleOtherList;
    }

    public void setSettleOtherList(List<SettleOtherVO> settleOtherList) {
        this.settleOtherList = settleOtherList;
    }

    public List<SettlePickingVO> getSettlePickingList() {
        return settlePickingList;
    }

    public void setSettlePickingList(List<SettlePickingVO> settlePickingList) {
        this.settlePickingList = settlePickingList;
    }

    public List<SettleSalaryVO> getSettleSalaryList() {
        return settleSalaryList;
    }

    public void setSettleSalaryList(List<SettleSalaryVO> settleSalaryList) {
        this.settleSalaryList = settleSalaryList;
    }

    public List<SettlePriceVO> getSettlePriceList() {
        return settlePriceList;
    }

    public void setSettlePriceList(List<SettlePriceVO> settlePriceList) {
        this.settlePriceList = settlePriceList;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public BigDecimal getArtificialTaxMny() {
        return artificialTaxMny;
    }

    public void setArtificialTaxMny(BigDecimal artificialTaxMny) {
        this.artificialTaxMny = artificialTaxMny;
    }

    public Integer getSettleTimes() {
        return settleTimes;
    }

    public void setSettleTimes(Integer settleTimes) {
        this.settleTimes = settleTimes;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getSettlePaymentTaxMny() {
        return settlePaymentTaxMny;
    }

    public void setSettlePaymentTaxMny(BigDecimal settlePaymentTaxMny) {
        this.settlePaymentTaxMny = settlePaymentTaxMny;
    }

    public BigDecimal getSettlePaymentMny() {
        return settlePaymentMny;
    }

    public void setSettlePaymentMny(BigDecimal settlePaymentMny) {
        this.settlePaymentMny = settlePaymentMny;
    }

    public BigDecimal getTotalSettlePaymentTaxMny() {
        return totalSettlePaymentTaxMny;
    }

    public void setTotalSettlePaymentTaxMny(BigDecimal totalSettlePaymentTaxMny) {
        this.totalSettlePaymentTaxMny = totalSettlePaymentTaxMny;
    }

    public BigDecimal getTotalSettlePaymentMny() {
        return totalSettlePaymentMny;
    }

    public void setTotalSettlePaymentMny(BigDecimal totalSettlePaymentMny) {
        this.totalSettlePaymentMny = totalSettlePaymentMny;
    }

    public BigDecimal getTotalDetailSettlePaymentTaxMny() {
        return totalDetailSettlePaymentTaxMny;
    }

    public void setTotalDetailSettlePaymentTaxMny(BigDecimal totalDetailSettlePaymentTaxMny) {
        this.totalDetailSettlePaymentTaxMny = totalDetailSettlePaymentTaxMny;
    }

    public BigDecimal getTotalDetailSettlePaymentMny() {
        return totalDetailSettlePaymentMny;
    }

    public void setTotalDetailSettlePaymentMny(BigDecimal totalDetailSettlePaymentMny) {
        this.totalDetailSettlePaymentMny = totalDetailSettlePaymentMny;
    }

    public List<SettlePaymentVO> getSettlePaymentList() {
        return settlePaymentList;
    }

    public void setSettlePaymentList(List<SettlePaymentVO> settlePaymentList) {
        this.settlePaymentList = settlePaymentList;
    }

    public String getContractSettleNum() {
        return contractSettleNum;
    }

    public void setContractSettleNum(String contractSettleNum) {
        this.contractSettleNum = contractSettleNum;
    }
}
