package com.ejianc.business.settle.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 结算子表-价格调整及增补
 *
 * @author generator
 */
@TableName("ejc_prosub_settle_price")
public class SettlePriceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer useFlag; // 是否引用过,否-0，是-1
    private Long settleId; // 结算id
    private Long contractId; // 合同id
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    private Long projectId; // 项目Id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private String sourceType; // 来源:合同，分包计量， 结算单
    private Long sourceId; // 来源id
    private Long sourceBillId; // 来源主单据id
    private Date sourceBillDate; // 来源主单据日期
    private String sourceBillCode; // 来源主单据编号
    private Long docId; // 档案id
    private Long docCategoryId; // 档案分类id
    private String detailName; // 清单名称
    private String detailMeasurementRules; // 工作计量规则
    private String detailWorkContent; // 工作内容
    private String detailUnit; // 单位
    private BigDecimal priceTaxPrice; // 单价(含税)
    private BigDecimal pricePrice; // 单价(无税)
    private BigDecimal priceTaxRate; // 税率
    private String memo; // 备注
    private String treeIndex;
    private Long parentId;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    private Long priceWbsId; // 核算对象主键
    private String priceWbsName; // 核算对象名称
    private String priceWbsCode; // 核算对象编码
    private Long priceSubjectId; // 成本科目主键
    private String priceSubjectName; // 成本科目名称
    private String priceSubjectCode; // 成本科目编码

    private BigDecimal priceSettlePaymentRatio;//本期结算支付比例
    private BigDecimal priceSettlePaymentMny; // 本期结算支付金额
    private BigDecimal priceSettlePaymentTaxMny; // 本期结算支付金额（含税）

    // 华泰增加字段

    private BigDecimal priceTotalProcessNum; // edit-本期累计审批工程量    原：含本期累计过程结算量：取该清单在已生效过程结算单中累计结算量+本期结算量；如果有多行对应合同同一个清单，本期结算量是多行的累计值
    private BigDecimal priceNum; //edit-合同清单 原：合同量
    private BigDecimal priceLastProcessNum; // edit-上期累计审批 原：历史过程结算量：该清单在已生效过程结算单中累计结算量
    private BigDecimal priceSettleNum; // edit-本期审批量   原：本期结算量：=累计节点结算量—过程累计结算量
    private BigDecimal priceSettleTaxMny; // edit-本期审批  原：本期结算金额
    private BigDecimal priceSettleMny; // edit-本期审批(无税)  原：本期结算金额(无税)
    private BigDecimal priceSettleTax; // edit-本期审批税额  原：本期结算税额
    private BigDecimal priceTotalSettleTaxMny; // add-上期累计金额
    private BigDecimal priceTotalSettleMny; //  add-上期累计金额(无税)
    private BigDecimal priceTotalCurrentSettleTaxMny; //  add-本期累计金额
    private BigDecimal priceTotalCurrentSettleMny; //  add-本期累计金额(无税)
    private BigDecimal priceSubmissionNum; // add-分包报送-工程量
    private BigDecimal priceSubmissionTaxMny; // add-分包报送-金额
    private BigDecimal priceSubmissionMny; // add-分包报送-金额(无税)
    private BigDecimal priceSubmissionTax; // add-分包报送-税额
    private BigDecimal priceSubmissionTotalTaxMny; //  add-本期累计金额-分包报送-金额
    private BigDecimal priceSubmissionTotalMny; //  add-本期累计金额(无税)-分包报送-金额

    private BigDecimal priceProjectNum; // add-项目部初审-工程量
    private BigDecimal priceProjectTaxMny; // add-项目部初审-金额
    private BigDecimal priceProjectMny; // add-项目部初审-金额(无税)
    private BigDecimal priceProjectTax; // add-项目部初审-税额
    private BigDecimal priceProjectTotalTaxMny; //  add-本期累计金额-项目部初审-金额
    private BigDecimal priceProjectTotalMny; //  add-本期累计金额(无税)-项目部初审-金额

    private BigDecimal priceCorpNum; // add-分公司审核-工程量
    private BigDecimal priceCorpTaxMny; // add-分公司审核-金额
    private BigDecimal priceCorpMny; // add-分公司审核-金额(无税)
    private BigDecimal priceCorpTax; // add-分公司审核-税额
    private BigDecimal priceCorpTotalTaxMny; //  add-本期累计金额-分公司审核-金额
    private BigDecimal priceCorpTotalMny; //  add-本期累计金额(无税)-分公司审核-金额

    private BigDecimal priceProjectSubtractionMny; //  add完工结算-项目部审减-金额(无税)
    private BigDecimal priceProjectSubtractionTaxMny; //  add完工结算-项目部审减-金额(含税)


    private BigDecimal priceCorpSubtractionMny; //  add完工结算-分工司审减-金额(无税)
    private BigDecimal priceCorpSubtractionTaxMny; //  add完工结算-分工司审减-金额(含税)


    private BigDecimal priceConstructionNum; // add-建设公司审核-工程量
    private BigDecimal priceConstructionTaxMny; // add-建设公司审核-金额
    private BigDecimal priceConstructionMny; // add-建设公司审核-金额(无税)
    private BigDecimal priceConstructionTax; // add-建设公司审核-税额

    private BigDecimal priceConstructionSubtractionMny; //  add-建设公司审减-金额(无税)
    private BigDecimal priceConstructionSubtractionTaxMny; //  add-建设公司审减-金额(含税)


    private BigDecimal addPriceTaxMny; // 价格调整和增补金额(含税)
    private BigDecimal addPriceMny; // 价格调整和增补金额(无税)


    public BigDecimal getPriceProjectSubtractionMny() {
        return priceProjectSubtractionMny;
    }

    public void setPriceProjectSubtractionMny(BigDecimal priceProjectSubtractionMny) {
        this.priceProjectSubtractionMny = priceProjectSubtractionMny;
    }

    public BigDecimal getPriceProjectSubtractionTaxMny() {
        return priceProjectSubtractionTaxMny;
    }

    public void setPriceProjectSubtractionTaxMny(BigDecimal priceProjectSubtractionTaxMny) {
        this.priceProjectSubtractionTaxMny = priceProjectSubtractionTaxMny;
    }

    public BigDecimal getPriceCorpSubtractionMny() {
        return priceCorpSubtractionMny;
    }

    public void setPriceCorpSubtractionMny(BigDecimal priceCorpSubtractionMny) {
        this.priceCorpSubtractionMny = priceCorpSubtractionMny;
    }

    public BigDecimal getPriceCorpSubtractionTaxMny() {
        return priceCorpSubtractionTaxMny;
    }

    public void setPriceCorpSubtractionTaxMny(BigDecimal priceCorpSubtractionTaxMny) {
        this.priceCorpSubtractionTaxMny = priceCorpSubtractionTaxMny;
    }

    public BigDecimal getPriceConstructionNum() {
        return priceConstructionNum;
    }

    public void setPriceConstructionNum(BigDecimal priceConstructionNum) {
        this.priceConstructionNum = priceConstructionNum;
    }

    public BigDecimal getPriceConstructionTaxMny() {
        return priceConstructionTaxMny;
    }

    public void setPriceConstructionTaxMny(BigDecimal priceConstructionTaxMny) {
        this.priceConstructionTaxMny = priceConstructionTaxMny;
    }

    public BigDecimal getPriceConstructionMny() {
        return priceConstructionMny;
    }

    public void setPriceConstructionMny(BigDecimal priceConstructionMny) {
        this.priceConstructionMny = priceConstructionMny;
    }

    public BigDecimal getPriceConstructionTax() {
        return priceConstructionTax;
    }

    public void setPriceConstructionTax(BigDecimal priceConstructionTax) {
        this.priceConstructionTax = priceConstructionTax;
    }

    public BigDecimal getPriceConstructionSubtractionMny() {
        return priceConstructionSubtractionMny;
    }

    public void setPriceConstructionSubtractionMny(BigDecimal priceConstructionSubtractionMny) {
        this.priceConstructionSubtractionMny = priceConstructionSubtractionMny;
    }

    public BigDecimal getPriceConstructionSubtractionTaxMny() {
        return priceConstructionSubtractionTaxMny;
    }

    public void setPriceConstructionSubtractionTaxMny(BigDecimal priceConstructionSubtractionTaxMny) {
        this.priceConstructionSubtractionTaxMny = priceConstructionSubtractionTaxMny;
    }

    public BigDecimal getAddPriceTaxMny() {
        return addPriceTaxMny;
    }

    public void setAddPriceTaxMny(BigDecimal addPriceTaxMny) {
        this.addPriceTaxMny = addPriceTaxMny;
    }

    public BigDecimal getAddPriceMny() {
        return addPriceMny;
    }

    public void setAddPriceMny(BigDecimal addPriceMny) {
        this.addPriceMny = addPriceMny;
    }

    public BigDecimal getPriceSubmissionTax() {
        return priceSubmissionTax;
    }

    public void setPriceSubmissionTax(BigDecimal priceSubmissionTax) {
        this.priceSubmissionTax = priceSubmissionTax;
    }

    public BigDecimal getPriceSubmissionTotalTaxMny() {
        return priceSubmissionTotalTaxMny;
    }

    public void setPriceSubmissionTotalTaxMny(BigDecimal priceSubmissionTotalTaxMny) {
        this.priceSubmissionTotalTaxMny = priceSubmissionTotalTaxMny;
    }

    public BigDecimal getPriceSubmissionTotalMny() {
        return priceSubmissionTotalMny;
    }

    public void setPriceSubmissionTotalMny(BigDecimal priceSubmissionTotalMny) {
        this.priceSubmissionTotalMny = priceSubmissionTotalMny;
    }

    public BigDecimal getPriceProjectTax() {
        return priceProjectTax;
    }

    public void setPriceProjectTax(BigDecimal priceProjectTax) {
        this.priceProjectTax = priceProjectTax;
    }

    public BigDecimal getPriceProjectTotalTaxMny() {
        return priceProjectTotalTaxMny;
    }

    public void setPriceProjectTotalTaxMny(BigDecimal priceProjectTotalTaxMny) {
        this.priceProjectTotalTaxMny = priceProjectTotalTaxMny;
    }

    public BigDecimal getPriceProjectTotalMny() {
        return priceProjectTotalMny;
    }

    public void setPriceProjectTotalMny(BigDecimal priceProjectTotalMny) {
        this.priceProjectTotalMny = priceProjectTotalMny;
    }

    public BigDecimal getPriceCorpTax() {
        return priceCorpTax;
    }

    public void setPriceCorpTax(BigDecimal priceCorpTax) {
        this.priceCorpTax = priceCorpTax;
    }

    public BigDecimal getPriceCorpTotalTaxMny() {
        return priceCorpTotalTaxMny;
    }

    public void setPriceCorpTotalTaxMny(BigDecimal priceCorpTotalTaxMny) {
        this.priceCorpTotalTaxMny = priceCorpTotalTaxMny;
    }

    public BigDecimal getPriceCorpTotalMny() {
        return priceCorpTotalMny;
    }

    public void setPriceCorpTotalMny(BigDecimal priceCorpTotalMny) {
        this.priceCorpTotalMny = priceCorpTotalMny;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }

    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getPriceTaxPrice() {
        return priceTaxPrice;
    }

    public void setPriceTaxPrice(BigDecimal priceTaxPrice) {
        this.priceTaxPrice = priceTaxPrice;
    }

    public BigDecimal getPricePrice() {
        return pricePrice;
    }

    public void setPricePrice(BigDecimal pricePrice) {
        this.pricePrice = pricePrice;
    }

    public BigDecimal getPriceTaxRate() {
        return priceTaxRate;
    }

    public void setPriceTaxRate(BigDecimal priceTaxRate) {
        this.priceTaxRate = priceTaxRate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getPriceWbsId() {
        return priceWbsId;
    }

    public void setPriceWbsId(Long priceWbsId) {
        this.priceWbsId = priceWbsId;
    }

    public String getPriceWbsName() {
        return priceWbsName;
    }

    public void setPriceWbsName(String priceWbsName) {
        this.priceWbsName = priceWbsName;
    }

    public String getPriceWbsCode() {
        return priceWbsCode;
    }

    public void setPriceWbsCode(String priceWbsCode) {
        this.priceWbsCode = priceWbsCode;
    }

    public Long getPriceSubjectId() {
        return priceSubjectId;
    }

    public void setPriceSubjectId(Long priceSubjectId) {
        this.priceSubjectId = priceSubjectId;
    }

    public String getPriceSubjectName() {
        return priceSubjectName;
    }

    public void setPriceSubjectName(String priceSubjectName) {
        this.priceSubjectName = priceSubjectName;
    }

    public String getPriceSubjectCode() {
        return priceSubjectCode;
    }

    public void setPriceSubjectCode(String priceSubjectCode) {
        this.priceSubjectCode = priceSubjectCode;
    }

    public BigDecimal getPriceSettlePaymentRatio() {
        return priceSettlePaymentRatio;
    }

    public void setPriceSettlePaymentRatio(BigDecimal priceSettlePaymentRatio) {
        this.priceSettlePaymentRatio = priceSettlePaymentRatio;
    }

    public BigDecimal getPriceSettlePaymentMny() {
        return priceSettlePaymentMny;
    }

    public void setPriceSettlePaymentMny(BigDecimal priceSettlePaymentMny) {
        this.priceSettlePaymentMny = priceSettlePaymentMny;
    }

    public BigDecimal getPriceSettlePaymentTaxMny() {
        return priceSettlePaymentTaxMny;
    }

    public void setPriceSettlePaymentTaxMny(BigDecimal priceSettlePaymentTaxMny) {
        this.priceSettlePaymentTaxMny = priceSettlePaymentTaxMny;
    }

    public BigDecimal getPriceTotalProcessNum() {
        return priceTotalProcessNum;
    }

    public void setPriceTotalProcessNum(BigDecimal priceTotalProcessNum) {
        this.priceTotalProcessNum = priceTotalProcessNum;
    }

    public BigDecimal getPriceNum() {
        return priceNum;
    }

    public void setPriceNum(BigDecimal priceNum) {
        this.priceNum = priceNum;
    }

    public BigDecimal getPriceLastProcessNum() {
        return priceLastProcessNum;
    }

    public void setPriceLastProcessNum(BigDecimal priceLastProcessNum) {
        this.priceLastProcessNum = priceLastProcessNum;
    }

    public BigDecimal getPriceSettleNum() {
        return priceSettleNum;
    }

    public void setPriceSettleNum(BigDecimal priceSettleNum) {
        this.priceSettleNum = priceSettleNum;
    }

    public BigDecimal getPriceSettleTaxMny() {
        return priceSettleTaxMny;
    }

    public void setPriceSettleTaxMny(BigDecimal priceSettleTaxMny) {
        this.priceSettleTaxMny = priceSettleTaxMny;
    }

    public BigDecimal getPriceSettleMny() {
        return priceSettleMny;
    }

    public void setPriceSettleMny(BigDecimal priceSettleMny) {
        this.priceSettleMny = priceSettleMny;
    }

    public BigDecimal getPriceSettleTax() {
        return priceSettleTax;
    }

    public void setPriceSettleTax(BigDecimal priceSettleTax) {
        this.priceSettleTax = priceSettleTax;
    }

    public BigDecimal getPriceTotalSettleTaxMny() {
        return priceTotalSettleTaxMny;
    }

    public void setPriceTotalSettleTaxMny(BigDecimal priceTotalSettleTaxMny) {
        this.priceTotalSettleTaxMny = priceTotalSettleTaxMny;
    }

    public BigDecimal getPriceTotalSettleMny() {
        return priceTotalSettleMny;
    }

    public void setPriceTotalSettleMny(BigDecimal priceTotalSettleMny) {
        this.priceTotalSettleMny = priceTotalSettleMny;
    }

    public BigDecimal getPriceTotalCurrentSettleTaxMny() {
        return priceTotalCurrentSettleTaxMny;
    }

    public void setPriceTotalCurrentSettleTaxMny(BigDecimal priceTotalCurrentSettleTaxMny) {
        this.priceTotalCurrentSettleTaxMny = priceTotalCurrentSettleTaxMny;
    }

    public BigDecimal getPriceTotalCurrentSettleMny() {
        return priceTotalCurrentSettleMny;
    }

    public void setPriceTotalCurrentSettleMny(BigDecimal priceTotalCurrentSettleMny) {
        this.priceTotalCurrentSettleMny = priceTotalCurrentSettleMny;
    }

    public BigDecimal getPriceSubmissionNum() {
        return priceSubmissionNum;
    }

    public void setPriceSubmissionNum(BigDecimal priceSubmissionNum) {
        this.priceSubmissionNum = priceSubmissionNum;
    }

    public BigDecimal getPriceSubmissionTaxMny() {
        return priceSubmissionTaxMny;
    }

    public void setPriceSubmissionTaxMny(BigDecimal priceSubmissionTaxMny) {
        this.priceSubmissionTaxMny = priceSubmissionTaxMny;
    }

    public BigDecimal getPriceSubmissionMny() {
        return priceSubmissionMny;
    }

    public void setPriceSubmissionMny(BigDecimal priceSubmissionMny) {
        this.priceSubmissionMny = priceSubmissionMny;
    }

    public BigDecimal getPriceProjectNum() {
        return priceProjectNum;
    }

    public void setPriceProjectNum(BigDecimal priceProjectNum) {
        this.priceProjectNum = priceProjectNum;
    }

    public BigDecimal getPriceProjectTaxMny() {
        return priceProjectTaxMny;
    }

    public void setPriceProjectTaxMny(BigDecimal priceProjectTaxMny) {
        this.priceProjectTaxMny = priceProjectTaxMny;
    }

    public BigDecimal getPriceProjectMny() {
        return priceProjectMny;
    }

    public void setPriceProjectMny(BigDecimal priceProjectMny) {
        this.priceProjectMny = priceProjectMny;
    }

    public BigDecimal getPriceCorpNum() {
        return priceCorpNum;
    }

    public void setPriceCorpNum(BigDecimal priceCorpNum) {
        this.priceCorpNum = priceCorpNum;
    }

    public BigDecimal getPriceCorpTaxMny() {
        return priceCorpTaxMny;
    }

    public void setPriceCorpTaxMny(BigDecimal priceCorpTaxMny) {
        this.priceCorpTaxMny = priceCorpTaxMny;
    }

    public BigDecimal getPriceCorpMny() {
        return priceCorpMny;
    }

    public void setPriceCorpMny(BigDecimal priceCorpMny) {
        this.priceCorpMny = priceCorpMny;
    }
}
