package com.ejianc.business.process.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 零工申请实体
 *
 * @author generator
 * 
 */
public class ApplicationVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 项目编码
     */
    private String projectCode;
    /**
     *  项目名称
     */
    private String projectName;
    /**
     * 项目id
     */
    private Long projectId;
    /**
     * 合同编号
     */
    private String contractCode;
    /**
     * 合同名称
     */
    private String contractName;
    /**
     *  合同id
     */
    private Long contractId;
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    private Integer contractType;
    /**
     * 合同类别：0-主合同 1-补充协议
     */
    private Integer supplementFlag;
    /**
     * 组织编码
     */
    private String orgCode;
    /**
     * 组织id
     */
    private Long orgId;
    /**
     *  组织名称
     */
    private String orgName;
    /**
     * 上级组织名称
     */
    private String parentOrgName;
    /**
     * 上级组织id
     */
    private Long parentOrgId;
    /**
     * 上级组织编码
     */
    private String parentOrgCode;
    /**
     * 申请人 即经办人
     */

    private Long employeeId;
    /**
     * 申请人信息 即经办人
     */
    private String employeeName;
    private Long firstPartyId;// 甲方Id
    private String firstPartyName;// 甲方名称
    /**
     * 供应商id(乙方)
     */
    private Long supplierId;
    /**
     * 供应商名称（乙方）
     */
    private String supplierName;
    /**
     *  经办部门id
     */
    private Long departmentId;
    /**
     *  经办部门
     */
    private String departmentName;
    /**
     *  用工内容 手动输入 1-50个字，必填项
     */
    private String useWorkDetail;
    /**
     *  用工类型id
     */
    private Long useWorkTypeId;
    /**
     *  用工类型 0-零星用工 1-临时机械 2-变更签证
     */
    private String useWorkTypeName;
    private String useWorkTypeStr;

    /**
     * 预计用工日期，暂时不做任何逻辑控制
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date preUseWorkDate;

    /**
     *  零工总金额（申请金额）：自动计算子表的无税总金额不支持修改(无税)
     */
    private BigDecimal mny;
    /**
     * 零工总金额 申请金额：自动计算子表的含税总金额不支持修改（含税）
     */
    private BigDecimal taxMny;
    /**
     * 零工是否登记  1被引用：显示标识 零工已登记 0 未被引用：零工未登记
     */
    private Integer useFlag;
    /**
     * 零工已登记、零工未登记
     */
    private String useFlagStr;
    /**
     *  单据编号
     */
    private String billCode;
    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private Integer billState;
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期

    /**
     *   班组id
     */
    private Long teamId;
    /**
     * 班组名称（带入）
     */
    private String teamName;
    /**
     * 班组编码
     */
    private String teamCode;

    /**
     * 用工明细表
     */
    private List<ApplicationDetailVO> detailList = new ArrayList<>();

    //    导出字段
    private String contractTypeStr;
    private String billStateStr;
    private String timeStr;

    public Long getTeamId() {
        return teamId;
    }
    @ReferDeserialTransfer
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public Date getPreUseWorkDate() {
        return preUseWorkDate;
    }

    public void setPreUseWorkDate(Date preUseWorkDate) {
        this.preUseWorkDate = preUseWorkDate;
    }

    public String getUseFlagStr() {
        return useFlagStr;
    }

    public void setUseFlagStr(String useFlagStr) {
        this.useFlagStr = useFlagStr;
    }

    public String getUseWorkTypeStr() {
        return useWorkTypeStr;
    }

    public void setUseWorkTypeStr(String useWorkTypeStr) {
        this.useWorkTypeStr = useWorkTypeStr;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public List<ApplicationDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ApplicationDetailVO> detailList) {
        this.detailList = detailList;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getUseWorkDetail() {
        return useWorkDetail;
    }

    public void setUseWorkDetail(String useWorkDetail) {
        this.useWorkDetail = useWorkDetail;
    }
    public Long getUseWorkTypeId() {
        return useWorkTypeId;
    }

    @ReferDeserialTransfer
    public void setUseWorkTypeId(Long useWorkTypeId) {
        this.useWorkTypeId = useWorkTypeId;
    }

    public String getUseWorkTypeName() {
        return useWorkTypeName;
    }

    public void setUseWorkTypeName(String useWorkTypeName) {
        this.useWorkTypeName = useWorkTypeName;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractTypeStr() {
        return contractTypeStr;
    }

    public void setContractTypeStr(String contractTypeStr) {
        this.contractTypeStr = contractTypeStr;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getTimeStr() {
        return timeStr;
    }

    public void setTimeStr(String timeStr) {
        this.timeStr = timeStr;
    }
}
