package com.ejianc.business.process.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 零工登记主实体
 * 
 * @author generator
 * 
 */
public class RegistrationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Long projectId; // 项目Id
    private java.lang.String projectName; // 项目名称（带入）
    private java.lang.String projectCode; // 项目编码
    private java.lang.String contractName; // 合同名称
    private java.lang.Long contractId; // 合同id
    private java.lang.String contractCode; // 合同编码
    private  Integer  contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    private Long orgId; // 项目部id
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgName; // 项目部所属组织名称
    private String parentOrgCode; // 项目部所属组织编码
    private Long firstPartyId;// 甲方Id
    private String firstPartyName;// 甲方名称
    private java.lang.Long supplierId; // 供应商id(乙方)
    private java.lang.String supplierName; // 供应商名称（乙方）
    private java.lang.Long employeeId; // 申请人 即经办人
    private java.lang.String employeeName; // 申请人信息 即经办人
    private java.lang.Integer billType; // 来源：0-自制、1-申请单—单据编号
    private String billTypeName; // 来源名称
    private Long useWorkTypeId; // 用工类型id
    private String useWorkTypeName; // 用工类型名称
    private java.lang.String useWorkDetail; // 用工内容 手动输入 1-50个字，必填项
    private java.math.BigDecimal totalTaxMny; // 零工总金额：自动计算子表的含税总金额不支持修改（含税）
    private java.math.BigDecimal totalMny; // 零工总金额：自动计算子表的无税总金额不支持修改(无税)
    private java.lang.Integer supplierSignStatus; // 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long departmentId;
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期
    /**
     * 登记时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date regionDate;

    private List<String> fileIds = new ArrayList<>();//文件id
    private Long applicationId;
    /**
     *  经办部门
     */
    private String departmentName;
    private List<RegistrationDetailVO> detailList = new ArrayList<>(); // 零工登记 子表 清单明细
    private List<RegistrationDeductVO> deductList = new ArrayList<>(); // 零工登记子表 转扣表实体
    private List<RegistrationTeamVO> teamList = new ArrayList<>(); // 零工登记子表 转扣表实体

    /**
     * 制单人Id
     */
    private Long createUserId;

    /***  协同需要字段 START  ***/

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    private Long supOperateFileId;

    /**
     * 是否支持若协同：0-不支持，1-支持
     */
    private Integer waekFlag;

    /**
     *   班组id
     */
    private Long teamId;
    /**
     * 班组名称（带入）
     */
    private String teamName;
    /**
     * 班组编码
     */
    private String teamCode;

    private String contractTypeStr;

    private String billStateStr;

    private String supplierSignStatusStr;
    private String timeStr;

    private Integer count; //业务笔数

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getTimeStr() {
        return timeStr;
    }

    public void setTimeStr(String timeStr) {
        this.timeStr = timeStr;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getSupplierSignStatusStr() {
        return supplierSignStatusStr;
    }

    public void setSupplierSignStatusStr(String supplierSignStatusStr) {
        this.supplierSignStatusStr = supplierSignStatusStr;
    }

    public String getContractTypeStr() {
        return contractTypeStr;
    }
    private String billTypeStr;

    public String getBillTypeStr() {
        return billTypeStr;
    }

    public void setBillTypeStr(String billTypeStr) {
        this.billTypeStr = billTypeStr;
    }

    public void setContractTypeStr(String contractTypeStr) {
        this.contractTypeStr = contractTypeStr;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public Long getTeamId() {
        return teamId;
    }
    @ReferDeserialTransfer
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    /***  协同需要字段 END  ***/


    public Date getCommitDate() {
        return commitDate;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }


    public Date getRegionDate() {
        return regionDate;
    }

    public void setRegionDate(Date regionDate) {
        this.regionDate = regionDate;
    }

    public List<String> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }



    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 项目Id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称（带入）
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    public List<RegistrationTeamVO> getTeamList() {
        return teamList;
    }

    public void setTeamList(List<RegistrationTeamVO> teamList) {
        this.teamList = teamList;
    }

    /**
     * 项目名称（带入）
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
//    @ReferSerialTransfer(referCode = "proSubContract")
    @ReferDeserialTransfer
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
//    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public java.lang.String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(java.lang.String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public java.lang.Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public void setContractType(java.lang.Integer contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public java.lang.Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public void setSupplementFlag(java.lang.Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public java.lang.String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(java.lang.String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部所属组织id
     */
    public java.lang.Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    public void setParentOrgId(java.lang.Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织名称
     */
    public java.lang.String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(java.lang.String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部所属组织编码
     */
    public java.lang.String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(java.lang.String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    /**
     * 供应商id(乙方)
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id(乙方)
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称（乙方）
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称（乙方）
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请人 即经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人 即经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人信息 即经办人
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人信息 即经办人
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 来源：0-自制、1-申请单—单据编号
     */
    public java.lang.Integer getBillType() {
        return billType;
    }

    /**
     * 来源：0-自制、1-申请单—单据编号
     */
    public void setBillType(java.lang.Integer billType) {
        this.billType = billType;
    }
    /**
     * 来源名称
     */
    public String getBillTypeName() {
        return billTypeName;
    }

    /**
     * 来源名称
     */
    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    /**
     * 用工类型id
     */
    public Long getUseWorkTypeId() {
        return useWorkTypeId;
    }

    /**
     * 用工类型id
     */
    @ReferDeserialTransfer
    public void setUseWorkTypeId(Long useWorkTypeId) {
        this.useWorkTypeId = useWorkTypeId;
    }

    /**
     * 用工类型名称
     */
    public String getUseWorkTypeName() {
        return useWorkTypeName;
    }

    /**
     * 用工类型名称
     */
    public void setUseWorkTypeName(String useWorkTypeName) {
        this.useWorkTypeName = useWorkTypeName;
    }

    /**
     * 用工内容 手动输入 1-50个字，必填项
     */
    public java.lang.String getUseWorkDetail() {
        return useWorkDetail;
    }

    /**
     * 用工内容 手动输入 1-50个字，必填项
     */
    public void setUseWorkDetail(java.lang.String useWorkDetail) {
        this.useWorkDetail = useWorkDetail;
    }
    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    public java.math.BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    public void setTotalTaxMny(java.math.BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    /**
     * 零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    public java.math.BigDecimal getTotalMny() {
        return totalMny;
    }

    /**
     * 零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    public void setTotalMny(java.math.BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    /**
     * 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    public java.lang.Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    /**
     * 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    public void setSupplierSignStatus(java.lang.Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    
     /**
      * 零工登记 子表 清单明细
      */
     public List<RegistrationDetailVO> getDetailList() {
        return detailList;
     }

     /**
      * 零工登记 子表 清单明细
      */
     public void setDetailList(List<RegistrationDetailVO> detailList) {
        this.detailList = detailList;
     }
     /**
      * 零工登记子表 转扣表实体
      */
     public List<RegistrationDeductVO> getDeductList() {
        return deductList;
     }

     /**
      * 零工登记子表 转扣表实体
      */
     public void setDeductList(List<RegistrationDeductVO> deductList) {
        this.deductList = deductList;
     }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public Integer getWaekFlag() {
        return waekFlag;
    }

    public void setWaekFlag(Integer waekFlag) {
        this.waekFlag = waekFlag;
    }
}
