package com.ejianc.business.prosub.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.prosub.vo.AccountZiVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 劳务纠纷台账实体
 *
 * @author generator
 */
public class AccountVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long departmentId; // 所属项目部
    private String departmentName; // 所属项目部名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date complaintDate; // 投诉时间
    private String complaintPerson; // 投诉人
    private String complaintPhone; // 联系方式
    private Long teamId; // 班组
    private String teamName; // 班组名称
    private Long complaintType; // 投诉类型
    private String complaintTypeName; // 投诉类型名称
    private String complaintReason; // 投诉原因
    private Long involveNumber; // 涉及人数
    private BigDecimal involveMny; // 涉及金额
    private String jobDescription; // 作业内容
    private Long processingStatus; // 处理状态
    private String processingStatusName; // 处理状态名称
    private String solutions; // 解决方案
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date solutionsDate; // 解决时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date operatorTime; // 经办时间
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private Long supplierId;//供应商Id
    private String supplierName;//供应商名称
    private Long supplierProjectManagerId; // 乙方项目经理Id
    private String supplierProjectManagerName; // 乙方项目经理名称
    private String supplierProjectManagerLink; // 乙方项目经理联系电话
    private String supplierProjectManagerPost; // 乙方项目经理职务
    private String supplierProjectManagerIdCard; // 乙方项目经理身份证号
    private String teamUserName; // 联系人
    private String teamUserPhone; // 联系电话
    private String editContractName; // 合同名称
    private String editSupplierName;//供应商名称
    private String editSupplierProjectManagerName; // 乙方项目经理名称
    private String editSupplierProjectManagerLink; // 乙方项目经理联系电话
    private String editTeamName; // 班组
    private String editTeamUserName; // 联系人
    private String editTeamUserPhone; // 联系电话

    private List<AccountZiVO> accountZiList = new ArrayList<>(); // 劳务纠纷台账子实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "ejc-share-zzyj-project-ex001")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getComplaintDate() {
        return complaintDate;
    }

    public void setComplaintDate(Date complaintDate) {
        this.complaintDate = complaintDate;
    }

    public String getComplaintPerson() {
        return complaintPerson;
    }

    public void setComplaintPerson(String complaintPerson) {
        this.complaintPerson = complaintPerson;
    }

    public String getComplaintPhone() {
        return complaintPhone;
    }

    public void setComplaintPhone(String complaintPhone) {
        this.complaintPhone = complaintPhone;
    }

    @ReferSerialTransfer(referCode = "team_use_ref")
    public Long getTeamId() {
        return teamId;
    }

    @ReferDeserialTransfer
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getComplaintType() {
        return complaintType;
    }

    @ReferDeserialTransfer
    public void setComplaintType(Long complaintType) {
        this.complaintType = complaintType;
    }

    public String getComplaintTypeName() {
        return complaintTypeName;
    }

    public void setComplaintTypeName(String complaintTypeName) {
        this.complaintTypeName = complaintTypeName;
    }

    public String getComplaintReason() {
        return complaintReason;
    }

    public void setComplaintReason(String complaintReason) {
        this.complaintReason = complaintReason;
    }

    public Long getInvolveNumber() {
        return involveNumber;
    }

    public void setInvolveNumber(Long involveNumber) {
        this.involveNumber = involveNumber;
    }

    public BigDecimal getInvolveMny() {
        return involveMny;
    }

    public void setInvolveMny(BigDecimal involveMny) {
        this.involveMny = involveMny;
    }

    public String getJobDescription() {
        return jobDescription;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProcessingStatus() {
        return processingStatus;
    }

    @ReferDeserialTransfer
    public void setProcessingStatus(Long processingStatus) {
        this.processingStatus = processingStatus;
    }

    public String getProcessingStatusName() {
        return processingStatusName;
    }

    public void setProcessingStatusName(String processingStatusName) {
        this.processingStatusName = processingStatusName;
    }

    public String getSolutions() {
        return solutions;
    }

    public void setSolutions(String solutions) {
        this.solutions = solutions;
    }

    public Date getSolutionsDate() {
        return solutionsDate;
    }

    public void setSolutionsDate(Date solutionsDate) {
        this.solutionsDate = solutionsDate;
    }

    public Date getOperatorTime() {
        return operatorTime;
    }

    public void setOperatorTime(Date operatorTime) {
        this.operatorTime = operatorTime;
    }

    @ReferSerialTransfer(referCode = "proSubContract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }

    public String getSupplierProjectManagerPost() {
        return supplierProjectManagerPost;
    }

    public void setSupplierProjectManagerPost(String supplierProjectManagerPost) {
        this.supplierProjectManagerPost = supplierProjectManagerPost;
    }

    public String getSupplierProjectManagerIdCard() {
        return supplierProjectManagerIdCard;
    }

    public void setSupplierProjectManagerIdCard(String supplierProjectManagerIdCard) {
        this.supplierProjectManagerIdCard = supplierProjectManagerIdCard;
    }


    public String getTeamUserName() {
        return teamUserName;
    }

    public void setTeamUserName(String teamUserName) {
        this.teamUserName = teamUserName;
    }

    public String getTeamUserPhone() {
        return teamUserPhone;
    }

    public void setTeamUserPhone(String teamUserPhone) {
        this.teamUserPhone = teamUserPhone;
    }

    public List<AccountZiVO> getAccountZiList() {
        return accountZiList;
    }

    public String getEditContractName() {
        return editContractName;
    }

    public void setEditContractName(String editContractName) {
        this.editContractName = editContractName;
    }

    public String getEditSupplierName() {
        return editSupplierName;
    }

    public void setEditSupplierName(String editSupplierName) {
        this.editSupplierName = editSupplierName;
    }

    public String getEditSupplierProjectManagerName() {
        return editSupplierProjectManagerName;
    }

    public void setEditSupplierProjectManagerName(String editSupplierProjectManagerName) {
        this.editSupplierProjectManagerName = editSupplierProjectManagerName;
    }

    public String getEditSupplierProjectManagerLink() {
        return editSupplierProjectManagerLink;
    }

    public String getEditTeamName() {
        return editTeamName;
    }

    public void setEditTeamName(String editTeamName) {
        this.editTeamName = editTeamName;
    }

    public void setEditSupplierProjectManagerLink(String editSupplierProjectManagerLink) {
        this.editSupplierProjectManagerLink = editSupplierProjectManagerLink;
    }

    public String getEditTeamUserName() {
        return editTeamUserName;
    }

    public void setEditTeamUserName(String editTeamUserName) {
        this.editTeamUserName = editTeamUserName;
    }

    public String getEditTeamUserPhone() {
        return editTeamUserPhone;
    }

    public void setEditTeamUserPhone(String editTeamUserPhone) {
        this.editTeamUserPhone = editTeamUserPhone;
    }

    public void setAccountZiList(List<AccountZiVO> accountZiList) {
        this.accountZiList = accountZiList;
    }
}
