package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包总计划变更实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("planChange")
public class PlanChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanChangeService service;

    @Autowired
    private IPlanService planService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExecutionApi executionApi;

    @Value("${common.env.base-host}")
    private static String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;


    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BASE_HOST;
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanChangeVO> saveOrUpdate(@RequestBody PlanChangeVO planVo) {
        return getPlanChangeVOCommonResponse(planVo, false);
    }

    private CommonResponse<PlanChangeVO> getPlanChangeVOCommonResponse(PlanChangeVO planVo, Boolean isControl) {
        //校验项目是否存在未完成的变更计划单存在
        PlanChangeEntity planChangeEntity = service.getUnFinishedChange(planVo.getSourcePlanId());

        if(null !=planChangeEntity && (null == planVo.getId() || !planChangeEntity.getId().equals(planVo.getId()))) {
            return CommonResponse.error("保存失败，该项目存在未完成的变更计划！");
        }

        PlanEntity masterPlan = planService.getById(planVo.getSourcePlanId());
        UserContext userContext = sessionManager.getUserContext();
        PlanChangeEntity saveEntity = null;
        boolean isNew = false;
        List<PlanDetailChangeEntity> detailList = BeanMapper.mapList(planVo.getPlanDetailList(), PlanDetailChangeEntity.class);
        if(null == planVo.getId()) {
            saveEntity = BeanMapper.map(planVo, PlanChangeEntity.class);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            //生成Id用于成本控制
            saveEntity.setId(IdWorker.getId());
            isNew = true;

        } else {
            saveEntity = service.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setMemo(planVo.getMemo());
            saveEntity.setBillCode(planVo.getBillCode());
            saveEntity.setTotalPlanTaxMny(planVo.getTotalPlanTaxMny());
            saveEntity.setTotalPlanMny(planVo.getTotalPlanMny());
            saveEntity.setModifyUserName(userContext.getUserName());
        }

        if(null == saveEntity.getTotalPlanMny()) {
            saveEntity.setTotalPlanMny(BigDecimal.ZERO.setScale(8));
        }

        /**
         * 变更保存 删除原有数据,推送变更数据
         * 1、先根据总计划Id查询总计划最近一次变更单记录
         * 若存在变更记录，则将最近一次变更记录删除，将当前变更单信息推送目标成本
         * 如不存在变更记录，则删除合同目标成本数据，将当前变更单信息推送目标成本
         */
        //判断是否新增变更记录
        // 不控制才能删除目标成本推送的数据
        if (Boolean.FALSE.equals(isControl)) {
            if(planVo.getId() == null) {
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                ExecutionVO executionVO1 = service.getLastExecutionVO(planVo.getSourcePlanId());
                //目标成本推送
                totalExecutionVOList.add(executionVO1.getTotalVO());
                logger.info("新增分包总计划变更，删除已有的目标成本数据：{}", JSON.toJSONString(totalExecutionVOList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                logger.info("新增分包总计划变更，删除已有的目标成本数据结果：{}", JSON.toJSONString(response));
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }
        }

        Map<Long, PlanDetailChangeEntity> parentMap = new HashMap<>();
        Set<Long> checkParentChangeStateList = new HashSet<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String, Long> idMap = new HashMap<>();
            for(PlanDetailChangeEntity detail : detailList){
                if(isNew) {
                    if(!"add".equals(detail.getRowState())) {
                        //新增变更重新生成Id
                        detail.setId(IdWorker.getId());
                    }
                }

                if (!("del").equals(detail.getRowState())){
                    if(null == saveEntity.getId() || null == detail.getId()) {
                        detail.setId(IdWorker.getId());
                    }
                    detail.setParentId(null);

                    detail.setPlanId(saveEntity.getId());
                }

                idMap.put(detail.getTid(), detail.getId());
                if(null == detail.getPlanNum()) {
                    parentMap.put(detail.getId(), detail);
                }
            }
            for (PlanDetailChangeEntity detail : detailList) {
                if (!("del").equals(detail.getRowState())){
                    if (StringUtils.isNotEmpty(detail.getTpid())) {
                        detail.setParentId(idMap.get(detail.getTpid()));
                        checkParentChangeStateList.add(detail.getParentId());
                    }
                }
            }
        }

        //处理父级变更状态
        if(CollectionUtils.isNotEmpty(checkParentChangeStateList)) {
            for(Long parentId : checkParentChangeStateList) {
                handleChangeState(parentId, parentMap);
            }
        }

        saveEntity.setPlanDetailList(detailList);
        saveEntity = service.saveOrUpdatePlanChange(saveEntity, isControl);

        PlanChangeVO planChangeVO;
        if (saveEntity.getId() != null && isControl == false){
            planChangeVO = service.queryDetail(saveEntity.getId(), true);
        }else {
            saveEntity.setId(IdWorker.getId());
            planChangeVO = BeanMapper.map(saveEntity, PlanChangeVO.class);
        }

        if (Boolean.FALSE.equals(isControl)) {
            //目标成本推送
            String linkUrl;
            if (saveEntity.getSubType()==0){
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/changeCard?id="+saveEntity.getId();
            }else {
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/changeCard?id="+saveEntity.getId();
            }
            // 太乱了直接查，有问题再说
            PlanChangeVO planChangeVO1 = service.queryDetail(saveEntity.getId(), false);
            ExecutionVO executionVO = service.targetCost(planChangeVO1,linkUrl,planChangeVO1.getSubType(),
                    planChangeVO1.getSubType().equals(0) ? ProsubBillTypeEnum.劳务分包总计划变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包总计划变更.getBillTypeCode(),false);
            logger.info("总计划变更单，目标成本推送数据： {}", JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            logger.info("总计划变更单-{}，目标成本推送结果： {}", planChangeVO1.getId().toString(), JSON.toJSONString(response));
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败, 原因："+ response.getMsg());
            }
            return CommonResponse.success("保存成功！", planChangeVO);
        }
        return CommonResponse.success("保存成功！", planChangeVO);
    }

    private void handleChangeState(Long parentId, Map<Long, PlanDetailChangeEntity> parentMap) {
        PlanDetailChangeEntity parent = parentMap.get(parentId);
        if(null != parent && "del".equals(parent.getRowState())) {
            parent.setRowState("edit");
            parent.setChangeType(3);
            parent.setChangeTypeDesc("变更项");

            if(null != parent.getParentId()) {
                handleChangeState(parent.getParentId(), parentMap);
            }
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanChangeVO> queryDetail(Long id) {
        PlanChangeVO vo = null;
        vo = service.queryDetail(id,true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanChangeVO> vos) {
        //变更删除 删除变更单据，删除目标成本推送数据，推送上一版数据
        if(CollectionUtils.isNotEmpty(vos)) {
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                List<PlanEntity> planEntityList = new ArrayList<>();
                for (PlanChangeVO planChangeVO : vos) {
                    PlanChangeEntity planChangeEntity = service.selectById(planChangeVO.getId());
                    ExecutionVO executionVO = service.targetCost(BeanMapper.map(planChangeEntity, PlanChangeVO.class),
                            "",planChangeEntity.getSubType(),
                            planChangeEntity.getSubType().equals(0) ? ProsubBillTypeEnum.劳务分包总计划变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包总计划变更.getBillTypeCode(), false);
                    totalExecutionVOList.add(executionVO.getTotalVO());
                    planEntityList.add(planService.selectById(planChangeEntity.getSourcePlanId()));
                }
                logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }

            //推送上一版数据
            for (PlanEntity planEntity : planEntityList) {
                //目标成本推送
                ExecutionVO executionVO1;
                String linkUrl;
                List<PlanChangeEntity> planChangeEntities = service.list(new QueryWrapper<PlanChangeEntity>().eq("source_plan_id", planEntity.getId()).orderByDesc("change_version"));
                if (planChangeEntities.size()>1 ){
                    if (planEntity.getSubType()==0){
                        linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/changeCard?id="+planEntity.getId();
                    }else {
                        linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/changeCard?id="+planEntity.getId();
                    }
                    executionVO1 = service.targetCost(BeanMapper.map(planChangeEntities.get(1),PlanChangeVO.class),linkUrl,planChangeEntities.get(1).getSubType(),
                            planChangeEntities.get(1).getSubType().equals(0) ? ProsubBillTypeEnum.劳务分包总计划变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包总计划变更.getBillTypeCode(), false);
                }else {
                    if (planEntity.getSubType()==0){
                        linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/card?id="+planEntity.getId();
                    }else {
                        linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/card?id="+planEntity.getId();
                    }
                    executionVO1 = planService.targetCost(BeanMapper.map(planEntity,PlanVO.class),linkUrl,planEntity.getSubType());
                }
                logger.info("总计划删除，目标成本推送数据：{}", JSON.toJSONString(executionVO1));
                CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
                logger.info("总计划-{}删除，目标成本推送结果：{}",planEntity.getId().toString(), JSONObject.toJSONString(response1));
                if (!response1.isSuccess()){
                    throw new BusinessException("目标成本推送失败,"+response.getMsg());
                }
            }
            service.deleteChangePlan(vos.stream().map(PlanChangeVO::getId).collect(Collectors.toList()));
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"),  null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            }else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<PlanDetailChangeEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, PlanDetailChangeEntity.class));
        }
    }

    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody PlanChangeVO planChangeVO) {
        CommonResponse<PlanChangeVO> planChangeVOCommonResponse = this.getPlanChangeVOCommonResponse(planChangeVO, true);
        if (!planChangeVOCommonResponse.isSuccess()) {
            return CommonResponse.error(planChangeVOCommonResponse.getMsg());
        }
        PlanChangeVO pcv = planChangeVOCommonResponse.getData();
        //目标成本推送
        String linkUrl;
        if (pcv.getSubType()==0){
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/changeCard?id="+pcv.getId();
        }else {
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/changeCard?id="+pcv.getId();
        }
        ExecutionVO executionVO = service.targetCost(pcv,linkUrl,pcv.getSubType(), pcv.getSubType().equals(0) ? ProsubBillTypeEnum.劳务分包总计划变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包总计划变更.getBillTypeCode(), true);
        logger.info("总计划变更，目标成本校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if(!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        logger.info("总计划变更，目标成本校验结果：{}" , JSONObject.toJSONString(response));
        //参数控制
        ParamsCheckVO paramsCheckVO = paramCheck(planChangeVO, response);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        PlanChangeVO pcv = service.queryDetail(id, false);
        //目标成本推送
        String linkUrl;
        if (pcv.getSubType()==0){
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/changeCard?id="+pcv.getId();
        }else {
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/changeCard?id="+pcv.getId();
        }
        ExecutionVO executionVO = service.targetCost(pcv,linkUrl,pcv.getSubType(), pcv.getSubType().equals(0) ? ProsubBillTypeEnum.劳务分包总计划变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包总计划变更.getBillTypeCode(), false);
        logger.error("总计划变更，目标成本校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if(!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        logger.info("总计划变更，目标成本校验结果：{}" , JSONObject.toJSONString(response));
        //参数控制
        ParamsCheckVO paramsCheckVO = paramCheck(pcv, response);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    private ParamsCheckVO paramCheck(PlanChangeVO planChangeVO, CommonResponse<ParamsCheckVO> response) {
        ParamsCheckVO responseData = response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();

        List<ParamsCheckVO> allCheck = new ArrayList<>();
        // 目标成本价控 总计划价
        logger.info("目标成本价 控 劳务分包总计划价 start");
        allCheck.addAll(service.targetCostPriceCtrlPlanPrice(planChangeVO));
        logger.info("目标成本价 控 劳务分包总计划价 end");
        logger.info("allCheck:{}", JSONObject.toJSONString(allCheck));
        // 历史价控 合同价
        logger.info("历史价控 总计划价 start");
        allCheck.addAll(service.historyPriceCtrlPlanPrice(planChangeVO));
        logger.info("历史价控 总计划价 end");

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }

        //如果目标成本预警登记小于等于参数控制预警登记
        if(null == responseData.getWarnType()  || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            for(ParamsCheckVO p : result) {
                resp.getDataSource().addAll(p.getDataSource());
            }
        } else if(ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            if(CollectionUtils.isNotEmpty(responseData.getDataSource())) {
                resp.getDataSource().addAll(responseData.getDataSource());
            }
            for(ParamsCheckVO p : result) {
                resp.getDataSource().addAll(p.getDataSource());
            }
        } else { //否则
            return responseData;
        }

        return resp;
    }

}
