/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planChange"})
public class PlanChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanChangeService service;
    @Autowired
    private IPlanService planService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private static String BASE_HOST;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    private String getBaseHost() {
        return StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : BASE_HOST;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanChangeVO> saveOrUpdate(@RequestBody PlanChangeVO planVo) {
        return this.getPlanChangeVOCommonResponse(planVo, false);
    }

    private CommonResponse<PlanChangeVO> getPlanChangeVOCommonResponse(PlanChangeVO planVo, Boolean isControl) {
        PlanChangeVO planChangeVO;
        PlanChangeEntity planChangeEntity = this.service.getUnFinishedChange(planVo.getSourcePlanId());
        if (!(null == planChangeEntity || null != planVo.getId() && planChangeEntity.getId().equals(planVo.getId()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u8ba1\u5212\uff01");
        }
        PlanEntity masterPlan = (PlanEntity)((Object)this.planService.getById(planVo.getSourcePlanId()));
        UserContext userContext = this.sessionManager.getUserContext();
        PlanChangeEntity saveEntity = null;
        boolean isNew = false;
        List detailList = BeanMapper.mapList((Iterable)planVo.getPlanDetailList(), PlanDetailChangeEntity.class);
        if (null == planVo.getId()) {
            saveEntity = (PlanChangeEntity)((Object)BeanMapper.map((Object)planVo, PlanChangeEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            saveEntity.setId(IdWorker.getId());
            isNew = true;
        } else {
            saveEntity = (PlanChangeEntity)((Object)this.service.getById(planVo.getId()));
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setMemo(planVo.getMemo());
            saveEntity.setBillCode(planVo.getBillCode());
            saveEntity.setTotalPlanTaxMny(planVo.getTotalPlanTaxMny());
            saveEntity.setTotalPlanMny(planVo.getTotalPlanMny());
            saveEntity.setModifyUserName(userContext.getUserName());
        }
        if (null == saveEntity.getTotalPlanMny()) {
            saveEntity.setTotalPlanMny(BigDecimal.ZERO.setScale(8));
        }
        if (Boolean.FALSE.equals(isControl) && planVo.getId() == null) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ExecutionVO executionVO1 = this.service.getLastExecutionVO(planVo.getSourcePlanId());
            totalExecutionVOList.add(executionVO1.getTotalVO());
            this.logger.info("\u65b0\u589e\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4\uff0c\u5220\u9664\u5df2\u6709\u7684\u76ee\u6807\u6210\u672c\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(totalExecutionVOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            this.logger.info("\u65b0\u589e\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4\uff0c\u5220\u9664\u5df2\u6709\u7684\u76ee\u6807\u6210\u672c\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        HashMap<Long, PlanDetailChangeEntity> parentMap = new HashMap<Long, PlanDetailChangeEntity>();
        HashSet<Long> checkParentChangeStateList = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            HashMap idMap = new HashMap();
            for (PlanDetailChangeEntity detail : detailList) {
                if (isNew && !"add".equals(detail.getRowState())) {
                    detail.setId(IdWorker.getId());
                }
                if (!"del".equals(detail.getRowState())) {
                    if (null == saveEntity.getId() || null == detail.getId()) {
                        detail.setId(IdWorker.getId());
                    }
                    detail.setParentId(null);
                    detail.setPlanId(saveEntity.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                if (null != detail.getPlanNum()) continue;
                parentMap.put(detail.getId(), detail);
            }
            for (PlanDetailChangeEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
                checkParentChangeStateList.add(detail.getParentId());
            }
        }
        if (CollectionUtils.isNotEmpty(checkParentChangeStateList)) {
            for (Long parentId : checkParentChangeStateList) {
                this.handleChangeState(parentId, parentMap);
            }
        }
        saveEntity.setPlanDetailList(detailList);
        saveEntity = this.service.saveOrUpdatePlanChange(saveEntity, isControl);
        if (saveEntity.getId() != null && !isControl.booleanValue()) {
            planChangeVO = this.service.queryDetail(saveEntity.getId(), true);
        } else {
            saveEntity.setId(IdWorker.getId());
            planChangeVO = (PlanChangeVO)BeanMapper.map((Object)((Object)saveEntity), PlanChangeVO.class);
        }
        if (Boolean.FALSE.equals(isControl)) {
            String linkUrl = saveEntity.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/changeCard?id=" + saveEntity.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/changeCard?id=" + saveEntity.getId();
            PlanChangeVO planChangeVO1 = this.service.queryDetail(saveEntity.getId(), false);
            ExecutionVO executionVO = this.service.targetCost(planChangeVO1, linkUrl, planChangeVO1.getSubType(), planChangeVO1.getSubType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode(), false);
            this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5355\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a {}", (Object)JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5355-{}\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u7ed3\u679c\uff1a {}", (Object)planChangeVO1.getId().toString(), (Object)JSON.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25, \u539f\u56e0\uff1a" + response.getMsg());
            }
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)planChangeVO);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)planChangeVO);
    }

    private void handleChangeState(Long parentId, Map<Long, PlanDetailChangeEntity> parentMap) {
        PlanDetailChangeEntity parent = parentMap.get(parentId);
        if (null != parent && "del".equals(parent.getRowState())) {
            parent.setRowState("edit");
            parent.setChangeType(3);
            parent.setChangeTypeDesc("\u53d8\u66f4\u9879");
            if (null != parent.getParentId()) {
                this.handleChangeState(parent.getParentId(), parentMap);
            }
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanChangeVO> queryDetail(Long id) {
        PlanChangeVO vo = null;
        vo = this.service.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanChangeVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ArrayList<Object> planEntityList = new ArrayList<Object>();
            for (PlanChangeVO planChangeVO : vos) {
                PlanChangeEntity planChangeEntity = (PlanChangeEntity)((Object)this.service.selectById(planChangeVO.getId()));
                ExecutionVO executionVO = this.service.targetCost((PlanChangeVO)BeanMapper.map((Object)((Object)planChangeEntity), PlanChangeVO.class), "", planChangeEntity.getSubType(), planChangeEntity.getSubType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode(), false);
                totalExecutionVOList.add(executionVO.getTotalVO());
                planEntityList.add(this.planService.selectById(planChangeEntity.getSourcePlanId()));
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            for (PlanEntity planEntity : planEntityList) {
                ExecutionVO executionVO1;
                String linkUrl;
                List planChangeEntities = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"source_plan_id", (Object)planEntity.getId())).orderByDesc((Object)"change_version"));
                if (planChangeEntities.size() > 1) {
                    linkUrl = planEntity.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/changeCard?id=" + planEntity.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/changeCard?id=" + planEntity.getId();
                    executionVO1 = this.service.targetCost((PlanChangeVO)BeanMapper.map(planChangeEntities.get(1), PlanChangeVO.class), linkUrl, ((PlanChangeEntity)((Object)planChangeEntities.get(1))).getSubType(), ((PlanChangeEntity)((Object)planChangeEntities.get(1))).getSubType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode(), false);
                } else {
                    linkUrl = planEntity.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/card?id=" + planEntity.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/card?id=" + planEntity.getId();
                    executionVO1 = this.planService.targetCost((PlanVO)BeanMapper.map((Object)((Object)planEntity), PlanVO.class), linkUrl, planEntity.getSubType());
                }
                this.logger.info("\u603b\u8ba1\u5212\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)executionVO1));
                CommonResponse response1 = this.executionApi.aggPush(executionVO1);
                this.logger.info("\u603b\u8ba1\u5212-{}\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u7ed3\u679c\uff1a{}", (Object)planEntity.getId().toString(), (Object)JSONObject.toJSONString((Object)response1));
                if (response1.isSuccess()) continue;
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            this.service.deleteChangePlan(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<PlanDetailChangeEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((PlanDetailChangeEntity)((Object)BeanMapper.map(ypd, PlanDetailChangeEntity.class)));
        }
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody PlanChangeVO planChangeVO) {
        CommonResponse<PlanChangeVO> planChangeVOCommonResponse = this.getPlanChangeVOCommonResponse(planChangeVO, true);
        if (!planChangeVOCommonResponse.isSuccess()) {
            return CommonResponse.error((String)planChangeVOCommonResponse.getMsg());
        }
        PlanChangeVO pcv = (PlanChangeVO)planChangeVOCommonResponse.getData();
        String linkUrl = pcv.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/changeCard?id=" + pcv.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/changeCard?id=" + pcv.getId();
        ExecutionVO executionVO = this.service.targetCost(pcv, linkUrl, pcv.getSubType(), pcv.getSubType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode(), true);
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\uff0c\u76ee\u6807\u6210\u672c\u6821\u9a8c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\uff0c\u76ee\u6807\u6210\u672c\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.paramCheck(planChangeVO, (CommonResponse<ParamsCheckVO>)response);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        PlanChangeVO pcv = this.service.queryDetail(id, false);
        String linkUrl = pcv.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/changeCard?id=" + pcv.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/changeCard?id=" + pcv.getId();
        ExecutionVO executionVO = this.service.targetCost(pcv, linkUrl, pcv.getSubType(), pcv.getSubType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode(), false);
        this.logger.error("\u603b\u8ba1\u5212\u53d8\u66f4\uff0c\u76ee\u6807\u6210\u672c\u6821\u9a8c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\uff0c\u76ee\u6807\u6210\u672c\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.paramCheck(pcv, (CommonResponse<ParamsCheckVO>)response);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    private ParamsCheckVO paramCheck(PlanChangeVO planChangeVO, CommonResponse<ParamsCheckVO> response) {
        ParamsCheckVO responseData = (ParamsCheckVO)response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();
        ArrayList<ParamsCheckVO> allCheck = new ArrayList<ParamsCheckVO>();
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7 \u63a7 \u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u4ef7 start");
        allCheck.addAll(this.service.targetCostPriceCtrlPlanPrice(planChangeVO));
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7 \u63a7 \u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u4ef7 end");
        this.logger.info("allCheck:{}", (Object)JSONObject.toJSONString(allCheck));
        this.logger.info("\u5386\u53f2\u4ef7\u63a7 \u603b\u8ba1\u5212\u4ef7 start");
        allCheck.addAll(this.service.historyPriceCtrlPlanPrice(planChangeVO));
        this.logger.info("\u5386\u53f2\u4ef7\u63a7 \u603b\u8ba1\u5212\u4ef7 end");
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }
        if (null == responseData.getWarnType() || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            for (ParamsCheckVO paramsCheckVO : result) {
                resp.getDataSource().addAll(paramsCheckVO.getDataSource());
            }
        } else if (ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            if (CollectionUtils.isNotEmpty((Collection)responseData.getDataSource())) {
                resp.getDataSource().addAll(responseData.getDataSource());
            }
            for (ParamsCheckVO paramsCheckVO : result) {
                resp.getDataSource().addAll(paramsCheckVO.getDataSource());
            }
        } else {
            return responseData;
        }
        return resp;
    }
}

