/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanChangeHisMapper;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.plan.mapper.PlanDetailChangeMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailChangeService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.PlanDetailChangeVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="planChangeService")
public class PlanChangeServiceImpl
extends BaseServiceImpl<PlanChangeMapper, PlanChangeEntity>
implements IPlanChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanService masterPlanService;
    @Autowired
    private PlanChangeMapper planChangeMapper;
    @Autowired
    private PlanDetailChangeMapper masterPlanDetailChangeMapper;
    @Autowired
    private PlanChangeHisMapper masterPlanChangeHisMapper;
    @Autowired
    private IPlanDetailChangeService masterPlanDetailChangeService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    private final String LAB_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-D12WrV0223";
    private final String PRO_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-yPfPb50221";
    private final String LAB_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-W3h8660273";
    private final String PRO_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-Ic8ufh0276";
    private final String LAB_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-033zg70274";
    private final String PRO_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-5cB3y00275";
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public PlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_plan_id", (Object)sourcePlanId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (PlanChangeEntity)((Object)this.planChangeMapper.selectOne((Wrapper)query));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity, Boolean isControl) {
        if (Boolean.FALSE.equals(isControl)) {
            if (CollectionUtils.isNotEmpty(saveEntity.getPlanDetailList())) {
                // empty if block
            }
            super.saveOrUpdate((Object)saveEntity, false);
            PlanEntity planEntity = (PlanEntity)((Object)this.masterPlanService.selectById(saveEntity.getSourcePlanId()));
            if (1 != planEntity.getChangeState()) {
                planEntity.setChangeState(1);
                planEntity.setChangeId(saveEntity.getId());
                this.masterPlanService.saveOrUpdate((Object)planEntity, false);
            }
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteChangePlan(List<Long> changeIds) {
        List changeList = this.planChangeMapper.selectBatchIds(changeIds);
        List planIds = changeList.stream().map(PlanChangeEntity::getSourcePlanId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", planIds);
        List planList = this.masterPlanService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_plan_id as planId"});
        query.in((Object)"source_plan_id", planIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_plan_id"});
        List queryResult = this.masterPlanChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = planList.iterator();
        while (iterator.hasNext()) {
            PlanEntity plan;
            plan.setChangeState(null != hisCountNumMap.get((plan = (PlanEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(plan.getId()) > 0 ? 2 : 0);
            plan.setChangeId(null);
        }
        this.masterPlanService.saveOrUpdateBatch(planList, planList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<PlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PlanChangeEntity::getSourcePlanId, (Object)id);
        lambda.in(PlanChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List recordVOList = BeanMapper.mapList((Iterable)entities, PlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getBillCode() + "-0" + recordVO.getChangeVersion());
            } else {
                recordVO.setHistoryCode(recordVO.getBillCode() + "-" + recordVO.getChangeVersion());
            }
        });
        return recordVOList;
    }

    @Override
    public PlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        PlanChangeEntity masterPlanChangeEntity = (PlanChangeEntity)((Object)super.selectById((Serializable)id));
        PlanChangeVO masterPlanChangeVO = (PlanChangeVO)BeanMapper.map((Object)((Object)masterPlanChangeEntity), PlanChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List masterPlanDetailChangeEntities = this.masterPlanDetailChangeService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)masterPlanDetailChangeEntities)) {
            masterPlanDetailChangeEntities.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (PlanDetailChangeEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class);
            List<PlanDetailChangeVO> usefulDetailList = this.selectUsefulByIds(resultMapList.stream().map(PlanDetailChangeVO::getTargetId).collect(Collectors.toList()));
            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<Long, Integer>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)) {
                for (PlanDetailChangeVO c : usefulDetailList) {
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailChangeVO c : resultMapList) {
                if (null != usefulDetailMap.get(c.getTargetId())) {
                    c.setUseNum(Integer.valueOf(1));
                    c.setRowState("edit");
                    continue;
                }
                c.setUseNum(null);
            }
            if (detailHasChildren) {
                masterPlanChangeVO.setPlanDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                masterPlanChangeVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanChangeVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class));
        }
        return masterPlanChangeVO;
    }

    @Override
    public List<PlanDetailChangeVO> selectUsefulByIds(List<Long> planIdList) {
        return this.masterPlanDetailChangeMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public ExecutionVO targetCost(PlanChangeVO planChangeVO, String linkUrl, Integer subType, String billTypeCode, boolean lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(planChangeVO.getId());
        totalVO.setTenantId(planChangeVO.getTenantId());
        totalVO.setBillCode(planChangeVO.getBillCode());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setBillType(billTypeCode);
        if (lastSourceId) {
            if (null == planChangeVO.getId()) {
                totalVO.setLastSourceId(this.getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
            } else {
                PlanChangeEntity change = (PlanChangeEntity)((Object)super.selectById((Serializable)planChangeVO.getId()));
                if (null == change) {
                    totalVO.setLastSourceId(this.getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
                }
            }
        }
        if (subType == 0) {
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getCode());
        } else {
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setProjectId(planChangeVO.getProjectId());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setMoney(planChangeVO.getTotalPlanMny());
        totalVO.setTaxMoney(planChangeVO.getTotalPlanTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (null != planChangeVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planChangeVO.getCreateTime()));
        }
        totalVO.setMemo(planChangeVO.getChangeReason());
        if (CollectionUtils.isNotEmpty((Collection)planChangeVO.getPlanDetailList())) {
            CommonResponse res;
            List planDetailChangeVOS = planChangeVO.getPlanDetailList().stream().filter(item -> item.getLeafFlag() != false && !"del".equals(item.getRowState()) && (null == item.getChangeType() || !item.getChangeType().equals(5))).collect(Collectors.toList());
            Assert.notEmpty(planDetailChangeVOS, (String)"\u6e05\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Map<Object, Object> labsubCategoryVOMap = new HashMap();
            Map<Object, Object> prosubCategoryVOMap = new HashMap();
            if (0 == subType) {
                res = this.shareLabsubApi.queryCategoryListByIds(planDetailChangeVOS.stream().map(PlanDetailChangeVO::getDocCategoryId).collect(Collectors.toList()));
                this.logger.info("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)res));
                if (!res.isSuccess() || res.getData() == null) {
                    throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                }
                labsubCategoryVOMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
            } else {
                res = this.shareProsubApi.queryCategoryListByIds(planDetailChangeVOS.stream().map(PlanDetailChangeVO::getDocCategoryId).collect(Collectors.toList()));
                this.logger.info("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)res));
                if (!res.isSuccess() || res.getData() == null) {
                    throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                }
                prosubCategoryVOMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
            }
            for (PlanDetailChangeVO planDetailVO : planDetailChangeVOS) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                Assert.notNull((Object)planDetailVO.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
                if (0 == subType) {
                    if (!labsubCategoryVOMap.containsKey(planDetailVO.getDocCategoryId())) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(((LabsubCategoryVO)labsubCategoryVOMap.get(planDetailVO.getDocCategoryId())).getInnerCode());
                        detailExecutionVO.setCategoryCode(((LabsubCategoryVO)labsubCategoryVOMap.get(planDetailVO.getDocCategoryId())).getCategoryCode());
                        detailExecutionVO.setCategoryName(((LabsubCategoryVO)labsubCategoryVOMap.get(planDetailVO.getDocCategoryId())).getCategoryName());
                    }
                } else if (!prosubCategoryVOMap.containsKey(planDetailVO.getDocCategoryId())) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(((ProsubCategoryVO)prosubCategoryVOMap.get(planDetailVO.getDocCategoryId())).getInnerCode());
                    detailExecutionVO.setCategoryCode(((ProsubCategoryVO)prosubCategoryVOMap.get(planDetailVO.getDocCategoryId())).getCategoryCode());
                    detailExecutionVO.setCategoryName(((ProsubCategoryVO)prosubCategoryVOMap.get(planDetailVO.getDocCategoryId())).getCategoryName());
                }
                Assert.notNull((Object)planDetailVO.getDocId(), (String)"\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if (null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ExecutionVO getLastExecutionVO(Long sourcePlanId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"source_plan_id", (Object)sourcePlanId)).orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)wrapper);
        PlanChangeEntity tmp = null;
        String linkUrl = null;
        String frontendBaseHost = "";
        frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BASE_HOST;
        if (!list.isEmpty()) {
            tmp = (PlanChangeEntity)((Object)list.get(0));
            QueryWrapper detailWrapper = new QueryWrapper();
            detailWrapper.eq((Object)"plan_id", (Object)tmp.getId());
            tmp.setPlanDetailList(this.masterPlanDetailChangeMapper.selectList((Wrapper)detailWrapper));
            linkUrl = tmp.getSubType() == 0 ? frontendBaseHost + "ejc-prosub-frontend/#/labSubPlan/changeCard?id=" + tmp.getId() : frontendBaseHost + "ejc-prosub-frontend/#/proSubPlan/changeCard?id=" + tmp.getId();
            return this.targetCost((PlanChangeVO)BeanMapper.map((Object)((Object)tmp), PlanChangeVO.class), linkUrl, tmp.getSubType(), tmp.getSubType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode(), false);
        }
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(sourcePlanId));
        linkUrl = planEntity.getSubType() == 0 ? frontendBaseHost + "ejc-prosub-frontend/#/labSubPlan/card?id=" + planEntity.getId() : frontendBaseHost + "ejc-prosub-frontend/#/proSubPlan/card?id=" + planEntity.getId();
        return this.planService.targetCost((PlanVO)BeanMapper.map((Object)((Object)planEntity), PlanVO.class), linkUrl, planEntity.getSubType());
    }

    @Override
    public List<ParamsCheckVO> targetCostPriceCtrlPlanPrice(PlanChangeVO planChangeVO) {
        this.logger.info("prosub---PlanChangeServiceImpl---targetCostPriceCtrlPlanPrice()--- \u76ee\u6807\u6210\u672c\u4ef7\u63a7\u603b\u8ba1\u5212\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)planChangeVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        Integer contractType = planChangeVO.getSubType();
        List detailList = planChangeVO.getPlanDetailList();
        if (0 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-D12WrV0223", planChangeVO.getOrgId());
        }
        if (1 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-yPfPb50221", planChangeVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u76ee\u6807\u6210\u672c\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u76ee\u6807\u6210\u672c\u4ef7\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List docIds = detailList.stream().filter(item -> null != item.getPlanNum()).map(PlanDetailChangeVO::getDocId).collect(Collectors.toList());
        CommonResponse dutyRes = this.dutyApi.queryPriceByDocIds(planChangeVO.getProjectId(), 0 == contractType ? DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode() : DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode(), docIds);
        if (null == dutyRes) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683c\u4e3a\u7a7a");
            return paramsCheckVOList;
        }
        Map dutyMap = (Map)dutyRes.getData();
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        if (null == dutyMap) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683cmap\u4e3a\u7a7a");
            return paramsCheckVOList;
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7map\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)dutyMap));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (PlanDetailChangeVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    if (null == detailVO.getPlanNum() || "del".equals(detailVO.getRowState())) continue;
                    BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : (BigDecimal)dutyMap.get(detailVO.getDocId());
                    BigDecimal price = null == detailVO.getPlanPrice() ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, 4);
                    if (price.compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getWorkContent() == null ? "" : "+" + detailVO.getWorkContent()));
                    paramsCheckDsVO.setWarnName("\u8ba1\u5212\u5355\u4ef7\u5927\u4e8e\u76ee\u6807\u6210\u672c\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8ba1\u5212\u5355\u4ef7\uff1a").append(price).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u5355\u4ef7\uff1a(").append(maxPrice).append("\u5143),\u76ee\u6807\u6210\u672c\u5355\u4ef7*").append(roleValueMax).append("%\uff1a").append(maxPriceParam).append("\u5143\uff0c\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlPlanPrice(PlanChangeVO planChangeVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        this.logger.info("prosub---PlanChangeServiceImpl---historyPriceCtrlPlanPrice()--- \u5386\u53f2\u4ef7\u63a7\u603b\u8ba1\u5212\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)planChangeVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        CommonResponse minParamByCode = new CommonResponse();
        Integer contractType = planChangeVO.getSubType();
        Integer princeDepot = null;
        List detailList = planChangeVO.getPlanDetailList();
        if (0 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-W3h8660273", planChangeVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-033zg70274", planChangeVO.getOrgId());
            princeDepot = PrinceDepotEnum.\u52b3\u52a1\u5206\u5305\u4ef7\u683c\u5e93.getCode();
        }
        if (1 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-Ic8ufh0276", planChangeVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-5cB3y00275", planChangeVO.getOrgId());
            princeDepot = PrinceDepotEnum.\u4e13\u4e1a\u5206\u5305\u4ef7\u683c\u5e93.getCode();
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u603b\u8ba1\u5212\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u603b\u8ba1\u5212\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)princeDepot));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(princeDepot);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (PlanDetailChangeVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u603b\u8ba1\u5212\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPlanPrice() == null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                if ("none".equals(paramsArray[minParamVO.getControlType()])) continue;
                for (PlanDetailChangeVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u603b\u8ba1\u5212\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPlanPrice() == null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }
        return paramsCheckVOList;
    }
}

