package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanChangeHisMapper;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.plan.mapper.PlanDetailChangeMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailChangeService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.PlanDetailChangeVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包总计划变更实体
 * 
 * @author generator
 * 
 */
@Service("planChangeService")
public class PlanChangeServiceImpl extends BaseServiceImpl<PlanChangeMapper, PlanChangeEntity> implements IPlanChangeService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanService masterPlanService;
    @Autowired
    private PlanChangeMapper planChangeMapper;
    @Autowired
    private PlanDetailChangeMapper masterPlanDetailChangeMapper;
    @Autowired
    private PlanChangeHisMapper masterPlanChangeHisMapper;
    @Autowired
    private IPlanDetailChangeService masterPlanDetailChangeService;

    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Autowired
    private IShareProsubApi shareProsubApi;

    @Autowired
    private IPlanService planService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IDutyApi dutyApi;


    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    // 【目标成本劳务分包价格】控【劳务分包总计划】
    private final String LAB_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-D12WrV0223";
    // 【目标成本专业分包价格】控【专业分包总计划】
    private final String PRO_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-yPfPb50221";

    //【分包清单历史最高价】 控【劳务分包总计划】
    private final String LAB_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-W3h8660273";
    //【分包清单历史最高价】 控【专业分包总计划】
    private final String PRO_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-Ic8ufh0276";
    //【分包清单历史最低价】 控【劳务分包总计划】
    private final String LAB_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-033zg70274";
    //【分包清单历史最低价】 控【专业分包总计划】
    private final String PRO_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-5cB3y00275";

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public PlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<PlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", sourcePlanId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity, Boolean isControl) {
        if (Boolean.FALSE.equals(isControl)) {
            if(CollectionUtils.isNotEmpty(saveEntity.getPlanDetailList())) {
                //更新子表信息
            /*if(null != saveEntity.getId()) {
                masterPlanDetailChangeMapper.delByPlanId(saveEntity.getId());
            }*/
            }
            super.saveOrUpdate(saveEntity, false);

            PlanEntity planEntity = masterPlanService.selectById(saveEntity.getSourcePlanId());
            if(1 != planEntity.getChangeState()) {
                planEntity.setChangeState(1);
                planEntity.setChangeId(saveEntity.getId());
                masterPlanService.saveOrUpdate(planEntity, false);
            }
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangePlan(List<Long> changeIds) {
        List<PlanChangeEntity> changeList = planChangeMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(PlanChangeEntity::getSourcePlanId).collect(Collectors.toList());

        QueryWrapper<PlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<PlanEntity> planList = masterPlanService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<PlanChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_plan_id as planId");
        query.in("source_plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_plan_id");

        List<Map<String, Object>> queryResult =masterPlanChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for(PlanEntity plan : planList) {
            plan.setChangeState((null !=hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setChangeId(null);
        }

        masterPlanService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(PlanChangeEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<PlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<PlanChangeEntity> lambda = Wrappers.<PlanChangeEntity>lambdaQuery();
        lambda.eq(PlanChangeEntity::getSourcePlanId, id);
        lambda.in(PlanChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PlanChangeEntity> entities = super.list(lambda);
        List<PlanChangeHisVO> recordVOList = BeanMapper.mapList(entities, PlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
                    if(recordVO.getChangeVersion() < 10){
                        recordVO.setHistoryCode(recordVO.getBillCode() + "-0" + recordVO.getChangeVersion());
                    }else{
                        recordVO.setHistoryCode(recordVO.getBillCode() + "-" + recordVO.getChangeVersion());
                    }
                }
        );
        return recordVOList;
    }

    @Override
    public PlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        PlanChangeEntity masterPlanChangeEntity = super.selectById(id);
        PlanChangeVO masterPlanChangeVO = BeanMapper.map(masterPlanChangeEntity, PlanChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<PlanDetailChangeEntity> masterPlanDetailChangeEntities = masterPlanDetailChangeService.queryList(queryParam, false);
        List<PlanDetailChangeEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(masterPlanDetailChangeEntities)) {
            masterPlanDetailChangeEntities.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(PlanDetailChangeEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
            }
            List<PlanDetailChangeVO> resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class);


            //判断当前清单是否被下游引用，如果引用，则该条数据不能被删除。
            //判断清单是否被下游数据引用（合同、招标）
            List<PlanDetailChangeVO> usefulDetailList = selectUsefulByIds(resultMapList.stream().map(PlanDetailChangeVO::getTargetId).collect(Collectors.toList()));

            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)){
                for (PlanDetailChangeVO c : usefulDetailList){
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailChangeVO c : resultMapList){
                if (null != usefulDetailMap.get(c.getTargetId())){
                    //如果被下游引用，则改变rowState不能删除
                    c.setUseNum(1);
                    c.setRowState("edit");
                }else {
                    c.setUseNum(null);
                }
            }


            if(detailHasChildren){
                masterPlanChangeVO.setPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                masterPlanChangeVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanChangeVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class));
        }

        return masterPlanChangeVO;
    }

    //查询当前明细id集合中的id是否被下游业务使用（合同、定标）
    @Override
    public List<PlanDetailChangeVO> selectUsefulByIds(List<Long> planIdList) {
        return masterPlanDetailChangeMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public ExecutionVO targetCost(PlanChangeVO planChangeVO, String linkUrl, Integer subType, String billTypeCode, boolean lastSourceId){
        ExecutionVO executionVO = new ExecutionVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(planChangeVO.getId());
        totalVO.setTenantId(planChangeVO.getTenantId());
        totalVO.setBillCode(planChangeVO.getBillCode());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setBillType(billTypeCode);

        //新增变更并且为控制校验时，将上一版本的Id传入
        if(lastSourceId) {
            if(null == planChangeVO.getId()) {
                totalVO.setLastSourceId(getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
            } else {
                PlanChangeEntity change = super.selectById(planChangeVO.getId());
                if(null == change) {
                    totalVO.setLastSourceId(getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
                }
            }
        }

        if (subType==0){
            totalVO.setBussinessType(BussinessTypeEnum.劳务分包总计划.getCode());
        }else {
            totalVO.setBussinessType(BussinessTypeEnum.专业分包总计划.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(planChangeVO.getProjectId());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setMoney(planChangeVO.getTotalPlanMny()); //总计划金额无税
        totalVO.setTaxMoney(planChangeVO.getTotalPlanTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        if(null != planChangeVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planChangeVO.getCreateTime()));
        }
        totalVO.setMemo(planChangeVO.getChangeReason());

        if (CollectionUtils.isNotEmpty(planChangeVO.getPlanDetailList())) {
            List<PlanDetailChangeVO> planDetailChangeVOS = planChangeVO.getPlanDetailList().stream()
                    .filter(item -> item.getLeafFlag() && !"del".equals(item.getRowState()) && (null == item.getChangeType() || !item.getChangeType().equals(5))).collect(Collectors.toList());
            Assert.notEmpty(planDetailChangeVOS, "清单数据不能为空");


            Map<Long, LabsubCategoryVO> labsubCategoryVOMap = new HashMap<>();
            Map<Long, ProsubCategoryVO> prosubCategoryVOMap = new HashMap<>();
            if (0 == subType){
                // 劳务分包
                CommonResponse<List<LabsubCategoryVO>> res = shareLabsubApi.queryCategoryListByIds(planDetailChangeVOS.stream().map(PlanDetailChangeVO::getDocCategoryId).collect(Collectors.toList()));
                logger.info("根据档案分类id查询劳务分包档案分类信息:{}", JSONObject.toJSONString(res));
                if (!res.isSuccess() || res.getData() == null) {
                    throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                }
                labsubCategoryVOMap = res.getData().stream().collect(Collectors.toMap(LabsubCategoryVO::getId, Function.identity(), (key1, key2) -> key1));

            }else {
                // 专业分包
                CommonResponse<List<ProsubCategoryVO>> res = shareProsubApi.queryCategoryListByIds(planDetailChangeVOS.stream().map(PlanDetailChangeVO::getDocCategoryId).collect(Collectors.toList()));
                logger.info("根据档案分类id查询专业分包档案分类信息:{}", JSONObject.toJSONString(res));
                if (!res.isSuccess() || res.getData() == null) {
                    throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
                }
                prosubCategoryVOMap = res.getData().stream().collect(Collectors.toMap(ProsubCategoryVO::getId, Function.identity(), (key1, key2) -> key1));
            }

            for (PlanDetailChangeVO planDetailVO : planDetailChangeVOS) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId()); // 档案分类ID
                // 根据档案id判断是否是分类
                if (planDetailVO.getDocId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(false);

                // 根据档案分类id查询档案分类信息
                Assert.notNull(planDetailVO.getDocCategoryId(), "档案分类id不能为空");
                if (0 == subType){
                    // 劳务分包
                    if (!labsubCategoryVOMap.containsKey(planDetailVO.getDocCategoryId())){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(labsubCategoryVOMap.get(planDetailVO.getDocCategoryId()).getInnerCode());
                        detailExecutionVO.setCategoryCode(labsubCategoryVOMap.get(planDetailVO.getDocCategoryId()).getCategoryCode());
                        detailExecutionVO.setCategoryName(labsubCategoryVOMap.get(planDetailVO.getDocCategoryId()).getCategoryName());
                    }
                } else {
                    // 专业分包
                    if (!prosubCategoryVOMap.containsKey(planDetailVO.getDocCategoryId())){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(prosubCategoryVOMap.get(planDetailVO.getDocCategoryId()).getInnerCode());
                        detailExecutionVO.setCategoryCode(prosubCategoryVOMap.get(planDetailVO.getDocCategoryId()).getCategoryCode());
                        detailExecutionVO.setCategoryName(prosubCategoryVOMap.get(planDetailVO.getDocCategoryId()).getCategoryName());
                    }
                }

                // 档案id
                Assert.notNull(planDetailVO.getDocId(), "档案id不能为空");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType==0){
                    detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                }else {
                    detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());
                // todo: 单位id
                // detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if(null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ExecutionVO getLastExecutionVO(Long sourcePlanId) {
        QueryWrapper<PlanChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_plan_id", sourcePlanId).orderByDesc("create_time");
        List<PlanChangeEntity> list = super.list(wrapper);

        PlanChangeEntity tmp = null;
        String linkUrl = null;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BASE_HOST;
        }
        //判断是否有过变更
        if (!list.isEmpty()){
            tmp = list.get(0);

            QueryWrapper<PlanDetailChangeEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("plan_id", tmp.getId());
            tmp.setPlanDetailList(masterPlanDetailChangeMapper.selectList(detailWrapper));

            if (tmp.getSubType()==0){
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/labSubPlan/changeCard?id="+tmp.getId();
            }else {
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/proSubPlan/changeCard?id="+tmp.getId();
            }
            // 变更取原总计划id
            return targetCost(BeanMapper.map(tmp, PlanChangeVO.class), linkUrl, tmp.getSubType(), tmp.getSubType().equals(0) ? ProsubBillTypeEnum.劳务分包总计划变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包总计划变更.getBillTypeCode(), false);
        }else {
            PlanEntity planEntity = planService.selectById(sourcePlanId);
            if (planEntity.getSubType()==0){
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/labSubPlan/card?id="+planEntity.getId();
            }else {
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/proSubPlan/card?id="+planEntity.getId();
            }
            return planService.targetCost(BeanMapper.map(planEntity, PlanVO.class), linkUrl, planEntity.getSubType());
        }
    }

    @Override
    public List<ParamsCheckVO> targetCostPriceCtrlPlanPrice(PlanChangeVO planChangeVO) {
        logger.info("prosub---PlanChangeServiceImpl---targetCostPriceCtrlPlanPrice()--- 目标成本价控总计划价入参：{}", JSONObject.toJSONString(planChangeVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        Integer contractType = planChangeVO.getSubType();// 计划类型： 劳务分包合同-0，专业分包合同-1
        List<PlanDetailChangeVO> detailList = planChangeVO.getPlanDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_TARGET_COST_PRICE_CTRL_PLAN_PRICE, planChangeVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_TARGET_COST_PRICE_CTRL_PLAN_PRICE, planChangeVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询目标成本价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数目标成本价查询结果：{}", JSONObject.toJSONString(maxParamByCode));
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果

        List<Long> docIds = detailList.stream().filter(item -> null != item.getPlanNum()).map(PlanDetailChangeVO::getDocId).collect(Collectors.toList());
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByDocIds(planChangeVO.getProjectId(), 0 == contractType ? DocTypeEnum.劳务分包档案.getCode() : DocTypeEnum.专业分包档案.getCode() , docIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVOList;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();

        logger.info("目标成本价参数控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        if (null == dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVOList;
        }
        logger.info("目标成本价map信息返回："+JSONObject.toJSONString(dutyMap));
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(maxParamVOS)){
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (PlanDetailChangeVO detailVO: detailList) {//遍历明细
                    if (null != detailVO.getPlanNum() && !"del".equals(detailVO.getRowState())){
                        BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : dutyMap.get(detailVO.getDocId());//获取目标成本价格
                        BigDecimal price = null == detailVO.getPlanPrice() ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//档案单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getWorkContent() == null ? "" : "+" + detailVO.getWorkContent()));
                            paramsCheckDsVO.setWarnName("计划单价大于目标成本单价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("计划单价：").append(price)
                                    .append("元，目标成本单价：(").append(maxPrice)
                                    .append("元),目标成本单价*").append(roleValueMax).append("%：").append(maxPriceParam)
                                    .append("元，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP)).append("元");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlPlanPrice(PlanChangeVO planChangeVO) {
        logger.info("prosub---PlanChangeServiceImpl---historyPriceCtrlPlanPrice()--- 历史价控总计划价入参：{}", JSONObject.toJSONString(planChangeVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        Integer contractType = planChangeVO.getSubType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        Integer princeDepot = null;
        List<PlanDetailChangeVO> detailList = planChangeVO.getPlanDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE, planChangeVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE, planChangeVO.getOrgId());
            princeDepot = PrinceDepotEnum.劳务分包价格库.getCode();
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE, planChangeVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE, planChangeVO.getOrgId());
            princeDepot = PrinceDepotEnum.专业分包价格库.getCode();
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("总计划历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("总计划历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        // 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(princeDepot));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(princeDepot);
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (PlanDetailChangeVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("总计划清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPlanPrice()==null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("总计划清单单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("总计划清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                for (PlanDetailChangeVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("总计划清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPlanPrice()==null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("总计划清单单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("总计划清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }
}
