/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contract.relieve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contract.relieve.vo.ContractRelieveVO;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="contractRelieveService")
public class ContractRelieveServiceImpl
extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity>
implements IContractRelieveService {
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Boolean isCanRelieve(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        List list = this.service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost(ContractRelieveVO contractRelieveVO, String linkUrl) {
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractRelieveVO.getContractId()));
        List<ContractDetailEntity> contractDetailList = contract.getDetailList();
        Map<Long, List<ContractDetailEntity>> contractDetailMap = contractDetailList.stream().filter(e -> e.getDetailNum() != null).collect(Collectors.groupingBy(ContractDetailEntity::getDocId));
        HashSet<Long> docIds = new HashSet<Long>(contractDetailMap.keySet());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractRelieveVO.getId());
        totalVO.setTenantId(contractRelieveVO.getTenantId());
        totalVO.setBillCode(contractRelieveVO.getBillCode());
        if (contract.getContractType().equals(0)) {
            totalVO.setBillType(ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u89e3\u9664.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getCode());
        } else {
            totalVO.setBillType(ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u89e3\u9664.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractRelieveVO.getProjectId());
        totalVO.setOrgId(contractRelieveVO.getOrgId());
        totalVO.setLinkUrl(linkUrl);
        if (null != contractRelieveVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(contractRelieveVO.getCreateTime()));
        }
        ArrayList processDetailExecution = new ArrayList();
        ArrayList nodeDetailExecution = new ArrayList();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper process = new LambdaQueryWrapper();
        process.eq(BaseEntity::getDr, (Object)0);
        process.in(SettleEntity::getBillState, list);
        process.eq(SettleEntity::getContractId, (Object)contractRelieveVO.getContractId());
        process.eq(SettleEntity::getSettleType, (Object)0);
        List processSettles = this.settleService.list((Wrapper)process);
        BigDecimal processMny = BigDecimal.ZERO;
        BigDecimal processTaxMny = BigDecimal.ZERO;
        LambdaQueryWrapper node = new LambdaQueryWrapper();
        node.eq(BaseEntity::getDr, (Object)0);
        node.in(SettleEntity::getBillState, list);
        node.eq(SettleEntity::getContractId, (Object)contractRelieveVO.getContractId());
        node.eq(SettleEntity::getSettleType, (Object)2);
        List nodeSettles = this.settleService.list((Wrapper)node);
        BigDecimal nodeMny = BigDecimal.ZERO;
        BigDecimal nodeTaxMny = BigDecimal.ZERO;
        ArrayList<DetailExecutionVO> detailExecutionVOS = new ArrayList<DetailExecutionVO>();
        if (CollectionUtils.isEmpty((Collection)processSettles) && CollectionUtils.isEmpty((Collection)nodeSettles)) {
            this.dealRemainingContractDetail(contract, contractDetailMap, docIds, sdf, detailExecutionVOS, contractRelieveVO.getId());
        } else {
            List settleIds;
            if (CollectionUtils.isNotEmpty((Collection)processSettles)) {
                processMny = processSettles.stream().map(SettleEntity::getMny).reduce(processMny, BigDecimal::add);
                processTaxMny = processSettles.stream().map(SettleEntity::getTaxMny).reduce(processTaxMny, BigDecimal::add);
                settleIds = processSettles.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper processDetail = new LambdaQueryWrapper();
                processDetail.in(SettleDetailEntity::getSettleId, settleIds);
                List processDetailNfList = this.settleDetailService.list((Wrapper)processDetail);
                List processDetailList = processDetailNfList.stream().filter(e -> e.getSettleNum() != null).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(processDetailList)) {
                    Map<Long, List<SettleDetailEntity>> processDetailMap = processDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getDocId));
                    processDetailMap.forEach((docId, settleDetailList) -> {
                        BigDecimal detailNum = settleDetailList.stream().map(SettleDetailEntity::getSettleNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal detailMny = settleDetailList.stream().map(SettleDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal detailTaxMny = settleDetailList.stream().map(SettleDetailEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal contractDetailNum = ((List)contractDetailMap.get(docId)).stream().map(ContractDetailEntity::getDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal contractDetailMny = ((List)contractDetailMap.get(docId)).stream().map(ContractDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal contractDetailTaxMny = ((List)contractDetailMap.get(docId)).stream().map(ContractDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        SettleDetailEntity sd = (SettleDetailEntity)((Object)((Object)settleDetailList.get(0)));
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setTenantId(sd.getTenantId());
                        detailExecutionVO.setDocId(sd.getDocId());
                        detailExecutionVO.setCode(sd.getSourceBillCode());
                        detailExecutionVO.setName(sd.getDetailName());
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(sd.getDocId() == null));
                        detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                        detailExecutionVO.setCategoryId(sd.getDocCategoryId());
                        Assert.notNull((Object)sd.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
                        if (0 == contract.getContractType()) {
                            detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                            CommonResponse res = this.shareLabsubApi.queryLabSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)sd.getDocCategoryId());
                                throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                            }
                            LabsubCategoryVO categoryVO = (LabsubCategoryVO)res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        } else {
                            detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                            CommonResponse res = this.shareLabsubApi.queryMajorSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)sd.getDocCategoryId());
                                throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                            }
                            ProsubCategoryVO categoryVO = (ProsubCategoryVO)res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        }
                        detailExecutionVO.setNum(ComputeUtil.safeSub((BigDecimal)detailNum, (BigDecimal)contractDetailNum));
                        detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)detailMny, (BigDecimal)contractDetailMny));
                        detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)detailTaxMny, (BigDecimal)contractDetailTaxMny));
                        detailExecutionVO.setUnitName(sd.getDetailUnit());
                        detailExecutionVO.setMemo(sd.getMemo());
                        detailExecutionVO.setPrice(sd.getDetailPrice());
                        detailExecutionVO.setTaxPrice(sd.getDetailTaxPrice());
                        detailExecutionVO.setSpec(sd.getDetailMeasurementRules());
                        if (null != sd.getCreateTime()) {
                            detailExecutionVO.setBillDate(sdf.format(sd.getCreateTime()));
                        }
                        detailExecutionVO.setTaxRate(sd.getDetailTaxRate());
                        detailExecutionVO.setSourceId(sd.getId());
                        detailExecutionVO.setSourceBillId(contractRelieveVO.getId());
                        processDetailExecution.add(detailExecutionVO);
                        docIds.remove(docId);
                    });
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)nodeSettles)) {
                nodeMny = nodeSettles.stream().map(SettleEntity::getMny).reduce(nodeMny, BigDecimal::add);
                nodeTaxMny = nodeSettles.stream().map(SettleEntity::getTaxMny).reduce(nodeTaxMny, BigDecimal::add);
                settleIds = nodeSettles.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper nodeDetail = new LambdaQueryWrapper();
                nodeDetail.in(SettleDetailEntity::getSettleId, settleIds);
                List nodeDetailNfList = this.settleDetailService.list((Wrapper)nodeDetail);
                List nodeDetailList = nodeDetailNfList.stream().filter(e -> e.getSettleNum() != null).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(nodeDetailList)) {
                    Map<Long, List<SettleDetailEntity>> nodeDetailMap = nodeDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getDocId));
                    nodeDetailMap.forEach((docId, settleDetailList) -> {
                        BigDecimal detailNum = settleDetailList.stream().map(SettleDetailEntity::getSettleNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal detailMny = settleDetailList.stream().map(SettleDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal detailTaxMny = settleDetailList.stream().map(SettleDetailEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal contractDetailNum = ((List)contractDetailMap.get(docId)).stream().map(ContractDetailEntity::getDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal contractDetailMny = ((List)contractDetailMap.get(docId)).stream().map(ContractDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal contractDetailTaxMny = ((List)contractDetailMap.get(docId)).stream().map(ContractDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        SettleDetailEntity sd = (SettleDetailEntity)((Object)((Object)settleDetailList.get(0)));
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setTenantId(sd.getTenantId());
                        detailExecutionVO.setDocId(sd.getDocId());
                        detailExecutionVO.setCode(sd.getSourceBillCode());
                        detailExecutionVO.setName(sd.getDetailName());
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(sd.getDocId() == null));
                        detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                        detailExecutionVO.setCategoryId(sd.getDocCategoryId());
                        Assert.notNull((Object)sd.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
                        if (0 == contract.getContractType()) {
                            detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                            CommonResponse res = this.shareLabsubApi.queryLabSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)sd.getDocCategoryId());
                                throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                            }
                            LabsubCategoryVO categoryVO = (LabsubCategoryVO)res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        } else {
                            detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                            CommonResponse res = this.shareLabsubApi.queryMajorSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)sd.getDocCategoryId());
                                throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                            }
                            ProsubCategoryVO categoryVO = (ProsubCategoryVO)res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        }
                        detailExecutionVO.setNum(ComputeUtil.safeSub((BigDecimal)detailNum, (BigDecimal)contractDetailNum));
                        detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)detailMny, (BigDecimal)contractDetailMny));
                        detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)detailTaxMny, (BigDecimal)contractDetailTaxMny));
                        detailExecutionVO.setUnitName(sd.getDetailUnit());
                        detailExecutionVO.setMemo(sd.getMemo());
                        detailExecutionVO.setPrice(sd.getDetailPrice());
                        detailExecutionVO.setTaxPrice(sd.getDetailTaxPrice());
                        detailExecutionVO.setSpec(sd.getDetailMeasurementRules());
                        if (null != sd.getCreateTime()) {
                            detailExecutionVO.setBillDate(sdf.format(sd.getCreateTime()));
                        }
                        detailExecutionVO.setTaxRate(sd.getDetailTaxRate());
                        detailExecutionVO.setSourceId(sd.getId());
                        detailExecutionVO.setSourceBillId(contractRelieveVO.getId());
                        nodeDetailExecution.add(detailExecutionVO);
                        docIds.remove(docId);
                    });
                }
            }
            if (CollectionUtils.isNotEmpty(processDetailExecution)) {
                if (CollectionUtils.isNotEmpty(nodeDetailExecution)) {
                    List ps = processDetailExecution.stream().map(DetailExecutionVO::getDocId).collect(Collectors.toList());
                    List nd = nodeDetailExecution.stream().map(DetailExecutionVO::getDocId).collect(Collectors.toList());
                    List processDetailExecutionList = processDetailExecution.stream().filter(p -> !nd.contains(p.getDocId())).collect(Collectors.toList());
                    List nodeDetailExecutionList = nodeDetailExecution.stream().filter(n -> !ps.contains(n.getDocId())).collect(Collectors.toList());
                    detailExecutionVOS.addAll(processDetailExecutionList);
                    detailExecutionVOS.addAll(nodeDetailExecutionList);
                    List<Long> intersectionList = processDetailExecution.stream().filter(p -> nd.contains(p.getDocId())).map(DetailExecutionVO::getDocId).collect(Collectors.toList());
                    intersectionList.forEach(docId -> {
                        DetailExecutionVO processDetailExecutionVO = processDetailExecution.stream().filter(p -> p.getDocId().equals(docId)).findFirst().get();
                        DetailExecutionVO nodeDetailExecutionVO = nodeDetailExecution.stream().filter(n -> n.getDocId().equals(docId)).findFirst().get();
                        if (processDetailExecutionVO.getNum().compareTo(nodeDetailExecutionVO.getNum()) >= 0) {
                            detailExecutionVOS.add(processDetailExecutionVO);
                        } else {
                            detailExecutionVOS.add(nodeDetailExecutionVO);
                        }
                    });
                } else {
                    detailExecutionVOS.addAll(processDetailExecution);
                }
            } else if (CollectionUtils.isNotEmpty(nodeDetailExecution)) {
                detailExecutionVOS.addAll(nodeDetailExecution);
            }
            this.dealRemainingContractDetail(contract, contractDetailMap, docIds, sdf, detailExecutionVOS, contractRelieveVO.getId());
        }
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)processMny.max(nodeMny), (BigDecimal)contract.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)processTaxMny.max(nodeTaxMny), (BigDecimal)contract.getContractTaxMny()));
        executionVO.setDetailList(detailExecutionVOS);
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    private void dealRemainingContractDetail(ContractEntity contract, Map<Long, List<ContractDetailEntity>> contractDetailMap, Set<Long> docIds, SimpleDateFormat sdf, ArrayList<DetailExecutionVO> detailExecutionVOS, Long contractReliveId) {
        if (CollectionUtils.isNotEmpty(docIds)) {
            CommonResponse res;
            ArrayList<Long> categoryDocIdList = new ArrayList<Long>();
            if (null != contractDetailMap) {
                for (Map.Entry<Long, List<ContractDetailEntity>> listEntry : contractDetailMap.entrySet()) {
                    categoryDocIdList.add(listEntry.getValue().get(0).getDocCategoryId());
                }
            }
            this.logger.info("\u6240\u67e5categoryDocIdList-{}", (Object)JSONObject.toJSONString(categoryDocIdList));
            Map<Object, Object> labsubCategoryMap = new HashMap();
            Map<Object, Object> prosubCategoryMap = new HashMap();
            if (contract.getContractType().equals(0)) {
                res = this.shareLabsubApi.queryCategoryListByIds(categoryDocIdList);
                if (!res.isSuccess() || res.getData() == null || ((List)res.getData()).size() == 0) {
                    this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bdocIdList:{}", (Object)JSONObject.toJSONString(categoryDocIdList));
                    throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                }
                labsubCategoryMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (k1, k2) -> k2));
                this.logger.info("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u957f\u5ea6{}", (Object)labsubCategoryMap.size());
            } else {
                res = this.shareProsubApi.queryCategoryListByIds(categoryDocIdList);
                if (!res.isSuccess() || res.getData() == null || ((List)res.getData()).size() == 0) {
                    this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bdocIdList:{}", (Object)JSONObject.toJSONString(categoryDocIdList));
                    throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                }
                prosubCategoryMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (k1, k2) -> k2));
                this.logger.info("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u957f\u5ea6{}", (Object)prosubCategoryMap.size());
            }
            for (Long docId : docIds) {
                LabsubCategoryVO categoryVO;
                BigDecimal contractDetailNum = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractDetailMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractDetailTaxMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                ContractDetailEntity cd = contractDetailMap.get(docId).get(0);
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setTenantId(cd.getTenantId());
                detailExecutionVO.setDocId(cd.getDocId());
                detailExecutionVO.setCode(cd.getDetailCode());
                detailExecutionVO.setName(cd.getDetailName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(cd.getDocId() == null));
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setCategoryId(cd.getDocCategoryId());
                Assert.notNull((Object)cd.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
                if (0 == contract.getContractType()) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    categoryVO = (LabsubCategoryVO)labsubCategoryMap.get(docId);
                    this.logger.info("\u6240\u67e5categoryVO-{}", (Object)JSONObject.toJSONString((Object)categoryVO));
                    if (null == categoryVO) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                        detailExecutionVO.setCategoryName(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                    categoryVO = (ProsubCategoryVO)prosubCategoryMap.get(docId);
                    this.logger.info("\u6240\u67e5categoryVO-{}", (Object)JSONObject.toJSONString((Object)categoryVO));
                    if (null == categoryVO) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                        detailExecutionVO.setCategoryName(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }
                detailExecutionVO.setNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)contractDetailNum));
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)contractDetailMny));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)contractDetailTaxMny));
                detailExecutionVO.setUnitName(cd.getDetailUnit());
                detailExecutionVO.setMemo(cd.getDetailMemo());
                detailExecutionVO.setPrice(cd.getDetailPrice());
                detailExecutionVO.setTaxPrice(cd.getDetailTaxPrice());
                detailExecutionVO.setSpec(cd.getDetailMeasurementRules());
                if (null != cd.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(cd.getCreateTime()));
                }
                detailExecutionVO.setTaxRate(cd.getDetailTaxRate());
                detailExecutionVO.setSourceId(cd.getId());
                detailExecutionVO.setSourceBillId(contractReliveId);
                detailExecutionVOS.add(detailExecutionVO);
            }
        }
    }
}

