package com.ejianc.business.contract.relieve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contract.relieve.vo.ContractRelieveVO;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同解除实体
 *
 * @author generator
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService {

    @Autowired
    private IContractRelieveService service;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISettleDetailService settleDetailService;

    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    @Override
    public Boolean isCanRelieve(Long contractId) {
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        List<ContractRelieveEntity> list = service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost(ContractRelieveVO contractRelieveVO, String linkUrl) {
        // 根据结算单的合同id查询合同详情
        ContractEntity contract = contractService.selectById(contractRelieveVO.getContractId());
        List<ContractDetailEntity> contractDetailList = contract.getDetailList();
        // 对合同明细叶子结点根据档案id进行分组
        Map<Long, List<ContractDetailEntity>> contractDetailMap = contractDetailList.stream().filter(e -> e.getDetailNum() != null).collect(Collectors.groupingBy(ContractDetailEntity::getDocId));
        // 合同里所有的档案id
        Set<Long> docIds = new HashSet<>(contractDetailMap.keySet());

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractRelieveVO.getId());
        totalVO.setTenantId(contractRelieveVO.getTenantId());
        totalVO.setBillCode(contractRelieveVO.getBillCode());
        if (contract.getContractType().equals(0)) {
            totalVO.setBillType(ProsubBillTypeEnum.劳务分包合同解除.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.劳务分包合同.getCode());
        } else {
            totalVO.setBillType(ProsubBillTypeEnum.专业分包合同解除.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.专业分包合同.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractRelieveVO.getProjectId());
        totalVO.setOrgId(contractRelieveVO.getOrgId());
        totalVO.setLinkUrl(linkUrl);
        if (null != contractRelieveVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(contractRelieveVO.getCreateTime()));
        }

        // 推总金额执行表 【结算金额累计】-【合同金额】
        // 【结算金额累计】=所有已生效结算的【本期结算金额】累计值（月度结算与节点结算两个单据中的最大值）
        List<DetailExecutionVO> processDetailExecution = new ArrayList<>();
        List<DetailExecutionVO> nodeDetailExecution = new ArrayList<>();

        // 生效的单据状态
        ArrayList<Integer> list = new ArrayList<>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        // 过程结算
        LambdaQueryWrapper<SettleEntity> process = new LambdaQueryWrapper<>();
        process.eq(SettleEntity::getDr, 0);
        process.in(SettleEntity::getBillState, list);
        process.eq(SettleEntity::getContractId, contractRelieveVO.getContractId());
        process.eq(SettleEntity::getSettleType, 0);
        List<SettleEntity> processSettles = settleService.list(process);
        BigDecimal processMny = BigDecimal.ZERO;
        BigDecimal processTaxMny = BigDecimal.ZERO;

        // 节点结算
        LambdaQueryWrapper<SettleEntity> node = new LambdaQueryWrapper<>();
        node.eq(SettleEntity::getDr, 0);
        node.in(SettleEntity::getBillState, list);
        node.eq(SettleEntity::getContractId, contractRelieveVO.getContractId());
        node.eq(SettleEntity::getSettleType, 2);
        List<SettleEntity> nodeSettles = settleService.list(node);
        BigDecimal nodeMny = BigDecimal.ZERO;
        BigDecimal nodeTaxMny = BigDecimal.ZERO;

        // 明细执行表
        ArrayList<DetailExecutionVO> detailExecutionVOS = new ArrayList<>();

        // 判断是否做结算
        if (CollectionUtils.isEmpty(processSettles) && CollectionUtils.isEmpty(nodeSettles)) {
            // 过程和节点结算都没做的情况

            // 合同清单剩余的从没结算的档案
            this.dealRemainingContractDetail(contract, contractDetailMap, docIds, sdf, detailExecutionVOS, contractRelieveVO.getId());
        } else {
            // 过程和节点至少有一个做的情况
            if (CollectionUtils.isNotEmpty(processSettles)) {
                // 过程结算
                processMny = processSettles.stream().map(SettleEntity::getMny).reduce(processMny, BigDecimal::add);
                processTaxMny = processSettles.stream().map(SettleEntity::getTaxMny).reduce(processTaxMny, BigDecimal::add);

                // 根据结算单ids查询过程结算明细
                List<Long> settleIds = processSettles.stream().map(SettleEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<SettleDetailEntity> processDetail = new LambdaQueryWrapper<>();
                processDetail.in(SettleDetailEntity::getSettleId, settleIds);
                List<SettleDetailEntity> processDetailNfList = settleDetailService.list(processDetail);

                // 过滤出叶子结点
                List<SettleDetailEntity> processDetailList = processDetailNfList.stream().filter(e -> e.getSettleNum() != null).collect(Collectors.toList());

                if (CollectionUtils.isNotEmpty(processDetailList)) {
                    // 对过程结算明细根据档案id进行分组
                    Map<Long, List<SettleDetailEntity>> processDetailMap = processDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getDocId));

                    processDetailMap.forEach((docId, settleDetailList) -> {

                        // 明细结算量累计
                        BigDecimal detailNum = settleDetailList.stream().map(SettleDetailEntity::getSettleNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 明细本期结算金额(无税)累计
                        BigDecimal detailMny = settleDetailList.stream().map(SettleDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 明细本期结算金额累计
                        BigDecimal detailTaxMny = settleDetailList.stream().map(SettleDetailEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                        // 合同清单明细工程量
                        BigDecimal contractDetailNum = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 合同清单明细本期结算金额(无税)
                        BigDecimal contractDetailMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 合同清单明细本期结算金额
                        BigDecimal contractDetailTaxMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                        SettleDetailEntity sd = settleDetailList.get(0);
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setTenantId(sd.getTenantId());
                        detailExecutionVO.setDocId(sd.getDocId());
                        detailExecutionVO.setCode(sd.getSourceBillCode());
                        detailExecutionVO.setName(sd.getDetailName());
                        // 档案id为空是分类
                        detailExecutionVO.setCategoryFlag(sd.getDocId() == null);
                        detailExecutionVO.setCategoryContainFlag(false);
                        detailExecutionVO.setCategoryId(sd.getDocCategoryId());
                        Assert.notNull(sd.getDocCategoryId(), "档案分类不能为空");
                        if (0 == contract.getContractType()) {
                            // 劳务分包
                            detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                            CommonResponse<LabsubCategoryVO> res = shareLabsubApi.queryLabSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类ID:{}", sd.getDocCategoryId());
                                throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                            }
                            LabsubCategoryVO categoryVO = res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        } else {
                            detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                            // 专业分包
                            CommonResponse<ProsubCategoryVO> res = shareLabsubApi.queryMajorSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                logger.error("根据档案分类id查询专业分包档案分类信息失败,档案分类ID:{}", sd.getDocCategoryId());
                                throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
                            }
                            ProsubCategoryVO categoryVO = res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        }

                        // 【明细结算量累计】- 【合同明细量  】
                        detailExecutionVO.setNum(ComputeUtil.safeSub(detailNum, contractDetailNum));
                        //  明细结算金额累计】-【合同明细金额】
                        detailExecutionVO.setMoney(ComputeUtil.safeSub(detailMny, contractDetailMny));
                        detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(detailTaxMny, contractDetailTaxMny));
                        // detailExecutionVO.setUnitId(sd.getUnitId());
                        detailExecutionVO.setUnitName(sd.getDetailUnit());
                        detailExecutionVO.setMemo(sd.getMemo());
                        detailExecutionVO.setPrice(sd.getDetailPrice());
                        detailExecutionVO.setTaxPrice(sd.getDetailTaxPrice());
                        detailExecutionVO.setSpec(sd.getDetailMeasurementRules());
                        if (null != sd.getCreateTime()) {
                            detailExecutionVO.setBillDate(sdf.format(sd.getCreateTime()));
                        }
                        detailExecutionVO.setTaxRate(sd.getDetailTaxRate());
                        detailExecutionVO.setSourceId(sd.getId());
                        detailExecutionVO.setSourceBillId(contractRelieveVO.getId());
                        processDetailExecution.add(detailExecutionVO);

                        docIds.remove(docId);
                    });

                }
            }

            if (CollectionUtils.isNotEmpty(nodeSettles)) {
                // 节点结算
                nodeMny = nodeSettles.stream().map(SettleEntity::getMny).reduce(nodeMny, BigDecimal::add);
                nodeTaxMny = nodeSettles.stream().map(SettleEntity::getTaxMny).reduce(nodeTaxMny, BigDecimal::add);

                // 根据结算单ids查询节点结算明细
                List<Long> settleIds = nodeSettles.stream().map(SettleEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<SettleDetailEntity> nodeDetail = new LambdaQueryWrapper<>();
                nodeDetail.in(SettleDetailEntity::getSettleId, settleIds);
                List<SettleDetailEntity> nodeDetailNfList = settleDetailService.list(nodeDetail);

                // 过滤出叶子结点
                List<SettleDetailEntity> nodeDetailList = nodeDetailNfList.stream().filter(e -> e.getSettleNum() != null).collect(Collectors.toList());

                if (CollectionUtils.isNotEmpty(nodeDetailList)) {
                    // 对过程结算明细根据档案id进行分组
                    Map<Long, List<SettleDetailEntity>> nodeDetailMap = nodeDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getDocId));

                    nodeDetailMap.forEach((docId, settleDetailList) -> {

                        // 明细结算量累计
                        BigDecimal detailNum = settleDetailList.stream().map(SettleDetailEntity::getSettleNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 明细本期结算金额(无税)累计
                        BigDecimal detailMny = settleDetailList.stream().map(SettleDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 明细本期结算金额累计
                        BigDecimal detailTaxMny = settleDetailList.stream().map(SettleDetailEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                        // 合同清单明细工程量
                        BigDecimal contractDetailNum = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 合同清单明细本期结算金额(无税)
                        BigDecimal contractDetailMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 合同清单明细本期结算金额
                        BigDecimal contractDetailTaxMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                        SettleDetailEntity sd = settleDetailList.get(0);
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setTenantId(sd.getTenantId());
                        detailExecutionVO.setDocId(sd.getDocId());
                        detailExecutionVO.setCode(sd.getSourceBillCode());
                        detailExecutionVO.setName(sd.getDetailName());
                        // 档案id为空是分类
                        detailExecutionVO.setCategoryFlag(sd.getDocId() == null);
                        detailExecutionVO.setCategoryContainFlag(false);
                        detailExecutionVO.setCategoryId(sd.getDocCategoryId());
                        Assert.notNull(sd.getDocCategoryId(), "档案分类不能为空");
                        if (0 == contract.getContractType()) {
                            // 劳务分包
                            detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                            CommonResponse<LabsubCategoryVO> res = shareLabsubApi.queryLabSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类ID:{}", sd.getDocCategoryId());
                                throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                            }
                            LabsubCategoryVO categoryVO = res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        } else {
                            detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                            // 专业分包
                            CommonResponse<ProsubCategoryVO> res = shareLabsubApi.queryMajorSubByCategoryId(sd.getDocCategoryId());
                            if (!res.isSuccess() || res.getData() == null) {
                                logger.error("根据档案分类id查询专业分包档案分类信息失败,档案分类ID:{}", sd.getDocCategoryId());
                                throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
                            }
                            ProsubCategoryVO categoryVO = res.getData();
                            if (null == categoryVO) {
                                detailExecutionVO.setCategoryInnerCode(null);
                                detailExecutionVO.setCategoryCode(null);
                                detailExecutionVO.setCategoryName(null);
                            } else {
                                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                                detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                                detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                            }
                        }

                        // 【明细结算量累计】- 【合同明细量  】
                        detailExecutionVO.setNum(ComputeUtil.safeSub(detailNum, contractDetailNum));
                        //  明细结算金额累计】-【合同明细金额】
                        detailExecutionVO.setMoney(ComputeUtil.safeSub(detailMny, contractDetailMny));
                        detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(detailTaxMny, contractDetailTaxMny));
                        // detailExecutionVO.setUnitId(sd.getUnitId());
                        detailExecutionVO.setUnitName(sd.getDetailUnit());
                        detailExecutionVO.setMemo(sd.getMemo());
                        detailExecutionVO.setPrice(sd.getDetailPrice());
                        detailExecutionVO.setTaxPrice(sd.getDetailTaxPrice());
                        detailExecutionVO.setSpec(sd.getDetailMeasurementRules());
                        if (null != sd.getCreateTime()) {
                            detailExecutionVO.setBillDate(sdf.format(sd.getCreateTime()));
                        }
                        detailExecutionVO.setTaxRate(sd.getDetailTaxRate());
                        detailExecutionVO.setSourceId(sd.getId());
                        detailExecutionVO.setSourceBillId(contractRelieveVO.getId());
                        nodeDetailExecution.add(detailExecutionVO);

                        docIds.remove(docId);
                    });

                }
            }

            // 推明细执行表（合同明细）
            // 【明细结算量累计】=所有已生效的结算单中该明细【本期结算量】累计值（月度结算与节点结算两个单据中的最大值）
            // 【明细结算金额累计】所有已生效的结算单中该明细【本期结算金额】累计值（月度结算与节点结算两个单据中的最大值）

            if (CollectionUtils.isNotEmpty(processDetailExecution)) {
                if (CollectionUtils.isNotEmpty(nodeDetailExecution)) {

                    // 过程和节点结算都有，取最大的，组成新的明细执行表
                    List<Long> ps = processDetailExecution.stream().map(DetailExecutionVO::getDocId).collect(Collectors.toList());
                    List<Long> nd = nodeDetailExecution.stream().map(DetailExecutionVO::getDocId).collect(Collectors.toList());

                    // 差集 processDetailExecution - nodeDetailExecution
                    List<DetailExecutionVO> processDetailExecutionList = processDetailExecution.stream().filter(p -> !nd.contains(p.getDocId())).collect(Collectors.toList());
                    // 差集 nodeDetailExecution - processDetailExecution
                    List<DetailExecutionVO> nodeDetailExecutionList = nodeDetailExecution.stream().filter(n -> !ps.contains(n.getDocId())).collect(Collectors.toList());
                    detailExecutionVOS.addAll(processDetailExecutionList);
                    detailExecutionVOS.addAll(nodeDetailExecutionList);

                    // 交集
                    // 先过滤出来重复的档案id
                    List<Long> intersectionList = processDetailExecution.stream()
                            .filter(p -> nd.contains(p.getDocId()))
                            .map(DetailExecutionVO::getDocId)
                            .collect(Collectors.toList());
                    // 比较大小选择最大的
                    intersectionList.forEach(docId -> {
                        DetailExecutionVO processDetailExecutionVO = processDetailExecution.stream()
                                .filter(p -> p.getDocId().equals(docId))
                                .findFirst().get();
                        DetailExecutionVO nodeDetailExecutionVO = nodeDetailExecution.stream()
                                .filter(n -> n.getDocId().equals(docId))
                                .findFirst().get();
                        // 理论上相同合同税率单价一致，只比较结算量即可
                        if (processDetailExecutionVO.getNum().compareTo(nodeDetailExecutionVO.getNum()) >= 0) {
                            // 相等情况下，数据一样，默认取过程结算的
                            detailExecutionVOS.add(processDetailExecutionVO);
                        } else {
                            detailExecutionVOS.add(nodeDetailExecutionVO);
                        }
                    });
                } else {
                    // 只有过程结算
                    detailExecutionVOS.addAll(processDetailExecution);
                }
            } else {
                if (CollectionUtils.isNotEmpty(nodeDetailExecution)) {
                    // 只有节点结算
                    detailExecutionVOS.addAll(nodeDetailExecution);
                }
            }

            // 合同清单剩余的从没结算的档案
            this.dealRemainingContractDetail(contract, contractDetailMap, docIds, sdf, detailExecutionVOS, contractRelieveVO.getId());
        }


        // 比较结算金额累计值
        totalVO.setMoney(ComputeUtil.safeSub(processMny.max(nodeMny), contract.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(processTaxMny.max(nodeTaxMny), contract.getContractTaxMny()));

        executionVO.setDetailList(detailExecutionVOS);

        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    /**
     * 处理合同清单剩余的从没借算的档案
     *
     * @param contract           合同
     * @param contractDetailMap  合同清单map
     * @param docIds             所有清单的档案id
     * @param sdf                日期格式化
     * @param detailExecutionVOS 执行明细表
     */
    private void dealRemainingContractDetail(ContractEntity contract, Map<Long, List<ContractDetailEntity>> contractDetailMap, Set<Long> docIds, SimpleDateFormat sdf, ArrayList<DetailExecutionVO> detailExecutionVOS, Long contractReliveId) {
        if (CollectionUtils.isNotEmpty(docIds)) {
            List categoryDocIdList = new ArrayList<>();
            if (null != contractDetailMap){
                for (Map.Entry<Long, List<ContractDetailEntity>> listEntry : contractDetailMap.entrySet()) {
                    categoryDocIdList.add(listEntry.getValue().get(0).getDocCategoryId());
                }
            }
            logger.info("所查categoryDocIdList-{}", JSONObject.toJSONString(categoryDocIdList));

            Map<Long, LabsubCategoryVO> labsubCategoryMap = new HashMap<>();
            Map<Long, ProsubCategoryVO> prosubCategoryMap = new HashMap<>();
            if (contract.getContractType().equals(0)){
                CommonResponse<List<LabsubCategoryVO>> res = shareLabsubApi.queryCategoryListByIds(categoryDocIdList);
                if (!res.isSuccess() || res.getData() == null || res.getData().size() == 0) {
                    logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类docIdList:{}", JSONObject.toJSONString(categoryDocIdList));
                    throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                }
                labsubCategoryMap = res.getData().stream().collect(Collectors.toMap(LabsubCategoryVO::getId, Function.identity(), (k1, k2) -> k2));
                logger.info("根据档案分类id查询劳务分包档案分类信息长度{}", labsubCategoryMap.size());
            }else {
                CommonResponse<List<ProsubCategoryVO>> res = shareProsubApi.queryCategoryListByIds(categoryDocIdList);
                if (!res.isSuccess() || res.getData() == null || res.getData().size() == 0) {
                    logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类docIdList:{}", JSONObject.toJSONString(categoryDocIdList));
                    throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                }
                prosubCategoryMap = res.getData().stream().collect(Collectors.toMap(ProsubCategoryVO::getId, Function.identity(), (k1, k2) -> k2));
                logger.info("根据档案分类id查询专业分包档案分类信息长度{}", prosubCategoryMap.size());
            }
            for (Long docId : docIds) {
                // 合同清单明细工程量
                BigDecimal contractDetailNum = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                // 合同清单明细本期结算金额(无税)
                BigDecimal contractDetailMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                // 合同清单明细本期结算金额
                BigDecimal contractDetailTaxMny = contractDetailMap.get(docId).stream().map(ContractDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                ContractDetailEntity cd = contractDetailMap.get(docId).get(0);
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setTenantId(cd.getTenantId());
                detailExecutionVO.setDocId(cd.getDocId());
                detailExecutionVO.setCode(cd.getDetailCode());
                detailExecutionVO.setName(cd.getDetailName());
                // 档案id为空是分类
                detailExecutionVO.setCategoryFlag(cd.getDocId() == null);
                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setCategoryId(cd.getDocCategoryId());
                Assert.notNull(cd.getDocCategoryId(), "档案分类不能为空");
                if (0 == contract.getContractType()) {
                    // 劳务分包
                    detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                    LabsubCategoryVO categoryVO = labsubCategoryMap.get(docId);
                    logger.info("所查categoryVO-{}", JSONObject.toJSONString(categoryVO));
                    if (null == categoryVO) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                        detailExecutionVO.setCategoryName(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                    // 专业分包
                    ProsubCategoryVO categoryVO = prosubCategoryMap.get(docId);
                    logger.info("所查categoryVO-{}", JSONObject.toJSONString(categoryVO));
                    if (null == categoryVO) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                        detailExecutionVO.setCategoryName(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }

                // 【明细结算量累计】- 【合同明细量  】
                detailExecutionVO.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, contractDetailNum));
                //  明细结算金额累计】-【合同明细金额】
                detailExecutionVO.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, contractDetailMny));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, contractDetailTaxMny));
                // detailExecutionVO.setUnitId(cd.getUnitId());
                detailExecutionVO.setUnitName(cd.getDetailUnit());
                detailExecutionVO.setMemo(cd.getDetailMemo());
                detailExecutionVO.setPrice(cd.getDetailPrice());
                detailExecutionVO.setTaxPrice(cd.getDetailTaxPrice());
                detailExecutionVO.setSpec(cd.getDetailMeasurementRules());
                if (null != cd.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(cd.getCreateTime()));
                }
                detailExecutionVO.setTaxRate(cd.getDetailTaxRate());
                detailExecutionVO.setSourceId(cd.getId());
                detailExecutionVO.setSourceBillId(contractReliveId);
                detailExecutionVOS.add(detailExecutionVO);
            };
        }
    }
}
