/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contract.relieve.vo.ContractRelieveVO;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.api.ISalaryApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.prosub.bean.ChangeDetailEntity;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractClauseEntity;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.bean.ContractOtherCostEntity;
import com.ejianc.business.prosub.bean.ContractPaymentEntity;
import com.ejianc.business.prosub.enums.ChangeStatusEnum;
import com.ejianc.business.prosub.enums.ContractFilingTypeEnum;
import com.ejianc.business.prosub.enums.DraftTypeEnum;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.prosub.mapper.ContractMapper;
import com.ejianc.business.prosub.service.IChangeDetailService;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractDetailService;
import com.ejianc.business.prosub.service.IContractOtherCostService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.ChangeVO;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.prosub.vo.ContractSettleDetailsReportVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    @Autowired
    private IContractDetailService detailService;
    @Autowired
    private IContractOtherCostService otherCostService;
    @Autowired
    private SessionManager sessionManager;
    private static final String LABOR_SUB_BILL_CODE = "PROSUB_CONTRACT";
    private static final String LABSUB_CONTRACT_YNJT01 = "LABSUB_CONTRACT_YNJT01";
    private static final String LABSUB_CONTRACT_YNJT02 = "LABSUB_CONTRACT_YNJT02";
    private static final String PROS_SUB_BILL_CODE = "PRO_SUB_CONTRACT";
    private static final String PRO_SUB_CONTRACT_YNJT_01 = "PRO_SUB_CONTRACT_YNJT_01";
    private final String LAB_SUPPLEMENT_PARAM_CODE = "P-18rO1Y72";
    private final String PRO_SUPPLEMENT_PARAM_CODE = "P-MK2Y0473";
    private final String LAB_CON_PLAN_NUM_CTRL_CON_NUM = "P-29O92c0105";
    private final String PRO_CON_PLAN_NUM_CTRL_CON_NUM = "P-90sLe50106";
    private final String LAB_CON_PLAN_MNY_CTRL_CON_MNY = "P-uOc2160107";
    private final String PRO_CON_PLAN_MNY_CTRL_CON_MNY = "P-66ZB8r0108";
    private final String LAB_CON_CONTRACTION_MNY_CTRL_CON_MNY = "P-4Avuf10109";
    private final String FILLING_TYPE_STATE = "P-eg7rBO0134";
    private final String LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-51g2FF0175";
    private final String PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-66o3LH0177";
    private final String LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-sT2I640176";
    private final String PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-1L8c900178";
    private static final String PRICE_LIB_CHECK_TYPE = "P-5ukonG0162";
    private final String LAB_TARGET_COST_PRICE_CTRL_CON_PRICE = "P-1A7To00217";
    private final String PRO_TARGET_COST_PRICE_CTRL_CON_PRICE = "P-8YTKj60216";
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ContractMapper contractMapper;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ITenderSubApi tenderApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private IContractRelieveService contractRelieveService;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private ISalaryApi salaryApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    private final int unOccupyState = 0;
    private final int occupyState = 1;

    private String getBaseHost() {
        return StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
    }

    @Override
    public boolean updatePerformanceStatusById(Long id) {
        return this.contractMapper.updatePerformanceStatusById(id) > 0;
    }

    @Override
    public ContractVO updatePerformanceStatusByContractId(ContractVO vo) {
        ContractEntity dbEntity = (ContractEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (dbEntity != null) {
            dbEntity.setPerformanceStatus(vo.getPerformanceStatus());
            super.saveOrUpdate((Object)dbEntity, false);
            return (ContractVO)BeanMapper.map((Object)((Object)dbEntity), ContractVO.class);
        }
        return new ContractVO();
    }

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO, String authority, Boolean isControl) {
        ContractEntity contract;
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        ContractEntity oldContractEntity = null;
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            } else if (entity.getFilingStatus().equals(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode())) {
                entity.setFilingRef(0);
            }
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                if (Boolean.FALSE.equals(isControl)) {
                    switch (this.GenerateBillCodeType) {
                        case "common": {
                            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)(entity.getContractType() == 0 ? LABOR_SUB_BILL_CODE : PROS_SUB_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                            if (!billCode.isSuccess()) {
                                this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            entity.setBillCode((String)billCode.getData());
                            break;
                        }
                        case "ynjt": {
                            CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(BillCodeParam.build((String)(entity.getContractType() == 0 ? ("\u673a\u68b0\u627f\u63fd".equals(entity.getSubType()) ? LABSUB_CONTRACT_YNJT02 : LABSUB_CONTRACT_YNJT01) : PRO_SUB_CONTRACT_YNJT_01), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                            if (!billCodeFirstPart.isSuccess()) {
                                this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            CommonSNVO commonSNVO = new CommonSNVO();
                            commonSNVO.setSnLength(Integer.valueOf(4));
                            commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                            commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                            commonSNVO.setSourceType(entity.getContractType() == 0 ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode());
                            CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                            if (!snResp.isSuccess()) {
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            entity.setBillCode((String)billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + (String)snResp.getData());
                        }
                    }
                } else {
                    entity.setBillCode(entity.getId().toString());
                }
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity.setSupplementFlag(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        } else {
            oldContractEntity = (ContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                entity.setBillCode(oldContractEntity.getBillCode());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (entity.getFilingStatus().equals(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode())) {
            entity.setFilingRef(0);
        }
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
        entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
        entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
        entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
        entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
        entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (ContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        this.resetPid(entity.getDetailList());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (Boolean.FALSE.equals(isControl)) {
            if (null != entity.getTargetResultId()) {
                this.checkTargetResultNum(entity);
            }
            super.saveOrUpdate((Object)entity, false);
            if (null != entity.getTargetResultId()) {
                if (null != oldContractEntity) {
                    this.writeBackTenderTarget(oldContractEntity, entity);
                } else {
                    this.writeBackTenderTarget(null, entity);
                }
            }
            String linkUrl = this.getLinkUrl((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class));
            ExecutionVO executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class), linkUrl, entity.getContractType(), entity.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse commonResponse = this.executionApi.aggPush(executionVO);
        }
        return (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
    }

    private void checkTargetResultNum(ContractEntity entity) {
        if (null != entity.getTargetResultId()) {
            List contractIds;
            QueryParam contractQuery = new QueryParam();
            contractQuery.getParams().put("targetResultId", new Parameter("eq", (Object)entity.getTargetResultId()));
            contractQuery.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            List contractEntityList = super.queryList(contractQuery);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)contractEntityList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(contractIds = contractEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()))) {
                List sourceIds = entity.getDetailList().stream().filter(item -> null != item.getDetailBaseTargetResultNum()).map(ContractDetailEntity::getSourceId).collect(Collectors.toList());
                QueryParam contractDetailQuery = new QueryParam();
                contractDetailQuery.getParams().put("contractId", new Parameter("in", contractIds));
                contractDetailQuery.getParams().put("sourceId", new Parameter("in", sourceIds));
                List contractDetailEntityList = this.detailService.queryList(contractDetailQuery);
                this.logger.info("\u67e5\u8be2\u5b9a\u6807\u91cf\u662f\u5426\u8d85\u51fa-checkTargetResultNum-\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)contractDetailEntityList));
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)contractDetailEntityList)) {
                    Map<Long, BigDecimal> targetResultNumMap = contractDetailEntityList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getSourceId, Collectors.reducing(BigDecimal.ZERO, ContractDetailEntity::getDetailBaseTargetResultNum, BigDecimal::add)));
                    StringBuilder errMsg = new StringBuilder();
                    for (ContractDetailEntity detail : entity.getDetailList()) {
                        BigDecimal targetResultNum;
                        if (!targetResultNumMap.containsKey(detail.getSourceId()) || (targetResultNum = targetResultNumMap.get(detail.getSourceId()).add(detail.getDetailBaseTargetResultNum())).compareTo(detail.getDetailTargetResultNum()) != 1) continue;
                        errMsg.append("\u6e05\u5355-" + detail.getDetailName() + "\u5df2\u7b7e\u5de5\u7a0b\u91cf\u3010" + targetResultNumMap.get(detail.getSourceId()).setScale(4, 4) + "\u3011 + \u672c\u671f\u5de5\u7a0b\u91cf\u3010" + detail.getDetailBaseTargetResultNum().setScale(4, 4) + "\u3011 \u8d85\u51fa\u5de5\u7a0b\u91cf\u3010" + targetResultNum.subtract(detail.getDetailTargetResultNum()).setScale(4, 4) + "\u3011");
                        errMsg.append("\r\n");
                    }
                    if (errMsg.length() > 0) {
                        throw new BusinessException(errMsg.toString());
                    }
                }
            }
        }
    }

    private void writeBackTenderTarget(ContractEntity oldContractEntity, ContractEntity newContractEntity) {
        TenderPicketageDetailVO tenderPicketageDetailVO;
        if (null != oldContractEntity) {
            TenderPicketageVO delTenderPicketageVO = new TenderPicketageVO();
            delTenderPicketageVO.setId(oldContractEntity.getTargetResultId());
            delTenderPicketageVO.setContractMoney(oldContractEntity.getContractMny());
            delTenderPicketageVO.setContractMoneyTax(oldContractEntity.getContractTaxMny());
            ArrayList<TenderPicketageDetailVO> delTenderPicketageDetailList = new ArrayList<TenderPicketageDetailVO>();
            for (ContractDetailEntity oldDetail : oldContractEntity.getDetailList()) {
                tenderPicketageDetailVO = new TenderPicketageDetailVO();
                if (null == oldDetail.getDetailNum()) continue;
                tenderPicketageDetailVO.setId(oldDetail.getDetailTargetResultSellId());
                tenderPicketageDetailVO.setSignNum(oldDetail.getDetailNum());
                delTenderPicketageDetailList.add(tenderPicketageDetailVO);
            }
            delTenderPicketageVO.setTenderPicketageDetailList(delTenderPicketageDetailList);
            CommonResponse delTenderResp = this.tenderApi.delUpdateStatus(delTenderPicketageVO);
            this.logger.info("\u5206\u5305\u5408\u540c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f-\u3010{}\u3011\uff0c\u7ed3\u679c-\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)delTenderPicketageVO), (Object)JSONObject.toJSONString((Object)delTenderResp));
            if (!delTenderResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        TenderPicketageVO saveTenderPicketageVO = new TenderPicketageVO();
        saveTenderPicketageVO.setId(newContractEntity.getTargetResultId());
        saveTenderPicketageVO.setContractMoney(newContractEntity.getContractMny());
        saveTenderPicketageVO.setContractMoneyTax(newContractEntity.getContractTaxMny());
        ArrayList<TenderPicketageDetailVO> saveTenderPicketageDetailList = new ArrayList<TenderPicketageDetailVO>();
        for (ContractDetailEntity newDetail : newContractEntity.getDetailList()) {
            tenderPicketageDetailVO = new TenderPicketageDetailVO();
            if (null == newDetail.getDetailNum() || "del".equals(newDetail.getRowState())) continue;
            tenderPicketageDetailVO.setId(newDetail.getDetailTargetResultSellId());
            tenderPicketageDetailVO.setSignNum(newDetail.getDetailNum());
            saveTenderPicketageDetailList.add(tenderPicketageDetailVO);
        }
        saveTenderPicketageVO.setTenderPicketageDetailList(saveTenderPicketageDetailList);
        CommonResponse saveTenderResp = this.tenderApi.updateStatus(saveTenderPicketageVO);
        this.logger.info("\u5206\u5305\u5408\u540c\u66f4\u65b0\u5b9a\u6807\u5f15\u7528\u4fe1\u606f-\u3010{}\u3011\uff0c\u7ed3\u679c-\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)saveTenderPicketageVO), (Object)JSONObject.toJSONString((Object)saveTenderResp));
        if (!saveTenderResp.isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5b9a\u6807\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    @Override
    public String getLinkUrl(ContractVO entity) {
        String linkUrl = 0 == entity.getContractType() ? (0 == entity.getAddType() ? this.getBaseHost() + "ejc-prosub-frontend/#/laborSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=laborSubCard&performanceStatus=" + entity.getPerformanceStatus() : this.getBaseHost() + "ejc-prosub-frontend/#/laborSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=laborSubDirectCard&performanceStatus=" + entity.getPerformanceStatus()) : (0 == entity.getAddType() ? this.getBaseHost() + "ejc-prosub-frontend/#/proSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=proSubCard&performanceStatus=" + entity.getPerformanceStatus() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=proSubDirectCard&performanceStatus=" + entity.getPerformanceStatus());
        return linkUrl;
    }

    @Override
    public String getLinkUrl(Long contractId) {
        String linkUrl = "";
        ContractEntity entity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        if (entity == null) {
            return linkUrl;
        }
        linkUrl = 0 == entity.getContractType() ? (0 == entity.getAddType() ? this.getBaseHost() + "ejc-prosub-frontend/#/laborSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=laborSubCard&performanceStatus=" + entity.getPerformanceStatus() : this.getBaseHost() + "ejc-prosub-frontend/#/laborSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=laborSubDirectCard&performanceStatus=" + entity.getPerformanceStatus()) : (0 == entity.getAddType() ? this.getBaseHost() + "ejc-prosub-frontend/#/proSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=proSubCard&performanceStatus=" + entity.getPerformanceStatus() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubList/card?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1&cardType=proSubDirectCard&performanceStatus=" + entity.getPerformanceStatus());
        return linkUrl;
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType, String billType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setBillType(billType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != contractVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(contractVO.getCreateTime()));
        }
        if (contractType == 0) {
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getCode());
        } else {
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (contractVO.getProjectId() == null) {
            throw new BusinessException("\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(contractVO.getProjectId());
        if (contractVO.getOrgId() == null) {
            throw new BusinessException("\u9879\u76ee\u90e8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\uff0c\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)contractVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        HashMap labCategoryCache = new HashMap();
        HashMap proCategoryCache = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            List contractDetailVOS = contractVO.getDetailList().stream().filter(item -> item.getDetailNum() != null && !"del".equals(item.getRowState())).collect(Collectors.toList());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\uff0c\u5408\u540c\u660e\u7ec6\u8fc7\u6ee4\u540e\u6570\u91cf\uff1a{}", (Object)contractDetailVOS.size());
            for (ContractDetailVO contractDetailVO : contractDetailVOS) {
                if (null == contractDetailVO.getDetailNum()) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(contractDetailVO.getId());
                if (ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(billType)) {
                    detailExecutionVO.setSourceBillId(contractDetailVO.getChangeId());
                } else if (null != contractDetailVO.getContractId()) {
                    detailExecutionVO.setSourceBillId(contractDetailVO.getContractId());
                } else {
                    detailExecutionVO.setSourceBillId(contractVO.getId());
                }
                detailExecutionVO.setCategoryId(contractDetailVO.getDocCategoryId());
                if (contractDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                Assert.notNull((Object)contractDetailVO.getDocId(), (String)"\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
                detailExecutionVO.setDocId(contractDetailVO.getDocId());
                if (contractType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setName(contractDetailVO.getDetailName());
                detailExecutionVO.setUnitName(contractDetailVO.getDetailUnit());
                detailExecutionVO.setNum(contractDetailVO.getDetailNum());
                detailExecutionVO.setMoney(contractDetailVO.getDetailMny());
                detailExecutionVO.setTaxMoney(contractDetailVO.getDetailTaxMny());
                detailExecutionVO.setSpec(contractDetailVO.getDetailMeasurementRules());
                detailExecutionVO.setPrice(contractDetailVO.getDetailPrice());
                detailExecutionVO.setTaxPrice(contractDetailVO.getDetailTaxPrice());
                detailExecutionVO.setTaxRate(contractDetailVO.getDetailTaxRate());
                detailExecutionVO.setMemo(contractDetailVO.getDetailMemo());
                if (null != contractDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(contractDetailVO.getCreateTime()));
                }
                detailList.add(detailExecutionVO);
            }
            this.logger.info("\u8bbe\u7f6e\u6210\u672c\u63a8\u9001\u660e\u7ec6\u7ed3\u675f\uff01");
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (ContractVO contractVO2 : vos) {
                ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractVO2.getId()));
                ExecutionVO executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), "", contractEntity.getContractType(), contractEntity.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode());
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse commonResponse = this.executionApi.aggDel(totalExecutionVOList);
        }
        vos.forEach(contractVO -> {
            ContractEntity contractEntity = (ContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                TenderPicketageVO delTenderPicketageVO = new TenderPicketageVO();
                delTenderPicketageVO.setId(contractEntity.getTargetResultId());
                delTenderPicketageVO.setContractMoney(contractEntity.getContractMny());
                delTenderPicketageVO.setContractMoneyTax(contractEntity.getContractTaxMny());
                ArrayList<TenderPicketageDetailVO> delTenderPicketageDetailList = new ArrayList<TenderPicketageDetailVO>();
                for (ContractDetailEntity oldDetail : contractEntity.getDetailList()) {
                    TenderPicketageDetailVO tenderPicketageDetailVO = new TenderPicketageDetailVO();
                    if (null == oldDetail.getDetailNum()) continue;
                    tenderPicketageDetailVO.setId(oldDetail.getDetailTargetResultSellId());
                    tenderPicketageDetailVO.setSignNum(oldDetail.getDetailNum());
                    delTenderPicketageDetailList.add(tenderPicketageDetailVO);
                }
                delTenderPicketageVO.setTenderPicketageDetailList(delTenderPicketageDetailList);
                CommonResponse delTenderResp = this.tenderApi.delUpdateStatus(delTenderPicketageVO);
                this.logger.info("\u5206\u5305\u5408\u540c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f-\u3010{}\u3011\uff0c\u7ed3\u679c-\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)delTenderPicketageVO), (Object)JSONObject.toJSONString((Object)delTenderResp));
                if (!delTenderResp.isSuccess()) {
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5220\u9664\u5b9a\u6807\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
                }
            }
        });
        this.service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public boolean pushContract(ContractVO vo) {
        this.logger.info("\u63a8\u9001\u5408\u540c\u6c60 \u5408\u540c \u5bf9\u8c61\uff1a\u2014\u2014\u2014\u2014\u2014\u2014{}", (Object)JSONObject.toJSONString((Object)vo));
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setSourceType(vo.getContractType().equals(0) ? ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode() : ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
            String cardType = "";
            String routePath = "";
            if (vo.getAddType() == 1) {
                if (vo.getContractType() == 1) {
                    cardType = "proSubDirectCard";
                    routePath = "proSubList";
                } else if (vo.getContractType() == 0) {
                    cardType = "laborSubDirectCard";
                    routePath = "laborSubList";
                }
            } else if (vo.getAddType() == 0) {
                if (vo.getContractType() == 1) {
                    cardType = "proSubCard";
                    routePath = "proSubList";
                } else if (vo.getContractType() == 0) {
                    cardType = "laborSubCard";
                    routePath = "laborSubList";
                }
            }
            data.setMobileCardUrl("ejc-prosub-mobile/#/" + (vo.getContractType() == 1 ? "proContract" : "labContract") + "/card?id=" + vo.getId());
            data.setPcCardUrl("/ejc-prosub-frontend/#/" + routePath + "/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus());
            data.setAddType(Integer.valueOf(0));
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60 \u8f6c\u6362 \u5bf9\u8c61\uff1a\u2014\u2014\u2014\u2014\u2014\u2014{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)JSONObject.toJSONString((Object)transDataResp));
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public String delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return null;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return StringUtils.isNotBlank((CharSequence)delDataResp.getMsg()) ? delDataResp.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u5355\u636e\u5904\u7406\u5931\u8d25\uff01";
    }

    @Override
    public Integer deleteContractFileById(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        contractEntity.setContractFileId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileHighlightId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileVersion(null);
        contractEntity.setContractFileVersionId(null);
        Boolean deleteContractFileResult = this.service.saveOrUpdate((Object)contractEntity, false);
        if (!deleteContractFileResult.booleanValue()) {
            return -1;
        }
        return contractEntity.getVersion();
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id, orderMap));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        if (null != contractVO.getTargetResultId()) {
            CommonResponse res = this.tenderApi.queryTreeList(contractVO.getTargetResultId());
            this.logger.info("\u67e5\u8be2\u5b9a\u6807\u5f53\u524d\u4ee5\u524d\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)res));
            if (res.isSuccess()) {
                List subDocumentSellVOList = (List)res.getData();
                this.logger.info("prosub-\u5206\u5305\u5408\u540c-queryDetail\u2014\u67e5\u8be2\u5b9a\u6807\u6765\u6e90\u6570\u636e-targetResultId-{}", (Object)contractVO.getTargetResultId());
                this.logger.info("\u901a\u8fc7targetResultId\u4f7f\u7528-queryTreeList-\u67e5\u8be2\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res));
                this.logger.info("\u901a\u8fc7targetResultId\u67e5\u8be2\u51fa\u5b9a\u6807\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)subDocumentSellVOList));
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)subDocumentSellVOList)) {
                    Map<Long, BigDecimal> targetResultNumMap = subDocumentSellVOList.stream().collect(Collectors.toMap(SubDocumentSellVO::getSellId, SubDocumentSellVO::getSurplusNum, (key1, key2) -> key2));
                    for (ContractDetailVO detail : contractVO.getDetailList()) {
                        this.logger.info("prosub-\u5206\u5305\u5408\u540c-queryDetail-\u521d\u59cb\u503c{}-detailTargetResultSellId-{}", (Object)detail.getDetailBaseTargetResultNum(), (Object)detail.getDetailTargetResultSellId());
                        this.logger.info("targetResultNumMap\u6570\u636e------->{}", (Object)JSONObject.toJSONString(targetResultNumMap));
                        if (targetResultNumMap.containsKey(detail.getDetailTargetResultSellId())) {
                            detail.setDetailTargetResultRemainderNum(detail.getDetailBaseTargetResultNum().add(targetResultNumMap.get(detail.getDetailTargetResultSellId())));
                            continue;
                        }
                        detail.setDetailTargetResultRemainderNum(detail.getDetailBaseTargetResultNum());
                    }
                } else {
                    for (ContractDetailVO detail : contractVO.getDetailList()) {
                        detail.setDetailTargetResultRemainderNum(detail.getDetailBaseTargetResultNum());
                    }
                }
            } else {
                throw new BusinessException("\u67e5\u8be2\u5b9a\u6807\u6570\u636e\u5931\u8d25\uff0c" + res.getMsg());
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            for (ContractDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree((List)contractVO.getDetailList()));
        }
        return contractVO;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO contractVO = new ContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"performance_status", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (ContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus())) {
            Boolean filingTypeFlag = this.checkFilingType(id, ContractFilingTypeEnum.\u5206\u5305\u5408\u540c\u8865\u5145\u534f\u8bae.getTypeCode());
            if (this.addSupplementFlag(id).booleanValue() && filingTypeFlag.booleanValue()) {
                contractVO.setEditFlag(Boolean.valueOf(true));
            } else {
                contractVO.setEditFlag(Boolean.valueOf(false));
            }
        } else {
            contractVO.setEditFlag(Boolean.valueOf(false));
        }
        return contractVO;
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVO, Boolean isControl) {
        ContractEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)contractVO.getBillCode()) && this.checkSameBillCode(contractVO).booleanValue()) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(contractVO.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVO.getMainContractId()));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        List supplementList = this.service.queryList(param, false);
        if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            contractVO.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }
        if (contractVO.getId() == null) {
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), ContractEntity.class));
            entity.setBillCode(contractVO.getBillCode());
            this.clearBaseFields(entity);
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setFilingStatus(contractVO.getFilingStatus());
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setEmployeeId(contractVO.getEmployeeId());
            entity.setEmployeeName(contractVO.getEmployeeName());
            entity.setEmployeePhone(contractVO.getEmployeePhone());
            entity.setSupplierEmployee(contractVO.getSupplierEmployee());
            entity.setSupplierEmployeePhone(contractVO.getSupplierEmployeePhone());
            entity.setPerformanceStatus(contractVO.getPerformanceStatus());
            entity.setDraftType(contractVO.getDraftType());
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());
            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
            entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
            entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
            entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
            entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
            entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
            entity.setDetailList(BeanMapper.mapList((Iterable)contractVO.getDetailList(), ContractDetailEntity.class));
            entity.setOtherCostList(BeanMapper.mapList((Iterable)contractVO.getOtherCostList(), ContractOtherCostEntity.class));
            entity.setClauseList(BeanMapper.mapList((Iterable)contractVO.getClauseList(), ContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList((Iterable)contractVO.getPaymentList(), ContractPaymentEntity.class));
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
            entity.setTargetResultId(null);
            entity.setTargetResultName(null);
        } else {
            entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setAttachIds(contractVO.getAttachIds());
        if (entity.getFilingStatus() == FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()) {
            entity.setFilingRef(0);
        }
        this.resetPid(entity.getDetailList());
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        if (Boolean.FALSE.equals(isControl)) {
            this.service.saveOrUpdate((Object)entity, false);
            String linkUrl = this.getSupplementLinkUrl(vo);
            ExecutionVO executionVO = this.service.targetCost(vo, linkUrl, vo.getContractType(), vo.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e:{}", (Object)JSON.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            return this.queryDetail(entity.getId());
        }
        return vo;
    }

    @Override
    public String getSupplementLinkUrl(ContractVO contractVO) {
        String linkUrl = 0 == contractVO.getContractType() ? (0 == contractVO.getAddType() ? this.getBaseHost() + "ejc-prosub-frontend/#/laborSubList/supplementCard?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=laborSubCard" : this.getBaseHost() + "ejc-prosub-frontend/#/laborSubList/supplementCard?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=laborSubDirectCard") : (0 == contractVO.getAddType() ? this.getBaseHost() + "ejc-prosub-frontend/#/proSubList/supplementCard?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=proSubCard" : this.getBaseHost() + "ejc-prosub-frontend/#/proSubList/supplementCard?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=proSubDirectCard");
        return linkUrl;
    }

    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private void resetPid(List<ContractDetailEntity> detailList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : detailList) {
                if ("del".equals(cdEntity.getRowState())) continue;
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid().toString() + cdEntity.getSourceType(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : detailList) {
                if ("del".equals(cdEntity.getRowState()) || !StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid().toString() + cdEntity.getSourceType()));
            }
        }
    }

    private void clearBaseFields(ContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setPurchaseId(contractVO.getPurchaseId());
        supplementVO.setPurchaseName(contractVO.getPurchaseName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public String getFilingTypeConfig() {
        String filingTypeConfig = "0";
        CommonResponse response = this.paramConfigApi.getByCode("P-eg7rBO0134");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u6839\u636e\u5f52\u6863\u53c2\u6570\u7f16\u7801-{}\uff0c\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff08\u5408\u540c\u5f52\u6863\u63a7\u5236\uff09\u914d\u7f6e\u4fe1\u606f\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)"P-eg7rBO0134", (Object)response.getMsg());
        } else if (null != ((ParamRegisterSetVO)response.getData()).getValueData()) {
            filingTypeConfig = ((ParamRegisterSetVO)response.getData()).getValueData();
        }
        return filingTypeConfig;
    }

    @Override
    public Boolean checkFilingType(Long contractId, String contractTypeCode) {
        Boolean addFlag = true;
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        if (null != contractEntity && 1 != contractEntity.getFilingStatus()) {
            String filingTypeConfig = this.getFilingTypeConfig();
            if ("1".equals(filingTypeConfig)) {
                switch (ContractFilingTypeEnum.getEnumByCode(contractTypeCode)) {
                    case \u5206\u5305\u5408\u540c\u53d8\u66f4: {
                        addFlag = false;
                        break;
                    }
                    case \u5206\u5305\u5408\u540c\u8865\u5145\u534f\u8bae: {
                        addFlag = false;
                        break;
                    }
                    case \u5206\u5305\u5408\u540c\u6708\u5ea6\u7ed3\u7b97: {
                        addFlag = false;
                        break;
                    }
                    case \u5206\u5305\u5408\u540c\u8282\u70b9\u7ed3\u7b97: {
                        addFlag = false;
                        break;
                    }
                    case \u5206\u5305\u5408\u540c\u6700\u7ec8\u7ed3\u7b97: {
                        addFlag = false;
                    }
                }
            } else {
                addFlag = "2".equals(filingTypeConfig) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
        }
        return addFlag;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(ContractVO contractVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        this.logger.info("prosub---ContractServiceImpl---historyPriceCtrlContractPrice()--- \u5386\u53f2\u4ef7\u63a7\u5408\u540c\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        CommonResponse minParamByCode = new CommonResponse();
        Integer contractType = contractVO.getContractType();
        Integer princeDepot = null;
        List detailList = contractVO.getDetailList();
        if (0 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-51g2FF0175", contractVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-sT2I640176", contractVO.getOrgId());
            princeDepot = PrinceDepotEnum.\u52b3\u52a1\u5206\u5305\u4ef7\u683c\u5e93.getCode();
        }
        if (1 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-66o3LH0177", contractVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-1L8c900178", contractVO.getOrgId());
            princeDepot = PrinceDepotEnum.\u4e13\u4e1a\u5206\u5305\u4ef7\u683c\u5e93.getCode();
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u5206\u5305\u5408\u540c\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u5206\u5305\u5408\u540c\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)princeDepot));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(princeDepot);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (ContractDetailVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getDetailPrice() == null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u5206\u5305\u6e05\u5355\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5206\u5305\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                if ("none".equals(paramsArray[minParamVO.getControlType()])) continue;
                for (ContractDetailVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getDetailPrice() == null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u5206\u5305\u6e05\u5355\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5206\u5305\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> targetCostPriceCtrlContractPrice(ContractVO contractVO) {
        this.logger.info("prosub---ContractServiceImpl---targetCostPriceCtrlContractPrice()--- \u76ee\u6807\u6210\u672c\u4ef7\u63a7\u5408\u540c\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        Integer contractType = contractVO.getContractType();
        List detailList = contractVO.getDetailList();
        if (0 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-1A7To00217", contractVO.getOrgId());
        }
        if (1 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-8YTKj60216", contractVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u76ee\u6807\u6210\u672c\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u76ee\u6807\u6210\u672c\u4ef7\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List docIds = detailList.stream().filter(item -> null != item.getDetailNum()).map(ContractDetailVO::getDocId).collect(Collectors.toList());
        CommonResponse dutyRes = this.dutyApi.queryPriceByDocIds(contractVO.getProjectId(), 0 == contractType ? DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode() : DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode(), docIds);
        if (null == dutyRes) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683c\u4e3a\u7a7a");
            return paramsCheckVOList;
        }
        Map dutyMap = (Map)dutyRes.getData();
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        if (null == dutyMap) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683cmap\u4e3a\u7a7a");
            return paramsCheckVOList;
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7map\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)dutyMap));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (ContractDetailVO detailVO : detailList) {
                    if (null == detailVO.getDetailNum()) continue;
                    BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : ((BigDecimal)dutyMap.get(detailVO.getDocId())).setScale(4, 4);
                    BigDecimal price = null == detailVO.getDetailPrice() ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, 4);
                    BigDecimal maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                    this.logger.info("marpriceparam:{},price:{},maxprice:{}", new Object[]{maxPriceParam, price, maxPrice});
                    if (price.compareTo(maxPriceParam) <= 0) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getDetailWorkContent() == null ? "" : "+" + detailVO.getDetailWorkContent()));
                    paramsCheckDsVO.setWarnName("\u5408\u540c\u5355\u4ef7\u5927\u4e8e\u76ee\u6807\u6210\u672c\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5408\u540c\u5355\u4ef7\uff1a").append(price).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u5355\u4ef7\uff1a(").append(maxPrice).append("\u5143),\u76ee\u6807\u6210\u672c\u5355\u4ef7*").append(roleValueMax).append("%\uff1a").append(maxPriceParam).append("\u5143\uff0c\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public IPage<ContractSettleDetailsReportVO> queryLabProSettleDetails(QueryParam queryParam, boolean exportFlag) {
        String searchText;
        String[] settleDateArr;
        String settleDateValue;
        OrgVO orgVO;
        Integer orgType;
        CommonResponse orgRes;
        Parameter detailUnitParam;
        Parameter detailRuleParam;
        Parameter detailWorkContentParam;
        Parameter detailNameParam;
        Parameter detailCodeParam;
        Parameter parentOrgNameParam;
        Parameter projectNameParam;
        Parameter contractNameParam;
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        Page page = new Page(0L, 10L);
        queryMap.put("orgId", null);
        queryMap.put("parentOrgIdList", null);
        queryMap.put("settleDataStart", null);
        queryMap.put("settleDataEnd", null);
        queryMap.put("processTaxMnyStart", null);
        queryMap.put("processTaxMnyEnd", null);
        queryMap.put("nodeTaxMnyStart", null);
        queryMap.put("nodeTaxMnyEnd", null);
        queryMap.put("finalTaxMnyStart", null);
        queryMap.put("finalTaxMnyEnd", null);
        queryMap.put("finalOverTaxMnyStart", null);
        queryMap.put("finalOverTaxMnyEnd", null);
        queryMap.put("contractCode", null);
        queryMap.put("contractName", null);
        queryMap.put("projectName", null);
        queryMap.put("parentOrgName", null);
        queryMap.put("detailCode", null);
        queryMap.put("detailName", null);
        queryMap.put("detailWorkContent", null);
        queryMap.put("detailRule", null);
        queryMap.put("detailUnit", null);
        Parameter contractCodeParam = (Parameter)queryParam.getParams().get("contractCode");
        if (contractCodeParam != null && contractCodeParam.getValue() != null) {
            queryMap.put("contractCode", contractCodeParam.getValue().toString());
        }
        if ((contractNameParam = (Parameter)queryParam.getParams().get("contractName")) != null && contractNameParam.getValue() != null) {
            queryMap.put("contractName", contractNameParam.getValue().toString());
        }
        if ((projectNameParam = (Parameter)queryParam.getParams().get("projectName")) != null && projectNameParam.getValue() != null) {
            queryMap.put("projectName", projectNameParam.getValue().toString());
        }
        if ((parentOrgNameParam = (Parameter)queryParam.getParams().get("parentOrgName")) != null && parentOrgNameParam.getValue() != null) {
            queryMap.put("parentOrgName", parentOrgNameParam.getValue().toString());
        }
        if ((detailCodeParam = (Parameter)queryParam.getParams().get("detailCode")) != null && detailCodeParam.getValue() != null) {
            queryMap.put("detailCode", detailCodeParam.getValue().toString());
        }
        if ((detailNameParam = (Parameter)queryParam.getParams().get("detailName")) != null && detailNameParam.getValue() != null) {
            queryMap.put("detailName", detailNameParam.getValue().toString());
        }
        if ((detailWorkContentParam = (Parameter)queryParam.getParams().get("detailWorkContent")) != null && detailWorkContentParam.getValue() != null) {
            queryMap.put("detailWorkContent", detailWorkContentParam.getValue().toString());
        }
        if ((detailRuleParam = (Parameter)queryParam.getParams().get("detailRule")) != null && detailRuleParam.getValue() != null) {
            queryMap.put("detailRule", detailRuleParam.getValue().toString());
        }
        if ((detailUnitParam = (Parameter)queryParam.getParams().get("detailUnit")) != null && detailUnitParam.getValue() != null) {
            queryMap.put("detailUnit", detailUnitParam.getValue().toString());
        }
        queryMap.put("searchText", null);
        queryMap.put("tenantId", InvocationInfoProxy.getTenantid());
        Parameter contractTypeParam = (Parameter)queryParam.getParams().get("contractType");
        if (!exportFlag) {
            queryMap.put("start", 0);
            queryMap.put("limit", 10);
            int pageIndex = queryParam.getPageIndex();
            int pageSize = queryParam.getPageSize();
            if (pageIndex > 0 && pageSize > 0) {
                queryMap.put("start", pageIndex - 1);
                queryMap.put("limit", pageSize);
                page.setCurrent((long)(pageIndex - 1));
                page.setSize((long)pageSize);
            }
        } else {
            queryMap.put("start", null);
            queryMap.put("limit", null);
            page.setCurrent(0L);
            page.setSize(-1L);
        }
        if (contractTypeParam == null) {
            return new Page();
        }
        queryMap.put("contractType", contractTypeParam.getValue());
        Long orgId = InvocationInfoProxy.getOrgId();
        Parameter orgIdParam = (Parameter)queryParam.getParams().get("orgId");
        if (orgIdParam != null && orgIdParam.getValue() != null ? (orgRes = this.orgApi.detailById(orgId = Long.valueOf(Long.parseLong(orgIdParam.getValue().toString())))).isSuccess() && orgRes.getData() != null && this.setOrgParam(queryMap, orgId, orgType = (orgVO = (OrgVO)orgRes.getData()).getOrgType()) : orgId != null && this.setOrgParam(queryMap, orgId, Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            return new Page();
        }
        Parameter settleDate = (Parameter)queryParam.getParams().get("settleDate");
        if (settleDate != null && StringUtils.isNotBlank((CharSequence)(settleDateValue = settleDate.getValue().toString())) && (settleDateArr = settleDateValue.split(",")).length > 0) {
            queryMap.put("settleDataStart", settleDateArr[0]);
            queryMap.put("settleDataEnd", settleDateArr[1]);
        }
        if (StringUtils.isNotBlank((CharSequence)(searchText = queryParam.getSearchText()))) {
            queryMap.put("searchText", searchText);
        }
        Parameter processTaxMnyParam = (Parameter)queryParam.getParams().get("processTaxMny");
        Parameter nodeTaxMnyParam = (Parameter)queryParam.getParams().get("nodeTaxMny");
        Parameter finalTaxMnyParam = (Parameter)queryParam.getParams().get("finalTaxMny");
        Parameter finalOverTaxMnyParam = (Parameter)queryParam.getParams().get("finalOverTaxMny");
        if (processTaxMnyParam != null && processTaxMnyParam.getValue() != null) {
            String processTaxMny = processTaxMnyParam.getValue().toString();
            String processType = processTaxMnyParam.getType();
            if (StringUtils.isNotBlank((CharSequence)processType)) {
                switch (processType) {
                    case "ge": {
                        queryMap.put("processTaxMnyStart", new BigDecimal(processTaxMny));
                        break;
                    }
                    case "le": {
                        queryMap.put("processTaxMnyEnd", new BigDecimal(processTaxMny));
                        break;
                    }
                    case "between": {
                        String[] processTaxMnyStrArr = processTaxMny.split(",");
                        queryMap.put("processTaxMnyStart", new BigDecimal(processTaxMnyStrArr[0]));
                        queryMap.put("processTaxMnyEnd", new BigDecimal(processTaxMnyStrArr[1]));
                        break;
                    }
                }
            }
        }
        if (nodeTaxMnyParam != null && nodeTaxMnyParam.getValue() != null) {
            String nodeTaxMny = nodeTaxMnyParam.getValue().toString();
            String nodeType = nodeTaxMnyParam.getType();
            if (StringUtils.isNotBlank((CharSequence)nodeType)) {
                switch (nodeType) {
                    case "ge": {
                        queryMap.put("nodeTaxMnyStart", new BigDecimal(nodeTaxMny));
                        break;
                    }
                    case "le": {
                        queryMap.put("nodeTaxMnyEnd", new BigDecimal(nodeTaxMny));
                        break;
                    }
                    case "between": {
                        String[] nodeTaxMnyStrArr = nodeTaxMny.split(",");
                        queryMap.put("nodeTaxMnyStart", new BigDecimal(nodeTaxMnyStrArr[0]));
                        queryMap.put("nodeTaxMnyEnd", new BigDecimal(nodeTaxMnyStrArr[1]));
                        break;
                    }
                }
            }
        }
        if (finalTaxMnyParam != null && finalTaxMnyParam.getValue() != null) {
            String finalTaxMny = finalTaxMnyParam.getValue().toString();
            String finalType = finalTaxMnyParam.getType();
            if (StringUtils.isNotBlank((CharSequence)finalType)) {
                switch (finalType) {
                    case "ge": {
                        queryMap.put("finalTaxMnyStart", new BigDecimal(finalTaxMny));
                        break;
                    }
                    case "le": {
                        queryMap.put("finalTaxMnyEnd", new BigDecimal(finalTaxMny));
                        break;
                    }
                    case "between": {
                        String[] finalTaxMnyStrArr = finalTaxMny.split(",");
                        queryMap.put("finalTaxMnyStart", new BigDecimal(finalTaxMnyStrArr[0]));
                        queryMap.put("finalTaxMnyEnd", new BigDecimal(finalTaxMnyStrArr[1]));
                        break;
                    }
                }
            }
        }
        if (finalOverTaxMnyParam != null && finalOverTaxMnyParam.getValue() != null) {
            String finalOverTaxMny = finalOverTaxMnyParam.getValue().toString();
            String finalOverType = finalOverTaxMnyParam.getType();
            if (StringUtils.isNotBlank((CharSequence)finalOverType)) {
                switch (finalOverType) {
                    case "ge": {
                        queryMap.put("finalOverTaxMnyStart", new BigDecimal(finalOverTaxMny));
                        break;
                    }
                    case "le": {
                        queryMap.put("finalOverTaxMnyEnd", new BigDecimal(finalOverTaxMny));
                        break;
                    }
                    case "between": {
                        String[] finalOverTaxMnyStrArr = finalOverTaxMny.split(",");
                        queryMap.put("finalOverTaxMnyStart", new BigDecimal(finalOverTaxMnyStrArr[0]));
                        queryMap.put("finalOverTaxMnyEnd", new BigDecimal(finalOverTaxMnyStrArr[1]));
                        break;
                    }
                }
            }
        }
        List<ContractSettleDetailsReportVO> list = this.contractMapper.querySettleDetails(queryMap);
        Long count = this.contractMapper.querySettleDetailsCount(queryMap);
        NumberFormat percent = NumberFormat.getPercentInstance();
        percent.setMaximumFractionDigits(4);
        list.forEach(item -> {
            BigDecimal finalOverNum;
            if (null != item.getFinalNum() && null != item.getContractNum()) {
                this.logger.info("\u8fdb\u5165\u7ed3\u7b97\u6bd4\u4f8b\u8ba1\u7b97\uff01");
                BigDecimal finalRate = item.getFinalNum().divide(item.getContractNum(), 2, RoundingMode.HALF_UP);
                item.setFinalRate(finalRate);
                item.setFinalRateStr(percent.format(finalRate));
                this.logger.info("\u6700\u7ec8\u7ed3\u7b97\u6bd4\u4f8b\uff1a{}\uff0c\u6700\u7ec8\u7ed3\u7b97\u6bd4\u4f8bStr\uff1a{}\uff0c\u6700\u7ec8\u7ed3\u7b97\u6570\u91cf\uff1a{}\uff0c\u6e05\u5355\u5408\u540c\u6570\u91cf\uff1a{}", new Object[]{finalRate, item.getFinalRateStr(), item.getFinalNum(), item.getContractNum()});
                BigDecimal finalOverRate = finalRate.subtract(BigDecimal.valueOf(1L));
                item.setFinalOverRate(finalOverRate);
                item.setFinalOverRateStr(percent.format(finalOverRate));
                this.logger.info("\u6700\u7ec8\u8d85\u7ed3\u6bd4\u4f8b\uff1a{}\uff0c\u6700\u7ec8\u8d85\u7ed3\u6bd4\u4f8bStr\uff1a{}", (Object)finalOverRate, (Object)item.getFinalOverRateStr());
            }
            String cardType = "";
            Integer addType = item.getAddType();
            String contractType = contractTypeParam.getValue().toString();
            if (addType != null) {
                if (addType == 1) {
                    cardType = "0".equals(contractType) ? "laborSubDirectCard" : "proSubDirectCard";
                } else if (addType == 0) {
                    cardType = "0".equals(contractType) ? "laborSubCard" : "proSubCard";
                }
                item.setPcContractCardUrl("/ejc-prosub-frontend/#/laborSubList/contractMultiCards?id=" + item.getContractId() + "&supplementFlag=" + item.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + item.getPerformanceStatus());
            }
            if ((finalOverNum = item.getFinalOverNum()) == null || finalOverNum.compareTo(BigDecimal.ZERO) <= 0) {
                item.setFinalOverNum(null);
                item.setFinalOverTaxMny(null);
                item.setFinalOverRate(null);
                item.setFinalOverRateStr(null);
            }
        });
        page.setRecords(list);
        page.setTotal(count.longValue());
        return page;
    }

    @Override
    public IPage<ContractSettleDetailsReportVO> queryLabProSettleDetailsList(Integer pageNumber, Integer pageSize, Long contractDetailId, Integer settleType, Integer contractType, String detailWorkContent, String detailRule) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        queryMap.put("contractDetailId", contractDetailId);
        queryMap.put("settleType", settleType);
        queryMap.put("contractType", contractType);
        queryMap.put("detailWorkContent", detailWorkContent);
        queryMap.put("detailRule", detailRule);
        queryMap.put("tenantId", InvocationInfoProxy.getTenantid());
        queryMap.put("start", pageNumber);
        queryMap.put("limit", pageSize);
        List<ContractSettleDetailsReportVO> list = this.contractMapper.queryLabProSettleDetailsList(queryMap);
        Long count = this.contractMapper.queryLabProSettleDetailsListCount(queryMap);
        for (ContractSettleDetailsReportVO vo : list) {
            if (vo == null) continue;
            String settleTypeUrl = "";
            String contractTypeUrl = "";
            if (contractType.equals(SettleTypeEnum.\u8fc7\u7a0b.getCode())) {
                settleTypeUrl = "processSettle";
            } else if (contractType.equals(SettleTypeEnum.\u5b8c\u5de5.getCode())) {
                settleTypeUrl = "finishSettle";
            } else if (contractType.equals(SettleTypeEnum.\u8282\u70b9.getCode())) {
                settleTypeUrl = "nodeSettle";
            }
            if (contractType == 0) {
                contractTypeUrl = "laborsub";
            } else if (contractType == 1) {
                contractTypeUrl = "prosub";
            }
            vo.setPcSettleCardUrl("/ejc-prosub-frontend/#/" + settleTypeUrl + "/" + contractTypeUrl + "/card?id=" + vo.getSettleId());
        }
        page.setRecords(list);
        page.setTotal(count.longValue());
        return page;
    }

    private boolean setOrgParam(Map<String, Object> queryMap, Long orgId, Integer orgType) {
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
            queryMap.put("orgId", orgId);
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)orgResp.getMsg());
                return true;
            }
            queryMap.put("parentOrgIdList", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        return false;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse salaryPayInfoResp;
        ContractEntity contractEntity;
        List paymentApplyVOList;
        CommonResponse resultData = this.paymentApplyApi.queryListByContractId(id);
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        if (resultData != null && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(paymentApplyVOList = (List)resultData.getData()))) {
            resultVO.setTotalApplyMny(paymentApplyVOList.stream().filter(p -> p.getApplyMny() != null).map(PaymentApplyVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalActualMny(paymentApplyVOList.stream().filter(p -> p.getActualMny() != null).map(PaymentApplyVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalApprovalMny(paymentApplyVOList.stream().filter(p -> p.getApprovalMny() != null).map(PaymentApplyVO::getApprovalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            paymentApplyVOList.forEach(item -> {
                item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
            });
            resultVO.setPaymentApplyList(paymentApplyVOList);
        }
        if (null != (contractEntity = (ContractEntity)((Object)this.service.selectById(id)))) {
            resultVO.setContractId(id);
            resultVO.setAddType(contractEntity.getAddType());
            resultVO.setContractFlag(contractEntity.getSupplementFlag());
            resultVO.setContractMny(contractEntity.getContractTaxMny());
            resultVO.setTotalApplyMny(null != resultVO.getTotalApplyMny() ? resultVO.getTotalApplyMny() : BigDecimal.ZERO);
            resultVO.setTotalActualMny(null != resultVO.getTotalActualMny() ? resultVO.getTotalActualMny() : BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(null != resultVO.getTotalApprovalMny() ? resultVO.getTotalApprovalMny() : BigDecimal.ZERO);
        }
        if (!(salaryPayInfoResp = this.salaryApi.querySalaryApplyInfoByContractId(id)).isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540cId-\u3010{}\u3011\u67e5\u8be2\u5408\u540c\u5bf9\u5e94\u5de5\u4eba\u5de5\u8d44\u652f\u4ed8\u4fe1\u606f\u5931\u8d25, {}\uff01", (Object)id, (Object)JSONObject.toJSONString((Object)salaryPayInfoResp));
        } else {
            com.ejianc.business.profinance.vo.ContractPaymentResultVO salaryPayInfo = (com.ejianc.business.profinance.vo.ContractPaymentResultVO)salaryPayInfoResp.getData();
            resultVO.setTotalActualMny(resultVO.getTotalActualMny().add(salaryPayInfo.getTotalActualMny()));
            resultVO.setTotalApplyMny(resultVO.getTotalApplyMny().add(salaryPayInfo.getTotalApplyMny()));
            resultVO.setTotalApprovalMny(resultVO.getTotalApprovalMny().add(salaryPayInfo.getTotalApprovalMny()));
            if (null == resultVO.getPaymentApplyList()) {
                resultVO.setPaymentApplyList(new ArrayList());
            }
            resultVO.getPaymentApplyList().addAll(salaryPayInfo.getPaymentApplyList());
        }
        if (null != resultVO.getTotalActualMny()) {
            resultVO.setPaymentRate(resultVO.getTotalActualMny().divide(resultVO.getContractMny(), 8, 5).multiply(new BigDecimal(100)));
        } else {
            resultVO.setPaymentRate(BigDecimal.ZERO);
        }
        CommonResponse addFlagData = this.paymentApplyApi.queryAddFlagContractId(id);
        if (addFlagData != null && addFlagData.getData() != null && ((String)addFlagData.getData()).equals("1")) {
            resultVO.setAddFlag(Boolean.valueOf(true));
        }
        return resultVO;
    }

    @Override
    public List<ParamsCheckVO> supplementMnyCtrl(ContractVO contractVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == contractVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-18rO1Y72", contractVO.getOrgId());
        }
        if (1 == contractVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-MK2Y0473", contractVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        QueryWrapper contractEntityQueryWrapper = new QueryWrapper();
        Long mainContractId = contractVO.getMainContractId();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)contractEntityQueryWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"main_contract_id", (Object)mainContractId)).eq((Object)"supplement_flag", (Object)1);
        if (contractVO.getId() != null) {
            contractEntityQueryWrapper.notIn((Object)"id", Arrays.asList(contractVO.getId()));
        }
        contractEntityQueryWrapper.select(new String[]{"sum(contract_tax_mny) as contractTaxMnySupTotal"});
        Map map = super.getMap((Wrapper)contractEntityQueryWrapper);
        BigDecimal contractTaxMnySupTotal = BigDecimal.ZERO;
        if (map != null) {
            contractTaxMnySupTotal = map.get("contractTaxMnySupTotal") != null ? new BigDecimal(map.get("contractTaxMnySupTotal").toString()) : BigDecimal.ZERO;
        }
        BigDecimal curDataContractTaxMny = contractVO.getContractTaxMny() != null ? contractVO.getContractTaxMny() : BigDecimal.ZERO;
        contractTaxMnySupTotal = contractTaxMnySupTotal.add(curDataContractTaxMny);
        contractEntityQueryWrapper = new QueryWrapper();
        contractEntityQueryWrapper.eq((Object)"id", (Object)mainContractId);
        ContractEntity contractEntity = (ContractEntity)((Object)super.getOne((Wrapper)contractEntityQueryWrapper));
        if (contractEntity == null) {
            this.logger.info("\u67e5\u8be2\u4e3b\u5408\u540c\u5931\u8d25\uff01");
            throw new BusinessException("\u67e5\u8be2\u4e3b\u5408\u540c\u5931\u8d25\uff01");
        }
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny();
        contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
        List data = (List)billParamByCode.getData();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal conTaxMny = contractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                if (contractTaxMnySupTotal.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = contractTaxMnySupTotal.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(curDataContractTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySupTotal.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(conTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> planNumCtrlContractNum(ContractVO contractVO) {
        this.logger.info("prosub---ContractServiceImpl---planNumCtrlContractNum()---\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = new CommonResponse();
        Integer contractType = contractVO.getContractType();
        Long projectIdSave = contractVO.getProjectId();
        Long tenantid = InvocationInfoProxy.getTenantid();
        if (0 == contractType) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-29O92c0105", contractVO.getOrgId());
        }
        if (1 == contractType) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-90sLe50106", contractVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List data = (List)billParamByCode.getData();
        QueryWrapper planWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)planWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).eq((Object)"sub_type", (Object)contractType)).eq((Object)"project_id", (Object)projectIdSave)).in((Object)"bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        PlanEntity pe = (PlanEntity)((Object)this.planService.getOne((Wrapper)planWrapper));
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u7684\u603b\u8ba1\u5212\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)pe)));
        HashMap<Long, BigDecimal> planNumMap = new HashMap<Long, BigDecimal>();
        if (pe != null) {
            QueryWrapper planDetailWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)planDetailWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).eq((Object)"plan_id", (Object)pe.getId())).isNotNull((Object)"plan_num")).groupBy((Object[])new String[]{"doc_id"});
            planDetailWrapper.select(new String[]{"sum(ifnull(plan_num, 0)) as planNumTotal, doc_id as docId"});
            List pdMapList = this.planDetailService.listMaps((Wrapper)planDetailWrapper);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)pdMapList)) {
                for (Object pdMap : pdMapList) {
                    Long docId = Long.parseLong(pdMap.get("docId").toString());
                    BigDecimal planNum = pdMap.get("planNumTotal") == null ? BigDecimal.ZERO : new BigDecimal(pdMap.get("planNumTotal").toString());
                    planNumMap.put(docId, planNum);
                }
            }
        }
        this.logger.info("\u603b\u8ba1\u5212\u5b50\u8868\u6839\u636e\u5408\u540c\u6e05\u5355docId\u7ef4\u5ea6\u6c47\u603b\u8ba1\u5212\u91cf\uff0c\u6c47\u603b\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(planNumMap));
        ArrayList<Long> cdIdListSave = new ArrayList<Long>();
        HashMap curConNumMap = new HashMap();
        ArrayList<ContractDetailVO> cdListSave = new ArrayList<ContractDetailVO>();
        ParamCtrlUtil.treeToConDetailVOList(cdListSave, contractVO.getDetailList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cdListSave)) {
            for (ContractDetailVO cdVO : cdListSave) {
                BigDecimal detailNum = cdVO.getDetailNum();
                Long l = cdVO.getDocId();
                String rowState = cdVO.getRowState();
                Long cdId = cdVO.getId();
                if (cdId != null) {
                    cdIdListSave.add(cdId);
                }
                if (detailNum == null || "del".equals(rowState)) continue;
                String detailName = cdVO.getDetailName();
                String detailRule = cdVO.getDetailMeasurementRules();
                HashMap<String, Object> mapOld = (HashMap<String, Object>)curConNumMap.get(l);
                BigDecimal conNumOld = BigDecimal.ZERO;
                if (MapUtils.isEmpty((Map)mapOld)) {
                    mapOld = new HashMap<String, Object>();
                } else {
                    conNumOld = mapOld.get("conNum") == null ? BigDecimal.ZERO : new BigDecimal(mapOld.get("conNum").toString());
                }
                mapOld.put("conNum", ComputeUtil.safeAdd((BigDecimal)conNumOld, (BigDecimal)detailNum));
                mapOld.put("detailName", StringUtils.isEmpty((CharSequence)detailName) ? "" : detailName);
                mapOld.put("detailRule", StringUtils.isEmpty((CharSequence)detailRule) ? "" : detailRule);
                curConNumMap.put(l, mapOld);
            }
        }
        this.logger.info("\u5165\u53c2VO\u5b50\u8868\u6570\u636e\u6839\u636e\u5408\u540c\u6e05\u5355docId\u7ef4\u5ea6\u6c47\u603b\u5408\u540c\u91cf\uff0c\u6c47\u603b\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(curConNumMap));
        HashMap<Long, BigDecimal> conNumMap = new HashMap<Long, BigDecimal>();
        List<Map<String, Object>> conMapList = this.contractMapper.queryCountConNum(contractType, tenantid, projectIdSave, com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cdIdListSave) ? null : cdIdListSave);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(conMapList)) {
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u4e0b\u5408\u540c\u7684\u5408\u540c\u91cf\uff08\u5df2\u6392\u9664\u672c\u671f\uff09\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(conMapList));
            for (Map map : conMapList) {
                conNumMap.put(Long.parseLong(map.get("docId").toString()), new BigDecimal(map.get("detailNumTotal") == null ? "0" : map.get("detailNumTotal").toString()));
            }
            this.logger.info("\u5f53\u524d\u9879\u76ee\u4e0b\u5408\u540c\u7684\u5408\u540c\u91cf\uff08\u5df2\u6392\u9664\u672c\u671f\uff09\u6839\u636e\u5408\u540c\u6e05\u5355docId\u7ef4\u5ea6\u6c47\u603b\u5408\u540c\u91cf\uff0c\u6c47\u603b\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(conNumMap));
        } else {
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u4e0b\u5408\u540c\u7684\u5408\u540c\u91cf\uff08\u5df2\u6392\u9664\u672c\u671f\uff09\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType()) && MapUtils.isNotEmpty(curConNumMap) && curConNumMap.keySet().size() > 0) {
                Set keySet = curConNumMap.keySet();
                for (Long key : keySet) {
                    this.logger.info("\u5f53\u524ddocId={}", (Object)key);
                    BigDecimal planNumKey = (BigDecimal)planNumMap.get(key);
                    if (planNumKey == null) {
                        this.logger.info("\u5f53\u524ddocId\u7684\u603b\u8ba1\u5212\u91cf\u4e3a\u7a7a\uff0c\u65e0\u9700\u63a7\u5236");
                        continue;
                    }
                    this.logger.info("\u5f53\u524ddocId\u7684\u603b\u8ba1\u5212\u91cf\uff1a{}", (Object)planNumKey);
                    Map curConMap = (Map)curConNumMap.get(key);
                    BigDecimal curConNum = BigDecimal.ZERO;
                    String detailName = "";
                    String detailRule = "";
                    if (MapUtils.isNotEmpty((Map)curConMap)) {
                        this.logger.info("\u5f53\u524ddocId\u7684\u672c\u671f\u5408\u540c\u91cfmap\uff1a{}", (Object)JSONObject.toJSONString((Object)curConMap));
                        Object conNumObj = curConMap.get("conNum");
                        curConNum = conNumObj == null ? BigDecimal.ZERO : new BigDecimal(conNumObj.toString());
                        Object detailNameObj = curConMap.get("detailName");
                        detailName = detailNameObj == null ? "" : detailNameObj.toString();
                        Object detailRuleObj = curConMap.get("detailRule");
                        detailRule = detailRuleObj == null ? "" : detailRuleObj.toString();
                    } else {
                        this.logger.info("\u5f53\u524ddocId\u7684\u672c\u671f\u5408\u540c\u91cfmap\uff1anull");
                    }
                    BigDecimal conNum = (BigDecimal)conNumMap.get(key);
                    conNum = conNum == null ? BigDecimal.ZERO : conNum;
                    this.logger.info("\u5f53\u524ddocId\u7684\u4e0d\u542b\u672c\u671f\u5408\u540c\u91cfmap\uff1a{}", (Object)JSONObject.toJSONString((Object)conNum));
                    conNum = conNum.add(curConNum);
                    this.logger.info("\u5f53\u524ddocId\u7684\u542b\u672c\u671f\u5408\u540c\u91cf = \u4e0d\u542b\u672c\u671f + \u672c\u671f\uff0c\u8ba1\u7b97\u7ed3\u679c={}", (Object)conNum);
                    BigDecimal planNum = planNumKey.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                    this.logger.info("\u8ba1\u7b97\uff1a\u603b\u8ba1\u5212\u91cf *" + roleValue + "% = {}", (Object)planNum);
                    if (conNum.compareTo(planNum) <= 0) continue;
                    BigDecimal overNum = conNum.subtract(planNum);
                    this.logger.info("\u8d85\u51fa\u6570\u91cf={}", (Object)overNum);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(detailName + detailRule);
                    paramsCheckDsVO.setWarnName("\u5408\u540c\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u6570\u91cf\uff1a").append(curConNum.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u6570\u91cf\uff1a").append(conNum.setScale(2, RoundingMode.DOWN)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%\uff1a").append(planNum.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(overNum.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                }
            }
            this.logger.info("prosub---ContractServiceImpl---planNumCtrlContractNum()---\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> planMnyCtrlContractMny(ContractVO contractVO) {
        this.logger.info("prosub---ContractServiceImpl---planMnyCtrlContractMny()---\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = new CommonResponse();
        Integer contractType = contractVO.getContractType();
        Long projectIdSave = contractVO.getProjectId();
        Integer supplementFlag = contractVO.getSupplementFlag();
        Long tenantid = InvocationInfoProxy.getTenantid();
        Long saveId = contractVO.getId();
        if (0 == contractType) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-uOc2160107", contractVO.getOrgId());
        }
        if (1 == contractType) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-66ZB8r0108", contractVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        QueryWrapper planWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)planWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).eq((Object)"sub_type", (Object)contractType)).eq((Object)"project_id", (Object)projectIdSave)).in((Object)"bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        PlanEntity pe = (PlanEntity)((Object)this.planService.getOne((Wrapper)planWrapper));
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u7684\u603b\u8ba1\u5212\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)pe)));
        BigDecimal totalPlanTaxMny = BigDecimal.ZERO;
        if (pe == null) {
            return paramsCheckVOList;
        }
        totalPlanTaxMny = pe.getTotalPlanTaxMny();
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u7684\u603b\u8ba1\u5212\u91d1\u989d\uff1a{}", (Object)JSONObject.toJSONString((Object)totalPlanTaxMny));
        Map<String, Object> lastConTaxMnyMap = this.contractMapper.queryCountConTaxMny(contractType, tenantid, projectIdSave, saveId, null);
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u4e0b\u5408\u540c\u7684\u5408\u540c\u91d1\u989d\uff08\u5df2\u6392\u9664\u672c\u671f\uff09\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(lastConTaxMnyMap));
        List data = (List)billParamByCode.getData();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                ArrayList cdIdListSave = new ArrayList();
                BigDecimal curConTaxMny = contractVO.getContractTaxMny();
                curConTaxMny = curConTaxMny == null ? BigDecimal.ZERO : curConTaxMny;
                this.logger.info("\u5165\u53c2VO\u5408\u540c\u91d1\u989d\uff1a{}", (Object)JSONObject.toJSONString((Object)curConTaxMny));
                BigDecimal totalPlanTaxMnyRoleValue = totalPlanTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                this.logger.info("\u8ba1\u7b97\uff1a\u603b\u8ba1\u5212\u91d1\u989d *" + roleValue + "% = {}", (Object)totalPlanTaxMnyRoleValue);
                BigDecimal lastConTaxMny = lastConTaxMnyMap.get("lastConTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(lastConTaxMnyMap.get("lastConTaxMny").toString());
                BigDecimal totalConTaxMny = lastConTaxMny.add(curConTaxMny);
                this.logger.info("\u542b\u672c\u671f\u5408\u540c\u91d1\u989d\uff1a{}", (Object)JSONObject.toJSONString((Object)totalConTaxMny));
                if (totalPlanTaxMny != BigDecimal.ZERO && totalConTaxMny.compareTo(totalPlanTaxMnyRoleValue) > 0) {
                    BigDecimal overMny = totalConTaxMny.subtract(totalPlanTaxMnyRoleValue);
                    this.logger.info("\u8d85\u51fa\u91d1\u989d={}", (Object)overMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u5408\u540c\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u5408\u540c\u91d1\u989d\u5927\u4e8e\u603b\u8ba1\u5212\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(curConTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(totalConTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%\uff1a").append(totalPlanTaxMnyRoleValue.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(overMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            this.logger.info("prosub---ContractServiceImpl---planMnyCtrlContractMny()---\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> contractionMnyCtrlLabConMny(ContractVO contractVO) {
        this.logger.info("prosub---ContractServiceImpl---contractionMnyCtrlLabConMny()---\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = new CommonResponse();
        Long projectIdSave = contractVO.getProjectId();
        Integer supplementFlag = contractVO.getSupplementFlag();
        Long tenantid = InvocationInfoProxy.getTenantid();
        Long saveId = contractVO.getId();
        BigDecimal curConTaxMny = contractVO.getContractTaxMny();
        curConTaxMny = curConTaxMny == null ? BigDecimal.ZERO : curConTaxMny;
        this.logger.info("\u5165\u53c2VO\u5408\u540c\u91d1\u989d\uff1a{}", (Object)JSONObject.toJSONString((Object)curConTaxMny));
        billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-4Avuf10109", contractVO.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List data = (List)billParamByCode.getData();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                BigDecimal contractionSubtractTaxMny = BigDecimal.ZERO;
                CommonResponse subtractTaxMnyRes = this.contractPoolApi.queryContractionSubtractProTaxMny(projectIdSave);
                this.logger.info("\u9879\u76eeid={}\uff0c\u67e5\u8be2\u6b64\u9879\u76ee\u4e0b(\u6700\u65b0\u7684\u65bd\u5de5\u5408\u540c\u91d1\u989d - \u4e13\u4e1a\u5408\u540c\u91d1\u989d)\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)projectIdSave, (Object)JSONObject.toJSONString((Object)subtractTaxMnyRes));
                if (subtractTaxMnyRes.isSuccess() && subtractTaxMnyRes.getData() != null) {
                    contractionSubtractTaxMny = (BigDecimal)subtractTaxMnyRes.getData();
                }
                if (contractionSubtractTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                    continue;
                }
                Map<String, Object> lastConTaxMnyMap = this.contractMapper.queryCountConTaxMny(0, tenantid, projectIdSave, saveId, null);
                this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u4e0b\u5408\u540c\u7684\u5408\u540c\u91d1\u989d\uff08\u5df2\u6392\u9664\u672c\u671f\uff09\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(lastConTaxMnyMap));
                BigDecimal lastConTaxMny = MapUtils.isEmpty(lastConTaxMnyMap) || lastConTaxMnyMap.get("lastConTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(lastConTaxMnyMap.get("lastConTaxMny").toString());
                BigDecimal totalConTaxMny = lastConTaxMny.add(curConTaxMny);
                this.logger.info("\u542b\u672c\u671f\u5408\u540c\u91d1\u989d\uff1a{}", (Object)JSONObject.toJSONString((Object)totalConTaxMny));
                contractionSubtractTaxMny = contractionSubtractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                this.logger.info("\u8ba1\u7b97\uff1a(\u65bd\u5de5\u5408\u540c\u91d1\u989d - \u4e13\u4e1a\u5408\u540c\u91d1\u989d) *" + roleValue + "% = {}", (Object)contractionSubtractTaxMny);
                if (contractionSubtractTaxMny != BigDecimal.ZERO && totalConTaxMny.compareTo(contractionSubtractTaxMny) > 0) {
                    BigDecimal overMny = totalConTaxMny.subtract(contractionSubtractTaxMny);
                    this.logger.info("\u8d85\u51fa\u91d1\u989d={}", (Object)overMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u5408\u540c\u91d1\u989d\u8d85\uff08\u65bd\u5de5\u5408\u540c\u91d1\u989d-\u4e13\u4e1a\u5408\u540c\u91d1\u989d\uff09");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u52b3\u52a1\u5408\u540c\u91d1\u989d\u5927\u4e8e\uff08\u65bd\u5de5\u5408\u540c\u91d1\u989d-\u4e13\u4e1a\u5408\u540c\u91d1\u989d\uff09");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u52b3\u52a1\u5408\u540c\u91d1\u989d\uff1a").append(curConTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u52b3\u52a1\u5408\u540c\u91d1\u989d\uff1a").append(totalConTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\uff08\u65bd\u5de5\u5408\u540c\u91d1\u989d-\u4e13\u4e1a\u5408\u540c\u91d1\u989d\uff09*").append(roleValue).append("%\uff1a").append(contractionSubtractTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(overMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            this.logger.info("prosub---ContractServiceImpl---contractionMnyCtrlLabConMny()---\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public void pushTargetCost(Long id) {
        String linkUrl;
        LambdaQueryWrapper queryWrapper;
        ArrayList<ExecutionVO> executionVOs = new ArrayList<ExecutionVO>();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)id)).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        if (!list.isEmpty()) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ChangeDetailEntity::getChangeId, (Object)((ChangeEntity)((Object)list.get(0))).getId());
            ((ChangeEntity)((Object)list.get(0))).setDetailList(this.changeDetailService.list((Wrapper)queryWrapper));
            ChangeVO changeVO = (ChangeVO)BeanMapper.map(list.get(0), ChangeVO.class);
            linkUrl = this.changeService.getLinkUrl(changeVO);
            executionVOs.add(this.changeService.targetCost(changeVO, linkUrl, changeVO.getContractType(), changeVO.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode(), false));
        } else {
            ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
            String linkUrl2 = this.service.getLinkUrl(contractVO);
            executionVOs.add(this.service.targetCost(contractVO, linkUrl2, contractEntity.getContractType(), contractEntity.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode()));
        }
        if (PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus())) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ContractRelieveEntity::getContractId, (Object)id);
            ContractRelieveEntity contractRelieveEntity = (ContractRelieveEntity)((Object)this.contractRelieveService.getOne((Wrapper)queryWrapper));
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractRelieveEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractRelieveEntity.getBillState())) {
                linkUrl = this.getBaseHost() + "ejc-prosub-frontend/#/contractRelieve/Card?id=" + contractRelieveEntity.getId() + "&cardType=" + contractEntity.getContractType();
                executionVOs.add(this.contractRelieveService.targetCost((ContractRelieveVO)BeanMapper.map((Object)((Object)contractRelieveEntity), ContractRelieveVO.class), linkUrl));
            }
        }
        if (CollectionUtils.isNotEmpty(executionVOs)) {
            executionVOs.forEach(executionVO -> {
                this.logger.info("\u624b\u52a8\uff1a\u5206\u5305\u5408\u540c\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a {}", (Object)JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                this.logger.info("\u624b\u52a8\uff1a\u5206\u5305\u5408\u540c\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\u7ed3\u679c\uff1a {}", (Object)JSON.toJSONString((Object)response));
            });
        }
    }

    @Override
    public String changePerformanceStatus(Long contractId, String stateCode) {
        ContractEntity contract = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        contract.setPerformanceStatus(stateCode);
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        contractPoolVO.setSourceId(contractId);
        contractPoolVO.setId(contractId);
        contractPoolVO.setPerformanceStatus(stateCode);
        contractPoolVO.setPerformanceStatusName(ContractPerformanceStateEnum.getByStateCode((String)stateCode).getStateName());
        CommonResponse updateResp = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
        if (!updateResp.isSuccess()) {
            this.logger.error("\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5230\u5408\u540c\u6c60\u5931\u8d25-\u3010{}\u3011, \u54cd\u5e94\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)contract)), (Object)JSONObject.toJSONString((Object)updateResp));
            return StringUtils.isNotBlank((CharSequence)updateResp.getMsg()) ? updateResp.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01";
        }
        super.saveOrUpdate((Object)contract, false);
        return null;
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter("in", targetResultIdList));
        List contractEntityList = super.queryList(queryParam);
        ArrayList<SignContractVo> signContractVoList = new ArrayList<SignContractVo>();
        this.logger.info("\u6839\u636e\u5b9a\u6807id\u96c6\u5408\u53c2\u6570\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5b9a\u6807\u65b0\u589e\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)contractEntityList));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)contractEntityList)) {
            for (ContractEntity contractEntity : contractEntityList) {
                SignContractVo signContractVo = new SignContractVo();
                signContractVo.setBillCode(contractEntity.getBillCode());
                signContractVo.setBillState(contractEntity.getBillState());
                signContractVo.setContractId(contractEntity.getId());
                signContractVo.setContractTaxMny(contractEntity.getContractTaxMny());
                signContractVo.setContractMny(contractEntity.getContractMny());
                signContractVo.setContractName(contractEntity.getContractName());
                signContractVo.setSignDate(contractEntity.getSignDate());
                signContractVo.setSupplierId(contractEntity.getSupplierId());
                signContractVo.setSupplierName(contractEntity.getSupplierName());
                signContractVo.setLinkUrl(this.getLinkUrl((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)));
                signContractVoList.add(signContractVo);
            }
        }
        return signContractVoList;
    }
}

