/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanContrastV0;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PlanMapper planMapper;
    @Autowired
    private IPlanChangeService planChangeService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    private final String LAB_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-D12WrV0223";
    private final String PRO_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-yPfPb50221";
    private final String LAB_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-W3h8660273";
    private final String PRO_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-Ic8ufh0276";
    private final String LAB_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-033zg70274";
    private final String PRO_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-5cB3y00275";

    @Override
    public PlanVO queryByCode(String planCode) {
        PlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PlanEntity entity = (PlanEntity)((Object)this.planMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO queryByProjectId(Long projectId, Integer subType) {
        PlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"sub_type", (Object)subType);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PlanEntity entity = (PlanEntity)((Object)this.planMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO saveOrUpdateMasterPlan(PlanEntity saveEntity, Boolean isControl) {
        if (Boolean.FALSE.equals(isControl)) {
            super.saveOrUpdate((Object)saveEntity, false);
        }
        PlanVO planVO = null;
        List<PlanDetailEntity> detailEntityList = saveEntity.getPlanDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            planVO = Boolean.FALSE.equals(isControl) ? this.queryDetail(saveEntity.getId(), true) : (PlanVO)BeanMapper.map((Object)((Object)saveEntity), PlanVO.class);
        }
        return planVO;
    }

    @Override
    public PlanVO queryDetail(Long id, boolean detailHasChildren) {
        PlanEntity masterPlanEntity = (PlanEntity)((Object)super.selectById((Serializable)id));
        PlanVO masterPlanVO = (PlanVO)BeanMapper.map((Object)((Object)masterPlanEntity), PlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.planDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (PlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailVO.class);
            List<PlanDetailVO> usefulDetailList = this.selectUsefulByIds(resultMapList.stream().map(BaseVO::getId).collect(Collectors.toList()));
            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<Long, Integer>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)) {
                for (PlanDetailVO c : usefulDetailList) {
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailVO c : resultMapList) {
                if (null != usefulDetailMap.get(c.getId())) {
                    c.setUseNum(Integer.valueOf(1));
                    c.setRowState("edit");
                    continue;
                }
                c.setUseNum(null);
            }
            if (detailHasChildren) {
                masterPlanVO.setPlanDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                masterPlanVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailVO.class));
        }
        if (null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0) {
            masterPlanVO.setPlanChangeHisList(this.planChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;
    }

    @Override
    public List<PlanDetailVO> selectUsefulByIds(List<Long> planIdList) {
        return this.planMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public List<PlanContrastV0> getContrastInfo(Long planId, Long oldPlanId) {
        return this.planMapper.getContrastInfo(planId, oldPlanId);
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<PlanDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((PlanDetailEntity)((Object)BeanMapper.map(ypd, PlanDetailEntity.class)));
        }
    }

    @Override
    public ExecutionVO targetCost(PlanVO planVO, String linkUrl, Integer subType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(planVO.getId());
        totalVO.setTenantId(planVO.getTenantId());
        totalVO.setBillCode(planVO.getBillCode());
        totalVO.setOrgId(planVO.getOrgId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (subType == 0) {
            totalVO.setBillType(ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getCode());
        } else {
            totalVO.setBillType(ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setProjectId(planVO.getProjectId());
        totalVO.setOrgId(planVO.getOrgId());
        totalVO.setMoney(planVO.getTotalPlanMny());
        totalVO.setTaxMoney(planVO.getTotalPlanTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (null != planVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planVO.getCreateTime()));
        }
        totalVO.setMemo(planVO.getMemo());
        if (CollectionUtils.isNotEmpty((Collection)planVO.getPlanDetailList())) {
            List planDetailVOS = planVO.getPlanDetailList().stream().filter(item -> item.getLeafFlag() != false && !"del".equals(item.getRowState())).collect(Collectors.toList());
            Assert.notEmpty(planDetailVOS, (String)"\u8ba1\u5212\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            for (PlanDetailVO planDetailVO : planDetailVOS) {
                LabsubCategoryVO categoryVO;
                CommonResponse res;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                Assert.notNull((Object)planDetailVO.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
                if (0 == subType) {
                    res = this.shareLabsubApi.queryLabSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)planDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (LabsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    res = this.shareLabsubApi.queryMajorSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)planDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (ProsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }
                Assert.notNull((Object)planDetailVO.getDocId(), (String)"\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if (null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public List<ParamsCheckVO> targetCostPriceCtrlPlanPrice(PlanVO planVO) {
        this.logger.info("prosub---PlanServiceImpl---targetCostPriceCtrlPlanPrice()--- \u76ee\u6807\u6210\u672c\u4ef7\u63a7\u603b\u8ba1\u5212\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)planVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        Integer contractType = planVO.getSubType();
        List detailList = planVO.getPlanDetailList();
        if (0 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-D12WrV0223", planVO.getOrgId());
        }
        if (1 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-yPfPb50221", planVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u76ee\u6807\u6210\u672c\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u76ee\u6807\u6210\u672c\u4ef7\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List docIds = detailList.stream().filter(item -> null != item.getDetailName()).map(PlanDetailVO::getDocId).collect(Collectors.toList());
        CommonResponse dutyRes = this.dutyApi.queryPriceByDocIds(planVO.getProjectId(), 0 == contractType ? DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode() : DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode(), docIds);
        if (null == dutyRes) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683c\u4e3a\u7a7a");
            return paramsCheckVOList;
        }
        Map dutyMap = (Map)dutyRes.getData();
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        if (null == dutyMap) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683cmap\u4e3a\u7a7a");
            return paramsCheckVOList;
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7map\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)dutyMap));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (PlanDetailVO detailVO : detailList) {
                    if (null == detailVO.getPlanNum() || "del".equals(detailVO.getRowState())) continue;
                    BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : ((BigDecimal)dutyMap.get(detailVO.getDocId())).setScale(4, 4);
                    BigDecimal price = null == detailVO.getPlanPrice() ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, 4);
                    BigDecimal maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                    this.logger.info("marpriceparam:{},price:{},maxprice:{}", new Object[]{maxPriceParam, price, maxPrice});
                    if (price.compareTo(maxPriceParam) <= 0) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getWorkContent() == null ? "" : "+" + detailVO.getWorkContent()));
                    paramsCheckDsVO.setWarnName("\u8ba1\u5212\u5355\u4ef7\u5927\u4e8e\u76ee\u6807\u6210\u672c\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8ba1\u5212\u5355\u4ef7\uff1a").append(price).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u5355\u4ef7\uff1a(").append(maxPrice).append("\u5143),\u76ee\u6807\u6210\u672c\u5355\u4ef7*").append(roleValueMax).append("%\uff1a").append(maxPriceParam).append("\u5143\uff0c\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlPlanPrice(PlanVO planVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        this.logger.info("prosub---PlanServiceImpl---historyPriceCtrlPlanPrice()--- \u5386\u53f2\u4ef7\u63a7\u603b\u8ba1\u5212\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)planVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        CommonResponse minParamByCode = new CommonResponse();
        Integer contractType = planVO.getSubType();
        Integer princeDepot = null;
        List detailList = planVO.getPlanDetailList();
        if (0 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-W3h8660273", planVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-033zg70274", planVO.getOrgId());
            princeDepot = PrinceDepotEnum.\u52b3\u52a1\u5206\u5305\u4ef7\u683c\u5e93.getCode();
        }
        if (1 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-Ic8ufh0276", planVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-5cB3y00275", planVO.getOrgId());
            princeDepot = PrinceDepotEnum.\u4e13\u4e1a\u5206\u5305\u4ef7\u683c\u5e93.getCode();
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u603b\u8ba1\u5212\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u603b\u8ba1\u5212\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)princeDepot));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(princeDepot);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (PlanDetailVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u603b\u8ba1\u5212\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPlanPrice() == null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                if ("none".equals(paramsArray[minParamVO.getControlType()])) continue;
                for (PlanDetailVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u603b\u8ba1\u5212\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPlanPrice() == null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u603b\u8ba1\u5212\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }
        return paramsCheckVOList;
    }
}

