package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.service.*;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("controlChange") 
public class ControlChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IControlService controlService;
	@Autowired
	private IControlChangeService controlChangeService;
	@Autowired
	private IControlDetailService controlDetailService;
	@Autowired
	private IControlDetailTwoService controlDetailTwoService;
	@Autowired
	private IControlDetailThreeService controlDetailThreeService;
	@Autowired
	private IControlDetailFourService controlDetailFourService;
	@Autowired
	private IControlChangeHisService controlChangeHisService;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IAttachmentApi attachmentApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());




	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

//		ControlEntity e = controlService.selectById(billId);
//		UserContext userContext = sessionManager.getUserContext();
//
//		e.setCommitDate(new Date());
//		e.setCommitUserCode(userContext.getUserCode());
//		e.setCommitUserName(userContext.getUserName());
//		masterPlanService.saveOrUpdate(e, false);
		return CommonResponse.success("总计划审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		//查询变更计划
		ControlChangeEntity planChange = controlChangeService.selectById(billId);
		ControlEntity newPlanEntity = null;
		//查询原计划
		ControlEntity oldPlan = controlService.selectById(planChange.getSourceControlId());
		//变更计划附件复制到主计划
		CommonResponse<String> stringCommonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "EJCBT202412000015", "materPlan001", String.valueOf(oldPlan.getId()), "EJCBT202412000013", "materPlan001");
		if(!stringCommonResponse.isSuccess()){
			logger.info("控制变更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
		}else {
			logger.info("控制更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
		}

		/*处理变更计划主表信息*/
//		if(state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
//			//直审时记录
//			UserContext userContext = sessionManager.getUserContext();
//			//设置提交人信息
//			planChange.setCommitDate(new Date());
//			planChange.setCommitUserCode(userContext.getUserCode());
//			planChange.setCommitUserName(userContext.getUserName());
//		}
//设置总计划变更单据生效时间
		planChange.setEffectiveDate(new Date());

		//1、复制计划信息到计划记录
		ControlChangeHisEntity recordEntity = BeanMapper.map(oldPlan, ControlChangeHisEntity.class);
		logger.info("总计划变更审批完成回调, 总计划变更信息：【{}】, 变更前总计划信息: 【{}】", JSON.toJSONString(planChange), JSON.toJSONString(oldPlan));

		//设置总计划Id
		recordEntity.setSourceControlId(oldPlan.getId());
		//Id置为空
		recordEntity.setId(null);
        //子表处理
		if(CollectionUtils.isNotEmpty(recordEntity.getControlDetailList())) {
			recordEntity.getControlDetailList().stream().forEach(detail -> {
				detail.setTargetId(detail.getId());
				detail.setId(null);
			});
		}
		if(CollectionUtils.isNotEmpty(recordEntity.getControlDetailTwoList())) {
			recordEntity.getControlDetailTwoList().stream().forEach(detail -> {
				detail.setTargetId(detail.getId());
				detail.setId(null);
			});
		}
		if(CollectionUtils.isNotEmpty(recordEntity.getControlDetailThreeList())) {
			recordEntity.getControlDetailThreeList().stream().forEach(detail -> {
				detail.setTargetId(detail.getId());
				detail.setId(null);
			});
		}
		if(CollectionUtils.isNotEmpty(recordEntity.getControlDetailFourList())) {
			recordEntity.getControlDetailFourList().stream().forEach(detail -> {
				detail.setTargetId(detail.getId());
				detail.setId(null);
			});
		}

		/*记录主表信息处理*/
		//设置编制人等信息
		recordEntity.setCreateUserCode(planChange.getCreateUserCode());
		recordEntity.setCreateTime(planChange.getCreateTime());
		recordEntity.setCreateUserName(planChange.getCreateUserName());
		recordEntity.setModifyUserName(planChange.getModifyUserName());
		recordEntity.setUpdateTime(planChange.getUpdateTime());
		recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
		recordEntity.setEffectiveDate(planChange.getEffectiveDate());
//		recordEntity.(oldPlan.getTotalPlanAmt());
//		recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
//		recordEntity.setChangePlanId(planChange.getId());
//		recordEntity.setChangeUserName(planChange.getChangeUserName());
//		recordEntity.setChangeReason(planChange.getChangeReason());

          //总计划变更记录保存
		controlChangeHisService.saveOrUpdate(recordEntity, false);

		//变更计划信息更新
		controlChangeService.saveOrUpdate(planChange, false);

		//修改总计划字段  复制变更计划{回显原计划用}
		newPlanEntity = BeanMapper.map(planChange, ControlEntity.class);
		/*
		 * 更新主表信息
		 * */
		//变更状态-已变更
		newPlanEntity.setChangeState(MasterPlanVO.PLAN_CHANGE_STATE_CHANGED);
		//清空当前变更计划id
		newPlanEntity.setChangeId(null);
		//合同初始创建信息
		newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
		newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
		newPlanEntity.setCreateTime(oldPlan.getCreateTime());
		newPlanEntity.setId(oldPlan.getId());
		newPlanEntity.setVersion(oldPlan.getVersion());
		newPlanEntity.setChangeVersion(planChange.getChangeVersion());

		//子表信息设置
		List<Long> delDetailIds = new ArrayList<>();//原计划要删除的子表
		List<ControlDetailEntity> controlDetailEntityList = new ArrayList<>();//要更新的子表
		logger.info("回显原计划子表开始！");
//		("变更类型: 1-增补项，2-删除项，3-变更项,0-未变更")
		List<ControlDetailEntity> oldList = oldPlan.getControlDetailList();//原计划 子表
		Map<Long, ControlDetailEntity> map = oldList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(ControlDetailEntity::getId, item -> item, (v1, v2) -> v2));
		if(CollectionUtils.isNotEmpty(newPlanEntity.getControlDetailList())) {//遍历变更计划子表
			for (ControlDetailEntity detail : newPlanEntity.getControlDetailList()) {
				if(detail.getChangeType()==2){//删除
					delDetailIds.add(detail.getTargetId());
				}else {
					if(null!=detail.getTargetId()){//修改
						if(map.containsKey(detail.getTargetId())){
							ControlDetailEntity controlDetailEntity = map.get(detail.getTargetId());
                            controlDetailEntity.setChangeType(detail.getChangeType());
                            controlDetailEntity.setControlPrice(detail.getControlPrice());
                            controlDetailEntity.setControlTaxPrice(detail.getControlTaxPrice());
                            controlDetailEntity.setControlTaxRate(detail.getControlTaxRate());
                            controlDetailEntity.setControlTaxMny(detail.getControlTaxMny());
                            controlDetailEntity.setControlMny(detail.getControlMny());
                            controlDetailEntity.setControlTax(detail.getControlTax());
                            controlDetailEntity.setDiffTaxPrice(detail.getDiffTaxPrice());
                            controlDetailEntity.setDiffPrice(detail.getDiffPrice());
                            controlDetailEntityList.add(controlDetailEntity);
						}

					}else {//新增
						detail.setId(null);
                        controlDetailEntityList.add(detail);
					}
				}
			}
		}

        if(CollectionUtils.isNotEmpty(controlDetailEntityList)){
            controlDetailService.saveOrUpdateBatch(controlDetailEntityList);
        }
        newPlanEntity.setControlDetailList(controlDetailEntityList);
        if(CollectionUtils.isNotEmpty(delDetailIds)){
            controlDetailService.removeByIds(delDetailIds);//原计划删除
        }

		//子表信息设置
		List<Long> delDetailTwoIds = new ArrayList<>();//原计划要删除的子表
		List<ControlDetailTwoEntity> controlDetailEntityTwoList = new ArrayList<>();//要更新的子表
		logger.info("回显原计划子表开始！");
//		("变更类型: 1-增补项，2-删除项，3-变更项,0-未变更")
		List<ControlDetailTwoEntity> oldTwoList = oldPlan.getControlDetailTwoList();//原计划 子表
		Map<Long, ControlDetailTwoEntity> mapTwo = oldTwoList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(ControlDetailTwoEntity::getId, item -> item, (v1, v2) -> v2));
		if(CollectionUtils.isNotEmpty(newPlanEntity.getControlDetailTwoList())) {//遍历变更计划子表
			for (ControlDetailTwoEntity detail : newPlanEntity.getControlDetailTwoList()) {
				if(detail.getTwoChangeType()==2){//删除
                    delDetailTwoIds.add(detail.getTargetId());
				}else {
					if(null!=detail.getTargetId()){//修改
						if(mapTwo.containsKey(detail.getTargetId())){
							ControlDetailTwoEntity controlDetailEntity = mapTwo.get(detail.getTargetId());
                            controlDetailEntity.setTwoChangeType(detail.getTwoChangeType());
                            controlDetailEntity.setTwoControlPrice(detail.getTwoControlPrice());
                            controlDetailEntity.setTwoControlTaxPrice(detail.getTwoControlTaxPrice());
                            controlDetailEntity.setTwoControlTaxRate(detail.getTwoControlTaxRate());
                            controlDetailEntity.setTwoControlTaxMny(detail.getTwoControlTaxMny());
                            controlDetailEntity.setTwoControlMny(detail.getTwoControlMny());
                            controlDetailEntity.setTwoControlTax(detail.getTwoControlTax());
                            controlDetailEntity.setTwoDiffTaxPrice(detail.getTwoDiffTaxPrice());
                            controlDetailEntity.setTwoDiffPrice(detail.getTwoDiffPrice());
                            controlDetailEntityTwoList.add(controlDetailEntity);
						}

					}else {//新增
						detail.setId(null);
                        controlDetailEntityTwoList.add(detail);
					}
				}
			}
		}

        if(CollectionUtils.isNotEmpty(controlDetailEntityTwoList)){
            controlDetailTwoService.saveOrUpdateBatch(controlDetailEntityTwoList);
        }
        newPlanEntity.setControlDetailTwoList(controlDetailEntityTwoList);
        if(CollectionUtils.isNotEmpty(delDetailIds)){
            controlDetailTwoService.removeByIds(delDetailTwoIds);//原计划删除
        }
		//子表信息设置
		List<Long> delDetailThreeIds = new ArrayList<>();//原计划要删除的子表
		List<ControlDetailThreeEntity> controlDetailEntityThreeList = new ArrayList<>();//要更新的子表
		logger.info("回显原计划子表开始！");
//		("变更类型: 1-增补项，2-删除项，3-变更项,0-未变更")
		List<ControlDetailThreeEntity> oldThreeList = oldPlan.getControlDetailThreeList();//原计划 子表
		Map<Long, ControlDetailThreeEntity> mapThree = oldThreeList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(ControlDetailThreeEntity::getId, item -> item, (v1, v2) -> v2));
		if(CollectionUtils.isNotEmpty(newPlanEntity.getControlDetailThreeList())) {//遍历变更计划子表
			for (ControlDetailThreeEntity detail : newPlanEntity.getControlDetailThreeList()) {
				if(detail.getThreeChangeType()==2){//删除
                    delDetailThreeIds.add(detail.getTargetId());
				}else {
					if(null!=detail.getTargetId()){//修改
						if(mapThree.containsKey(detail.getTargetId())){
							ControlDetailThreeEntity controlDetailEntity = mapThree.get(detail.getTargetId());
                            controlDetailEntity.setThreeChangeType(detail.getThreeChangeType());
                            controlDetailEntity.setThreeControlPrice(detail.getThreeControlPrice());
                            controlDetailEntity.setThreeControlTaxPrice(detail.getThreeControlTaxPrice());
                            controlDetailEntity.setThreeControlTaxRate(detail.getThreeControlTaxRate());
                            controlDetailEntity.setThreeControlTaxMny(detail.getThreeControlTaxMny());
                            controlDetailEntity.setThreeControlMny(detail.getThreeControlMny());
                            controlDetailEntity.setThreeControlTax(detail.getThreeControlTax());
                            controlDetailEntity.setThreeDiffTaxPrice(detail.getThreeDiffTaxPrice());
                            controlDetailEntity.setThreeDiffPrice(detail.getThreeDiffPrice());
                            controlDetailEntityThreeList.add(controlDetailEntity);
						}

					}else {//新增
						detail.setId(null);
                        controlDetailEntityThreeList.add(detail);
					}
				}
			}
		}

        if(CollectionUtils.isNotEmpty(controlDetailEntityThreeList)){
            controlDetailThreeService.saveOrUpdateBatch(controlDetailEntityThreeList);
        }
        newPlanEntity.setControlDetailThreeList(controlDetailEntityThreeList);
        if(CollectionUtils.isNotEmpty(delDetailIds)){
            controlDetailThreeService.removeByIds(delDetailThreeIds);//原计划删除
        }
		//子表信息设置
		List<Long> delDetailFourIds = new ArrayList<>();//原计划要删除的子表
		List<ControlDetailFourEntity> controlDetailEntityFourList = new ArrayList<>();//要更新的子表
		logger.info("回显原计划子表开始！");
//		("变更类型: 1-增补项，2-删除项，3-变更项,0-未变更")
		List<ControlDetailFourEntity> oldFourList = oldPlan.getControlDetailFourList();//原计划 子表
		Map<Long, ControlDetailFourEntity> mapFour = oldFourList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(ControlDetailFourEntity::getId, item -> item, (v1, v2) -> v2));
		if(CollectionUtils.isNotEmpty(newPlanEntity.getControlDetailFourList())) {//遍历变更计划子表
			for (ControlDetailFourEntity detail : newPlanEntity.getControlDetailFourList()) {
				if(detail.getFourChangeType()==2){//删除
                    delDetailFourIds.add(detail.getTargetId());
				}else {
					if(null!=detail.getTargetId()){//修改
						if(mapFour.containsKey(detail.getTargetId())){
							ControlDetailFourEntity controlDetailEntity = mapFour.get(detail.getTargetId());
                            controlDetailEntity.setFourChangeType(detail.getFourChangeType());
                            controlDetailEntity.setFourControlPrice(detail.getFourControlPrice());
                            controlDetailEntity.setFourControlTaxPrice(detail.getFourControlTaxPrice());
                            controlDetailEntity.setFourControlTaxRate(detail.getFourControlTaxRate());
                            controlDetailEntity.setFourControlTaxMny(detail.getFourControlTaxMny());
                            controlDetailEntity.setFourControlMny(detail.getFourControlMny());
                            controlDetailEntity.setFourControlTax(detail.getFourControlTax());
                            controlDetailEntity.setFourDiffTaxPrice(detail.getFourDiffTaxPrice());
                            controlDetailEntity.setFourDiffPrice(detail.getFourDiffPrice());
                            controlDetailEntityFourList.add(controlDetailEntity);
						}
					}else {//新增
						detail.setId(null);
                        controlDetailEntityFourList.add(detail);
					}
				}
			}
		}

        if(CollectionUtils.isNotEmpty(controlDetailEntityFourList)){
            controlDetailFourService.saveOrUpdateBatch(controlDetailEntityFourList);
        }
        newPlanEntity.setControlDetailFourList(controlDetailEntityFourList);
        if(CollectionUtils.isNotEmpty(delDetailIds)){
            controlDetailFourService.removeByIds(delDetailFourIds);//原计划删除
        }

        controlService.saveOrUpdate(newPlanEntity, false);
        return CommonResponse.success("审批通过后回调完成！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
