package com.ejianc.business.control.service.impl;

import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.control.mapper.ControlMapper;
import com.ejianc.business.control.service.IControlService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包招标控制价审核表
 * 
 * @author generator
 * 
 */
@Service("controlService")
public class ControlServiceImpl extends BaseServiceImpl<ControlMapper, ControlEntity> implements IControlService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUB_CONTROL";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IControlService service;


//    @Value("${common.env.base-host}")
//    private String BASE_HOST;
//
//    @Value("${refer.base-host:null}")
//    private String BASE_HOST_FRONTEND;

    @Override
    public ControlVO saveOrUpdate(ControlVO saveOrUpdateVO) {
        ControlEntity entity = BeanMapper.map(saveOrUpdateVO, ControlEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        UserContext userContext = sessionManager.getUserContext();
        ControlEntity saveEntity = null;
        if(null == saveOrUpdateVO.getId()) {
            saveEntity = BeanMapper.map(saveOrUpdateVO, ControlEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为未变更
            saveEntity.setChangeState(0);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(1);
            //设置编制人
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = service.getById(saveOrUpdateVO.getId());
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setMemo(saveOrUpdateVO.getMemo());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setTaxRate(saveOrUpdateVO.getTaxRate());
            saveEntity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
            saveEntity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
            saveEntity.setCostMny(saveOrUpdateVO.getCostMny());
            saveEntity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
            saveEntity.setControlMny(saveOrUpdateVO.getControlMny());
            saveEntity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setEmployeeId(saveOrUpdateVO.getEmployeeId());
            saveEntity.setEmployeeName(saveOrUpdateVO.getEmployeeName());

            saveEntity.setControlDetailList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailList(), ControlDetailEntity.class));
            saveEntity.setControlDetailTwoList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailTwoList(), ControlDetailTwoEntity.class));
            saveEntity.setControlDetailThreeList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailThreeEntity.class));
            saveEntity.setControlDetailFourList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailFourEntity.class));
        }

        List<ControlDetailEntity> controlDetailList = saveEntity.getControlDetailList();
        if(CollectionUtils.isNotEmpty(controlDetailList)){
//            for(ControlDetailEntity detail : controlDetailList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailEntity detail : controlDetailList) {
                detail.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        List<ControlDetailTwoEntity> controlDetailTwoList = saveEntity.getControlDetailTwoList();
        if(CollectionUtils.isNotEmpty(controlDetailTwoList)){
//            for(ControlDetailTwoEntity detail : controlDetailTwoList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailTwoEntity detail : controlDetailTwoList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setTwoChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailThreeEntity> controlDetailThreeList = saveEntity.getControlDetailThreeList();
        if(CollectionUtils.isNotEmpty(controlDetailThreeList)){
//            for(ControlDetailThreeEntity detail : controlDetailThreeList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailThreeEntity detail : controlDetailThreeList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setThreeChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailFourEntity> controlDetailFourList = saveEntity.getControlDetailFourList();
        if(CollectionUtils.isNotEmpty(controlDetailFourList)){
//            for(ControlDetailFourEntity detail : controlDetailFourList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailFourEntity detail : controlDetailFourList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setFourChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        super.saveOrUpdate(saveEntity, false);

        ControlVO vo = BeanMapper.map(entity, ControlVO.class);
        return vo;
    }
}
