package com.ejianc.business.process.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 专业分包领料结算
 *
 * @author generator
 *
 */
@TableName("ejc_prosub_process_picking")
public class PicKingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议

    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别 名称
    @TableField(value="contract_category_code")
    private String contractCategoryCode; // 合同类别 编码


    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称（带入）
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="employee_name")
    private String employeeName; // 申请人名 即经办人
    @TableField(value="employee_id")
    private Long employeeId; // 申请人id 即经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办部门id
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @TableField(value = "first_party_id")
    private Long firstPartyId;// 甲方Id
    @TableField(value = "first_party_name")
    private String firstPartyName;// 甲方名称
    @TableField(value = "supplier_sign_status")
    private Integer supplierSignStatus; // 乙方签字状态:已签字-1,未签字-0
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value="org_id")
    private Long orgId; // 项目组织ID
    @TableField(value="org_name")
    private String orgName; // 项目组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织id
    @TableField(value="memo")
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="settle_date")
    private Date settleDate; // 结算日期：默认显示当天
    @TableField(value="mny")
    private BigDecimal mny; // 本期扣款金额(无税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 本期扣款金额(含税)
    @TableField(value="tax")
    private BigDecimal tax; // 本期扣款税额
    @TableField(value="out_mny")
    private BigDecimal outMny; //  出库结算金额(无税)
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 出库结算金额（含税）
    @TableField(value="out_tax")
    private BigDecimal outTax; // 出库结算税额
    @TableField(value="exit_tax")
    private BigDecimal exitTax; // 退库税额
    @TableField(value="exit_mny")
    private BigDecimal exitMny; // 退库金额（无税）
    @TableField(value="exit_tax_mny")
    private BigDecimal exitTaxMny; // 退库金额（含税）

    @TableField(value="equipment_deduct_tax")
    private BigDecimal equipmentDeductTax; // '设备扣款税额'
    @TableField(value="equipment_deduct_mny")
    private BigDecimal equipmentDeductMny; // 设备扣款金额（无税）
    @TableField(value="equipment_deduct_tax_mny")
    private BigDecimal equipmentDeductTaxMny; // 设备扣款金额（含税）



    @TableField(value="commit_data")
    private Date commitData; // 提交日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 编码
    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "effective_date")
    private Date effectiveDate; // 生效日期


    @TableField(exist = false)
    @SubEntity(serviceName = "picKingStoreService", pidName = "pickingId")
    private List<PicKingStoreEntity> outList = new ArrayList<>(); // 出库子表
    @TableField(exist = false)
    @SubEntity(serviceName = "picKingStoreService", pidName = "pickingId")
    private List<PicKingStoreEntity> exitList = new ArrayList<>();//退库子表
    @TableField(exist = false)
    @SubEntity(serviceName = "picKingTotalService", pidName = "pickingId")
    private List<PicKingTotalEntity> totalList = new ArrayList<>();//领料汇总子表

    @TableField(exist = false)
    @SubEntity(serviceName = "pickingEquipmentService", pidName = "pickingId")
    private List<PickingEquipmentEntity> equipmentList = new ArrayList<>();//领料汇总子表
    /**
     * 制单人Id
     */
    @TableField(value = "create_user_id")
    private Long createUserId;


    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;

    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String sourceSystemId;

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;



    @TableField(value="cost_mny")
    private BigDecimal costMny; // '成本金额'
    @TableField(value="cost_tax_mny")
    private BigDecimal costTaxMny; // 成本金额（含税）
    @TableField(value="cost_tax")
    private BigDecimal costTax; // 成本税额

    public List<PickingEquipmentEntity> getEquipmentList() {
        return equipmentList;
    }

    public void setEquipmentList(List<PickingEquipmentEntity> equipmentList) {
        this.equipmentList = equipmentList;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public List<PicKingStoreEntity> getOutList() {
        return outList;
    }

    public void setOutList(List<PicKingStoreEntity> outList) {
        this.outList = outList;
    }

    public List<PicKingStoreEntity> getExitList() {
        return exitList;
    }

    public void setExitList(List<PicKingStoreEntity> exitList) {
        this.exitList = exitList;
    }

    public List<PicKingTotalEntity> getTotalList() {
        return totalList;
    }

    public void setTotalList(List<PicKingTotalEntity> totalList) {
        this.totalList = totalList;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public BigDecimal getEquipmentDeductTax() {
        return equipmentDeductTax;
    }

    public void setEquipmentDeductTax(BigDecimal equipmentDeductTax) {
        this.equipmentDeductTax = equipmentDeductTax;
    }

    public BigDecimal getEquipmentDeductMny() {
        return equipmentDeductMny;
    }

    public void setEquipmentDeductMny(BigDecimal equipmentDeductMny) {
        this.equipmentDeductMny = equipmentDeductMny;
    }

    public BigDecimal getEquipmentDeductTaxMny() {
        return equipmentDeductTaxMny;
    }

    public void setEquipmentDeductTaxMny(BigDecimal equipmentDeductTaxMny) {
        this.equipmentDeductTaxMny = equipmentDeductTaxMny;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    public BigDecimal getOutTax() {
        return outTax;
    }

    public void setOutTax(BigDecimal outTax) {
        this.outTax = outTax;
    }
    public BigDecimal getExitTax() {
        return exitTax;
    }

    public void setExitTax(BigDecimal exitTax) {
        this.exitTax = exitTax;
    }
    public BigDecimal getExitMny() {
        return exitMny;
    }

    public void setExitMny(BigDecimal exitMny) {
        this.exitMny = exitMny;
    }
    public BigDecimal getExitTaxMny() {
        return exitTaxMny;
    }

    public void setExitTaxMny(BigDecimal exitTaxMny) {
        this.exitTaxMny = exitTaxMny;
    }
    public Date getCommitData() {
        return commitData;
    }

    public void setCommitData(Date commitData) {
        this.commitData = commitData;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }


    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }

    public BigDecimal getCostTax() {
        return costTax;
    }

    public void setCostTax(BigDecimal costTax) {
        this.costTax = costTax;
    }
}
