package com.ejianc.business.prosub.pricelib.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包指导价价格明细子实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_price_guide_detail")
public class PriceGuideDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="guide_id")
    private Long guideId; // 主表ID
    @TableField(value="doc_id")
    private Long docId; // 清单id-档案Id
    @TableField(value="doc_code")
    private String docCode; // 清单编码-档案编码
    @TableField(value="doc_name")
    private String docName; // 清单名称-档案名称
    @TableField(value="doc_category_id")
    private Long docCategoryId; // 所属上级id-档案分类Id
    @TableField(value="doc_category_name")
    private String docCategoryName; // 所属上级名称-档案分类名称
    @TableField(value="doc_inner_code")
    private String docInnerCode; // 分类内码
    @TableField(value="unit_id")
    private Long unitId; // 计量单位主键
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="min_price")
    private BigDecimal minPrice; // 最低价(无税)
    @TableField(value="min_tax_price")
    private BigDecimal minTaxPrice; // 最低价(含税)
    @TableField(value="max_price")
    private BigDecimal maxPrice; // 最高价(无税)
    @TableField(value="max_tax_price")
    private BigDecimal maxTaxPrice; // 最高价(含税)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="contract_price_area")
    private String contractPriceArea; // 合同价格区间（无税）
    @TableField(value="contract_tax_price_area")
    private String contractTaxPriceArea; // 合同价格区间（含税）
    @TableField(value="market_price")
    private String marketPrice; // 市场价（无税）
    @TableField(value="market_tax_price")
    private String marketTaxPrice; // 市场价（含税）
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="source_type")
    private String sourceType; // 来源类型（laborPriceLib-劳务分包价格库，proPriceLib-专业分包价格库,proSubDoc-专业分包档案，laborSubDoc-劳务分包档案)
    
    
    

    public Long getGuideId() {
        return guideId;
    }

    public void setGuideId(Long guideId) {
        this.guideId = guideId;
    }
    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }
    public String getDocCode() {
        return docCode;
    }

    public void setDocCode(String docCode) {
        this.docCode = docCode;
    }
    public String getDocName() {
        return docName;
    }

    public void setDocName(String docName) {
        this.docName = docName;
    }
    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }
    public String getDocCategoryName() {
        return docCategoryName;
    }

    public void setDocCategoryName(String docCategoryName) {
        this.docCategoryName = docCategoryName;
    }
    public String getDocInnerCode() {
        return docInnerCode;
    }

    public void setDocInnerCode(String docInnerCode) {
        this.docInnerCode = docInnerCode;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }
    public BigDecimal getMinTaxPrice() {
        return minTaxPrice;
    }

    public void setMinTaxPrice(BigDecimal minTaxPrice) {
        this.minTaxPrice = minTaxPrice;
    }
    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }
    public BigDecimal getMaxTaxPrice() {
        return maxTaxPrice;
    }

    public void setMaxTaxPrice(BigDecimal maxTaxPrice) {
        this.maxTaxPrice = maxTaxPrice;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getContractPriceArea() {
        return contractPriceArea;
    }

    public void setContractPriceArea(String contractPriceArea) {
        this.contractPriceArea = contractPriceArea;
    }
    public String getContractTaxPriceArea() {
        return contractTaxPriceArea;
    }

    public void setContractTaxPriceArea(String contractTaxPriceArea) {
        this.contractTaxPriceArea = contractTaxPriceArea;
    }
    public String getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(String marketPrice) {
        this.marketPrice = marketPrice;
    }
    public String getMarketTaxPrice() {
        return marketTaxPrice;
    }

    public void setMarketTaxPrice(String marketTaxPrice) {
        this.marketTaxPrice = marketTaxPrice;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    
}
