/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.control.service.impl;

import com.ejianc.business.control.bean.ControlDetailEntity;
import com.ejianc.business.control.bean.ControlDetailFourEntity;
import com.ejianc.business.control.bean.ControlDetailThreeEntity;
import com.ejianc.business.control.bean.ControlDetailTwoEntity;
import com.ejianc.business.control.bean.ControlEntity;
import com.ejianc.business.control.mapper.ControlMapper;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="controlService")
public class ControlServiceImpl
extends BaseServiceImpl<ControlMapper, ControlEntity>
implements IControlService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SUB_CONTROL";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IControlService service;

    @Override
    public ControlVO saveOrUpdate(ControlVO saveOrUpdateVO) {
        List<ControlDetailFourEntity> list;
        List<ControlDetailThreeEntity> list2;
        List<ControlDetailTwoEntity> controlDetailTwoList;
        ControlEntity entity = (ControlEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        UserContext userContext = this.sessionManager.getUserContext();
        ControlEntity saveEntity = null;
        if (null == saveOrUpdateVO.getId()) {
            saveEntity = (ControlEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setChangeState(0);
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(1);
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (ControlEntity)((Object)this.service.getById(saveOrUpdateVO.getId()));
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setMemo(saveOrUpdateVO.getMemo());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setTaxRate(saveOrUpdateVO.getTaxRate());
            saveEntity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
            saveEntity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
            saveEntity.setCostMny(saveOrUpdateVO.getCostMny());
            saveEntity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
            saveEntity.setControlMny(saveOrUpdateVO.getControlMny());
            saveEntity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setEmployeeId(saveOrUpdateVO.getEmployeeId());
            saveEntity.setEmployeeName(saveOrUpdateVO.getEmployeeName());
            saveEntity.setControlDetailList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailList(), ControlDetailEntity.class));
            saveEntity.setControlDetailTwoList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailTwoList(), ControlDetailTwoEntity.class));
            saveEntity.setControlDetailThreeList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailThreeList(), ControlDetailThreeEntity.class));
            saveEntity.setControlDetailFourList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailThreeList(), ControlDetailFourEntity.class));
        }
        List<ControlDetailEntity> controlDetailList = saveEntity.getControlDetailList();
        if (CollectionUtils.isNotEmpty(controlDetailList)) {
            for (ControlDetailEntity controlDetailEntity : controlDetailList) {
                controlDetailEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(controlDetailTwoList = saveEntity.getControlDetailTwoList())) {
            for (ControlDetailTwoEntity controlDetailTwoEntity : controlDetailTwoList) {
                if ("del".equals(controlDetailTwoEntity.getRowState())) continue;
                controlDetailTwoEntity.setTwoChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(list2 = saveEntity.getControlDetailThreeList())) {
            for (ControlDetailThreeEntity controlDetailThreeEntity : list2) {
                if ("del".equals(controlDetailThreeEntity.getRowState())) continue;
                controlDetailThreeEntity.setThreeChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(list = saveEntity.getControlDetailFourList())) {
            for (ControlDetailFourEntity detail : list) {
                if ("del".equals(detail.getRowState())) continue;
                detail.setFourChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        super.saveOrUpdate((Object)saveEntity, false);
        ControlVO controlVO = (ControlVO)BeanMapper.map((Object)((Object)entity), ControlVO.class);
        return controlVO;
    }
}

