/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.UseFlagEnum;
import com.ejianc.business.process.mapper.ApplicationMapper;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="applicationService")
public class ApplicationServiceImpl
extends BaseServiceImpl<ApplicationMapper, ApplicationEntity>
implements IApplicationService {
    private static final String LAB_CHECK_PARAM_CODE = "P-34v45349";
    private static final String PRO_CHECK_PARAM_NAME = "P-0lV6mY50";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IRegistrationService registrationService;

    @Override
    public ParamsCheckVO mnyCtrl(ApplicationVO applicationVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == applicationVO.getContractType()) {
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(applicationVO.getContractId()));
            if (!"laborSub-2".equals(contract.getContractCategoryProperty())) {
                billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, applicationVO.getOrgId());
            } else {
                this.logger.info("\u96f6\u5de5\u7533\u8bf7-\u3010{}\u3011\u6240\u5c5e\u5408\u540c-\u3010{}\u3011\u4e3a\u96f6\u5de5\u5408\u540c\uff0c\u4e0d\u8fdb\u884c\u53c2\u6570\u63a7\u5236\uff01", (Object)JSONObject.toJSONString((Object)applicationVO), (Object)JSONObject.toJSONString((Object)((Object)contract)));
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
        }
        if (1 == applicationVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, applicationVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            this.logger.info("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if ("none".equals(paramsCheck.getWarnType())) continue;
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(applicationVO.getContractId()));
            if (null == contract) {
                this.logger.info("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BigDecimal contractTaxMny = contract.getContractTaxMny().multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            BigDecimal taxMny = applicationVO.getTaxMny();
            BigDecimal totalTaxMny = BigDecimal.ZERO;
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"contract_id", (Object)applicationVO.getContractId());
            List res = this.registrationService.list((Wrapper)qw);
            if (CollectionUtils.isNotEmpty((Collection)res)) {
                totalTaxMny = res.stream().map(RegistrationEntity::getTotalTaxMny).reduce(taxMny, BigDecimal::add);
            }
            QueryWrapper ae = new QueryWrapper();
            ae.eq((Object)"contract_id", (Object)applicationVO.getContractId());
            ae.eq((Object)"use_flag", (Object)UseFlagEnum.\u96f6\u5de5\u672a\u767b\u8bb0.getCode());
            List aes = super.list((Wrapper)ae);
            if (CollectionUtils.isNotEmpty((Collection)aes)) {
                totalTaxMny = aes.stream().map(ApplicationEntity::getTaxMny).reduce(totalTaxMny, BigDecimal::add);
            }
            if (totalTaxMny.compareTo(contractTaxMny) > 0) {
                BigDecimal overTaxMny = totalTaxMny.subtract(contractTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u96f6\u5de5\u8d85\u5408\u540c");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u96f6\u5de5\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u96f6\u5de5\u91d1\u989d\uff1a").append(taxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u96f6\u5de5\u91d1\u989d\uff1a").append(totalTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheck.setDataSource(checkDsVOS);
                paramsCheckVOList.add(paramsCheck);
                continue;
            }
            paramsCheck.setWarnType(paramsArray[0]);
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }
}

