/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.ApplicationStateEnum;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.enums.UseFlagEnum;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationDetailService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.process.vo.RegistrationDetailVO;
import com.ejianc.business.process.vo.RegistrationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"registration"})
public class RegistrationController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "RESG_JOB";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IRegistrationService service;
    @Autowired
    private IRegistrationDetailService detailService;
    @Autowired
    private IApplicationService applicationService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private final String billTypeCode = "BT211230000000003";
    @Autowired
    private IContractService contractService;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/oddRegist/card";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RegistrationVO> saveOrUpdate(@RequestBody RegistrationVO saveorUpdateVO) {
        RegistrationEntity entity = (RegistrationEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RegistrationEntity.class));
        if (entity.getBillCode() == null) {
            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
        }
        entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
        entity.setBillState(0);
        entity.setRegionType(0);
        entity.setSettleFlag(0);
        if (entity.getFileIds() != null) {
            boolean bl = entity.getAttachIds().addAll(entity.getFileIds());
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getApplicationId() != null) {
            this.service.updateUseFlag(entity.getApplicationId(), UseFlagEnum.\u96f6\u5de5\u5df2\u767b\u8bb0.getCode(), ApplicationStateEnum.\u529e\u7406\u4e2d.getCode());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), RegistrationVO.class));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RegistrationVO> queryDetail(Long id) {
        RegistrationEntity entity = (RegistrationEntity)((Object)this.service.selectById(id));
        RegistrationVO vo = (RegistrationVO)BeanMapper.map((Object)((Object)entity), RegistrationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private static void sortIntMethod(List<RegistrationDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                RegistrationDetailVO o1Detail = (RegistrationDetailVO)objectMapper.convertValue(o1, RegistrationDetailVO.class);
                RegistrationDetailVO o2Detail = (RegistrationDetailVO)objectMapper.convertValue(o2, RegistrationDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RegistrationVO> vos) {
        for (RegistrationVO vo : vos) {
            ApplicationEntity applicationEntity;
            RegistrationEntity registrationEntity = (RegistrationEntity)((Object)this.service.selectById(vo.getId()));
            if (registrationEntity == null || null == registrationEntity.getApplicationId() || null == (applicationEntity = (ApplicationEntity)((Object)this.applicationService.selectById(registrationEntity.getApplicationId())))) continue;
            applicationEntity.setUseFlag(0);
            applicationEntity.setVisaState(ApplicationStateEnum.\u4e03\u5929\u5185\u672a\u529e\u7406.getCode());
            this.applicationService.saveOrUpdate((Object)applicationEntity);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RegistrationVO>> queryList(@RequestBody QueryParam param) {
        IPage page;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkDetail");
        List dataList = new ArrayList();
        param.getOrderMap().put("create_time", "desc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            if (null == param.getParams().get("orgId")) {
                page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            } else {
                page = this.service.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            Long orgId = InvocationInfoProxy.getOrgId();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            page = this.service.queryPage(param, false);
            dataList = page.getRecords();
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(dataList, RegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRegistrationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RegistrationVO>> refPicKingData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="searchObject", required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkDetail");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("contractId", new Parameter("eq", (Object)_con.getLong("contractId")));
            }
            if (_con.containsKey((Object)"endDate")) {
                param.getParams().put("regionDate", new Parameter("le", _con.get((Object)"endDate")));
            }
            if (_con.containsKey((Object)"settleFlag")) {
                param.getParams().put("settleFlag", new Parameter("eq", (Object)0));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"queryDetailByAppId"})
    @ResponseBody
    public CommonResponse<RegistrationVO> queryDetailByAppId(@RequestParam(value="id") Long id) {
        RegistrationVO vo = null;
        ApplicationEntity entity = (ApplicationEntity)((Object)this.applicationService.selectById(id));
        if (null != entity) {
            vo = (RegistrationVO)BeanMapper.map((Object)((Object)entity), RegistrationVO.class);
            vo.setApplicationId(id);
            vo.setApplicationCode(entity.getBillCode());
            vo.setCreateUserCode(null);
            vo.setCreateTime(null);
            vo.setUpdateUserCode(null);
            vo.setUpdateTime(null);
            vo.setBillState(null);
            vo.setVersion(Integer.valueOf(1));
            vo.setId(Long.valueOf(IdWorker.getId()));
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "BT211230000000002", "ygbefore", String.valueOf(vo.getId()), "BT211230000000003", "ygbefore");
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "BT211230000000002", "ygafter", String.valueOf(vo.getId()), "BT211230000000003", "ygafter");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getBillShareLink"})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        RegistrationEntity entity = (RegistrationEntity)((Object)this.service.selectById(id));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode("BT211230000000003");
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)"BT211230000000003", (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter((RegistrationEntity)((Object)BeanMapper.map((Object)((Object)entity), RegistrationEntity.class)), "BT211230000000003", (CooperateVO)cooperateResp.getData());
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, "BT211230000000003", entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/oddRegist/card", null);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkDetail");
        param.getOrderMap().put("create_time", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = (IPage)this.queryList(param).getData();
        this.logger.info("\u5bfc\u51fa\u6570\u636e----{}", (Object)JSONObject.toJSONString((Object)pageData));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), RegistrationVO.class);
            for (RegistrationVO item : list) {
                item.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
                item.setContractTypeStr(item.getContractType() == 0 ? "\u52b3\u52a1\u5206\u5305\u5408\u540c" : "\u4e13\u4e1a\u5206\u5305\u5408\u540c");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                item.setTimeStr(sdf.format(item.getCreateTime()));
            }
            HashMap<String, List> beans = new HashMap<String, List>(list.size());
            beans.put("records", list);
            ExcelExport.getInstance().exportWithTrans("registration-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/mnyCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody RegistrationVO registrationVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.mnyCtrl(registrationVO));
    }

    @RequestMapping(value={"/mnyCtrlById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value="id") Long id) {
        RegistrationEntity entity = (RegistrationEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728\uff01");
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.mnyCtrl((RegistrationVO)BeanMapper.map((Object)((Object)entity), RegistrationVO.class)));
    }

    @RequestMapping(value={"/contractRegistrationRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> contractRegistrationRecord(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(id));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contract.getId());
        query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc((Object)"create_time");
        List list = this.service.list((Wrapper)query);
        resp.put("registrationList", (Object)BeanMapper.mapList((Iterable)list, RegistrationVO.class));
        BigDecimal totalRegistrationTaxMny = BigDecimal.ZERO;
        for (RegistrationEntity item : list) {
            totalRegistrationTaxMny = totalRegistrationTaxMny.add(item.getTotalTaxMny());
        }
        resp.put("contractTaxMny", (Object)contract.getContractTaxMny());
        resp.put("totalRegistrationTaxMny", (Object)totalRegistrationTaxMny);
        resp.put("registrationRatio", (Object)totalRegistrationTaxMny.divide(contract.getContractTaxMny(), 8, 4));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }
}

