package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.mapper.ControlChangeHisMapper;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.*;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeHisVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeVO;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.*;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.control.mapper.ControlChangeMapper;
import com.ejianc.business.control.service.IControlChangeService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包招标控制价审核表-变更
 * 
 * @author generator
 * 
 */
@Service("controlChangeService")
public class ControlChangeServiceImpl extends BaseServiceImpl<ControlChangeMapper, ControlChangeEntity> implements IControlChangeService{

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IControlChangeService controlChangeService;
    @Autowired
    private IControlService controlService;
    private static final String BILL_CODE = "SUB_CONTROL_CHANGE";//此处需要根据实际修改
    private static final String CONTROL_COST_CODE = "P-i3X5840010";//无项目策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_DETAIL_CODE = "P-94k78t0012";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";//清单的分包招标控制价是否允许超过策划成本价
    @Autowired
    private IBuildDutyApi buildDutyApi;

    @Autowired
    private ControlChangeMapper controlChangeMapper;
    @Autowired
    private ControlChangeHisMapper controlChangeHisMapper;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private SessionManager sessionManager;


    @Override
    public ControlChangeVO saveOrUpdate(ControlChangeVO saveOrUpdateVO) {

        //校验项目是否存在未完成的变更计划单存在
        ControlChangeEntity controlChangeEntity = controlChangeService.getUnFinishedChange(saveOrUpdateVO.getSourceControlId());

        if(null !=controlChangeEntity && (null == saveOrUpdateVO.getId() || !controlChangeEntity.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的变更分包招标控制价审核表！");
        }

        ControlEntity masterPlan = controlService.getById(saveOrUpdateVO.getSourceControlId());
        UserContext userContext = sessionManager.getUserContext();
        ControlChangeEntity saveEntity = null;
        saveEntity = BeanMapper.map(saveOrUpdateVO, ControlChangeEntity.class);
        if(null == saveOrUpdateVO.getId()) {
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            //设置变更人
//            saveEntity.setChangeUserName(userContext.getUserName());

            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            //生成Id用于成本控制
            saveEntity.setId(IdWorker.getId());
        }
//        } else {
//            saveEntity = super.getById(saveOrUpdateVO.getId());
//            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
//            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
//            saveEntity.setMemo(saveOrUpdateVO.getMemo());
//            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
//            saveEntity.setModifyUserName(userContext.getUserName());
//            saveEntity.setTaxRate(saveOrUpdateVO.getTaxRate());
//            saveEntity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
//            saveEntity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
//            saveEntity.setCostMny(saveOrUpdateVO.getCostMny());
//            saveEntity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
//            saveEntity.setControlMny(saveOrUpdateVO.getControlMny());
//            saveEntity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
//            saveEntity.setModifyUserName(userContext.getUserName());
//
//            saveEntity.setControlDetailList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailList(), ControlDetailChangeEntity.class));
//            saveEntity.setControlDetailTwoList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailTwoList(), ControlDetailChangeTwoEntity.class));
//            saveEntity.setControlDetailThreeList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailChangeThreeEntity.class));
//            saveEntity.setControlDetailFourList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailFourList(), ControlDetailChangeFourEntity.class));
//
//        }

        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeEntity> controlDetailList = saveEntity.getControlDetailList();

        if (CollectionUtils.isNotEmpty(controlDetailList) && null == saveEntity.getId()) {
            for (ControlDetailChangeEntity cdEntity : controlDetailList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }

        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeTwoEntity> controlDetailTwoList = saveEntity.getControlDetailTwoList();
        if (CollectionUtils.isNotEmpty(controlDetailTwoList) && null == saveEntity.getId()) {
            for (ControlDetailChangeTwoEntity cdEntity : controlDetailTwoList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeThreeEntity> controlDetailThreeList = saveEntity.getControlDetailThreeList();
        if (CollectionUtils.isNotEmpty(controlDetailThreeList) && null == saveEntity.getId()) {
            for (ControlDetailChangeThreeEntity cdEntity : controlDetailThreeList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeFourEntity> controlDetailFourList = saveEntity.getControlDetailFourList();
        if (CollectionUtils.isNotEmpty(controlDetailFourList) && null == saveEntity.getId()) {
            for (ControlDetailChangeFourEntity cdEntity : controlDetailFourList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        List<ControlDetailChangeFiveEntity> controlDetailFiveList = saveEntity.getControlDetailFiveList();
        if (CollectionUtils.isNotEmpty(controlDetailFiveList) && null == saveEntity.getId()) {
            for (ControlDetailChangeFiveEntity cdEntity : controlDetailFiveList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }

        saveEntity = controlChangeService.saveOrUpdateControlChange(saveEntity);
        ControlChangeVO controlChangeVO = BeanMapper.map(saveEntity, ControlChangeVO.class);

        return controlChangeVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ControlChangeEntity saveOrUpdateControlChange(ControlChangeEntity saveEntity) {

        super.saveOrUpdate(saveEntity, false);

        ControlEntity controlEntity = controlService.selectById(saveEntity.getSourceControlId());
        if (1 != controlEntity.getChangeState()) {
            controlEntity.setChangeState(1);
            controlEntity.setChangeId(saveEntity.getId());
            controlService.saveOrUpdate(controlEntity, false);
        }
        return saveEntity;
    }


    @Override
    public ControlChangeEntity getUnFinishedChange(Long sourceControlId) {
        QueryWrapper<ControlChangeEntity> query = new QueryWrapper<>();
        query.eq("source_control_id", sourceControlId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return controlChangeMapper.selectOne(query);
    }

    @Override
    public List<ControlChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<ControlChangeEntity> lambda = Wrappers.<ControlChangeEntity>lambdaQuery();
        lambda.eq(ControlChangeEntity::getSourceControlId, id);
        lambda.in(ControlChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(ControlChangeEntity::getCreateTime);
        List<ControlChangeEntity> entities = super.list(lambda);
        List<ControlChangeHisVO> recordVOList = BeanMapper.mapList(entities, ControlChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
                    if (recordVO.getChangeVersion() < 10) {
                        recordVO.setHistoryCode(recordVO.getControlCode() + "-0" + recordVO.getChangeVersion());
                    }else {
                        recordVO.setHistoryCode(recordVO.getControlCode() + "-" + recordVO.getChangeVersion());
                    }
                    recordVO.setChangeCode(recordVO.getControlCode());
                }
        );
        return recordVOList;
    }

    private String responseIsCost(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)

        //无项目策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的系统参数不能为空!");
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, Long> costMap = new HashMap<>();
        if (subType == 1){
            if (buildDutyVO != null){
                List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
                if(CollectionUtils.isNotEmpty(proSubDetailList)){
                    costMap = proSubDetailList.stream().filter(s->s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getId));
                }
            }

        }
        if (subType == 2){
            if (buildDutyVO != null){
                List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
                if(CollectionUtils.isNotEmpty(laborDetailList)){
                    costMap = laborDetailList.stream().filter(s->s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getId));
                }
            }
        }

        // 是否限制： 0:限制，1:不限制
        if ("1".equals(valueData)) {
            return "1";
        }
        if ("0".equals(valueData)) {
            if (buildDutyVO == null || (buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)){
                throw new BusinessException("项目未做项目策划成本，不允许保存!");
            }
        }

        return "1";
    }
    private String responseDetailIsCost(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)

        //无项目策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的系统参数不能为空!");
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null){
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, Long> costMap = new HashMap<>();
        if (subType == 1){
            if (buildDutyVO != null){
                List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
                if(CollectionUtils.isNotEmpty(proSubDetailList)){
                    costMap = proSubDetailList.stream().filter(s->s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getId));
                }
            }

        }
        if (subType == 2){
            if (buildDutyVO != null){
                List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
                if(CollectionUtils.isNotEmpty(laborDetailList)){
                    costMap = laborDetailList.stream().filter(s->s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getId));
                }
            }
        }

        // 清单无策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> responseDetail = paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE);
        if (!responseDetail.isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + responseDetail.getMsg());
        }
        String valueDataDetail = responseDetail.getData().getValueData();
        Assert.hasText(valueDataDetail, "获取系统参数不能为空!");

        // 是否限制： 0:限制，1:不限制
        if ("1".equals(valueDataDetail)) {
            return "1";
        }
        if ("0".equals(valueDataDetail)) {
            //标段1
            List<ControlDetailChangeVO> controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty(controlDetailList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().filter(s->s.getChangeType() == null || s.getChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段1清单没有策划成本，不允许保存!");
                }
            }
            //标段2
            List<ControlDetailChangeTwoVO> controlDetailTwoList = controlVO.getControlDetailTwoList();
            if (CollectionUtils.isNotEmpty(controlDetailTwoList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().filter(s->s.getTwoChangeType() == null || s.getTwoChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段2清单没有策划成本，不允许保存!");
                }
            }
            //标段3
            List<ControlDetailChangeThreeVO> controlDetailThreeList = controlVO.getControlDetailThreeList();
            if (CollectionUtils.isNotEmpty(controlDetailThreeList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().filter(s->s.getThreeChangeType() == null || s.getThreeChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段3清单没有策划成本，不允许保存!");
                }
            }
            //标段4
            List<ControlDetailChangeFourVO> controlDetailFourList = controlVO.getControlDetailFourList();
            if (CollectionUtils.isNotEmpty(controlDetailFourList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().filter(s->s.getFourChangeType() == null || s.getFourChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段4清单没有策划成本，不允许保存!");
                }
            }
        }

        return "1";
    }

    //分包招标控制总价是否允许超过策划成本总价
    private List<ParamsCheckVO> checkControlAllMny(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        Map<Long, BigDecimal> numMasterPlanMap = new HashMap<>();
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null){
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }

//        分包招标控制总价>策划成本总价*X%

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info(" 分包招标控制总价>策划成本总价*X%：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal compareNum = ComputeUtil.safeMultiply(planedTotalCostTaxMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                    if (ComputeUtil.isGreaterThan(controlVO.getControlTaxMny(), compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("分包招标控制总价大于策划成本总价");
                        paramsCheckDsVO.setWarnName("分包招标控制总价大于策划成本总价");

                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("当前分包招标控制总价为:").append(ComputeUtil.nullToZero(controlVO.getControlTaxMny()).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("，策划成本总价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("。超出量：").append(ComputeUtil.safeSub(controlVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }



    @Override
    public ParamsCheckVO checkParams(ControlChangeVO vo, Object o) {

        //无项目策划成本时是否可提交分包招标控制价审核表
        String status = responseIsCost(vo);
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
//        if (status.equals("0")){
//            return paramsCheckVO;
//        }

        paramsCheckVOS.addAll(checkControlAllMny(vo));
        responseDetailIsCost(vo);
        paramsCheckVOS.addAll(checkControlDetailMny(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public void deleteChangeControl(List<Long> changeIds) {
        List<ControlChangeEntity> changeList = controlChangeMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(ControlChangeEntity::getSourceControlId).collect(Collectors.toList());

        QueryWrapper<ControlEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<ControlEntity> planList = controlService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<ControlChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_control_id as planId");
        query.in("source_control_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_control_id");

        List<Map<String, Object>> queryResult = controlChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for (ControlEntity plan : planList) {
            plan.setChangeState((null != hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setChangeId(null);
        }

        controlService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(ControlChangeEntity::getId).collect(Collectors.toList()), false);

    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        List<ControlDetailChangeVO> controlDetailList = controlVO.getControlDetailList();


        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, BigDecimal> costMap = new HashMap<>();
        if (subType == 1 && buildDutyVO != null){
            List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
            if(CollectionUtils.isNotEmpty(proSubDetailList)){
                costMap = proSubDetailList.stream().filter(s -> s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
            }
        }
        if (subType == 2 && buildDutyVO != null){
            List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
            if(CollectionUtils.isNotEmpty(laborDetailList)){
                costMap = laborDetailList.stream().filter(s -> s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info("清单的分包招标控制价是否允许超过策划成本价：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (ControlDetailChangeVO detailVO : controlVO.getControlDetailList()) {
                    if("del".equals(detailVO.getRowState())){
                        continue;
                    }
                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额: ").append(ComputeUtil.nullToZero(detailVO.getControlTaxMny()).setScale(3,                                     BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段2
                for (ControlDetailChangeTwoVO detailVO : controlVO.getControlDetailTwoList()) {
                    if("del".equals(detailVO.getRowState())){
                        continue;
                    }
                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getTwoControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段2清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getTwoControlTaxMny()).setScale(3,                                BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getTwoControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
            //标段3
            for (ControlDetailChangeThreeVO detailVO : controlVO.getControlDetailThreeList()) {
                if("del".equals(detailVO.getRowState())){
                    continue;
                }
                BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    //清单的分包招标控制价>清单的策划成本价*X%
                    BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                    if (ComputeUtil.isGreaterThan(detailVO.getThreeControlTaxMny(), compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                        paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("当前分包招标控制价 标段3清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getThreeControlTaxMny()).setScale(3,                              BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getThreeControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
            //标段4
            for (ControlDetailChangeFourVO detailVO : controlVO.getControlDetailFourList()) {
                if("del".equals(detailVO.getRowState())){
                    continue;
                }
                BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    //清单的分包招标控制价>清单的策划成本价*X%
                    BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                    if (ComputeUtil.isGreaterThan(detailVO.getFourControlTaxMny(), compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                        paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("当前分包招标控制价 标段4清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getFourControlTaxMny()).setScale(3,                               BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getFourControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

}
