package com.ejianc.business.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("adjust") 
public class AdjustBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IAdjustService service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AdjustEntity entity = service.selectById(billId);
		List<AdjustDetailEntity> detailList= entity.getAdjustDetailList();
		BigDecimal approveMny=BigDecimal.ZERO;
		for (AdjustDetailEntity detailEntity : detailList) {
			if (null!=detailEntity.getDetailProjectNum() || null!=detailEntity.getDetailProjectTaxPrice()){
				detailEntity.setDetailFinishNum(detailEntity.getDetailProjectNum());
				detailEntity.setDetailFinishTaxMny(detailEntity.getDetailProjectTaxMny());
				detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailProjectTaxPrice());
				detailEntity.setDetailFinishMny(detailEntity.getDetailProjectMny());
				detailEntity.setDetailFinishTax(detailEntity.getDetailProjectTax());
				detailEntity.setDetailFinishPrice(detailEntity.getDetailProjectPrice());
			}
			if (null!=detailEntity.getDetailBranchNum() || null!=detailEntity.getDetailBranchTaxPrice()){
				detailEntity.setDetailFinishNum(detailEntity.getDetailBranchNum());
				detailEntity.setDetailFinishTaxMny(detailEntity.getDetailBranchTaxMny());
				detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailBranchTaxPrice());
				detailEntity.setDetailFinishMny(detailEntity.getDetailBranchMny());
				detailEntity.setDetailFinishTax(detailEntity.getDetailBranchTax());
				detailEntity.setDetailFinishPrice(detailEntity.getDetailBranchPrice());
			}
			if (null!=detailEntity.getDetailMasterNum() || null!=detailEntity.getDetailMasterTaxPrice()){
				detailEntity.setDetailFinishNum(detailEntity.getDetailMasterNum());
				detailEntity.setDetailFinishTaxMny(detailEntity.getDetailMasterTaxMny());
				detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailMasterTaxPrice());
				detailEntity.setDetailFinishMny(detailEntity.getDetailMasterMny());
				detailEntity.setDetailFinishTax(detailEntity.getDetailMasterTax());
				detailEntity.setDetailFinishPrice(detailEntity.getDetailMasterPrice());
			}
			approveMny= ComputeUtil.safeAdd(approveMny,detailEntity.getDetailFinishTaxMny());
		}
		entity.setApproveTime(new Date());
		entity.setApproveMny(approveMny);
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AdjustEntity entity = service.selectById(billId);
		// 校验审批时间
		if (!validateApproveTime(entity)) return CommonResponse.error("该合同下非最新价格调整与增补，不能撤回!");
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		if(res.isSuccess()) {//单据未被下游单据引用
		}else{
			return CommonResponse.error(res.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AdjustEntity entity = service.selectById(billId);
		List<AdjustDetailEntity> detailList= entity.getAdjustDetailList();
		BigDecimal approveMny=BigDecimal.ZERO;
		for (AdjustDetailEntity detailEntity : detailList) {
				detailEntity.setDetailFinishNum(null);
				detailEntity.setDetailFinishTaxMny(null);
				detailEntity.setDetailFinishTaxPrice(null);
				detailEntity.setDetailFinishMny(null);
				detailEntity.setDetailFinishTax(null);
				detailEntity.setDetailFinishPrice(null);

				detailEntity.setDetailBranchNum(null);
				detailEntity.setDetailBranchTaxMny(null);
				detailEntity.setDetailBranchTaxPrice(null);
				detailEntity.setDetailBranchMny(null);
			  	detailEntity.setDetailBranchTax(null);
				detailEntity.setDetailBranchPrice(null);

				detailEntity.setDetailMasterNum(null);
				detailEntity.setDetailMasterTaxMny(null);
				detailEntity.setDetailMasterTaxPrice(null);
				detailEntity.setDetailMasterMny(null);
				detailEntity.setDetailMasterTax(null);
				detailEntity.setDetailMasterPrice(null);
		}
		entity.setApproveTime(null);
		entity.setApproveMny(approveMny);
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}
	/**
	 * 校验审批时间
	 * @param entity
	 * @return
	 */
	private boolean validateApproveTime(AdjustEntity entity) {
		Long contractId = entity.getContractId();
		QueryWrapper wrapper = new QueryWrapper<AdjustEntity>();
		wrapper.eq("contract_id", contractId);
		wrapper.gt("approve_time", entity.getApproveTime());
		List<AdjustEntity> list = service.list(wrapper);
		if(!list.isEmpty()){
			return false;
		}
		return true;
	}
}
