package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractAsyncService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;

/**
 * 合同水印的异步服务
 */
@Controller
@RequestMapping("contractAsync")
public class ContractAsyncController implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IContractAsyncService contractAsyncService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeService changeService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 获取合同水印文件
     * @param
     * @return
     */
    @RequestMapping(value = "/getWatermarkAttachment", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> getWatermarkAttachment(Long id, String contractType){
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));

            if ("contract".equals(contractType)){//合同
                ContractEntity contractEntity = contractService.selectById(id);
                if (null == contractEntity){
                    throw new BusinessException("获取合同信息失败，请检查合同id是否正确！");
                }
                // 转换水印参数配置：默认规则
                WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(),
                        contractEntity.getBillCode(), contractEntity.getContractType().equals(0) ? ProsubBillTypeEnum.劳务分包合同.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同.getBillTypeCode(), "proSubContract");
                Assert.notNull(watermarkVO, "获取水印系统参数失败!");
                contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO, "contract");
            }else if ("changeContract".equals(contractType)){//变更
                ChangeEntity changeEntity = changeService.selectById(id);
                if (null == changeEntity){
                    throw new BusinessException("获取变更合同信息失败，请检查变更合同id是否正确！");
                }
                // 转换水印参数配置：默认规则
                WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(),
                        changeEntity.getBillCode(), changeEntity.getContractType().equals(0) ? ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode(), "proSubChangeContract");
                Assert.notNull(watermarkVO, "获取水印系统参数失败!");
                contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO, "changeContract");
            }
        }
        return CommonResponse.success("获取合同水印文件成功！");
    }
}
