/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ChangeStatusEnum;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.vo.ChangeVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"change"})
public class ChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IChangeService service;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamCheckApi paramCheckApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ChangeVO> saveOrUpdate(@RequestBody ChangeVO saveorUpdateVO) {
        ChangeVO vo = this.service.insertOrUpdate(saveorUpdateVO, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetail(Long id) {
        ChangeVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ExecutionVO executionVO;
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ArrayList<Object> contractEntityList = new ArrayList<Object>();
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BASE_HOST;
            for (ChangeVO ChangeVO2 : vos) {
                ChangeEntity changeEntity = (ChangeEntity)((Object)this.service.selectById(ChangeVO2.getId()));
                executionVO = this.service.targetCost((ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class), "", changeEntity.getContractType(), changeEntity.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode(), false);
                totalExecutionVOList.add(executionVO.getTotalVO());
                contractEntityList.add(this.contractService.selectById(changeEntity.getContractId()));
            }
            this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u5220\u9664\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)response));
            if (!response.isSuccess()) {
                // empty if block
            }
            for (ContractEntity contractEntity : contractEntityList) {
                String linkUrl;
                executionVO = null;
                List changeEntities = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)contractEntity.getId())).orderByDesc((Object)"change_version"));
                if (changeEntities.size() > 1) {
                    if (contractEntity.getContractType() == 0) {
                        if (contractEntity.getAddType() == 0) {
                            linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/laborSubList/changeCard?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=laborSubCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                            executionVO = this.service.targetCost((ChangeVO)BeanMapper.map(changeEntities.get(1), ChangeVO.class), linkUrl, ((ChangeEntity)((Object)changeEntities.get(1))).getContractType(), ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode(), false);
                        } else {
                            linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/laborSubList/changeCard?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=laborSubDirectCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                            executionVO = this.service.targetCost((ChangeVO)BeanMapper.map(changeEntities.get(1), ChangeVO.class), linkUrl, ((ChangeEntity)((Object)changeEntities.get(1))).getContractType(), ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode(), false);
                        }
                    } else if (contractEntity.getAddType() == 0) {
                        linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/proSubList/changeCard?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=proSubCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                        executionVO = this.service.targetCost((ChangeVO)BeanMapper.map(changeEntities.get(1), ChangeVO.class), linkUrl, ((ChangeEntity)((Object)changeEntities.get(1))).getContractType(), ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode(), false);
                    } else {
                        linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/proSubList/changeCard?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=proSubDirectCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                        executionVO = this.service.targetCost((ChangeVO)BeanMapper.map(changeEntities.get(1), ChangeVO.class), linkUrl, ((ChangeEntity)((Object)changeEntities.get(1))).getContractType(), ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode(), false);
                    }
                } else if (contractEntity.getContractType() == 0) {
                    if (contractEntity.getAddType() == 0) {
                        linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/laborSubList/card?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=laborSubCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                        executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), linkUrl, contractEntity.getContractType(), ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode());
                    } else {
                        linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/laborSubList/card?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=laborSubDirectCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                        executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), linkUrl, contractEntity.getContractType(), ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode());
                    }
                } else if (contractEntity.getAddType() == 0) {
                    linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/proSubList/card?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=proSubCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                    executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), linkUrl, contractEntity.getContractType(), ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode());
                } else {
                    linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/proSubList/card?id=" + contractEntity.getId() + "&supplementFlag=" + contractEntity.getSupplementFlag() + "&routeType=1&cardType=proSubDirectCard&performanceStatus=" + contractEntity.getPerformanceStatus();
                    executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), linkUrl, contractEntity.getContractType(), ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode());
                }
                this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u65e7\u7248\u672c\u6570\u636e: {}", (Object)JSON.toJSONString((Object)executionVO));
                CommonResponse responses = this.executionApi.aggPush(executionVO);
                this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u65e7\u7248\u672c\u6570\u636e: {}", (Object)JSON.toJSONString((Object)responses));
                if (response.isSuccess()) continue;
            }
        }
        return this.service.deleteById(vos.get(0).getId());
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetailRecord(Long id) {
        ChangeVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> addConvertByConId(Long contractId, Long changeId) {
        ChangeVO vo = this.service.addConvertByConId(contractId, changeId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryChangeCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map<String, Object> returnMap = this.service.queryChangeCompare(id);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", returnMap);
    }

    @RequestMapping(value={"/queryChangeRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryChangeRecord(Long contractId, Long changeId) {
        ChangeVO vo = this.service.queryChangeRecord(contractId, changeId);
        return CommonResponse.success((String)"\u53d8\u66f4\u8bb0\u5f55\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/changeSignatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeSignatureProcess(Long id) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.service.selectById(id));
        if (changeEntity != null) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
            changeEntity.setEffectiveDate(new Date());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().toString());
            changeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            this.service.saveOrUpdate((Object)changeEntity);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
            updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ChangeVO changeVO) {
        ChangeVO cv = this.service.insertOrUpdate(changeVO, true);
        String linkUrl = this.service.getLinkUrl(cv);
        ParamsCheckVO responseData = this.paramCheck(changeVO, null, false);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        ChangeEntity entity = (ChangeEntity)((Object)this.service.selectById(id));
        ChangeVO cv = (ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class);
        ParamsCheckVO responseData = this.paramCheck(cv, null, true);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    private ParamsCheckVO paramCheck(@RequestBody ChangeVO changeVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
        ParamsCheckVO resp = new ParamsCheckVO();
        ArrayList<Object> allCheck = new ArrayList<Object>();
        allCheck.addAll(this.service.changeMnyCtrl(changeVO));
        allCheck.addAll(this.service.planNumCtrlContractNum(changeVO));
        allCheck.addAll(this.service.planMnyCtrlContractMny(changeVO));
        allCheck.addAll(this.service.historyPriceCtrlContractPrice(changeVO));
        this.logger.info("\u53d8\u66f4\u5408\u540c \u76ee\u6807\u6210\u672c\u4ef7\u63a7 \u5408\u540c\u4ef7 start");
        allCheck.addAll(this.service.targetCostPriceCtrlContractPrice(changeVO));
        this.logger.info("\u53d8\u66f4\u5408\u540c \u76ee\u6807\u6210\u672c\u4ef7\u63a7 \u5408\u540c\u4ef7 end");
        CommonResponse ctrlOutConMnyRes = this.paramCheckApi.paramsCheck(changeVO.getProjectId(), changeVO.getMainContractId(), changeVO.getContractTaxMny(), changeVO.getOrgId());
        if (ctrlOutConMnyRes.isSuccess() && ctrlOutConMnyRes.getData() != null) {
            allCheck.addAll((Collection)ctrlOutConMnyRes.getData());
        }
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }
        return resp;
    }
}

