package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanContrastV0;
import com.ejianc.business.plan.vo.PlanDetailRefVO;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包总计划实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("plan")
public class PlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    /**
     * 劳务总计划编码
     */
    private static final String LABSUB_BILL_CODE = "PLAN_CODE";
    /**
     * 专业总计划编码
     */
    private static final String PROSUB_BILL_CODE = "PRO_SUB_PLAN_CODE";


    @Autowired
    private IPlanService service;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private SessionManager sessionManager;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IPlanChangeService planChangeService;

    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BASE_HOST;
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO planVO) {
        return getPlanVOCommonResponse(planVO, false);
    }

    private CommonResponse<PlanVO> getPlanVOCommonResponse(PlanVO planVO, Boolean isControl) {
        if(StringUtils.isNotBlank(planVO.getBillCode())) {
            //编码重复校验
            PlanVO voByCode = service.queryByCode(planVO.getBillCode());
            if(null != voByCode && (null == planVO.getId() || !voByCode.getId().equals(planVO.getId()))) {
                return CommonResponse.error("保存失败，编码重复！");
            }
        } else {
            CommonResponse<String> codeResp = billCodeApi.generateBillCode(BillCodeParam.build(PlanVO.PLAN_TYPE_LABOR_SUB.equals(planVO.getSubType()) ? LABSUB_BILL_CODE : PROSUB_BILL_CODE, InvocationInfoProxy.getTenantid(), planVO));
            if(!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            planVO.setBillCode(codeResp.getData());
        }

        //校验项目是否已有总计划
        PlanVO voByProject = service.queryByProjectId(planVO.getProjectId(), planVO.getSubType());
        if(null != voByProject && (voByProject.getSubType().equals(planVO.getSubType())) && (null == planVO.getId() || !voByProject.getId().equals(planVO.getId()))) {
            return CommonResponse.error("保存失败，该项目下已存在分包总计划，请勿重复添加！");
        }

        UserContext userContext = sessionManager.getUserContext();
        PlanEntity saveEntity = null;
        if(null == planVO.getId()) {
            saveEntity = BeanMapper.map(planVO, PlanEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为未变更
            saveEntity.setChangeState(0);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(1);
            //设置编制人
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = service.getById(planVO.getId());
            saveEntity.setProjectId(planVO.getProjectId());
            saveEntity.setProjectName(planVO.getProjectName());
            saveEntity.setMemo(planVO.getMemo());
            saveEntity.setBillCode(planVO.getBillCode());
            saveEntity.setTotalPlanTaxMny(planVO.getTotalPlanTaxMny());
            saveEntity.setTotalPlanMny(planVO.getTotalPlanMny());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setEmployeeId(planVO.getEmployeeId());
            saveEntity.setEmployeeName(planVO.getEmployeeName());
            saveEntity.setDepartmentId(planVO.getDepartmentId());
            saveEntity.setDepartmentName(planVO.getDepartmentName());

            saveEntity.setPlanDetailList(BeanMapper.mapList(planVO.getPlanDetailList(), PlanDetailEntity.class));
        }

        if(null == saveEntity.getTotalPlanTaxMny()) {
            saveEntity.setTotalPlanTaxMny(BigDecimal.ZERO.setScale(8));
        }
        if(null == saveEntity.getTotalPlanMny()) {
            saveEntity.setTotalPlanMny(BigDecimal.ZERO.setScale(8));
        }
        List<PlanDetailEntity> beforeDetails = saveEntity.getPlanDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails)){
            Map<String, Long> idMap = new HashMap<>();
            for(PlanDetailEntity detail : beforeDetails){
                if (!("del").equals(detail.getRowState())){
                    if(null == saveEntity.getId() || null == detail.getId()) {
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
                if(null == detail.getPlanId()) {
                    detail.setPlanId(saveEntity.getId());
                }
            }
            for (PlanDetailEntity detail : beforeDetails) {
                if (!("del").equals(detail.getRowState())){
                    if (StringUtils.isNotEmpty(detail.getTpid())) {
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                    detail.setChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }

        PlanVO masterPlanVO = service.saveOrUpdateMasterPlan(saveEntity, isControl);

        if (Boolean.FALSE.equals(isControl)) {
            PlanVO pv = service.queryDetail(saveEntity.getId(), false);
            PlanEntity entity = BeanMapper.map(pv, PlanEntity.class);
            //目标成本推送
            String linkUrl;
            if (entity.getSubType()==0){
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/card?id="+entity.getId();
            }else {
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/card?id="+entity.getId();
            }
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, PlanVO.class),linkUrl,entity.getSubType());
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
//                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        }

        return CommonResponse.success("保存成功！", masterPlanVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanVO vo = new PlanVO();
        vo = service.queryDetail(id,true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)) {
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (PlanVO planVO : vos){
                PlanEntity planEntity = service.selectById(planVO.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(planEntity, PlanVO.class),"",planEntity.getSubType());
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
//                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
            List<Long> ids = vos.stream().map(PlanVO::getId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(ids)) {
                service.removeByIds(ids);
            }
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<PlanEntity> page = service.queryPage(param,false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @GetMapping(value = "/projectPlanCheck")
    @ResponseBody
    public CommonResponse<String> projectPlanCheck(@RequestParam(value = "projectId") Long projectId,
                                                   @RequestParam(value = "billId", required = false) Long billId,
                                                   @RequestParam(value = "subType") Integer subType) {
        QueryWrapper<PlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("sub_type", subType);

        PlanEntity entityByProject = service.getOne(query);
        if(null != entityByProject && (entityByProject.getSubType().equals(subType)) && (null == billId || !entityByProject.getId().equals(billId))) {
            return CommonResponse.error("该项目下已存在分包总计划！");
        }
        return CommonResponse.success("该项目适用当前总计划！");
    }


    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanDetailRefVO>> refPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        IPage<PlanDetailRefVO> resp = new Page<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("detail_name");

        //按照物资Id正序排列
        queryParam.getOrderMap().put("id", QueryParam.ASC);
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        if(StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }

        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if(null == conditionMap.get("projectId")) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        List<Integer> approvedBillState = new ArrayList<>();
        QueryWrapper<PlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", conditionMap.get("projectId"));
        //查询审批通过
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in("bill_state", approvedBillState);
        PlanEntity entity = service.getOne(queryWrapper);
        if(null == entity) {
            resp.setTotal(0L);
            resp.setSize(pageSize);
            resp.setCurrent(pageNumber);
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
        } else {
            queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, entity.getId()));

            IPage<PlanDetailEntity> pageData = planDetailService.queryPage(queryParam, false);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());

            List<PlanDetailRefVO> dataList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
                dataList = BeanMapper.mapList(pageData.getRecords(), PlanDetailRefVO.class);
            }

            resp.setRecords(dataList);
        }

        return CommonResponse.success("查询参照数据成功！",resp);
     }


    /**
     * @Description 总计划明细树形参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPlanTreeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PlanDetailVO>> refPlanTreeData(String condition,String searchObject,String searchText) {
        List<PlanDetailVO> resList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("detail_code");
        queryParam.getFuzzyFields().add("detail_name");
        queryParam.getFuzzyFields().add("work_content");
        queryParam.getFuzzyFields().add("detail_measurement_rules");
        queryParam.getFuzzyFields().add("unit");
        queryParam.setSearchText(searchText);
        //按照物资Id正序排列
        queryParam.getOrderMap().put("id", QueryParam.ASC);
        if(StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if(null == conditionMap.get("projectId")) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        if(null == conditionMap.get("subType")) {
            return CommonResponse.error("查询失败，参数condition中缺少项subType！");
        }
        List<Integer> approvedBillState = new ArrayList<>();
        QueryWrapper<PlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", conditionMap.get("projectId"));
        queryWrapper.eq("sub_type", conditionMap.get("subType"));
        //查询审批通过
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in("bill_state", approvedBillState);
        PlanEntity planEntity = service.getOne(queryWrapper);
        if(null != planEntity) {
            queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, planEntity.getId()));
            queryParam.getOrderMap().put("treeIndex", "asc");

            List<PlanDetailEntity> detailEntityListDb = planDetailService.queryList(queryParam, false);
            List<PlanDetailEntity> detailEntityList = new ArrayList<>();
            Map<String, String> innerCodes = new HashMap<>();
            List<Long> detailSourceIds = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
                detailEntityListDb.forEach(entity ->{
                    if(null == entity.getChangeType() || !ChangeTypeEnum.中止.getCode().equals(entity.getChangeType())){
                        if(StringUtils.isNotBlank(entity.getDocInnerCode())) {
                            int idx = entity.getDocInnerCode().indexOf("\\|");
                            idx = idx >= 0 ? idx : entity.getDocInnerCode().length();
                            if(!innerCodes.containsKey(entity.getDocInnerCode(). substring(0, idx))) {
                                if (null != entity.getDocCategoryId()) { //档案，需从下往上查
                                    detailSourceIds.addAll(Arrays.stream(entity.getDocInnerCode().split("\\|")).map(item -> Long.valueOf(item)).collect(Collectors.toList()));
                                } else { //分类，从上往下查
                                    innerCodes.put(entity.getDocInnerCode().substring(0, idx), entity.getDocInnerCode());
                                }
                            }
                        } else {
                            detailSourceIds.add(entity.getSourceId());
                        }
                    }
                });
            }


            if(CollectionUtils.isNotEmpty(detailSourceIds) || CollectionUtils.isNotEmpty(innerCodes.values())) {
                QueryWrapper<PlanDetailEntity> query = new QueryWrapper<>();
                detailEntityList = planDetailService.getListBySourceIdsAndInnerCode(planEntity.getId(), detailSourceIds, innerCodes.values().stream().collect(Collectors.toList()));
            }

            if(CollectionUtils.isNotEmpty(detailEntityList)) {
                for(PlanDetailEntity cdEntity : detailEntityList){
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                }
                List<PlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailVO.class);
                resList = TreeNodeBUtil.buildTree(resultMapList);
            }
        }

        return CommonResponse.success("查询参照数据成功！",resList);
    }

    @GetMapping(value = "/getContrastInfo")
    @ResponseBody
    public CommonResponse<List<PlanContrastV0>> getContrastInfo(@RequestParam(value = "planId") Long planId,
                                                                @RequestParam(value = "oldPlanId") Long oldPlanId) {

        List<PlanContrastV0> list= service.getContrastInfo(planId,oldPlanId);

        return CommonResponse.success("获取对比数据成功！",list);
    }

    /**
     * @Description 导出
     *
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(-1);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<PlanEntity> page = service.queryPage(param,false);
        List<PlanVO> plans = new ArrayList<>();

        page.getRecords().stream().forEach(c -> {
            PlanVO p = BeanMapper.map(c, PlanVO.class);
            p.setChangeStateName(PlanVO.PLAN_CHANGE_STATE_UNCHANGED.equals(p.getChangeState()) ? "未变更" : PlanVO.PLAN_CHANGE_STATE_CHANGING.equals(p.getChangeState()) ? "变更中" : "已变更");
            //流程状态
            p.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            plans.add(p);
        });
        beans.put("records", plans);
        ExcelExport.getInstance().export("contractPlan-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody PlanVO planVO) {
        CommonResponse<PlanVO> planVOCommonResponse = this.getPlanVOCommonResponse(planVO, true);
        if(!planVOCommonResponse.isSuccess()) {
            return CommonResponse.error(planVOCommonResponse.getMsg());
        }
        PlanVO pv = planVOCommonResponse.getData();
        String linkUrl;
        if (pv.getSubType()==0){
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/card?id="+pv.getId();
        }else {
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/card?id="+pv.getId();
        }
        //目标成本推送
        ExecutionVO executionVO = service.targetCost(pv, linkUrl, pv.getSubType());
        logger.error("目标成本推送控制：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if(!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        return CommonResponse.success("参数校验成功！", response.getData());
    }

    @PostMapping(value = "/pushTargetCost")
    @ResponseBody
    public CommonResponse<String> pushTargetCost(@RequestBody Long id) {
        //推送最新总计划变更单到目标成本
        ExecutionVO executionVO = planChangeService.getLastExecutionVO(id);
        //目标成本推送
        logger.info("手动：分包总计划目标成本推送数据： {}", JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("手动：分包总计划目标成本推送数据结果： {}", JSON.toJSONString(response));
        return response;
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        PlanVO pv = service.queryDetail(id, false);
        String linkUrl;
        if (pv.getSubType()==0){
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/labSubPlan/card?id="+pv.getId();
        }else {
            linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubPlan/card?id="+pv.getId();
        }
        //目标成本推送
        ExecutionVO executionVO = service.targetCost(pv, linkUrl, pv.getSubType());
        logger.error("目标成本推送控制：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if(!response.isSuccess()) {
            return response;
        }
        return CommonResponse.success("参数校验成功！", response.getData());
    }

}
