package com.ejianc.business.process.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 工人工资单明细表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_salary_detail")
public class SalaryDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="salary_id")
    private Long salaryId; // 工人工资单主表id
    @TableField(value="worker_name")
    private String workerName; // 工人
    @TableField(value="work_type")
    private String workType; // 工种
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="bank_card")
    private String bankCard; // 银行卡号
    @TableField(value="bank_name")
    private String bankName; // 开户行
    @TableField(value="measurement_type")
    private Integer measurementType; // 计量方式 （0:计日，1计件）
    @TableField(value="workload")
    private BigDecimal workload; // 工作量
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="overtime_measure_type")
    private Integer overtimeMeasureType; // 加班计量方式
    @TableField(value="overtime_num")
    private BigDecimal overtimeNum; // 加班工作量
    @TableField(value="should_salary_mny")
    private BigDecimal shouldSalaryMny; // 应发工资:工作量*单价+加班工作量*单价
    @TableField(value="deduct_mny")
    private BigDecimal deductMny; // 扣款费用
    @TableField(value="salary_mny")
    private BigDecimal salaryMny; // 实发工资
    @TableField(value="group_name")
    private String groupName; // 班组名称
    @TableField(value="memo")
    private String memo; // 备注
    
    
    

    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public String getWorkType() {
        return workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getBankCard() {
        return bankCard;
    }

    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public Integer getMeasurementType() {
        return measurementType;
    }

    public void setMeasurementType(Integer measurementType) {
        this.measurementType = measurementType;
    }
    public BigDecimal getWorkload() {
        return workload;
    }

    public void setWorkload(BigDecimal workload) {
        this.workload = workload;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public Integer getOvertimeMeasureType() {
        return overtimeMeasureType;
    }

    public void setOvertimeMeasureType(Integer overtimeMeasureType) {
        this.overtimeMeasureType = overtimeMeasureType;
    }
    public BigDecimal getOvertimeNum() {
        return overtimeNum;
    }

    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }

    public void setOvertimeNum(BigDecimal overtimeNum) {
        this.overtimeNum = overtimeNum;
    }

    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }

    public BigDecimal getSalaryMny() {
        return salaryMny;
    }

    public void setSalaryMny(BigDecimal salaryMny) {
        this.salaryMny = salaryMny;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
