package com.ejianc.business.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.PicKingTotalEntity;
import com.ejianc.business.process.mapper.PicKingTotalMapper;
import com.ejianc.business.process.service.IPicKingTotalService;
import com.ejianc.business.process.vo.PicKingTotalVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 领料汇总
 *
 * @author generator
 */
@Service("picKingTotalService")
public class PicKingTotalServiceImpl extends BaseServiceImpl<PicKingTotalMapper, PicKingTotalEntity> implements IPicKingTotalService {

    @Autowired
    private PicKingTotalMapper mapper;

    @Override
    public List<PicKingTotalVO> totalSumList(Long contractId, Long projectId) {
        return mapper.totalSumList(contractId, projectId);
    }

    @Override
    public void deleteByPickingId(Long id) {
        UpdateWrapper<PicKingTotalEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("picking_id", id);
        super.remove(updateWrapper);
    }


}
