/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanContrastV0;
import com.ejianc.business.plan.vo.PlanDetailRefVO;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"plan"})
public class PlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String LABSUB_BILL_CODE = "PLAN_CODE";
    private static final String PROSUB_BILL_CODE = "PRO_SUB_PLAN_CODE";
    @Autowired
    private IPlanService service;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IPlanChangeService planChangeService;

    private String getBaseHost() {
        return StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BASE_HOST;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO planVO) {
        return this.getPlanVOCommonResponse(planVO, false);
    }

    private CommonResponse<PlanVO> getPlanVOCommonResponse(PlanVO planVO, Boolean isControl) {
        List<PlanDetailEntity> beforeDetails;
        if (StringUtils.isNotBlank((CharSequence)planVO.getBillCode())) {
            PlanVO voByCode = this.service.queryByCode(planVO.getBillCode());
            if (!(null == voByCode || null != planVO.getId() && voByCode.getId().equals(planVO.getId()))) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            CommonResponse codeResp = this.billCodeApi.generateBillCode(BillCodeParam.build((String)(PlanVO.PLAN_TYPE_LABOR_SUB.equals(planVO.getSubType()) ? LABSUB_BILL_CODE : PROSUB_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)planVO));
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            planVO.setBillCode((String)codeResp.getData());
        }
        PlanVO voByProject = this.service.queryByProjectId(planVO.getProjectId(), planVO.getSubType());
        if (null != voByProject && voByProject.getSubType().equals(planVO.getSubType()) && (null == planVO.getId() || !voByProject.getId().equals(planVO.getId()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u5206\u5305\u603b\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        PlanEntity saveEntity = null;
        if (null == planVO.getId()) {
            saveEntity = (PlanEntity)((Object)BeanMapper.map((Object)planVO, PlanEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setChangeState(0);
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(1);
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (PlanEntity)((Object)this.service.getById(planVO.getId()));
            saveEntity.setProjectId(planVO.getProjectId());
            saveEntity.setProjectName(planVO.getProjectName());
            saveEntity.setMemo(planVO.getMemo());
            saveEntity.setBillCode(planVO.getBillCode());
            saveEntity.setTotalPlanTaxMny(planVO.getTotalPlanTaxMny());
            saveEntity.setTotalPlanMny(planVO.getTotalPlanMny());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setEmployeeId(planVO.getEmployeeId());
            saveEntity.setEmployeeName(planVO.getEmployeeName());
            saveEntity.setDepartmentId(planVO.getDepartmentId());
            saveEntity.setDepartmentName(planVO.getDepartmentName());
            saveEntity.setPlanDetailList(BeanMapper.mapList((Iterable)planVO.getPlanDetailList(), PlanDetailEntity.class));
        }
        if (null == saveEntity.getTotalPlanTaxMny()) {
            saveEntity.setTotalPlanTaxMny(BigDecimal.ZERO.setScale(8));
        }
        if (null == saveEntity.getTotalPlanMny()) {
            saveEntity.setTotalPlanMny(BigDecimal.ZERO.setScale(8));
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = saveEntity.getPlanDetailList())) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PlanDetailEntity detail : beforeDetails) {
                if (!"del".equals(detail.getRowState())) {
                    if (null == saveEntity.getId() || null == detail.getId()) {
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
                if (null != detail.getPlanId()) continue;
                detail.setPlanId(saveEntity.getId());
            }
            for (PlanDetailEntity detail : beforeDetails) {
                if ("del".equals(detail.getRowState())) continue;
                if (StringUtils.isNotEmpty((CharSequence)detail.getTpid())) {
                    detail.setParentId((Long)idMap.get(detail.getTpid()));
                }
                detail.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        PlanVO masterPlanVO = this.service.saveOrUpdateMasterPlan(saveEntity, isControl);
        if (Boolean.FALSE.equals(isControl)) {
            PlanVO pv = this.service.queryDetail(saveEntity.getId(), false);
            PlanEntity entity = (PlanEntity)((Object)BeanMapper.map((Object)pv, PlanEntity.class));
            String linkUrl = entity.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/card?id=" + entity.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/card?id=" + entity.getId();
            ExecutionVO executionVO = this.service.targetCost((PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class), linkUrl, entity.getSubType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                // empty if block
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)masterPlanVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanVO vo = new PlanVO();
        vo = this.service.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List ids;
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (PlanVO planVO : vos) {
                PlanEntity planEntity = (PlanEntity)((Object)this.service.selectById(planVO.getId()));
                ExecutionVO executionVO = this.service.targetCost((PlanVO)BeanMapper.map((Object)((Object)planEntity), PlanVO.class), "", planEntity.getSubType());
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                // empty if block
            }
            if (CollectionUtils.isNotEmpty(ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList()))) {
                this.service.removeByIds(ids);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"/projectPlanCheck"})
    @ResponseBody
    public CommonResponse<String> projectPlanCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId, @RequestParam(value="subType") Integer subType) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"sub_type", (Object)subType);
        PlanEntity entityByProject = (PlanEntity)((Object)this.service.getOne((Wrapper)query));
        if (null != entityByProject && entityByProject.getSubType().equals(subType) && (null == billId || !entityByProject.getId().equals(billId))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u5206\u5305\u603b\u8ba1\u5212\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u9002\u7528\u5f53\u524d\u603b\u8ba1\u5212\uff01");
    }

    @RequestMapping(value={"/refPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlanDetailRefVO>> refPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Page resp = new Page();
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("detail_name");
        queryParam.getOrderMap().put("id", "asc");
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", conditionMap.get("projectId"));
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in((Object)"bill_state", approvedBillState);
        PlanEntity entity = (PlanEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (null == entity) {
            resp.setTotal(0L);
            resp.setSize((long)pageSize.intValue());
            resp.setCurrent((long)pageNumber.intValue());
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
        } else {
            queryParam.getParams().put("planId", new Parameter("eq", (Object)entity.getId()));
            IPage pageData = this.planDetailService.queryPage(queryParam, false);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());
            List dataList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
                dataList = BeanMapper.mapList((Iterable)pageData.getRecords(), PlanDetailRefVO.class);
            }
            resp.setRecords(dataList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/refPlanTreeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PlanDetailVO>> refPlanTreeData(String condition, String searchObject, String searchText) {
        List resList = new ArrayList();
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("detail_code");
        queryParam.getFuzzyFields().add("detail_name");
        queryParam.getFuzzyFields().add("work_content");
        queryParam.getFuzzyFields().add("detail_measurement_rules");
        queryParam.getFuzzyFields().add("unit");
        queryParam.setSearchText(searchText);
        queryParam.getOrderMap().put("id", "asc");
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        if (null == conditionMap.get("subType")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879subType\uff01");
        }
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", conditionMap.get("projectId"));
        queryWrapper.eq((Object)"sub_type", conditionMap.get("subType"));
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in((Object)"bill_state", approvedBillState);
        PlanEntity planEntity = (PlanEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (null != planEntity) {
            queryParam.getParams().put("planId", new Parameter("eq", (Object)planEntity.getId()));
            queryParam.getOrderMap().put("treeIndex", "asc");
            List detailEntityListDb = this.planDetailService.queryList(queryParam, false);
            List<Object> detailEntityList = new ArrayList();
            HashMap innerCodes = new HashMap();
            ArrayList<Long> detailSourceIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
                detailEntityListDb.forEach(entity -> {
                    if (null == entity.getChangeType() || !ChangeTypeEnum.\u4e2d\u6b62.getCode().equals(entity.getChangeType())) {
                        if (StringUtils.isNotBlank((CharSequence)entity.getDocInnerCode())) {
                            int idx = entity.getDocInnerCode().indexOf("\\|");
                            int n = idx = idx >= 0 ? idx : entity.getDocInnerCode().length();
                            if (!innerCodes.containsKey(entity.getDocInnerCode().substring(0, idx))) {
                                if (null != entity.getDocCategoryId()) {
                                    detailSourceIds.addAll(Arrays.stream(entity.getDocInnerCode().split("\\|")).map(item -> Long.valueOf(item)).collect(Collectors.toList()));
                                } else {
                                    innerCodes.put(entity.getDocInnerCode().substring(0, idx), entity.getDocInnerCode());
                                }
                            }
                        } else {
                            detailSourceIds.add(entity.getSourceId());
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(detailSourceIds) || CollectionUtils.isNotEmpty(innerCodes.values())) {
                QueryWrapper query = new QueryWrapper();
                detailEntityList = this.planDetailService.getListBySourceIdsAndInnerCode(planEntity.getId(), detailSourceIds, innerCodes.values().stream().collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                for (PlanDetailEntity cdEntity : detailEntityList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                }
                List resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailVO.class);
                resList = TreeNodeBUtil.buildTree((List)resultMapList);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @GetMapping(value={"/getContrastInfo"})
    @ResponseBody
    public CommonResponse<List<PlanContrastV0>> getContrastInfo(@RequestParam(value="planId") Long planId, @RequestParam(value="oldPlanId") Long oldPlanId) {
        List<PlanContrastV0> list = this.service.getContrastInfo(planId, oldPlanId);
        return CommonResponse.success((String)"\u83b7\u53d6\u5bf9\u6bd4\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        ArrayList plans = new ArrayList();
        page.getRecords().stream().forEach(c -> {
            PlanVO p;
            p.setChangeStateName(PlanVO.PLAN_CHANGE_STATE_UNCHANGED.equals((p = (PlanVO)BeanMapper.map((Object)c, PlanVO.class)).getChangeState()) ? "\u672a\u53d8\u66f4" : (PlanVO.PLAN_CHANGE_STATE_CHANGING.equals(p.getChangeState()) ? "\u53d8\u66f4\u4e2d" : "\u5df2\u53d8\u66f4"));
            p.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            plans.add(p);
        });
        beans.put("records", plans);
        ExcelExport.getInstance().export("contractPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody PlanVO planVO) {
        CommonResponse<PlanVO> planVOCommonResponse = this.getPlanVOCommonResponse(planVO, true);
        if (!planVOCommonResponse.isSuccess()) {
            return CommonResponse.error((String)planVOCommonResponse.getMsg());
        }
        PlanVO pv = (PlanVO)planVOCommonResponse.getData();
        String linkUrl = pv.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/card?id=" + pv.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/card?id=" + pv.getId();
        ExecutionVO executionVO = this.service.targetCost(pv, linkUrl, pv.getSubType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)response.getData());
    }

    @PostMapping(value={"/pushTargetCost"})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(@RequestBody Long id) {
        ExecutionVO executionVO = this.planChangeService.getLastExecutionVO(id);
        this.logger.info("\u624b\u52a8\uff1a\u5206\u5305\u603b\u8ba1\u5212\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a {}", (Object)JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        this.logger.info("\u624b\u52a8\uff1a\u5206\u5305\u603b\u8ba1\u5212\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\u7ed3\u679c\uff1a {}", (Object)JSON.toJSONString((Object)response));
        return response;
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        PlanVO pv = this.service.queryDetail(id, false);
        String linkUrl = pv.getSubType() == 0 ? this.getBaseHost() + "ejc-prosub-frontend/#/labSubPlan/card?id=" + pv.getId() : this.getBaseHost() + "ejc-prosub-frontend/#/proSubPlan/card?id=" + pv.getId();
        ExecutionVO executionVO = this.service.targetCost(pv, linkUrl, pv.getSubType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            return response;
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)response.getData());
    }
}

