/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IDeductionService;
import com.ejianc.business.process.service.IMeasureService;
import com.ejianc.business.process.service.IPickingService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.IFinishSettleService;
import com.ejianc.business.settle.service.ISettleDeductService;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOddjobService;
import com.ejianc.business.settle.service.ISettlePickingService;
import com.ejianc.business.settle.service.ISettleSalaryService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDeductVO;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleOddjobVO;
import com.ejianc.business.settle.vo.SettlePickingVO;
import com.ejianc.business.settle.vo.SettleSalaryVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="FinishSettleService")
public class FinishSettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements IFinishSettleService {
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private IMeasureService measureService;
    @Autowired
    private IPickingService pickingService;
    @Autowired
    private IRegistrationService oddjobService;
    @Autowired
    private IDeductionService deductService;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private ISettleOddjobService settleOddjobService;
    @Autowired
    private ISettleDeductService settleDeductService;
    @Autowired
    private ISettlePickingService settlePickingService;
    @Autowired
    private ISettleSalaryService settleSalaryService;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContractDetailMapper contractDetailMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IExecutionApi executionApi;
    private static final String BILL_CODE = "SUB_SETTLE_NEW";
    private static final String PRO_SUB_BILL_CODE = "PRO_FINISH_SETTLE";
    private static final String LAB_FINISH_NUM_CHECK_PARAM_CODE = "P-T8i61981";
    private static final String PRO_FINISH_NUM_CHECK_PARAM_NAME = "P-7qkB6680";
    private static final String LAB_CHECK_PARAM_CODE = "P-FWAwT442";
    private static final String PRO_CHECK_PARAM_NAME = "P-LkI10x45";

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        Date resultDate;
        SettleVO settleVO = new SettleVO();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)contractId);
        lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)contractId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = super.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((SettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode(((SettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002"));
        }
        if (null != settleType && SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            queryParam.getParams().put("bill_state", new Parameter("eq", (Object)BillStateEnum.APPROVING_HAS_STATE));
            List measureEntityList = this.measureService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)measureEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u5206\u5305\u8ba1\u91cf\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
            List picKingEntityList = this.pickingService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)picKingEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u9886\u6599\u7ed3\u7b97\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
            List registrationEntityList = this.oddjobService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)registrationEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u96f6\u5de5\u767b\u8bb0\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
            List deductionEntityList = this.deductService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)deductionEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u5956\u7f5a\u6263\u6b3e\u5355\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
        }
        if (null == (resultDate = this.settleService.queryMaxSettleDate(contractId))) {
            resultDate = null != settleDate ? settleDate : new Date();
            settleVO.setMinSettleDate(null);
        } else {
            resultDate = DateUtils.addDays((Date)resultDate, (int)1);
            settleVO.setMinSettleDate(resultDate);
            if (null != settleDate && settleDate.compareTo(resultDate) > 0) {
                resultDate = settleDate;
            }
        }
        settleVO.setSettleDate(resultDate);
        SettleVO processPickingVO = this.settleService.selectPickingProcessTaxMny(contractId);
        SettleVO processOddjobVO = this.settleService.selectOddjobProcessTaxMny(contractId);
        SettleVO processOtherVO = this.settleService.selectOtherProcessTaxMny(contractId);
        if (null != processPickingVO) {
            settleVO.setPickingProcessTaxMny(null != processPickingVO.getPickingProcessTaxMny() ? processPickingVO.getPickingProcessTaxMny() : BigDecimal.ZERO);
            settleVO.setPickingProcessMny(null != processPickingVO.getPickingProcessMny() ? processPickingVO.getPickingProcessMny() : BigDecimal.ZERO);
        } else {
            settleVO.setPickingProcessTaxMny(BigDecimal.ZERO);
            settleVO.setPickingProcessMny(BigDecimal.ZERO);
        }
        if (null != processOddjobVO) {
            settleVO.setOddjobProcessTaxMny(null != processOddjobVO.getOddjobProcessTaxMny() ? processOddjobVO.getOddjobProcessTaxMny() : BigDecimal.ZERO);
            settleVO.setOddjobProcessMny(null != processOddjobVO.getOddjobProcessMny() ? processOddjobVO.getOddjobProcessMny() : BigDecimal.ZERO);
        } else {
            settleVO.setOddjobProcessTaxMny(BigDecimal.ZERO);
            settleVO.setOddjobProcessMny(BigDecimal.ZERO);
        }
        if (null != processOtherVO) {
            settleVO.setOtherProcessTaxMny(null != processOtherVO.getOtherProcessTaxMny() ? processOtherVO.getOtherProcessTaxMny() : BigDecimal.ZERO);
            settleVO.setOtherProcessMny(null != processOtherVO.getOtherProcessMny() ? processOtherVO.getOtherProcessMny() : BigDecimal.ZERO);
        } else {
            settleVO.setOtherProcessTaxMny(BigDecimal.ZERO);
            settleVO.setOtherProcessMny(BigDecimal.ZERO);
        }
        List<SettleDetailVO> settleDetailList = this.settleDetailService.selectDetailRecordAndTotalProcessNum(contractId);
        List<SettleDetailVO> settleDetailNodeNumList = this.settleDetailService.selectDetailTotalNodeNum(contractId);
        HashMap settleDetailNodeNumMap = new HashMap();
        settleDetailNodeNumList.forEach(settleDetailVO -> settleDetailNodeNumMap.put(settleDetailVO.getId(), settleDetailVO.getTotalNodeNum()));
        if (CollectionUtils.isNotEmpty(settleDetailList)) {
            settleDetailList.forEach(settleDetail -> {
                settleDetail.setTotalNodeNum(null != settleDetailNodeNumMap.get(settleDetail.getId()) ? (BigDecimal)settleDetailNodeNumMap.get(settleDetail.getId()) : BigDecimal.ZERO);
                settleDetail.setTotalProcessNum(null != settleDetail.getTotalProcessNum() ? settleDetail.getTotalProcessNum() : BigDecimal.ZERO);
                settleDetail.setTid(settleDetail.getId().toString());
                settleDetail.setTpid(settleDetail.getParentId() != null ? settleDetail.getParentId().toString() : null);
                settleDetail.setRowState("edit");
            });
            settleVO.setSettleDetailList(TreeNodeBUtil.buildTree(settleDetailList));
        }
        settleVO.setSettlePickingList(BeanMapper.mapList(this.settlePickingService.queryPickingList(SettleTypeEnum.\u5b8c\u5de5.getCode(), contractId, null), SettlePickingVO.class));
        settleVO.setSettleOddjobList(BeanMapper.mapList(this.settleOddjobService.queryOddjobList(SettleTypeEnum.\u5b8c\u5de5.getCode(), contractId, null), SettleOddjobVO.class));
        settleVO.setSettleDeductList(BeanMapper.mapList(this.settleDeductService.queryDeductList(SettleTypeEnum.\u5b8c\u5de5.getCode(), contractId, null), SettleDeductVO.class));
        settleVO.setSettleSalaryList(BeanMapper.mapList(this.settleSalaryService.querySalaryList(SettleTypeEnum.\u5b8c\u5de5.getCode(), contractId, null), SettleSalaryVO.class));
        return CommonResponse.success((String)"\u5f53\u524d\u5408\u540c\u53ef\u7528\uff01", (Object)settleVO);
    }

    @Override
    public CommonResponse queryFinishFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
        lambda.eq(SettleEntity::getContractId, (Object)contractId);
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97 \u4e0d\u80fd\u8fdb\u884c\u9886\u6599\u7ed3\u7b97");
        }
        return CommonResponse.success((String)"\u5f53\u524d\u5408\u540c\u53ef\u4ee5\u8fdb\u884c\u7ed3\u7b97");
    }

    @Override
    public SettleVO getPushTargetCostSettleVO(SettleEntity settleEntity) {
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class);
        List settleDetailList = settleEntity.getSettleDetailList().stream().filter(e -> e.getSettleNum() != null).collect(Collectors.toList());
        ContractEntity ce = (ContractEntity)((Object)this.contractService.selectById(settleEntity.getContractId()));
        List ceDetailList = ce.getDetailList().stream().filter(e -> e.getDetailNum() != null).collect(Collectors.toList());
        settleVO.setMny(ComputeUtil.safeSub((BigDecimal)settleEntity.getMny(), (BigDecimal)ce.getContractMny()));
        settleVO.setTaxMny(ComputeUtil.safeSub((BigDecimal)settleEntity.getTaxMny(), (BigDecimal)ce.getContractTaxMny()));
        ArrayList<Object> sdList = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty(settleDetailList)) {
            List contractIds = ceDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            for (SettleDetailEntity sd : settleDetailList) {
                if (contractIds.contains(sd.getSourceId())) {
                    for (ContractDetailEntity cd : ceDetailList) {
                        if (!sd.getSourceId().equals(cd.getId())) continue;
                        sd.setSettleNum(ComputeUtil.safeSub((BigDecimal)sd.getSettleNum(), (BigDecimal)cd.getDetailNum()));
                        sd.setSettleMny(ComputeUtil.safeSub((BigDecimal)sd.getSettleMny(), (BigDecimal)cd.getDetailMny()));
                        sd.setSettleTaxMny(ComputeUtil.safeSub((BigDecimal)sd.getSettleTaxMny(), (BigDecimal)cd.getDetailTaxMny()));
                    }
                }
                sdList.add(BeanMapper.map((Object)((Object)sd), SettleDetailVO.class));
            }
        }
        settleVO.setSettleDetailList(sdList);
        return settleVO;
    }

    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        if (contractType == 0) {
            totalVO.setBillType("BT220114000000004");
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getCode());
        } else {
            totalVO.setBillType("BT220307000000009");
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (settleVO.getProjectId() != null) {
            totalVO.setProjectId(settleVO.getProjectId());
        }
        if (settleVO.getOrgId() != null) {
            totalVO.setOrgId(settleVO.getOrgId());
        }
        totalVO.setMoney(settleVO.getMny());
        totalVO.setTaxMoney(settleVO.getTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleDetailList())) {
            List settleDetailVOS = settleVO.getSettleDetailList().stream().filter(item -> item.getDetailNum() != null).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(settleDetailVOS)) {
                // empty if block
            }
            for (SettleDetailVO settleDetailVO : settleDetailVOS) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(settleDetailVO.getId());
                detailExecutionVO.setSourceBillId(settleDetailVO.getSettleId());
                detailExecutionVO.setCategoryId(settleDetailVO.getDocCategoryId());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(settleDetailVO.getDocId() == null));
                detailExecutionVO.setCode(settleDetailVO.getSourceBillCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                if (null == settleDetailVO.getDocCategoryId()) {
                    throw new BusinessException("\u6863\u6848\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (settleDetailVO.getDocId() == null) {
                    throw new BusinessException("\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                detailExecutionVO.setDocId(settleDetailVO.getDocId());
                if (contractType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(settleDetailVO.getSourceBillCode());
                detailExecutionVO.setName(settleDetailVO.getDetailName());
                detailExecutionVO.setUnitName(settleDetailVO.getDetailUnit());
                detailExecutionVO.setNum(settleDetailVO.getSettleNum());
                detailExecutionVO.setTaxPrice(settleDetailVO.getDetailTaxPrice());
                detailExecutionVO.setPrice(settleDetailVO.getDetailPrice());
                detailExecutionVO.setSpec(settleDetailVO.getDetailMeasurementRules());
                detailExecutionVO.setMemo(settleDetailVO.getMemo());
                detailExecutionVO.setMoney(settleDetailVO.getSettleMny());
                detailExecutionVO.setTaxMoney(settleDetailVO.getSettleTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO) {
        CostCtrlVO costCtrlVO;
        ParamsCheckVO tarRes;
        List<ParamsCheckVO> paramsCheckVOS;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        if (null != settleVO.getProjectId() && null != settleVO.getOrgId() && CollectionUtils.isNotEmpty(paramsCheckVOS = this.costProjectCheckParams(settleVO))) {
            return paramsCheckVOS.get(0);
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        if (1 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, settleVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            BigDecimal contractTaxMny;
            ArrayList checkDsVOS = new ArrayList();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if ("none".equals(paramsCheck.getWarnType())) continue;
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
            if (null == contract) {
                this.logger.info("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BigDecimal taxMny = settleVO.getTaxMny();
            if (taxMny.compareTo(contractTaxMny = this.settleService.getContractTaxMny(contract.getContractTaxMny(), roleValue)) > 0) {
                BigDecimal overTaxMny = this.settleService.getOverTaxMny(taxMny, contractTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d\uff1a").append(taxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheck.setDataSource((List)checkDsVOS);
                paramsCheckVOList.add(paramsCheck);
                continue;
            }
            paramsCheck.setWarnType(paramsArray[0]);
        }
        if (null == settleVO.getId()) {
            settleVO.setId(Long.valueOf(IdWorker.getId()));
        }
        List settlementDetailList = settleVO.getSettleDetailList();
        ArrayList<SettleDetailVO> settlementDetailListNew = new ArrayList<SettleDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)settlementDetailList)) {
            for (SettleDetailVO cdEntity : settlementDetailList) {
                if (null == cdEntity.getId()) {
                    cdEntity.setId(Long.valueOf(IdWorker.getId()));
                    cdEntity.setSettleId(settleVO.getId());
                }
                if ("del".equals(cdEntity.getRowState())) continue;
                settlementDetailListNew.add(cdEntity);
            }
            settleVO.setSettleDetailList(settlementDetailListNew);
        }
        ExecutionVO executionVO = this.settleService.prepareExecutionVO((SettleEntity)((Object)BeanMapper.map((Object)settleVO, SettleEntity.class)));
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            // empty if block
        }
        if (null != (tarRes = (ParamsCheckVO)response.getData())) {
            paramsCheckVOList.add(tarRes);
        }
        if (null != (costCtrlVO = this.settleService.sjCost(settleVO))) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOList.add(costRes);
            }
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO numCtrl(SettleVO settleVO, Boolean flag) {
        this.logger.info("FinishSettleServiceImpl--numCtrl()--begin--\u5f53\u524d\u4e3a\u5b8c\u5de5\u7ed3\u7b97\uff0c\u3010\u5408\u540c\u91cf\u3011\u63a7\u3010\u6700\u7ec8\u7ed3\u7b97\u91cf\u3011--\u5165\u53c2\uff1asettleVO={}", (Object)JSONObject.toJSONString((Object)settleVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_FINISH_NUM_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        if (1 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_FINISH_NUM_CHECK_PARAM_NAME, settleVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheck.getWarnType())) {
                Long tenantid = InvocationInfoProxy.getTenantid();
                List settleDetailList = settleVO.getSettleDetailList();
                HashMap<Long, SettleDetailVO> settleDetailMap = new HashMap<Long, SettleDetailVO>();
                HashMap<Long, BigDecimal> settleNumMap = new HashMap<Long, BigDecimal>();
                if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
                    for (SettleDetailVO settleDetailVO : settleDetailList) {
                        if (settleDetailVO.getDetailNum() == null || "del".equals(settleDetailVO.getRowState())) continue;
                        settleDetailMap.put(settleDetailVO.getContractDetailId(), settleDetailVO);
                        BigDecimal settleNum = settleDetailVO.getSettleNum() == null ? BigDecimal.ZERO : settleDetailVO.getSettleNum();
                        BigDecimal settleNumTotalOld = (BigDecimal)settleNumMap.get(settleDetailVO.getContractDetailId());
                        settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                        settleNumMap.put(settleDetailVO.getContractDetailId(), settleNumTotalOld.add(settleNum));
                    }
                }
                this.logger.info("\u5f85\u4fdd\u5b58\u6570\u636e\u540c\u4e00\u5408\u540c\u6e05\u5355\u4e0b\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u7684\u4e3a\uff1amap={}", (Object)JSONObject.toJSONString(settleNumMap));
                List contractDetailEntityList = new ArrayList();
                QueryWrapper cdWrapper = new QueryWrapper();
                Set settleNumMapKeySet = settleNumMap.keySet();
                if (MapUtils.isNotEmpty(settleNumMap)) {
                    cdWrapper = new QueryWrapper();
                    ((QueryWrapper)((QueryWrapper)cdWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).in((Object)"id", settleNumMapKeySet);
                    contractDetailEntityList = this.contractDetailMapper.selectList((Wrapper)cdWrapper);
                }
                this.logger.info("\u67e5\u8be2\u5230\u7684\u5f85\u4fdd\u5b58\u6570\u636e\u6240\u5c5e\u7684\u5408\u540c\u6e05\u5355\u6570\u636e\uff1alist={}", (Object)JSONObject.toJSONString(contractDetailEntityList));
                HashMap<Long, ContractDetailEntity> contractDetailEntityMap = new HashMap<Long, ContractDetailEntity>();
                if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
                    for (ContractDetailEntity contractDetailEntity : contractDetailEntityList) {
                        contractDetailEntityMap.put(contractDetailEntity.getId(), contractDetailEntity);
                    }
                }
                if (MapUtils.isNotEmpty(settleDetailMap)) {
                    Set keySet = settleDetailMap.keySet();
                    if (keySet.size() > 0) {
                        this.logger.info("\u53c2\u6570\u63a7\u5236----begin");
                        for (Long key : keySet) {
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355id\uff1aid={}", (Object)JSONObject.toJSONString((Object)key));
                            BigDecimal settleNum = (BigDecimal)settleNumMap.get(key);
                            settleNum = settleNum == null ? BigDecimal.ZERO : settleNum;
                            this.logger.info("\u5f85\u4fdd\u5b58\u7684\u7ed3\u7b97\u6e05\u5355\u540c\u4e00\u5408\u540c\u6e05\u5355\u4e0b\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u4e3a:settleNum={}", (Object)settleNum);
                            ContractDetailEntity cdEntiey = (ContractDetailEntity)((Object)contractDetailEntityMap.get(key));
                            if (cdEntiey == null) continue;
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355\u6570\u636e\uff1acontractDetailVO={}", (Object)JSONObject.toJSONString((Object)((Object)cdEntiey)));
                            String detailName = cdEntiey.getDetailName();
                            detailName = StringUtils.isBlank((String)detailName) ? "" : detailName;
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355\u540d\u79f0\uff1adetailName={}", (Object)detailName);
                            String detailRule = cdEntiey.getDetailMeasurementRules();
                            detailRule = StringUtils.isBlank((String)detailRule) ? "" : detailRule;
                            this.logger.info("\u5f53\u524d\u8ba1\u91cf\u89c4\u5219\uff1adetailRule={}", (Object)detailRule);
                            BigDecimal detailNum = cdEntiey.getDetailNum() == null ? BigDecimal.ZERO : cdEntiey.getDetailNum();
                            this.logger.info("\u5f53\u524d\u5408\u540c\u91cf\uff1adetailNum={}", (Object)detailNum);
                            BigDecimal conNum = detailNum.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                            this.logger.info("\u5f53\u524d\u5408\u540c\u91cf*" + roleValue.toString() + "%\uff1aconNum={}", (Object)conNum);
                            this.logger.info("\u518d\u6b21\u6253\u5370\u65e5\u5fd7\uff0c\u672c\u671f\u7ed3\u7b97\u91cf = {}\uff0c\u5408\u540c\u91cf*" + roleValue.toString() + "% = {}", (Object)settleNum, (Object)conNum);
                            if (settleNum.compareTo(conNum) <= 0) continue;
                            BigDecimal overNum = settleNum.subtract(conNum);
                            this.logger.info("\u8d85\u51fa\u6570\u91cf={}", (Object)overNum);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(detailName + detailRule);
                            paramsCheckDsVO.setWarnName("\u6700\u7ec8\u7ed3\u7b97\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u5408\u540c\u6700\u7ec8\u7ed3\u7b97\u6570\u91cf\uff1a").append(settleNum.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%\uff1a").append(conNum.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(overNum.setScale(2, RoundingMode.DOWN));
                            paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            dataSource.add(paramsCheckDsVO);
                            paramsCheck.setDataSource(dataSource);
                        }
                        this.logger.info("\u53c2\u6570\u63a7\u5236--end");
                    } else {
                        paramsCheck.setWarnType(paramsArray[0]);
                    }
                } else {
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
            this.logger.info("FinishSettleServiceImpl--numCtrl()--end--\u5f53\u524d\u4e3a\u5b8c\u5de5\u7ed3\u7b97\uff0c\u3010\u5408\u540c\u91cf\u3011\u63a7\u3010\u6700\u7ec8\u7ed3\u7b97\u91cf\u3011--\u8fd4\u56de\u7ed3\u679c\uff1aparamsCheckVO={}", (Object)JSONObject.toJSONString((Object)paramsCheck));
            paramsCheckVOList.add(paramsCheck);
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    public List<ParamsCheckVO> costProjectCheckParams(SettleVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse booleanCommonResponse = this.dutyApi.queryDutyByProjectId(vo.getProjectId());
        if (!booleanCommonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (!((Boolean)booleanCommonResponse.getData()).booleanValue()) {
            CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId("P-ilUA850193", vo.getOrgId());
            if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
                List data = (List)billParamByCodeAndOrgId.getData();
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (BillParamVO billParamByCode : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        String orgName = billParamByCode.getOrgName();
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        paramsCheckVO.setWarnType(paramsArray[billParamByCode.getControlType()]);
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u65e0\u76ee\u6807\u6210\u672c\u63a7\u7ed3\u7b97");
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnName("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c");
                        paramsCheckDsVO.setContent("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u7ed3\u7b97\u5355");
                        checkDsVOS.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            } else {
                this.logger.info(billParamByCodeAndOrgId.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public SettleVO saveFinishSettle(SettleVO saveOrUpdateVO) {
        List<SettleDetailEntity> detailList;
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setFilingStatus(0);
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
        }
        if (!(detailList = entity.getSettleDetailList()).isEmpty()) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SettleDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState())) continue;
                if (sd.getId() == null || entity.getId() == null) {
                    sd.setId(IdWorker.getId());
                }
                idMap.put(sd.getTid(), sd.getId());
                sd.setParentId(null);
            }
            for (SettleDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState()) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)sd.getTpid())) continue;
                sd.setParentId((Long)idMap.get(sd.getTpid()));
            }
        }
        entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        super.saveOrUpdate((Object)entity, false);
        this.settleService.saveCost(entity, 0);
        return (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
    }

    @Override
    public String delBatch(List<Long> billIds) {
        StringBuilder sp = new StringBuilder();
        ArrayList<Long> delIds = new ArrayList<Long>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", billIds);
        List settleList = this.settleService.list((Wrapper)query);
        for (SettleEntity settle : settleList) {
            String msg = this.contractService.changePerformanceStatus(settle.getContractId(), ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            if (StringUtils.isBlank((String)msg)) {
                delIds.add(settle.getId());
                super.removeById((Serializable)settle.getId());
                continue;
            }
            sp.append(settle.getContractName()).append("\u3001[").append(settle.getContractCode()).append("]");
        }
        return sp.toString().length() > 0 ? sp.toString() : null;
    }
}

