/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanContrastV0;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PlanMapper planMapper;
    @Autowired
    private IPlanChangeService planChangeService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Override
    public PlanVO queryByCode(String planCode) {
        PlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PlanEntity entity = (PlanEntity)((Object)this.planMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO queryByProjectId(Long projectId, Integer subType) {
        PlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"sub_type", (Object)subType);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PlanEntity entity = (PlanEntity)((Object)this.planMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO saveOrUpdateMasterPlan(PlanEntity saveEntity, Boolean isControl) {
        if (Boolean.FALSE.equals(isControl)) {
            super.saveOrUpdate((Object)saveEntity, false);
        }
        PlanVO planVO = null;
        List<PlanDetailEntity> detailEntityList = saveEntity.getPlanDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            planVO = Boolean.FALSE.equals(isControl) ? this.queryDetail(saveEntity.getId(), true) : (PlanVO)BeanMapper.map((Object)((Object)saveEntity), PlanVO.class);
        }
        return planVO;
    }

    @Override
    public PlanVO queryDetail(Long id, boolean detailHasChildren) {
        PlanEntity masterPlanEntity = (PlanEntity)((Object)super.selectById((Serializable)id));
        PlanVO masterPlanVO = (PlanVO)BeanMapper.map((Object)((Object)masterPlanEntity), PlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.planDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (PlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailVO.class);
            List<PlanDetailVO> usefulDetailList = this.selectUsefulByIds(resultMapList.stream().map(BaseVO::getId).collect(Collectors.toList()));
            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<Long, Integer>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)) {
                for (PlanDetailVO c : usefulDetailList) {
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailVO c : resultMapList) {
                if (null != usefulDetailMap.get(c.getId())) {
                    c.setUseNum(Integer.valueOf(1));
                    c.setRowState("edit");
                    continue;
                }
                c.setUseNum(null);
            }
            if (detailHasChildren) {
                masterPlanVO.setPlanDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                masterPlanVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailVO.class));
        }
        if (null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0) {
            masterPlanVO.setPlanChangeHisList(this.planChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;
    }

    @Override
    public List<PlanDetailVO> selectUsefulByIds(List<Long> planIdList) {
        return this.planMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public List<PlanContrastV0> getContrastInfo(Long planId, Long oldPlanId) {
        return this.planMapper.getContrastInfo(planId, oldPlanId);
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<PlanDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((PlanDetailEntity)((Object)BeanMapper.map(ypd, PlanDetailEntity.class)));
        }
    }

    @Override
    public ExecutionVO targetCost(PlanVO planVO, String linkUrl, Integer subType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(planVO.getId());
        totalVO.setTenantId(planVO.getTenantId());
        totalVO.setBillCode(planVO.getBillCode());
        totalVO.setOrgId(planVO.getOrgId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (subType == 0) {
            totalVO.setBillType(ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getCode());
        } else {
            totalVO.setBillType(ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setProjectId(planVO.getProjectId());
        totalVO.setOrgId(planVO.getOrgId());
        totalVO.setMoney(planVO.getTotalPlanMny());
        totalVO.setTaxMoney(planVO.getTotalPlanTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (null != planVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planVO.getCreateTime()));
        }
        totalVO.setMemo(planVO.getMemo());
        if (CollectionUtils.isNotEmpty((Collection)planVO.getPlanDetailList())) {
            List planDetailVOS = planVO.getPlanDetailList().stream().filter(item -> item.getLeafFlag() != false && !"del".equals(item.getRowState())).collect(Collectors.toList());
            Assert.notEmpty(planDetailVOS, (String)"\u8ba1\u5212\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            for (PlanDetailVO planDetailVO : planDetailVOS) {
                LabsubCategoryVO categoryVO;
                CommonResponse res;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                Assert.notNull((Object)planDetailVO.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
                if (0 == subType) {
                    res = this.shareLabsubApi.queryLabSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)planDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (LabsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    res = this.shareLabsubApi.queryMajorSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)planDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (ProsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }
                Assert.notNull((Object)planDetailVO.getDocId(), (String)"\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if (null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}

