/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.prosub.service.IContractDetailService;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.bean.SettleOddjobEntity;
import com.ejianc.business.settle.bean.SettleOtherEntity;
import com.ejianc.business.settle.bean.SettlePickingEntity;
import com.ejianc.business.settle.bean.SettlePriceEntity;
import com.ejianc.business.settle.bean.SettleSalaryEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleDetailMapper;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOddjobService;
import com.ejianc.business.settle.service.ISettleOtherService;
import com.ejianc.business.settle.service.ISettlePickingService;
import com.ejianc.business.settle.service.ISettlePriceService;
import com.ejianc.business.settle.service.ISettleSalaryService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleOddjobVO;
import com.ejianc.business.settle.vo.SettleOtherVO;
import com.ejianc.business.settle.vo.SettlePickingVO;
import com.ejianc.business.settle.vo.SettlePriceVO;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleSalaryVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springside.modules.nosql.redis.JedisTemplate;

@RestController
@RequestMapping(value={"settle"})
public class SettleController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettleService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettleSalaryService salaryService;
    @Autowired
    private ISettleOddjobService oddjobService;
    @Autowired
    private ISettlePickingService pickingService;
    @Autowired
    private ISettleOtherService otherService;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    private final String processBillType = "BT220114000000002";
    private final String finishBillType = "BT220114000000004";
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private final String nodeBillType = "BT220114000000003";
    private final String nodeMobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subNode/card";
    private final String finishMobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subCompletion/card";
    private final String procMobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subProcess/card";
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISettlePriceService settlePriceService;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private SettleDetailMapper settleDetailMapper;
    private final String PUSH_POOL_PREFIX = "pushContractSettle::";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private final String FINISH_SETTLE_DIFFERENCE_CONFIG = "P-2hiWQQ0131";

    @RequestMapping(value={"/queryUnusedContract"}, method={RequestMethod.GET})
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType, Long changeId) {
        return this.service.queryUnusedContract(contractId, settleDate, settleType, changeId);
    }

    @RequestMapping(value={"/queryDetailSumMny"}, method={RequestMethod.POST})
    public CommonResponse<List<SettleDetailVO>> queryDetailSumMny(@RequestBody List<SettleDetailVO> list) {
        List<Long> ids = list.stream().map(BaseVO::getId).collect(Collectors.toList());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.settleDetailMapper.queryDetailSumMny(ids));
    }

    @RequestMapping(value={"/queryPriceSumMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SettlePriceVO>> queryPriceSumMny(@RequestBody List<SettlePriceVO> list) {
        List<Long> ids = list.stream().map(BaseVO::getId).collect(Collectors.toList());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.settleDetailMapper.queryPriceSumMny(ids));
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO saveOrUpdateVO) {
        this.logger.info(" \u624b\u52a8\u5173\u8054\u4fdd\u5b58\u63a5\u53e3---{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
        return this.service.pushCost(saveOrUpdateVO);
    }

    @RequestMapping(value={"/autoPushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Long>> autoPushCost(@RequestBody List<SettleVO> vos) {
        List<Long> billIds = vos.stream().map(SettleVO::getId).collect(Collectors.toList());
        List<Long> longs = this.service.autoPushCost(billIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", longs);
    }

    @RequestMapping(value={"/querySubTableList"}, method={RequestMethod.POST})
    public CommonResponse<SettleVO> querySubTableList(@RequestBody SettleVO settleVO) {
        BigDecimal contractBillTaxMny;
        BigDecimal contractPayMny;
        if (settleVO.getSettleType() == null || settleVO.getContractId() == null || settleVO.getSettleDate() == null) {
            throw new BusinessException("\u8bf7\u68c0\u67e5\u5408\u540cid\u6216\u7ed3\u7b97\u65e5\u671f\u662f\u5426\u4e3a\u7a7a\uff01");
        }
        SettleEntity entity = this.service.querySubTableList(settleVO.getSettleType(), settleVO.getContractId(), settleVO.getSettleDate());
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        List settleDetailList = vo.getSettleDetailList();
        List ids = settleDetailList.stream().map(SettleDetailVO::getDocId).collect(Collectors.toList());
        Long projectId = settleVO.getProjectId();
        CommonResponse res = this.shareLabsubApi.queryLabsubItemByIdsNew(ids, projectId);
        Map data = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        for (SettleDetailVO settleDetailVO : settleDetailList) {
            if (!data.containsKey(settleDetailVO.getDocId())) continue;
            LabsubItemVO labsubItemVO = (LabsubItemVO)data.get(settleDetailVO.getDocId());
            settleDetailVO.setDetailSubjectId(labsubItemVO.getSubjectId());
            settleDetailVO.setDetailSubjectCode(labsubItemVO.getSubjectName());
        }
        vo.setSettleDetailList(settleDetailList);
        if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleVO.getSettleType())) {
            vo.setSettleDetailList(TreeNodeBUtil.buildTree((List)vo.getSettleDetailList()));
        } else {
            List<ContractDetailVO> details = this.contractDetailService.listByContractId(settleVO.getContractId());
            List detailList = vo.getSettleDetailList();
            List<SettleDetailVO> mList = null;
            ArrayList<SettleDetailVO> detailNumList = new ArrayList<SettleDetailVO>();
            if (!detailList.isEmpty()) {
                mList = this.changeToMeasureDetail(details, detailList, "\u5206\u5305\u8ba1\u91cf");
                vo.setSettleDetailList(TreeNodeBUtil.buildTree(mList));
                detailNumList.addAll(detailList);
            }
            if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleVO.getSettleType())) {
                List<SettleDetailVO> numList = this.settleDetailService.addDetail(settleVO.getContractId());
                if (CollectionUtils.isNotEmpty(numList)) {
                    detailNumList.addAll(numList);
                    List<SettleDetailVO> list = this.changeToMeasureDetail(details, numList, "\u7ed3\u7b97\u5355");
                    vo.getSettleDetailList().addAll(TreeNodeBUtil.buildTree(list));
                }
                if (CollectionUtils.isNotEmpty(detailNumList)) {
                    Map<Long, BigDecimal> countMapByNum = detailNumList.stream().collect(Collectors.groupingBy(SettleDetailVO::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailVO::getSettleNum, BigDecimal::add)));
                    HashMap countMapByProcess = new HashMap();
                    for (SettleDetailVO settleDetailVO : detailNumList) {
                        if (countMapByProcess.containsKey(settleDetailVO.getContractDetailId())) continue;
                        countMapByProcess.put(settleDetailVO.getContractDetailId(), settleDetailVO.getLastProcessNum());
                    }
                    detailNumList.stream().forEach(item -> {
                        BigDecimal totalNum = (BigDecimal)countMapByNum.get(item.getContractDetailId());
                        item.setTotalProcessNum(totalNum.add((BigDecimal)countMapByProcess.get(item.getContractDetailId())));
                    });
                }
            }
        }
        if (Objects.equals(settleVO.getSettleType(), SettleTypeEnum.\u8fc7\u7a0b.getCode())) {
            QueryParam param = new QueryParam();
            param.getParams().put("contract_id", new Parameter("eq", (Object)settleVO.getContractId()));
            param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u8fc7\u7a0b.getCode()));
            List settleEntities = this.service.queryList(param);
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            contractPayMny = BigDecimal.ZERO;
            contractBillTaxMny = BigDecimal.ZERO;
            for (SettleEntity s : settleEntities) {
                lastTaxMny = lastTaxMny.add(s.getTaxMny());
                lastMny = lastMny.add(s.getMny());
                contractPayMny = contractPayMny.add(s.getContractPayMny());
                contractBillTaxMny = contractBillTaxMny.add(s.getContractBillTaxMny());
            }
            vo.setLastTaxMny(lastTaxMny);
            vo.setLastMny(lastMny);
            vo.setContractPayMny(contractPayMny);
            vo.setContractBillTaxMny(contractBillTaxMny);
        }
        if (Objects.equals(settleVO.getSettleType(), SettleTypeEnum.\u8282\u70b9.getCode()) || Objects.equals(settleVO.getSettleType(), SettleTypeEnum.\u5b8c\u5de5.getCode())) {
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastNodeTaxMny = BigDecimal.ZERO;
            BigDecimal lastNodeMny = BigDecimal.ZERO;
            contractPayMny = BigDecimal.ZERO;
            contractBillTaxMny = BigDecimal.ZERO;
            QueryParam param = new QueryParam();
            param.getParams().put("contract_id", new Parameter("eq", (Object)settleVO.getContractId()));
            param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u8282\u70b9.getCode()));
            List settleEntities = this.service.queryList(param);
            for (SettleEntity s : settleEntities) {
                lastNodeTaxMny = lastNodeTaxMny.add(s.getTaxMny());
                lastNodeMny = lastNodeMny.add(s.getMny());
                contractPayMny = contractPayMny.add(s.getContractPayMny());
                contractBillTaxMny = contractBillTaxMny.add(s.getContractBillTaxMny());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)settleVO.getContractId()));
            queryParam.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u8fc7\u7a0b.getCode()));
            List processSettleEntities = this.service.queryList(queryParam);
            for (SettleEntity s : processSettleEntities) {
                lastTaxMny = lastTaxMny.add(s.getTaxMny());
                lastMny = lastMny.add(s.getMny());
            }
            vo.setLastTaxMny(lastTaxMny);
            vo.setLastMny(lastMny);
            vo.setLastNodeTaxMny(lastNodeTaxMny);
            vo.setLastNodeMny(lastNodeMny);
            vo.setContractPayMny(contractPayMny);
            vo.setContractBillTaxMny(contractBillTaxMny);
        }
        if (SettleTypeEnum.\u8282\u70b9.getCode().equals(settleVO.getSettleType())) {
            int settleTimes = this.service.queryContractSettleNumOfNode(settleVO.getContractId());
            vo.setSettleTimes(Integer.valueOf(settleTimes + 1));
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)settleVO.getContractId()));
            queryParam.getParams().put("settle_type", new Parameter("eq", (Object)settleVO.getSettleType()));
            List settleEntityList = this.service.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)settleEntityList)) {
                vo.setSettleTimes(Integer.valueOf(settleEntityList.size()));
            } else {
                vo.setSettleTimes(Integer.valueOf(0));
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(SettleEntity::getBillState, new Object[]{1, 3});
        lambda.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        List entities = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List settleIds = entities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaPrice = Wrappers.lambdaQuery();
            lambdaPrice.in(SettlePriceEntity::getSettleId, settleIds);
            lambdaPrice.in(SettlePriceEntity::getSettleType, new Object[]{0});
            List settlePriceEntityList = this.settlePriceService.list((Wrapper)lambdaPrice);
            List collect = settlePriceEntityList.stream().map(SettlePriceEntity::getDocId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.shareLabsubApi.queryLabsubItemByIdsNew(collect, settleVO.getProjectId());
            Map collect1 = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            for (SettlePriceEntity entity1 : settlePriceEntityList) {
                if (!collect1.containsKey(entity1.getDocId())) continue;
                LabsubItemVO labsubItemVO = (LabsubItemVO)collect1.get(entity1.getDocId());
                entity1.setPriceSubjectId(labsubItemVO.getSubjectId());
                entity1.setPriceSubjectName(labsubItemVO.getSubjectName());
            }
            List list = BeanMapper.mapList((Iterable)settlePriceEntityList, SettlePriceVO.class);
            vo.setSettlePriceList(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5b50\u8868\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private List<SettleDetailVO> changeToMeasureDetail(List<ContractDetailVO> details, List<SettleDetailVO> vos, String sourceType) {
        SettleDetailVO measureDetailVO = vos.get(0);
        Map<Long, List<SettleDetailVO>> vosMap = vos.stream().collect(Collectors.groupingBy(SettleDetailVO::getContractDetailId));
        HashMap<Long, SettleDetailVO> treeVOMap = new HashMap<Long, SettleDetailVO>();
        HashMap<Long, SettleDetailVO> resultMap = new HashMap<Long, SettleDetailVO>();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        List collect = vos.stream().map(SettleDetailVO::getDocId).collect(Collectors.toList());
        SettleDetailVO tmp = null;
        for (ContractDetailVO contractDetailVO : details) {
            if (null != vosMap.get(contractDetailVO.getId())) {
                for (SettleDetailVO s : vosMap.get(contractDetailVO.getId())) {
                    tmp = (SettleDetailVO)BeanMapper.map((Object)s, SettleDetailVO.class);
                    tmp.setParentId(contractDetailVO.getParentId());
                    s.setParentId(contractDetailVO.getParentId());
                    if (sourceType.equals("\u5206\u5305\u8ba1\u91cf")) {
                        s.setDetailArtificialTaxPrice(contractDetailVO.getDetailArtificialTaxPrice());
                        if (contractDetailVO.getDetailArtificialTaxPrice() != null && s.getSettleNum() != null) {
                            s.setDetailArtificialTaxMny(contractDetailVO.getDetailArtificialTaxPrice().multiply(s.getSettleNum()));
                        }
                    }
                    treeVOMap.put(tmp.getId(), tmp);
                }
                continue;
            }
            tmp = new SettleDetailVO();
            tmp.setContractId(measureDetailVO.getContractId());
            tmp.setDetailName(contractDetailVO.getDetailName());
            tmp.setDetailWorkContent(contractDetailVO.getDetailWorkContent());
            tmp.setDetailMeasurementRules(contractDetailVO.getDetailMeasurementRules());
            tmp.setDetailUnit(contractDetailVO.getDetailUnit());
            tmp.setSourceType(sourceType);
            tmp.setDetailArtificialTaxPrice(contractDetailVO.getDetailArtificialTaxPrice());
            tmp.setId(Long.valueOf(IdWorker.getId()));
            tmp.setContractDetailId(tmp.getId());
            tmp.setRowState("add");
            tmp.setParentId(contractDetailVO.getParentId());
            idMap.put(contractDetailVO.getId(), tmp.getId());
            treeVOMap.put(tmp.getContractDetailId(), tmp);
        }
        for (List list : vosMap.values()) {
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                SettleDetailVO vo;
                tmp = vo = (SettleDetailVO)iterator.next();
                tmp.setParentId((Long)idMap.get(tmp.getParentId()));
                resultMap.put(vo.getId(), tmp);
                tmp.setRowState("add");
            }
            if (null == tmp.getParentId() || resultMap.containsKey(tmp.getParentId())) continue;
            this.findParent(tmp.getParentId(), treeVOMap, resultMap, idMap);
        }
        return new ArrayList<SettleDetailVO>(resultMap.values());
    }

    private void findParent(Long parentId, Map<Long, SettleDetailVO> treeVOMap, Map<Long, SettleDetailVO> resultMap, Map<Long, Long> idMap) {
        SettleDetailVO parent = treeVOMap.get(parentId);
        parent.setRowState("add");
        parent.setParentId(idMap.get(parent.getParentId()));
        resultMap.put(parentId, parent);
        if (null != parent.getParentId() && !resultMap.containsKey(parent.getParentId())) {
            this.findParent(parent.getParentId(), treeVOMap, resultMap, idMap);
        }
    }

    @RequestMapping(value={"/refSettleSalaryData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleSalaryVO>> refSalaryData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Integer settleType = null;
        Long contractId = null;
        String settleDate = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("condition\uff1a{}", (Object)_con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
            settleDate = _con.getString("settleDate");
        }
        Page pg = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<SettleSalaryEntity> page = this.salaryService.selectPageSalary((Page<SettleSalaryEntity>)pg, settleType, contractId, settleDate);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleSalaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/getBillShareLink"})
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        Integer settType = entity.getSettleType();
        String mobileH5url = null;
        String mobileWxUrl = null;
        String billtype = null;
        if (SettleTypeEnum.\u8282\u70b9.getCode().equals(settType)) {
            billtype = "BT220114000000003";
            mobileH5url = "/ejc-supbusiness-mobile/#/subNode/card";
            mobileWxUrl = "/ejc-supbusiness-mobile/#/subNode/card";
        } else if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settType)) {
            billtype = "BT220114000000002";
            mobileH5url = "/ejc-supbusiness-mobile/#/subProcess/card";
            mobileWxUrl = "/ejc-supbusiness-mobile/#/subProcess/card";
        } else {
            billtype = "BT220114000000004";
            mobileH5url = "/ejc-supbusiness-mobile/#/subCompletion/card";
            mobileWxUrl = "/ejc-supbusiness-mobile/#/subCompletion/card";
        }
        if (SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billtype);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)billtype, (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter((SettleEntity)((Object)BeanMapper.map((Object)((Object)entity), SettleEntity.class)), billtype, (CooperateVO)cooperateResp.getData());
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
        }
        return this.shareCooperateApi.getShareLink(id, billtype, entity.getSupplierId().toString(), mobileH5url, mobileWxUrl);
    }

    @RequestMapping(value={"/refSettleOddjobData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleOddjobVO>> refSettleOddjobData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Integer settleType = null;
        Long contractId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("condition\uff1a{}", (Object)_con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page pg = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<SettleOddjobEntity> page = this.oddjobService.selectPageSalary((Page<SettleOddjobEntity>)pg, settleType, contractId);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleOddjobVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSettlePickingData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettlePickingVO>> refSettlePickingData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Integer settleType = null;
        Long contractId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("condition\uff1a{}", (Object)_con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page pg = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<SettlePickingEntity> page = this.pickingService.selectPageSalary((Page<SettlePickingEntity>)pg, settleType, contractId);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlePickingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSettleOtherData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleOtherVO>> refOtherData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        Long contractId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("condition\uff1a{}", (Object)_con);
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page pg = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<SettleOtherEntity> page = this.otherService.selectPageOther((Page<SettleOtherEntity>)pg, contractId, searchText);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleOtherVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSettleDetailData"}, method={RequestMethod.GET})
    public CommonResponse<List<SettleDetailVO>> refDetailData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        Integer settleType = null;
        Long contractId = null;
        List<String> oldDelIdList = new ArrayList<String>();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("condition\uff1a{}", (Object)_con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)_con.getString("oldDelDataId"))) {
                oldDelIdList = Arrays.asList(_con.getString("oldDelDataId").split(","));
            }
        }
        Page pg = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        pg.setSize(-1L);
        IPage<SettleDetailEntity> page = this.detailService.selectPageDetail((Page<SettleDetailEntity>)pg, settleType, contractId, searchText, CollectionUtils.isNotEmpty(oldDelIdList) ? oldDelIdList : null);
        List resList = new ArrayList();
        List settleDetailList = BeanMapper.mapList((Iterable)page.getRecords(), SettleDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
            for (SettleDetailVO detail : settleDetailList) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            resList = TreeNodeBUtil.buildTree((List)settleDetailList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @PostMapping(value={"/supSignSync"})
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @PostMapping(value={"/testPushBill"})
    public CommonResponse<String> testPushBill(@RequestBody Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        this.logger.info("\u63a8\u9001\u7ed3\u7b97\u5355BASE_HOST\uff1a{}", (Object)this.BASE_HOST);
        CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(SettleTypeEnum.\u8282\u70b9.getCode().equals(entity.getSettleType()) ? "BT220114000000003" : (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(entity.getSettleType()) ? "BT220114000000002" : "BT220114000000004"));
        this.service.pushBillToSupCenter(entity, SettleTypeEnum.\u8282\u70b9.getCode().equals(entity.getSettleType()) ? "BT220114000000003" : (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(entity.getSettleType()) ? "BT220114000000002" : "BT220114000000004"), (CooperateVO)cooperateResp.getData());
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01~");
    }

    @GetMapping(value={"/queryDetailRecord"})
    public CommonResponse<SettleRecordVO> queryDetailRecord(@RequestParam(value="id") Long id, @RequestParam(value="settleType") Integer settleType) {
        SettleRecordVO vo = this.service.queryDetailRecord(id, settleType);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/newSettleCheck"})
    public CommonResponse<String> beforeNewSettleCheck(@RequestParam(value="id") Long contractId, @RequestParam(value="settleType") Integer settleType) {
        String msg = this.service.beforeNewSettleCheck(contractId, settleType);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u6539\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u7ed3\u7b97");
    }

    @ResponseBody
    @RequestMapping(value={"/queryTotalNodeAndFin"}, method={RequestMethod.POST})
    public CommonResponse<SettleVO> queryTotalNodeAndFin(@RequestBody SettleVO settleVO) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)this.service.queryTotalNodeAndFin(settleVO.getContractId(), settleVO.getProjectId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/pushSettleToPool"})
    @ResponseBody
    public CommonResponse<SettleVO> pushSettleToPool(@RequestBody Long settleId) {
        SettleVO s;
        JedisTemplate jedisTemplate;
        block23: {
            CommonResponse commonResponse;
            jedisTemplate = this.cacheManager.getJedisTemplate();
            String contractIdStr = jedisTemplate.get("pushContractSettle::" + settleId.toString());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractIdStr)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6570\u636e\u5df2\u5904\u4e8e\u540c\u6b65\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            jedisTemplate.set("pushContractSettle::" + settleId.toString(), settleId.toString());
            SettleEntity dbEntity = (SettleEntity)((Object)this.service.selectById(settleId));
            if (null == dbEntity) {
                jedisTemplate.del(new String[]{"pushContractSettle::" + settleId.toString()});
                return CommonResponse.error((String)("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff0c\u672a\u627e\u5230Id-" + settleId + "\u5339\u914d\u7684\u7ed3\u7b97\u5355\uff01"));
            }
            s = (SettleVO)BeanMapper.map((Object)((Object)dbEntity), SettleVO.class);
            SettlePoolVO spv = new SettlePoolVO();
            try {
                this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
                BeanConvertorUtil.convert((Object)s, (Object)spv);
                this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
                this.service.convertSettleVOToSettlePoolVO(s, spv);
                String settleType = "";
                String contractType = "";
                if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(s.getSettleType())) {
                    settleType = "processSettle";
                    spv.setUltimateFlag(SettleUltimateFlagEnum.\u975e\u6700\u7ec8\u7ed3\u7b97.getCode());
                } else if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(s.getSettleType())) {
                    settleType = "finishSettle";
                    spv.setUltimateFlag(SettleUltimateFlagEnum.\u6700\u7ec8\u7ed3\u7b97.getCode());
                    spv.setFinishCurTaxMny(s.getTaxMny());
                    spv.setFinishCurMny(s.getMny());
                    spv.setCurTax(s.getTax());
                    CommonResponse response = this.paramConfigApi.getByCode("P-2hiWQQ0131");
                    if (!response.isSuccess() || response.getData() == null) {
                        throw new BusinessException("\u83b7\u53d6\u5b8c\u5de5\u5355\u5dee\u989d\u53d6\u503c\u65b9\u5f0f\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                    }
                    String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
                    if ("1".equals(valueData)) {
                        spv.setCurTaxMny(s.getTotalProcessTaxDifference());
                        if (null != s.getTotalProcessDifference()) {
                            spv.setCurMny(s.getTotalProcessDifference());
                            spv.setCurTax(s.getTotalProcessTaxDifference().subtract(s.getTotalProcessDifference()));
                        }
                        spv.setResidueApplyMny(s.getTotalProcessTaxDifference());
                    } else {
                        spv.setCurTaxMny(s.getTotalNodeTaxDifference());
                        if (null != s.getTotalNodeDifference()) {
                            spv.setCurMny(s.getTotalNodeDifference());
                            spv.setCurTax(s.getTotalNodeTaxDifference().subtract(s.getTotalNodeDifference()));
                        }
                        spv.setResidueApplyMny(s.getTotalNodeTaxDifference());
                    }
                } else if (SettleTypeEnum.\u8282\u70b9.getCode().equals(s.getSettleType())) {
                    settleType = "nodeSettle";
                    spv.setUltimateFlag(SettleUltimateFlagEnum.\u975e\u6700\u7ec8\u7ed3\u7b97.getCode());
                }
                if (s.getContractType() == 0) {
                    contractType = "laborsub";
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)spv.getContractType())) {
                        spv.setContractType(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
                        spv.setContractTypeName(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeName());
                    }
                } else if (s.getContractType() == 1) {
                    contractType = "prosub";
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)spv.getContractType())) {
                        spv.setContractType(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
                        spv.setContractTypeName(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeName());
                    }
                } else {
                    this.logger.info("\u7ed3\u7b97\u5355\u5408\u540c\u7c7b\u578b\u672a\u77e5\u7ed3\u7b97\u5355id-{}", (Object)s.getId());
                }
                spv.setBillCodeUrl("/ejc-prosub-frontend/#/" + settleType + "/" + contractType + "/card?id=" + s.getId());
                spv.setContractFlag(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCode());
                spv.setContractFlagName(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCodeName());
                spv.setHandleType(Integer.valueOf(0));
                this.service.fillOtherSettlePoolAttr(dbEntity, spv);
                CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
                if (!res.isSuccess()) break block23;
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId());
                if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(dbEntity.getPushPoolFlag())) {
                    dbEntity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                    this.service.saveOrUpdate((Object)dbEntity);
                }
                commonResponse = CommonResponse.success((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f\uff01");
            }
            catch (Exception e) {
                try {
                    this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId(), (Object)e);
                }
                catch (Throwable throwable) {
                    jedisTemplate.del(new String[]{"pushContractSettle::" + settleId.toString()});
                    throw throwable;
                }
                jedisTemplate.del(new String[]{"pushContractSettle::" + settleId.toString()});
            }
            jedisTemplate.del(new String[]{"pushContractSettle::" + settleId.toString()});
            return commonResponse;
        }
        jedisTemplate.del(new String[]{"pushContractSettle::" + settleId.toString()});
        return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u5931\u8d25", (Object)s);
    }

    @ResponseBody
    @RequestMapping(value={"/settleRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> settleRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("orgId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7id\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("contractType")) {
            queryParam.getParams().put("contractType", new Parameter("eq", conditionMap.get("contractType")));
        }
        if (null != conditionMap.get("settleType")) {
            queryParam.getParams().put("settleType", new Parameter("eq", conditionMap.get("settleType")));
        }
        Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("filing_status", new Parameter("eq", (Object)0));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(queryParam, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), SettleVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u7ed3\u7b97\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @PostMapping(value={"/pushSettle2TargetCost"})
    public CommonResponse<String> pushSettle2TargetCost(@RequestBody Long settleId) {
        this.service.pushSettle2TargetCost(settleId);
        return CommonResponse.success((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u76ee\u6807\u6210\u672c\u6210\u529f\uff01");
    }
}

