package com.ejianc.business.prosub.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.prosub.vo.ContractSettleDetailsReportVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 分包合同实体
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {

    // 校验  劳务/专业分包合同-补充协议  【合同金额】控【补充协议金额】  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    List<ParamsCheckVO> supplementMnyCtrl(ContractVO contractVO);

    // 劳务分包合同-签订（即保存时）、补充协议 【总计划量】控【合同量】 合同量  > 总计划量*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    List<ParamsCheckVO> planNumCtrlContractNum(ContractVO contractVO);

    // 劳务分包合同-签订（即保存时）、补充协议 【总计划金额】控【合同金额】 合同金额  > 总计划金额*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    List<ParamsCheckVO> planMnyCtrlContractMny(ContractVO contractVO);

    // 劳务分包合同（含补充协议）  【施工合同金额-专业合同金额】控【劳务合同金额】
    List<ParamsCheckVO> contractionMnyCtrlLabConMny(ContractVO contractVO);

    boolean updatePerformanceStatusById( Long id);

    // 更新合同履约状态
    ContractVO updatePerformanceStatusByContractId(ContractVO vo);
    ContractVO insertOrUpdate(ContractVO saveorUpdateVO, String authority, Boolean isControl);

    String getLinkUrl(ContractVO entity);

    String getLinkUrl(Long contractId);

    Map<String, Object> countContractAmount(QueryParam param);

    ContractVO queryDetail(Long id);

    ContractVO querySupplementRecord(Long id);

    ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO, Boolean isControl);

    String getSupplementLinkUrl(ContractVO contractVO);

    ContractVO addConvertByConId(Long contractId);

    CommonResponse<JSONObject> excelImportEquipment(HttpServletRequest request, HttpServletResponse response, Integer flag);


    Boolean addSupplementFlag(Long id);

    Boolean delContractFile(Long fileId, String authority);

    CommonResponse<String> deleteByIds(List<ContractVO> vos);

    ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType, String billType);

    /**
     * 合同推送合同池
     *
     * @param contract
     * @return
     */
    boolean pushContract(ContractVO contract);

    /**
     * 将合同从合同池删除
     *
     * @param id
     * @return
     */
    String delContractFromPool(Long id);

    /**
     * 删除当前合同的合同附件
     * @param id
     * @return
     */
    Integer deleteContractFileById(Long id);

    // 查询合同下所有单项结算末级清单
    IPage<ContractSettleDetailsReportVO> queryLabProSettleDetails(QueryParam queryParam, boolean exportFlag);

    IPage<ContractSettleDetailsReportVO> queryLabProSettleDetailsList(Integer pageNumber, Integer pageSize, Long contractDetailId, Integer settleType, Integer contractType, String detailWorkContent, String detailRule);

    ContractPaymentResultVO queryPaymentApplyList(Long id);

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

    /**
     * 分包合同目标成本推送数据
     *
     * @param id 合同id
     */
    void pushTargetCost(Long id);

    /**
     * 更新合同、合同池状态
     *
     * @param contractId
     * @param stateCode
     * @return
     */
    String changePerformanceStatus(Long contractId, String stateCode);


    /**
     * 根据招标id查询合同集合
     * @param targetResultIdList
     * @return
     */
    List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList);

    /**
     * 归档参数 filingTypeConfig 为
     *             o: 不做控制
     *             1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
     *             2： 合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
     * @return
     */
    String getFilingTypeConfig();

    /**
     * 通过归档参数校验是否能新增，
     * o: 不做控制
     * 1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
     * 2： 合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
     * @param contractId
     * @return
     */
    Boolean checkFilingType(Long contractId, String contractTypeCode);

    /**
     * 历史价控合同价
     * @param contractVO
     * @return
     */
    List<ParamsCheckVO>  historyPriceCtrlContractPrice(ContractVO contractVO);

    /**
     * 目标成本价控合同价
     * @param contractVO
     * @return
     */
    List<ParamsCheckVO> targetCostPriceCtrlContractPrice(ContractVO contractVO);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response,Integer flag);
}
