package com.ejianc.business.settle.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettlePriceVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 结算子表-分包清单
 *
 * @author generator
 */
@Mapper
public interface SettleDetailMapper extends BaseCrudMapper<SettleDetailEntity> {

    // 查询当前结算单的结算清单的所有合同清单的往期的本期结算量的累计值，查询时区分结算类型
    List<Map<String, Object>> queryCountSettleNumByContractSettleType(@Param("tenantId") Long tenantId, @Param("settleType") Integer settleType, @Param("contractDetailIdList") List<Long> contractDetailIdList, @Param("settleDetailIdList") List<Long> settleDetailIdList);

    /**
     * 查询结算清单子表数据和累计过程量
     *
     * @param contractId
     * @return
     */
    List<SettleDetailVO> selectDetailRecordAndTotalProcessNum(@Param(value = "contractId") Long contractId);
    /**
     * 查询结算清单累计结算金额
     *
     * @param ids
     * @return
     */
    List<SettleDetailVO> queryDetailSumMny(@Param(value = "ids") List<Long> ids);

    /**
     * 查询结算价格调整清单累计结算金额
     *
     * @param ids
     * @return
     */
    List<SettlePriceVO> queryPriceSumMny(@Param(value = "ids") List<Long> ids);

    /**
     * 查询结算清单累计节点量
     *
     * @param contractId
     * @return
     */
    List<SettleDetailVO> selectDetailTotalNodeNum(@Param(value = "contractId") Long contractId);

    List<SettleDetailEntity> queryDetailList(@Param(value = "settleType") Integer settleType,
                                             @Param(value = "contractId") Long contractId,
                                             @Param(value = "settleDate") Date settleDate);

    IPage<SettleDetailEntity> queryPageDetail(Page<SettleDetailEntity> page,
                                              @Param(value = "settleType") Integer settleType,
                                              @Param(value = "contractId") Long contractId,
                                              @Param(value = "searchText") String searchText,
                                              @Param(value = "oldDelIdList") List<String> oldDelIdList);

    List<SettleDetailEntity> queryContractDetail(@Param(value = "contractId") Long contractId);

    List<SettleDetailVO> queryNodeAndProcessNum(@Param(value = "contractId") Long contractId);
}
