/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.control.bean.ControlChangeEntity;
import com.ejianc.business.control.bean.ControlDetailChangeEntity;
import com.ejianc.business.control.bean.ControlDetailChangeFiveEntity;
import com.ejianc.business.control.bean.ControlDetailChangeFourEntity;
import com.ejianc.business.control.bean.ControlDetailChangeThreeEntity;
import com.ejianc.business.control.bean.ControlDetailChangeTwoEntity;
import com.ejianc.business.control.bean.ControlEntity;
import com.ejianc.business.control.mapper.ControlChangeHisMapper;
import com.ejianc.business.control.mapper.ControlChangeMapper;
import com.ejianc.business.control.service.IControlChangeService;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.ControlChangeHisVO;
import com.ejianc.business.control.vo.ControlChangeVO;
import com.ejianc.business.control.vo.ControlDetailChangeVO;
import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="controlChangeService")
public class ControlChangeServiceImpl
extends BaseServiceImpl<ControlChangeMapper, ControlChangeEntity>
implements IControlChangeService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IControlChangeService controlChangeService;
    @Autowired
    private IControlService controlService;
    private static final String BILL_CODE = "SUB_CONTROL_CHANGE";
    private static final String CONTROL_COST_CODE = "P-i3X5840010";
    private static final String CONTROL_COST_DETAIL_CODE = "P-94k78t0012";
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";
    @Autowired
    private IBuildDutyApi buildDutyApi;
    @Autowired
    private ControlChangeMapper controlChangeMapper;
    @Autowired
    private ControlChangeHisMapper controlChangeHisMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private final String PC_XM_CHANGE_URL = "ejc-prosub-frontend/#/changeCard/card?id=";
    private final String PC_KJXY_CHANGE_URL = "ejc-prosub-frontend/#/subcontractPriceChangeHisKJXY/card?id=";

    /*
     * WARNING - void declaration
     */
    @Override
    public ControlChangeVO saveOrUpdate(ControlChangeVO saveOrUpdateVO, Boolean isControl) {
        List<ControlDetailChangeFiveEntity> list;
        List<ControlDetailChangeFourEntity> list2;
        List<ControlDetailChangeThreeEntity> list3;
        List<ControlDetailChangeTwoEntity> controlDetailTwoList;
        List<ControlDetailChangeEntity> controlDetailList;
        ControlChangeEntity controlChangeEntity = this.controlChangeService.getUnFinishedChange(saveOrUpdateVO.getSourceControlId());
        if (!(null == controlChangeEntity || null != saveOrUpdateVO.getId() && controlChangeEntity.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u5ba1\u6838\u8868\uff01");
        }
        ControlEntity masterPlan = (ControlEntity)((Object)this.controlService.getById(saveOrUpdateVO.getSourceControlId()));
        UserContext userContext = this.sessionManager.getUserContext();
        ControlChangeEntity saveEntity = null;
        saveEntity = (ControlChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlChangeEntity.class));
        if (null == saveOrUpdateVO.getId()) {
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            saveEntity.setId(IdWorker.getId());
        }
        if (CollectionUtils.isNotEmpty(controlDetailList = saveEntity.getControlDetailList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeEntity controlDetailChangeEntity : controlDetailList) {
                controlDetailChangeEntity.setId(null);
                controlDetailChangeEntity.setParentId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(controlDetailTwoList = saveEntity.getControlDetailTwoList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeTwoEntity controlDetailChangeTwoEntity : controlDetailTwoList) {
                controlDetailChangeTwoEntity.setId(null);
                controlDetailChangeTwoEntity.setParentId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(list3 = saveEntity.getControlDetailThreeList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeThreeEntity controlDetailChangeThreeEntity : list3) {
                controlDetailChangeThreeEntity.setId(null);
                controlDetailChangeThreeEntity.setParentId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(list2 = saveEntity.getControlDetailFourList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeFourEntity controlDetailChangeFourEntity : list2) {
                controlDetailChangeFourEntity.setId(null);
                controlDetailChangeFourEntity.setParentId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(list = saveEntity.getControlDetailFiveList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeFiveEntity cdEntity : list) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        if (Boolean.FALSE.equals(isControl) && ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals((saveEntity = this.controlChangeService.saveOrUpdateControlChange(saveEntity)).getType())) {
            CommonResponse response;
            void var12_27;
            boolean bl = false;
            if (saveOrUpdateVO.getId() == null) {
                boolean bl2 = true;
            } else {
                boolean bl3;
                ControlChangeEntity dbEntity = (ControlChangeEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
                boolean bl4 = bl3 = dbEntity == null;
            }
            if (var12_27 != false) {
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVO1 = this.getLastExecutionVO(saveEntity.getSourceControlId());
                totalExecutionVOList.add(executionVO1.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(totalExecutionVOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                response = this.executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
            String linkUrl = this.getLinkUrl(saveEntity.getId(), saveEntity.getType());
            ExecutionVO executionVO = this.controlService.targetCost((ControlVO)BeanMapper.map((Object)((Object)saveEntity), ControlVO.class), linkUrl, saveEntity.getSubType(), ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(saveEntity.getType()) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode());
            this.logger.info("\u5408\u540c\u53d8\u66f4\u4fdd\u5b58\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a {}", (Object)JSON.toJSONString((Object)executionVO));
            response = this.executionApi.aggPush(executionVO);
            this.logger.info("\u5408\u540c\u53d8\u66f4\u4fdd\u5b58\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        ControlChangeVO controlChangeVO = (ControlChangeVO)BeanMapper.map((Object)((Object)saveEntity), ControlChangeVO.class);
        return controlChangeVO;
    }

    private ExecutionVO getLastExecutionVO(Long sourceControlId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"source_control_id", (Object)sourceControlId)).orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)wrapper);
        ControlChangeEntity tmp = null;
        String linkUrl = null;
        if (!list.isEmpty()) {
            tmp = (ControlChangeEntity)((Object)list.get(0));
            tmp = (ControlChangeEntity)((Object)super.selectById((Serializable)tmp.getId()));
            linkUrl = this.getLinkUrl(tmp.getId(), tmp.getType());
            return this.controlService.targetCost((ControlVO)BeanMapper.map((Object)((Object)tmp), ControlVO.class), linkUrl, tmp.getSubType(), tmp.getSubType().equals(0) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode());
        }
        ControlEntity controlEntity = (ControlEntity)((Object)this.controlService.selectById(sourceControlId));
        linkUrl = this.controlService.getLinkUrl(controlEntity.getId(), controlEntity.getType());
        return this.controlService.targetCost((ControlVO)BeanMapper.map((Object)((Object)controlEntity), ControlVO.class), linkUrl, controlEntity.getSubType(), ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(controlEntity.getType()) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode());
    }

    @Override
    public String getLinkUrl(Long id, Integer type) {
        return this.getBaseHost() + (ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(type) ? "ejc-prosub-frontend/#/changeCard/card?id=" : "ejc-prosub-frontend/#/subcontractPriceChangeHisKJXY/card?id=") + id;
    }

    private String getBaseHost() {
        return StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ControlChangeEntity saveOrUpdateControlChange(ControlChangeEntity saveEntity) {
        super.saveOrUpdate((Object)saveEntity, false);
        ControlEntity controlEntity = (ControlEntity)((Object)this.controlService.selectById(saveEntity.getSourceControlId()));
        if (1 != controlEntity.getChangeState()) {
            controlEntity.setChangeState(1);
            controlEntity.setChangeId(saveEntity.getId());
            this.controlService.saveOrUpdate((Object)controlEntity, false);
        }
        return saveEntity;
    }

    @Override
    public ControlChangeEntity getUnFinishedChange(Long sourceControlId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_control_id", (Object)sourceControlId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (ControlChangeEntity)((Object)this.controlChangeMapper.selectOne((Wrapper)query));
    }

    @Override
    public List<ControlChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ControlChangeEntity::getSourceControlId, (Object)id);
        lambda.in(ControlChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        List recordVOList = BeanMapper.mapList((Iterable)entities, ControlChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getControlCode() + "-0" + recordVO.getChangeVersion());
            } else {
                recordVO.setHistoryCode(recordVO.getControlCode() + "-" + recordVO.getChangeVersion());
            }
            recordVO.setChangeCode(recordVO.getControlCode());
        });
        return recordVOList;
    }

    private String responseIsCost(ControlChangeVO controlVO) {
        List laborDetailList;
        List proSubDetailList;
        CommonResponse response = this.paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        Integer subType = controlVO.getSubType();
        Map<Object, Object> costMap = new HashMap();
        if (subType == 1 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(proSubDetailList = buildDutyVO.getProSubDetailList()))) {
            costMap = proSubDetailList.stream().filter(s -> s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BaseVO::getId));
        }
        if (subType == 2 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(laborDetailList = buildDutyVO.getLaborDetailList()))) {
            costMap = laborDetailList.stream().filter(s -> s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BaseVO::getId));
        }
        if ("1".equals(valueData)) {
            return "1";
        }
        if ("0".equals(valueData) && (buildDutyVO == null || buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)) {
            throw new BusinessException("\u9879\u76ee\u672a\u505a\u9879\u76ee\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        return "1";
    }

    private String responseDetailIsCost(ControlChangeVO controlVO) {
        CommonResponse responseDetail;
        List laborDetailList;
        List proSubDetailList;
        CommonResponse response = this.paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null) {
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }
        Integer subType = controlVO.getSubType();
        Map<Object, Object> costMap = new HashMap();
        if (subType == 1 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(proSubDetailList = buildDutyVO.getProSubDetailList()))) {
            costMap = proSubDetailList.stream().filter(s -> s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BaseVO::getId));
        }
        if (subType == 2 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(laborDetailList = buildDutyVO.getLaborDetailList()))) {
            costMap = laborDetailList.stream().filter(s -> s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BaseVO::getId));
        }
        if (!(responseDetail = this.paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE)).isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + responseDetail.getMsg());
        }
        String valueDataDetail = ((ParamRegisterSetVO)responseDetail.getData()).getValueData();
        Assert.hasText((String)valueDataDetail, (String)"\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("1".equals(valueDataDetail)) {
            return "1";
        }
        if ("0".equals(valueDataDetail)) {
            List controlDetailFourList;
            List controlDetailThreeList;
            List controlDetailTwoList;
            List controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty((Collection)controlDetailList)) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().filter(s -> s.getChangeType() == null || s.getChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb51\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailTwoList = controlVO.getControlDetailTwoList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().filter(s -> s.getTwoChangeType() == null || s.getTwoChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb52\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailThreeList = controlVO.getControlDetailThreeList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().filter(s -> s.getThreeChangeType() == null || s.getThreeChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb53\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailFourList = controlVO.getControlDetailFourList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().filter(s -> s.getFourChangeType() == null || s.getFourChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb54\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
        }
        return "1";
    }

    private List<ParamsCheckVO> checkControlAllMny(ControlChangeVO controlVO) {
        CommonResponse billParamByCode;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        HashMap numMasterPlanMap = new HashMap();
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null) {
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info(" \u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7>\u7b56\u5212\u6210\u672c\u603b\u4ef7*X%\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal compareNum = ComputeUtil.safeMultiply((BigDecimal)planedTotalCostTaxMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)controlVO.getControlTaxMny(), (BigDecimal)compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u5927\u4e8e\u7b56\u5212\u6210\u672c\u603b\u4ef7");
                        paramsCheckDsVO.setWarnName("\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u5927\u4e8e\u7b56\u5212\u6210\u672c\u603b\u4ef7");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u4e3a:").append(ComputeUtil.nullToZero((BigDecimal)controlVO.getControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u603b\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)controlVO.getControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO checkParams(ControlChangeVO vo, Object o) {
        String status = this.responseIsCost(vo);
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkControlAllMny(vo));
        this.responseDetailIsCost(vo);
        paramsCheckVOS.addAll(this.checkControlDetailMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public void deleteChangeControl(List<Long> changeIds) {
        List changeList = this.controlChangeMapper.selectBatchIds(changeIds);
        List controlIds = changeList.stream().map(ControlChangeEntity::getSourceControlId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", controlIds);
        List controlEntities = this.controlService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_control_id as planId"});
        query.in((Object)"source_control_id", controlIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_control_id"});
        List queryResult = this.controlChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        ArrayList<Long> sourceControlIds = new ArrayList<Long>();
        Iterator iterator = controlEntities.iterator();
        while (iterator.hasNext()) {
            ControlEntity control;
            control.setChangeState(null != hisCountNumMap.get((control = (ControlEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(control.getId()) > 0 ? 2 : 0);
            control.setChangeId(null);
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (Long changeId : changeIds) {
                ControlChangeEntity changeEntity = (ControlChangeEntity)((Object)super.selectById((Serializable)changeId));
                if (!ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(changeEntity.getType())) continue;
                ExecutionVO executionVO = this.controlService.targetCost((ControlVO)BeanMapper.map((Object)((Object)changeEntity), ControlVO.class), this.getLinkUrl(changeEntity.getId(), changeEntity.getType()), changeEntity.getSubType(), changeEntity.getType().equals(0) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode());
                totalExecutionVOList.add(executionVO.getTotalVO());
                sourceControlIds.add(changeEntity.getSourceControlId());
            }
            this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u5220\u9664\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString(totalExecutionVOList));
            if (!CollectionUtils.isNotEmpty(totalExecutionVOList)) continue;
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)response));
            if (response.isSuccess()) continue;
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        if (CollectionUtils.isNotEmpty(sourceControlIds)) {
            ExecutionVO executionVO = null;
            for (Long controlId : sourceControlIds) {
                executionVO = this.getLastExecutionVO(controlId);
                this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u65e7\u7248\u672c\u6570\u636e: {}", (Object)JSON.toJSONString((Object)executionVO));
                CommonResponse responses = this.executionApi.aggPush(executionVO);
                this.logger.info("\u5408\u540c\u53d8\u66f4\u5220\u9664\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u65e7\u7248\u672c\u6570\u636e: {}", (Object)JSON.toJSONString((Object)responses));
                if (responses.isSuccess()) continue;
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + responses.getMsg());
            }
        }
        this.controlService.saveOrUpdateBatch(controlEntities, controlEntities.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlChangeVO controlVO) {
        CommonResponse billParamByCode;
        List laborDetailList;
        List proSubDetailList;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        List controlDetailList = controlVO.getControlDetailList();
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        Integer subType = controlVO.getSubType();
        Map<Object, Object> costMap = new HashMap();
        if (subType == 1 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(proSubDetailList = buildDutyVO.getProSubDetailList()))) {
            costMap = proSubDetailList.stream().filter(s -> s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
        }
        if (subType == 2 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(laborDetailList = buildDutyVO.getLaborDetailList()))) {
            costMap = laborDetailList.stream().filter(s -> s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId())).isSuccess() && null != billParamByCode.getData()) {
            StringBuffer stringBuffer;
            ParamsCheckDsVO paramsCheckDsVO;
            BigDecimal compareNum;
            BigDecimal roleValue;
            ArrayList<ParamsCheckDsVO> checkDsVOS;
            ParamsCheckVO paramsCheckVO;
            BigDecimal costMny;
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (ControlDetailChangeVO detailVO : controlVO.getControlDetailList()) {
                    if ("del".equals(detailVO.getRowState())) continue;
                    costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        paramsCheckVO = new ParamsCheckVO();
                        checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getControlTaxMny(), (BigDecimal)compareNum)) {
                            paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb51\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d: ").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                for (ControlDetailChangeVO detailVO : controlVO.getControlDetailTwoList()) {
                    if ("del".equals(detailVO.getRowState())) continue;
                    costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        paramsCheckVO = new ParamsCheckVO();
                        checkDsVOS = new ArrayList();
                        roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getTwoControlTaxMny(), (BigDecimal)compareNum)) {
                            paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb52\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getTwoControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getTwoControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
            for (ControlDetailChangeVO detailVO : controlVO.getControlDetailThreeList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    paramsCheckVO = new ParamsCheckVO();
                    checkDsVOS = new ArrayList();
                    roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getThreeControlTaxMny(), (BigDecimal)compareNum)) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb53\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getThreeControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getThreeControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
            for (ControlDetailChangeVO detailVO : controlVO.getControlDetailFourList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    paramsCheckVO = new ParamsCheckVO();
                    checkDsVOS = new ArrayList();
                    roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getFourControlTaxMny(), (BigDecimal)compareNum)) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb54\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getFourControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getFourControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }
}

