package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.promaterial.contract.vo.ContractChangeVO;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ChangeStatusEnum;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.vo.ChangeVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包变更实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("change")
public class ChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IChangeService service;

    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IParamCheckApi paramCheckApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeVO> saveOrUpdate(@RequestBody ChangeVO saveorUpdateVO) {
        ChangeVO vo = service.insertOrUpdate(saveorUpdateVO, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetail(Long id) {
    	ChangeVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVO> vos) {
        //变更删除 删除变更单据，删除推送数据，推送上一版数据

        if(CollectionUtils.isNotEmpty(vos)) {
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            List<ContractEntity>  contractEntityList = new ArrayList<>();
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = BASE_HOST;
            }
            for (ChangeVO ChangeVO : vos) {
                ChangeEntity changeEntity = service.selectById(ChangeVO.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(changeEntity, ChangeVO.class),"",changeEntity.getContractType(), changeEntity.getContractType().equals(0) ? ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode(), false);
                totalExecutionVOList.add(executionVO.getTotalVO());
               // ContractVO contractVO = contractService.queryDetail(changeVO.getContractId());
                contractEntityList.add(contractService.selectById(changeEntity.getContractId()));
            }
            logger.info("合同变更删除，删除目标成本删除数据:{}", JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            logger.info("合同变更删除，目标成本删除数据结果:{}", JSON.toJSONString(response));
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }

            //推送上一版数据
            ExecutionVO executionVO = null;
            String linkUrl;
            ChangeVO tmpChange = null;
            ContractVO tmpContract = null;
           for(ContractEntity contractEntity:contractEntityList) {
               //目标成本推送
               List<ChangeEntity> changeEntities = service.list(new QueryWrapper<ChangeEntity>().eq("contract_id", contractEntity.getId()).orderByDesc("change_version"));
               // 判断是否有其他合同变更
               if (changeEntities.size() > 1) {
                   tmpChange = BeanMapper.map(changeEntities.get(1), ChangeVO.class);
                   executionVO = service.targetCost(tmpChange, service.getLinkUrl(tmpChange), tmpChange.getContractType(),
                          service.getBillType(tmpChange.getId(), tmpChange.getContractType()), false);
               } else {
                   tmpContract = BeanMapper.map(contractEntity, ContractVO.class);
                   executionVO = contractService.targetCost(tmpContract, contractService.getLinkUrl(tmpContract), tmpContract.getContractType(),
                           contractService.getBillType(tmpContract.getId(), tmpContract.getContractType()));
               }
               logger.info("合同变更删除，目标成本推送旧版本数据: {}", JSON.toJSONString(executionVO));
               CommonResponse<String> responses = executionApi.aggPush(executionVO);
               logger.info("合同变更删除，目标成本推送旧版本数据: {}", JSON.toJSONString(responses));
               if (!response.isSuccess()) {
                   throw new BusinessException("目标成本推送失败," + responses.getMsg());
               }
           }
        }
        return service.deleteById(vos.get(0).getId());
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            return CommonResponse.error("查询失败，获取本下组织信息失败！");
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeEntity> page = service.queryPage(param,false);
        IPage<ChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description saveOrUpdate 查询当前合同下变更列表
     * @param id
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetailRecord(Long id) {
        ChangeVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更需要的主合同字段
     * @param contractId
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> addConvertByConId(Long contractId, Long changeId) {
        ChangeVO vo = service.addConvertByConId(contractId, changeId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Author yangst
     * @Description  查询变更对比
     * @param
     */
    @RequestMapping(value = "/queryChangeCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map returnMap = service.queryChangeCompare(id);
        return CommonResponse.success("新增转换数据成功！", returnMap);
    }

    /**
     * @Author yangst
     * @Description  查询变更记录
     * @param
     */
    @RequestMapping(value = "/queryChangeRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> queryChangeRecord(Long contractId, Long changeId) {
        ChangeVO vo = service.queryChangeRecord(contractId, changeId);
        return CommonResponse.success("变更记录查询成功！",vo);
    }

    /**
     * 变更合同签章流程queryDetailRecord
     * @param
     * @return
     */
    @RequestMapping(value = "/changeSignatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeSignatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ChangeEntity changeEntity = service.selectById(id);
        if (changeEntity != null){
            changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
            changeEntity.setEffectiveDate(new Date());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode().toString());
            changeEntity.setChangeFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            service.saveOrUpdate(changeEntity);

            //回写主合同（变更合同签章状态，主合同变更状态）
            LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
            updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.已变更.getCode());
            contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
        }
        return CommonResponse.success();
    }



    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ChangeVO changeVO) {
        ChangeVO cv = service.insertOrUpdate(changeVO, true);
//        目标成本推送
        String linkUrl = service.getLinkUrl(cv);
        ExecutionVO executionVO = service.targetCost(cv,linkUrl,cv.getContractType(), changeVO.getContractType().equals(0) ? ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode(), true);
        logger.error("合同变更，目标成本数据校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        logger.error("合同变更，目标成本数据校验结果：{}" , JSONObject.toJSONString(response));

        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = paramCheck(changeVO, null, false);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        ChangeEntity entity = service.selectById(id);
        ChangeVO cv = BeanMapper.map(entity, ChangeVO.class);
        //目标成本推送
        String linkUrl = service.getLinkUrl(cv);
        ExecutionVO executionVO = service.targetCost(cv,linkUrl,cv.getContractType(), cv.getContractType().equals(0) ? ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode(), false);
        logger.error("合同变更，目标成本数据校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        logger.error("合同变更，目标成本数据校验结果：{}" , JSONObject.toJSONString(response));

        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = paramCheck(cv, null, true);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    /**
     * 劳务/专业分包合同-变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * 劳务分包合同-变更 【总计划量】控【合同量】 合同量  > 总计划量*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * 劳务分包合同-变更 【总计划金额】控【合同金额】 合同金额  > 总计划金额*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * 【施工合同】控【支出合同金额】接口
     *
     * @param changeVO
     * @param response
     * @param flag 是否是新增的数据：true是，false否
     * @return
     */
    private ParamsCheckVO paramCheck(@RequestBody ChangeVO changeVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
//        ParamsCheckVO responseData = response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();

        List<ParamsCheckVO> allCheck = new ArrayList<>();
        // 【合同金额】控【变更金额】
        allCheck.addAll(service.changeMnyCtrl(changeVO));

        // 【总计划量】控【合同量】
        allCheck.addAll(service.planNumCtrlContractNum(changeVO));

        // 【总计划金额】控【合同金额】
        allCheck.addAll(service.planMnyCtrlContractMny(changeVO));

        // 历史价控 合同价
        allCheck.addAll(service.historyPriceCtrlContractPrice(changeVO));

        // 目标成本价控 合同价
        logger.info("变更合同 目标成本价控 合同价 start");
        allCheck.addAll(service.targetCostPriceCtrlContractPrice(changeVO));
        logger.info("变更合同 目标成本价控 合同价 end");


        // 【施工合同】控【支出合同金额】 接口
        CommonResponse<List<ParamsCheckVO>> ctrlOutConMnyRes = paramCheckApi.paramsCheck(changeVO.getProjectId(), changeVO.getMainContractId(), changeVO.getContractTaxMny(), changeVO.getOrgId());
        if (ctrlOutConMnyRes.isSuccess() && ctrlOutConMnyRes.getData() != null) {
            allCheck.addAll(ctrlOutConMnyRes.getData());
        }

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }

        //如果目标成本预警登记小于等于参数控制预警登记
//        if(null == responseData.getWarnType() || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
//            for(ParamsCheckVO p : result) {
//                resp.getDataSource().addAll(p.getDataSource());
//            }
//        } else if(ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
//
//            if(CollectionUtils.isNotEmpty(responseData.getDataSource())) {
//                resp.getDataSource().addAll(responseData.getDataSource());
//            }
//
//            for(ParamsCheckVO p : result) {
//                resp.getDataSource().addAll(p.getDataSource());
//            }
//        } else { //否则
//            return responseData;
//        }

        return resp;
    }
}
