package com.ejianc.business.settle.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 结算子表-领料结算
 *
 * @author generator
 */
@TableName("ejc_prosub_settle_picking")
public class SettlePickingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "use_flag")
    private Integer useFlag; // 是否引用过,否-0，是-1
    @TableField(value = "settle_id")
    private Long settleId; // 结算id
    @TableField(value = "contract_id")
    private Long contractId; // 合同id
    @TableField(value = "contract_type")
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value = "settle_type")
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    @TableField(value = "project_id")
    private Long projectId; // 项目Id
    @TableField(value = "settle_date")
    private Date settleDate; // 结算日期
    @TableField(value = "source_id")
    private Long sourceId; // 领料结算id
    @TableField(value = "source_bill_code")
    private String sourceBillCode; // 单据单号
    @TableField(value = "picking_tax_mny")
    private BigDecimal pickingTaxMny; // 领料扣款金额
    @TableField(value = "picking_mny")
    private BigDecimal pickingMny; // 领料扣款金额(无税)
    @TableField(value = "picking_tax")
    private BigDecimal pickingTax; // 领料扣款金额税额
    @TableField(value = "picking_date")
    private Date pickingDate; // 领料结算日期
    @TableField(value = "memo")
    private String memo; // 备注 默认为空，非必填，0-30字


    @TableField(value="cost_mny")
    private BigDecimal costMny; // '成本金额'
    @TableField(value="cost_tax_mny")
    private BigDecimal costTaxMny; // 成本金额（含税）
    @TableField(value="cost_tax")
    private BigDecimal costTax; // 成本税额

    @TableField(value = "picking_wbs_id")
    private Long pickingWbsId; // 核算对象主键
    @TableField(value = "picking_wbs_name")
    private String pickingWbsName; // 核算对象名称
    @TableField(value = "picking_wbs_code")
    private String pickingWbsCode; // 核算对象编码
    @TableField(value = "picking_subject_id")
    private Long pickingSubjectId; // 成本科目主键
    @TableField(value = "picking_subject_name")
    private String pickingSubjectName; // 成本科目名称
    @TableField(value = "picking_subject_code")
    private String pickingSubjectCode; // 成本科目编码

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }

    public BigDecimal getCostTax() {
        return costTax;
    }

    public void setCostTax(BigDecimal costTax) {
        this.costTax = costTax;
    }

    public Long getPickingWbsId() {
        return pickingWbsId;
    }

    public void setPickingWbsId(Long pickingWbsId) {
        this.pickingWbsId = pickingWbsId;
    }

    public String getPickingWbsName() {
        return pickingWbsName;
    }

    public void setPickingWbsName(String pickingWbsName) {
        this.pickingWbsName = pickingWbsName;
    }

    public String getPickingWbsCode() {
        return pickingWbsCode;
    }

    public void setPickingWbsCode(String pickingWbsCode) {
        this.pickingWbsCode = pickingWbsCode;
    }

    public Long getPickingSubjectId() {
        return pickingSubjectId;
    }

    public void setPickingSubjectId(Long pickingSubjectId) {
        this.pickingSubjectId = pickingSubjectId;
    }

    public String getPickingSubjectName() {
        return pickingSubjectName;
    }

    public void setPickingSubjectName(String pickingSubjectName) {
        this.pickingSubjectName = pickingSubjectName;
    }

    public String getPickingSubjectCode() {
        return pickingSubjectCode;
    }

    public void setPickingSubjectCode(String pickingSubjectCode) {
        this.pickingSubjectCode = pickingSubjectCode;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public BigDecimal getPickingTaxMny() {
        return pickingTaxMny;
    }

    public void setPickingTaxMny(BigDecimal pickingTaxMny) {
        this.pickingTaxMny = pickingTaxMny;
    }

    public BigDecimal getPickingMny() {
        return pickingMny;
    }

    public void setPickingMny(BigDecimal pickingMny) {
        this.pickingMny = pickingMny;
    }

    public BigDecimal getPickingTax() {
        return pickingTax;
    }

    public void setPickingTax(BigDecimal pickingTax) {
        this.pickingTax = pickingTax;
    }

    public Date getPickingDate() {
        return pickingDate;
    }

    public void setPickingDate(Date pickingDate) {
        this.pickingDate = pickingDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
