/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.mapper.AdjustMapper;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.AdjustVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="adjustService")
public class AdjustServiceImpl
extends BaseServiceImpl<AdjustMapper, AdjustEntity>
implements IAdjustService {
    private static final String BILL_CODE = "ADJUST_CODE";
    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public AdjustVO insertOrUpdate(AdjustVO saveOrUpdateVO) {
        AdjustEntity entity = (AdjustEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AdjustEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getAdjustDetailList())) {
            HashSet<String> useTypeSet = new HashSet<String>();
            List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
            for (AdjustDetailEntity detailEntity : detailList) {
                if ("del".equals(detailEntity.getRowState()) || !StringUtils.isNotBlank((String)detailEntity.getDetailUseTypeName())) continue;
                useTypeSet.add(detailEntity.getDetailUseTypeName());
            }
            if (CollectionUtils.isNotEmpty(useTypeSet)) {
                entity.setUseType(String.join((CharSequence)",", useTypeSet));
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        return (AdjustVO)BeanMapper.map((Object)((Object)entity), AdjustVO.class);
    }

    @Override
    public AdjustVO queryDetail(Long id) {
        AdjustEntity entity = (AdjustEntity)((Object)this.service.selectById(id));
        AdjustVO vo = (AdjustVO)BeanMapper.map((Object)((Object)entity), AdjustVO.class);
        return vo;
    }

    private static void sortIntMethod(List<AdjustDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                AdjustDetailVO o1Detail = (AdjustDetailVO)objectMapper.convertValue(o1, AdjustDetailVO.class);
                AdjustDetailVO o2Detail = (AdjustDetailVO)objectMapper.convertValue(o2, AdjustDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }
}

