package com.ejianc.business.prosub.pricelib.controller;

import com.ejianc.business.prosub.pricelib.service.IPriceContractCollectService;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.*;

/**
 * 分包价格库清单明细实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceContractCollect")
public class PriceContractCollectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceContractCollectService service;


    /**
     * @Description shelfGoods 价格库列表数据到历史表定时任务
     */
    @RequestMapping(value = "/savePriceContractCollect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePriceContractCollect(HttpServletRequest request) {
        service.savePriceContractToHistoryByTiming();
        return CommonResponse.success("价格库列表数据到历史表定时任务处理成功");
    }


    //查询多个档案清单历史价格
    @PostMapping("/getPriceContractByDocIds")
    @ResponseBody
    public CommonResponse<List<PriceContractCollectVO>> getPriceContractByDocIds(@RequestBody List<Long> docIds){
        logger.info("档案id集合【{}】", docIds);
        List<PriceContractCollectVO> PriceContractCollectVOList = service.getPriceContractByDocIds(docIds);
        return CommonResponse.success("查询成功！",PriceContractCollectVOList);
    }

}
