/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.MeasureDetailEntity;
import com.ejianc.business.process.bean.MeasureEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IMeasureDetailService;
import com.ejianc.business.process.service.IMeasureService;
import com.ejianc.business.process.vo.MeasureVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"measure"})
public class MeasureController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SUB_MEA";
    @Autowired
    private IMeasureService service;
    @Autowired
    private IMeasureDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IUserApi userApi;
    private final String billTypeCode = "BT211227000000002";
    @Autowired
    private IContractService contractService;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subMeasure/card";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<MeasureVO> saveOrUpdate(@RequestBody MeasureVO saveOrUpdateVO) {
        MeasureEntity entity = (MeasureEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MeasureEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        List<MeasureDetailEntity> detailList = entity.getMeasureDetailList();
        BigDecimal total = BigDecimal.ZERO;
        if (!detailList.isEmpty()) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            int detailListSize = detailList.size();
            for (int i = 0; i < detailListSize; ++i) {
                MeasureDetailEntity detail = detailList.get(i);
                BigDecimal lastWorkNum = this.detailService.queryLastWorkNum(detail.getListId(), detail.getId());
                BigDecimal measure = detail.getMeasure();
                if (lastWorkNum != null && measure != null) {
                    if (lastWorkNum.add(measure).compareTo(detail.getWorkNum()) == 1) {
                        rows.add(i + 1);
                    }
                } else {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u8be5\u6e05\u5355\u5386\u53f2\u8ba1\u91cf\u548c\u672c\u6b21\u8ba1\u91cf\u662f\u5426\u4e3a\u7a7a\uff01");
                }
                total = total.add(detail.getListTaxMny());
            }
            if (CollectionUtils.isNotEmpty(rows)) {
                String rowIds = StringUtils.join(rows, (String)",");
                String warning = "\u672c\u6b21\u8ba1\u91cf\u4e0d\u5f97\u8d85\u8fc7\u5408\u540c\u5269\u4f59\u91cf\uff0c\u8bf7\u68c0\u67e5\u7b2c" + rowIds + "\u884c\uff01";
                throw new BusinessException(warning);
            }
        }
        entity.setTotalTaxMny(total);
        this.service.saveOrUpdate((Object)entity, false);
        MeasureVO vo = (MeasureVO)BeanMapper.map((Object)((Object)entity), MeasureVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<MeasureVO> queryDetail(Long id) {
        MeasureEntity entity = (MeasureEntity)((Object)this.service.selectById(id));
        MeasureVO vo = (MeasureVO)BeanMapper.map((Object)((Object)entity), MeasureVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<MeasureVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MeasureVO measureVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<MeasureVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        List dataList = new ArrayList();
        IPage page = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            if (null == param.getParams().get("orgId")) {
                page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            } else {
                page = this.service.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            Long orgId = InvocationInfoProxy.getOrgId();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            page = this.service.queryPage(param, false);
            dataList = page.getRecords();
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(dataList, MeasureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List records = BeanMapper.mapList((Iterable)list, MeasureVO.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            MeasureVO item;
            item.setContractTypeStr((item = (MeasureVO)iterator.next()).getContractType() == 0 ? "\u52b3\u52a1\u5206\u5305" : "\u4e13\u4e1a\u5206\u5305");
            item.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
            item.setCreateTimeStr(sdf.format(item.getCreateTime()));
        }
        beans.put("records", records);
        ExcelExport.getInstance().export("measureExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMeasureData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<MeasureVO>> refMeasureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MeasureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(path={"/queryLastWorkNum"})
    public CommonResponse<BigDecimal> queryLastWorkNum(Long listId) {
        BigDecimal data = this.detailService.queryLastWorkNum(listId, null);
        return CommonResponse.success((String)"\u6e05\u5355\u5386\u53f2\u8ba1\u91cf\u67e5\u8be2\u6210\u529f\uff01", (Object)data);
    }

    @PostMapping(value={"/supSignSync"})
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @PostMapping(value={"/testPushBill"})
    public CommonResponse<String> testPushBill(@RequestBody Long id) {
        MeasureEntity entity = (MeasureEntity)((Object)this.service.selectById(id));
        System.out.println(this.BASE_HOST);
        CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode("BT211227000000002");
        this.service.pushBillToSupCenter(entity, "BT211227000000002", (CooperateVO)cooperateResp.getData());
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01~");
    }

    @GetMapping(value={"/getBillShareLink"})
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        MeasureEntity entity = (MeasureEntity)((Object)this.service.selectById(id));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode("BT211227000000002");
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)"BT211227000000002", (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter((MeasureEntity)((Object)BeanMapper.map((Object)((Object)entity), MeasureEntity.class)), "BT211227000000002", (CooperateVO)cooperateResp.getData());
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, "BT211227000000002", entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/subMeasure/card", null);
    }

    @RequestMapping(value={"/mnyCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody MeasureVO measureVO) {
        ParamsCheckVO responseData = this.paramCheck(measureVO, false);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @RequestMapping(value={"/mnyCtrlById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value="id") Long id) {
        MeasureEntity entity = (MeasureEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        MeasureVO measureVO = (MeasureVO)BeanMapper.map((Object)((Object)entity), MeasureVO.class);
        ParamsCheckVO responseData = this.paramCheck(measureVO, true);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    private ParamsCheckVO paramCheck(@RequestBody MeasureVO measureVO, boolean flag) {
        ParamsCheckVO responseData = this.service.mnyCtrl(measureVO, flag);
        return responseData;
    }

    @RequestMapping(value={"/contractMeasureRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> contractRegistrationRecord(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(id));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contract.getId());
        query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc((Object)"create_time");
        List list = this.service.list((Wrapper)query);
        resp.put("measureList", (Object)BeanMapper.mapList((Iterable)list, MeasureVO.class));
        BigDecimal totalMeasureTaxMny = BigDecimal.ZERO;
        for (MeasureEntity item : list) {
            totalMeasureTaxMny = totalMeasureTaxMny.add(item.getTotalTaxMny());
        }
        resp.put("contractTaxMny", (Object)contract.getContractTaxMny());
        resp.put("totalMeasureTaxMny", (Object)totalMeasureTaxMny);
        resp.put("measureRatio", (Object)totalMeasureTaxMny.multiply(new BigDecimal("100").divide(contract.getContractTaxMny(), 8, 4)));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }
}

