package com.ejianc.business.process.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.process.service.IRegistrationTeamService;
import com.ejianc.business.process.vo.TeamDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.process.mapper.TeamMapper;
import com.ejianc.business.process.bean.TeamEntity;
import com.ejianc.business.process.service.ITeamService;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 班组主表
 * 
 * @author generator
 * 
 */
@Service("teamService")
public class TeamServiceImpl extends BaseServiceImpl<TeamMapper, TeamEntity> implements ITeamService{
    @Autowired
    private IApplicationService applicationService;
    @Autowired
    private IRegistrationService registrationService;


    @Autowired
    private IRegistrationTeamService registrationTeamService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<Boolean> queryReferenceTeam(List<Long> ids) {
        //根据 当前班组id 查询 是否存在
        QueryWrapper applicationQuery = new QueryWrapper();
        applicationQuery.in("team_id",ids);
        applicationQuery.eq("dr",0);
        int countApp = applicationService.count(applicationQuery);
        if (countApp>0){
            logger.info("查询班组id--{}", JSONObject.toJSONString(ids));
            return CommonResponse.success("班组已被零工申请引用 不能删除",false);
        }
        QueryWrapper registrationQuery = new QueryWrapper();
        registrationQuery.in("team_id",ids);
        registrationQuery.eq("dr",0);
        int countReg = registrationService.count(registrationQuery);
        if (countReg>0){
            logger.info("查询班组id--{}", JSONObject.toJSONString(ids));
            return CommonResponse.success("班组已被零工登记引用 不能删除",false);
        }
        QueryWrapper registrationTeamQuery = new QueryWrapper();
        registrationTeamQuery.in("team_detail_id",ids);
        registrationTeamQuery.eq("dr",0);
        int countRegTea = registrationTeamService.count(registrationTeamQuery);
        if (countRegTea>0){
            logger.info("查询班组id--{}", JSONObject.toJSONString(ids));
            return CommonResponse.success("班组已被零工登记转口引用 不能删除",false);

        }

        return CommonResponse.success("删除成功",true );
   }


    public void queryRef(List<TeamDetailVO> detailVOS){
        if (CollectionUtil.isNotEmpty(detailVOS)){
            List<Long> ids = detailVOS.stream().map(TeamDetailVO::getId).collect(Collectors.toList());

        }

    }
}
