package com.ejianc.business.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.prosub.bean.*;
import com.ejianc.business.prosub.enums.*;
import com.ejianc.business.prosub.mapper.ChangeMapper;
import com.ejianc.business.prosub.mapper.ContractMapper;
import com.ejianc.business.prosub.service.*;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.*;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 分包变更实体
 *
 * @author generator
 *
 */
@Service("changeService")
public class ChangeServiceImpl extends BaseServiceImpl<ChangeMapper, ChangeEntity> implements IChangeService {


    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private IContractFileService contractFileService;

    @Autowired
    private IRecordService recordService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractClauseService contractClauseService;

    @Autowired
    private IContractPaymentService contractPaymentService;

    @Autowired
    private ChangeMapper changeMapper;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";

    //劳务分包合同单据编码
    private final String LABORSUB_Bill_CODE = "BT211108000000002";
    //劳务分包合同记录单据编码
    private final String LABORSUB_RECORD_Bill_CODE = "BT211108000000004";

    //专业分包合同单据编码
    private final String PROSUB_Bill_CODE = "BT220216000000003";
    //专业分包合同记录单据编码
    private final String PROSUB_RECORD_Bill_CODE = "BT220216000000005";

    //特种设备租赁合同单据编码
    private final String EQU_SUB_Bill_CODE = "EJCBT202505000002";
    //特种设备租赁合同记录单据编码
    private final String EQU_SUB_RECORD_Bill_CODE = "EJCBT202505000008";


    //其他分包合同单据编码
    private final String OTHER_SUB_Bill_CODE = "EJCBT202505000003";
    //其他分包合同记录单据编码
    private final String OTHER_SUB_RECORD_Bill_CODE = "EJCBT202505000009";

    @Autowired
    private IParamConfigApi paramConfigApi;

    // 劳务分包合同-变更
    // 【合同金额】控【变更金额】
    private final String LAB_CHANGE_PARAM_CODE = "P-26y61564";
    // 专业分包合同-变更  【合同金额】控【变更金额】
    private final String PRO_CHANGE_PARAM_CODE = "P-D73e5K68";

    // 劳务分包合同-签订、变更、补充协议  【总计划量】控【合同量】
    private final String LAB_CHANGE_PLAN_NUM_CTRL_CON_NUM = "P-29O92c0105";
    // 专业分包合同-签订、变更、补充协议  【总计划量】控【合同量】
    private final String PRO_CHANGE_PLAN_NUM_CTRL_CON_NUM = "P-90sLe50106";

    // 劳务分包合同-签订、变更、补充协议  【总计划金额】控【合同金额】
    private final String LAB_CHANGE_PLAN_MNY_CTRL_CON_MNY = "P-uOc2160107";
    // 专业分包合同-签订、变更、补充协议  【总计划金额】控【合同金额】
    private final String PRO_CHANGE_PLAN_MNY_CTRL_CON_MNY = "P-66ZB8r0108";

    // 劳务分包合同-签订、变更、补充协议  【分包清单历史最高价】 控【劳务分包合同价格】
    private final String LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-51g2FF0175";
    // 专业分包合同-签订、变更、补充协议  【分包清单历史最高价】 控【专业分包合同价格】
    private final String PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-66o3LH0177";
    // 劳务分包合同-签订、变更、补充协议  【分包清单历史最低价】 控【劳务分包合同价格】
    private final String LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-sT2I640176";
    // 专业分包合同-签订、变更、补充协议  【分包清单历史最低价】 控【专业分包合同价格】
    private final String PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-1L8c900178";
    // 分包价格库查询类型 0、全部 1、综合单价
    private static final String PRICE_LIB_CHECK_TYPE = "P-5ukonG0162";
    // 劳务分包合同-签订、变更、补充协议  【目标成本价】 控【劳务分包合同价格】
    private final String LAB_TARGET_COST_PRICE_CTRL_CON_PRICE = "P-1A7To00217";
    // 专业分包合同-签订、变更、补充协议  【目标成本价】 控【专业分包合同价格】
    private final String PRO_TARGET_COST_PRICE_CTRL_CON_PRICE = "P-8YTKj60216";

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IPlanService planService;

    @Autowired
    private ContractMapper contractMapper;

    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Autowired
    private IDutyApi dutyApi;

    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    @Autowired
    private IShareEquipmentApi equipmentApi;

    /**
     * @Description saveOrUpdate 查询当前合同下变更列表
     * @param id
     */
    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);
        ChangeVO changeVO = new ChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        param.getParams().put("performance_status", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getOrderMap().put("change_date", QueryParam.DESC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(change_mny) as sumChangeMoney, count(*) as changeNum");
        resp = super.getMap(wrapper);

        //设置变更详情
        changeVO.setChangeList(BeanMapper.mapList(queryList(param), ChangeVO.class));

        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
            changeAmtRate = (sumChangeMoney.divide(contractEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
        }

        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long) resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        changeVO.setContractType(contractEntity.getContractType());

        //判断能否新增变更
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus())))){
            //归档参数控制校验
            Boolean contractFilingFlag = contractService.checkFilingType(id, ContractFilingTypeEnum.分包合同变更.getTypeCode());
            if (this.editChangeFlag(id) && contractFilingFlag){
                changeVO.setEditFlag(true);
            }else {
                changeVO.setEditFlag(false);
            }
        }else {
            changeVO.setEditFlag(false);
        }
        return changeVO;
    }

    /**
     * 查询能否变更
     * @param contractId
     * @return
     */
    @Override
    public Boolean editChangeFlag(Long contractId) {
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
            自由态也不能新增
         */
        LambdaQueryWrapper<ChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangeEntity::getContractId, contractId);
        lambda.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ChangeEntity> changeList = super.list(lambda);
        if (changeList.size() > 0){
            return false;
        }
        return true;
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更合同需要的主合同字段
     * @param contractId
     */
    @Override
    public ChangeVO addConvertByConId(Long contractId, Long changeId) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = contractService.selectById(contractId, orderMap);
        if(ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            return queryDetail(contractEntity.getChangeId());
        }
        ChangeVO changeVO = BeanMapper.map(contractEntity, ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion()+ 1);
        changeVO.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.未归档.getTypeCode());
        //设置明细表字段
        resetSub(changeVO);

        return changeVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ChangeVO insertOrUpdate(ChangeVO changeVO, Boolean isControl) {
        //获取主合同当前合同文件Id
        ContractEntity contract = contractService.selectById(changeVO.getContractId());
        //将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(CollectionUtils.isNotEmpty(changeVO.getAttachIds()) &&  null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }

        ChangeEntity changeEntity = BeanMapper.map(changeVO, ChangeEntity.class);

        //变更合同只能存在一条未生效的
        //查询语句，主合同id一致，且变更id不同，单据状态不为已通过或已提交的，或签章状态不为已签章的
        LambdaQueryWrapper<ChangeEntity> lambdachange = Wrappers.<ChangeEntity>lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId,changeVO.getContractId());
        if(changeVO.getId() != null) {
            lambdachange.ne(ChangeEntity::getId,changeVO.getId());
        }
        lambdachange.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if (changeEntity.getId() == null){
            // 初始化变更合同主键id
            changeEntity.setId(IdWorker.getId());
            changeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());

            //校验编码是否重复
            if(StringUtils.isBlank(changeEntity.getBillCode()) || contract.getBillCode().equals(changeEntity.getBillCode())) {
                String type = "-1-";
                //设置补充协议编码
                if(changeEntity.getChangeVersion() < 10){
                    changeEntity.setBillCode(contract.getBillCode() + type + "0" + changeEntity.getChangeVersion());
                } else {
                    changeEntity.setBillCode(contract.getBillCode() + type + changeEntity.getChangeVersion());
                }
            } else {
                //校验编码唯一
                if(checkSameBillCode(changeEntity)) {
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }


        } else {
            //校验编码是否重复
            ChangeEntity dbEntity = super.selectById(changeEntity.getId());
            if(StringUtils.isBlank(changeEntity.getBillCode())) {
                changeEntity.setBillCode(dbEntity.getBillCode());
            } else if(!dbEntity.getBillCode().equals(changeEntity.getBillCode()) && checkSameBillCode(changeEntity)) {
                //校验编码唯一
                throw new BusinessException("编码重复，不允许保存!");
            }
        }
        if (changeEntity.getChangeFilingStatus()!=null&&FilingStatusEnum.已归档.getTypeCode()==changeEntity.getChangeFilingStatus()){
            changeEntity.setFilingRef(0);
        }
        //保存前清空主键和父主键，重新生成
        List<ChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails)){
            Map<String, Long> idMap = new HashMap<>();
            for(ChangeDetailEntity detail : beforeDetails){
                if(null == detail.getChangeId()) {
                    detail.setChangeId(changeEntity.getId());
                }
                if (!("del").equals(detail.getRowState())){
                    if(null == changeVO.getId() || null == detail.getId()) {
                        detail.setId(IdWorker.getId());
                    }
//                    idMap.put(detail.getTid().toString()+detail.getSourceType(), detail.getId());
                    detail.setParentId(null);
                }
            }
//            for (ChangeDetailEntity detail : beforeDetails) {
//                if (!("del").equals(detail.getRowState())){
//                    if (StringUtils.isNotEmpty(detail.getTpid())) {
//                        detail.setParentId(idMap.get(detail.getTpid().toString()+detail.getSourceType()));
//                    }
//                }
//            }
        }

        if (Boolean.FALSE.equals(isControl)) {
            /**
             * 变更保存 删除原有数据,推送变更数据
             * 1、先根据合同Id查询合同最近一次变更单记录
             * 若存在变更记录，则将最近一次变更记录删除，将当前变更单信息推送目标成本
             * 如不存在变更记录，则删除合同目标成本数据，将当前变更单信息推送目标成本
             */
            //判断是否新增变更记录
            boolean delFlag = false;
            if(changeVO.getId() == null) {
                delFlag = true;
            } else {
                ChangeEntity dbEntity = changeService.selectById(changeEntity.getId());
                delFlag = dbEntity == null;
            }
            if(delFlag) {
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                ExecutionVO executionVO1 = getLastExecutionVO(changeEntity.getContractId());
                //目标成本推送
                totalExecutionVOList.add(executionVO1.getTotalVO());
                logger.info("目标成本推送数据：{}", JSON.toJSONString(totalExecutionVOList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }
        }

        if (Boolean.FALSE.equals(isControl)) {
            super.saveOrUpdate(changeEntity, false);
            //变更信息回写主合同
            saveWriteContract(changeEntity);

            //目标成本推送
            String linkUrl = this.getLinkUrl(BeanMapper.map(changeEntity, ChangeVO.class));
            ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(changeEntity, ContractVO.class),
                    linkUrl,changeEntity.getContractType(),
                    getContractBillType(changeEntity.getId(), changeEntity.getContractType(), true));
            logger.info("合同变更保存，目标成本推送数据： {}", JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            logger.info("合同变更保存，目标成本推送数据结果：{}", JSONObject.toJSONString(response));
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
            return queryDetail(changeEntity.getId());
        }

        return BeanMapper.map(changeEntity, ChangeVO.class);
    }

    private ExecutionVO getLastExecutionVO(Long contractId) {
        QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId).orderByDesc("create_time");
        List<ChangeEntity> list = changeService.list(wrapper);
        ExecutionVO executionVO1;
        ChangeEntity delTargetEntity = null;

        //判断是否有过变更
        if (!list.isEmpty()){
            delTargetEntity = list.get(0);
            delTargetEntity = super.selectById(delTargetEntity.getId());
            executionVO1 = targetCost(BeanMapper.map(delTargetEntity, ChangeVO.class),
                    this.getLinkUrl(BeanMapper.map(delTargetEntity, ChangeVO.class)), delTargetEntity.getContractType(),
                    getContractBillType(delTargetEntity.getId(), delTargetEntity.getContractType(), true), false);
        }else {
            ContractEntity contractEntity = contractService.selectById(contractId);
            executionVO1 = contractService.targetCost(BeanMapper.map(contractEntity, ContractVO.class),
                    contractService.getLinkUrl(BeanMapper.map(contractEntity, ContractVO.class)),
                    contractEntity.getContractType(),
                    getContractBillType(contractEntity.getId(), contractEntity.getContractType(), false));
        }
        return executionVO1;
    }

    private String getContractBillType(Long contractId, Integer contractType, boolean isChange) {
        //设置业务类型
        switch (contractType) {
            case 0:
                return isChange ? ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode() : ProsubBillTypeEnum.劳务分包合同.getBillTypeCode();
            case 1:
                return isChange ? ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同.getBillTypeCode();
            case 2:
                return isChange ? ProsubBillTypeEnum.特种设备租赁合同变更.getBillTypeCode() : ProsubBillTypeEnum.特种设备租赁合同.getBillTypeCode();
            case 3:
                return isChange ? ProsubBillTypeEnum.其他分包合同变更.getBillTypeCode() : ProsubBillTypeEnum.其他分包合同.getBillTypeCode();
            default:
                logger.error("合同id-{}错误的合同类型:{}", contractId, contractType);
                throw new BusinessException("错误的合同类型");
        }
    }

    @Override
    public String getLinkUrl(ChangeVO entity) {
        String linkUrl;
        switch (entity.getContractType()) {
            case 0:
                // 劳务分包合同
                if (entity.getAddType()==0){
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/laborSubList/changeCard?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=laborSubCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  劳务分包  参照新增
                }else {
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/laborSubList/changeCard?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=laborSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  劳务分包  手动新增
                }
                break;
            case 1:
                // 专业分包合同
                if (entity.getAddType()==0){
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubList/changeCard?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=proSubCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  专业分包  参照新增
                }else {
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubList/changeCard?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=proSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  专业分包  手动新增
                }
                break;
            case 2:
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/equipmentSubList/changeCard?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=equipmentSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  特种设备分包直接新增;
                break;
            case 3:
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/otherSubList/changeCard?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=otherSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  其他分包直接新增;
                break;
            default:
                logger.error("合同id-{}错误的合同类型：{}",entity.getId(), entity.getContractType());
                throw new BusinessException("错误的合同类型");
        }
        return linkUrl;
    }

    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BASE_HOST;
    }

    /**
     * 校验变更合同的编码是否重复
     * @param changeEntity
     * @return
     */
    private boolean checkSameBillCode(ChangeEntity changeEntity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangeEntity::getBillCode, changeEntity.getBillCode());
        lambda.eq(ChangeEntity::getTenantId, tenantId);
        if (null != changeEntity.getId() && changeEntity.getId() > 0) {
            lambda.ne(ChangeEntity::getId, changeEntity.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        ChangeEntity changeEntity = super.selectById(id, orderMap);
        ChangeVO changeVO = new ChangeVO();
        if (null != changeEntity){
            changeVO =  BeanMapper.map(changeEntity, ChangeVO.class);
        }

        List<Long> srcTblIdList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(changeVO.getDetailList())) {
            for (ChangeDetailVO detail : changeVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                srcTblIdList.add(detail.getSrcTblId());
            }
            //判断清单是否被下游数据引用
            List<ChangeDetailVO> usefulDetailList = selectUsefulByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
            Map<Long, Integer> usefulDetailMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)){
                for (ChangeDetailVO c : usefulDetailList){
                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
                }
            }
            for (ChangeDetailVO c : changeVO.getDetailList()){
                if (null != usefulDetailMap.get(c.getSrcTblId())){
                    c.setUseNum(1);
                }else {
                    c.setUseNum(null);
                }
            }

            //设置最小工程量（结算单最大结算量）
            List<ChangeDetailVO> minDetailNumList = selectMinDetailNumByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
            Map<Long, BigDecimal> minDetailNumMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(minDetailNumList)){
                for (ChangeDetailVO c : minDetailNumList){
                    minDetailNumMap.put(c.getSrcTblId(), c.getMinDetailNum());
                }
            }
            for (ChangeDetailVO c : changeVO.getDetailList()){
                if (null != minDetailNumMap.get(c.getSrcTblId())){
                    c.setMinDetailNum(minDetailNumMap.get(c.getSrcTblId()));
                }else {
                    c.setMinDetailNum(null);
                }
            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree(changeVO.getDetailList()));
        }

        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ChangeEntity entity = super.selectById(changeBillId);
        //合同变更只有详情页有删除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<ChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", changeBillId);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion()-1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<ContractEntity>().eq("id",contractEntity.getId()),false);

        super.removeById(changeBillId,false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 查询变更对比
     * @param id
     * @param
     * @return
     */
    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<>();
        orderByParams.put("treeIndex", QueryParam.ASC);
        Map<String, LinkedHashMap<String, String>> orders = new HashMap<>();
        orders.put("detailList", orderByParams);
        ChangeEntity changeEntity = super.selectById(id, orders);
        ChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, ChangeCompareVO.class);
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());

        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            //若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<RecordEntity> lambda = Wrappers.<RecordEntity>lambdaQuery();
            lambda.eq(RecordEntity::getChangeId, id)
                    .eq(RecordEntity::getContractId, changeEntity.getContractId())
                    .orderByDesc(RecordEntity::getCreateTime);
            List<RecordEntity> recordList = recordService.list(lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null){
                beforeChangeVO = BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
            }
        }else {
            beforeChangeVO = BeanMapper.map(contractEntity, ChangeCompareVO.class);
        }

        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null){
            //设置明细内容
            if (CollectionUtils.isNotEmpty(changeCompareVO.getDetailList())) {
                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(changeCompareVO.getDetailList().stream().filter(detail -> StringUtils.isNotBlank(detail.getChangeType())).collect(Collectors.toList())));
            }

            //设置其他花费内容
            if (CollectionUtils.isNotEmpty(changeCompareVO.getOtherCostList())){
                changeCompareVO.setOtherCostList(
                        changeCompareVO.getOtherCostList().stream().filter(cost -> StringUtils.isNotBlank(cost.getChangeType())).collect(Collectors.toList())
                );
            }

            if (CollectionUtils.isNotEmpty(changeCompareVO.getClauseList())){
                changeCompareVO.setClauseList(
                        changeCompareVO.getClauseList().stream().filter(clause -> null == clause.getBeforeClauseContent() || !clause.getBeforeClauseContent().equals(clause.getClauseContent())).collect(Collectors.toList())
                );
            }

            if (CollectionUtils.isNotEmpty(changeCompareVO.getPaymentList())){
                changeCompareVO.setPaymentList(//前付款比例为空证明是新增项
                        changeCompareVO.getPaymentList().stream().filter(payment -> null == payment.getBeforePaymentScale() || !payment.getBeforePaymentScale().equals(payment.getPaymentScale())).collect(Collectors.toList())
                );
            }


            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }


    /**
     * 保存回写合同
     * @param changeEntity
     */
    private void saveWriteContract(ChangeEntity changeEntity){
        /*
            回写主合同，两个金额六个变更
         */
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangeId, changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()){
            updateWrapper.set(ContractEntity::getChangingMny, changeEntity.getChangeMny().subtract(changeEntity.getChangeTax()));
        }
        updateWrapper.set(ContractEntity::getChangingTaxMny, changeEntity.getChangeMny());

        updateWrapper.set(ContractEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, changeEntity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, changeEntity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(ContractEntity::getChangeFileId, changeEntity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, changeEntity.getContractName());

        updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());

        contractService.update(updateWrapper);
    }



    @Override
    public ChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = contractService.selectById(contractId);

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, changeId));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<RecordEntity> recordList = recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty(recordList)){
            changeVO = BeanMapper.map(recordList.get(0), ChangeVO.class);
        }

        if (changeVO !=null){
            resetSub(changeVO);
        }

        return changeVO;
    }

    private void resetSub(ChangeVO changeVO) {
        //设置明细表字段
        List<ChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            List<Long> srcTblIdList = new ArrayList<>();
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getDetailNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getDetailPrice());
                changeDetailVO.setBeforeChangeArtificialPrice(changeDetailVO.getDetailArtificialPrice());
                changeDetailVO.setBeforeChangeDetailNewNum(changeDetailVO.getDetailNewNum());
                changeDetailVO.setBeforeChangeUseTime(changeDetailVO.getUseTime());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getDetailTaxRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
                srcTblIdList.add(changeDetailVO.getSrcTblId());
            });

            //判断清单是否被下游数据引用（零工登记，零工申请，分包计量，过程结算）
            List<ChangeDetailVO> usefulDetailList = selectUsefulByIds(changeDetailList.stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));

            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)){
                for (ChangeDetailVO c : usefulDetailList){
                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
                }
            }
            for (ChangeDetailVO c : changeDetailList){
                if (null != usefulDetailMap.get(c.getSrcTblId())){
                    c.setUseNum(1);
                }else {
                    c.setUseNum(null);
                }
            }

            //设置最小工程量（结算单最大结算量）
            List<ChangeDetailVO> minDetailNumList = selectMinDetailNumByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
            Map<Long, BigDecimal> minDetailNumMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(minDetailNumList)){
                for (ChangeDetailVO c : minDetailNumList){
                    minDetailNumMap.put(c.getSrcTblId(), c.getMinDetailNum());
                }
            }
            for (ChangeDetailVO c : changeVO.getDetailList()){
                if (null != minDetailNumMap.get(c.getSrcTblId())){
                    c.setMinDetailNum(minDetailNumMap.get(c.getSrcTblId()));
                }else {
                    c.setMinDetailNum(null);
                }
            }
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        //其他费用
        List<ChangeOtherCostVO> changeOtherCostVOList = changeVO.getOtherCostList();
        if(CollectionUtils.isNotEmpty(changeOtherCostVOList)){
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostTaxRate());
                changeOtherCostVO.setChangeType(null);
                changeOtherCostVO.setRowState("add");
            });
        }
        //清单
        List<ChangeClauseVO> changeClauseList = changeVO.getClauseList();
        if(CollectionUtils.isNotEmpty(changeClauseList)){
            changeClauseList.forEach(changeClauseVO ->{
                changeClauseVO.setRowState("add");
                changeClauseVO.setSrcTblId(changeClauseVO.getId());
                changeClauseVO.setChangeType(null);
                changeClauseVO.setBeforeClauseContent(changeClauseVO.getClauseContent());
            });
        }

        //付款阶段
        List<ChangePaymentVO> payList = changeVO.getPaymentList();
        if(CollectionUtils.isNotEmpty(payList)){
            payList.forEach(item ->{
                item.setRowState("add");
                item.setSrcTblId(item.getId());
                item.setChangeType(null);
                item.setBeforePaymentScale(item.getPaymentScale());
            });
        }
    }


    /**
     * 变更单据生效创建记录文件并回写主合同
     * @param changeBillId
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState,boolean filingFlag) {
        CommonResponse<String> resp = null;
        /**更新变更的审批时间  begin */
        ChangeEntity changeEntity = changeService.selectById(changeBillId);
        if (commitState){
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
        }

        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制合同表数据到记录表 begin */
        ContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());
        //获取当前合同记录数
        QueryWrapper<RecordEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("contract_id", contractVO.getId());
        countQuery.eq("dr", BaseVO.DR_UNDELETE);
        int curRecordVersion = recordService.count(countQuery);

        Map<Long, Integer> contIdVersionMap =  new HashMap<>();
        RecordEntity recordEntity = BeanMapper.map(contractVO, RecordEntity.class);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion+1);
        recordEntity.setId(null);
        logger.info("变更前主合同数据: {}", JSONObject.toJSONString(contractVO));
        logger.info("变更前主合同子表detail数据: {}", JSONObject.toJSONString(contractVO.getDetailList()));
        logger.info("记录表从主合同表复制的数据: {}", JSONObject.toJSONString(recordEntity));
        logger.info("记录表从主合同表复制的数据的子表detail数据: {}", JSONObject.toJSONString(recordEntity.getDetailList()));

        if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getClauseList())){
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())){
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getPaymentList())){
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }

        logger.info("记录表从主合同表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");
        //根据实体RefCode查询实体单据类型
        String srcBillCode = null;
        String targetBillCode = null;
        if (contractVO.getContractType().equals(0)){
            srcBillCode = LABORSUB_Bill_CODE;
            targetBillCode = LABORSUB_RECORD_Bill_CODE;
        }
        if (contractVO.getContractType().equals(1)){
            srcBillCode = PROSUB_Bill_CODE;
            targetBillCode = PROSUB_RECORD_Bill_CODE;
        }
        if (contractVO.getContractType().equals(2)){
            srcBillCode = EQU_SUB_Bill_CODE;
            targetBillCode = EQU_SUB_RECORD_Bill_CODE;
        }
        if (contractVO.getContractType().equals(3)){
            srcBillCode = OTHER_SUB_Bill_CODE;
            targetBillCode = OTHER_SUB_RECORD_Bill_CODE;
        }

        //原合同附件、起草附件同步到记录单据中
        resp = copyFile(contractVO.getId().toString(), srcBillCode,
                recordEntity.getId().toString(), targetBillCode, CONTRACT_ATTACH_SOURCE_TYPE, true);
        if(resp != null) {
            logger.error("同步原合同附件到记录单据失败，失败原因：{}", JSONObject.toJSONString(resp));
        }
        /**复制合同表数据到记录表 end */

        /**更新变更表主表数据到原合同 begin */
        logger.info("更新变更数据到主合同表,contractVO---------------->: {}", JSONObject.toJSONString(contractVO));
        ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
        //基本信息
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setContractCategoryProperty(changeEntity.getContractCategoryProperty());
        contractEntity.setSubType(changeEntity.getSubType());
        contractEntity.setWarrantyRate(changeEntity.getWarrantyRate());
        //劳务分包人资质
        contractEntity.setQualifyId(changeEntity.getQualifyId());
        contractEntity.setQualifyName(changeEntity.getQualifyName());
        contractEntity.setQualifyCertifyNo(changeEntity.getQualifyCertifyNo());
        contractEntity.setQualifyLicenceIssuingAuthority(changeEntity.getQualifyLicenceIssuingAuthority());
        contractEntity.setQualifyGrantDate(changeEntity.getQualifyGrantDate());
        contractEntity.setQualifyValidTillDate(changeEntity.getQualifyValidTillDate());
        contractEntity.setSafetyProductionLicenseNo(changeEntity.getSafetyProductionLicenseNo());
        contractEntity.setSafetyCertifyGrantDate(changeEntity.getSafetyCertifyGrantDate());
        contractEntity.setSafetyCertifyValidTillDate(changeEntity.getSafetyCertifyValidTillDate());
        //合同工期
        contractEntity.setProjectStartDate(changeEntity.getProjectStartDate());
        contractEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
        contractEntity.setContractDaysLimit(changeEntity.getContractDaysLimit());
        //项目经理代表人
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerLink(changeEntity.getFirstPartyProjectManagerLink());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyProjectManagerPost(changeEntity.getFirstPartyProjectManagerPost());
        contractEntity.setSupplierProjectManagerId(changeEntity.getSupplierProjectManagerId());
        contractEntity.setSupplierProjectManagerIdCard(changeEntity.getSupplierProjectManagerIdCard());
        contractEntity.setSupplierProjectManagerLink(changeEntity.getSupplierProjectManagerLink());
        contractEntity.setSupplierProjectManagerName(changeEntity.getSupplierProjectManagerName());
        contractEntity.setSupplierProjectManagerPost(changeEntity.getSupplierProjectManagerPost());
        //分包款项
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setSubContractTaxMny(changeEntity.getSubContractTaxMny());
        contractEntity.setSubContractMny(changeEntity.getSubContractMny());
        contractEntity.setSubContractTax(changeEntity.getSubContractTax());
        contractEntity.setOtherCostMny(changeEntity.getOtherCostMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());

		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        //清空变更单信息
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);

        logger.info("1212-进入变更终审审核完回调------>合同提交，线下签订直接修改签章状态");
        //设置变更合同生效状态
        changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
        //签章来的 可以修改 不然不修改
        if (filingFlag){
            changeEntity.setChangeFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());

        //同步变更单附件（不包含变更变更附件）到原合同
        resp = copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), srcBillCode, "subChangeContractFile", false);
        if(resp != null) {
            logger.error("同步变更附件到原合同失败，失败原因：{}", JSONObject.toJSONString(resp));
        }

        //变更单更新
        changeService.saveOrUpdate(changeEntity);

        //更新变更单的 签章文件id - signFieldId
        if (DraftTypeEnum.线上起草.getCode().equals(changeEntity.getChangeDraftType()) || DraftTypeEnum.上传合同.getCode().equals(changeEntity.getChangeDraftType())){
            contractFileService.updateSignedFileInfo(changeBillId, "contractChange");
        }

        logger.info("更新变更表合同状态和数据,changeEntity---------->： {}", JSONObject.toJSONString(changeEntity));

        /**更新变更表主表数据到原合同 end */

        /**更新变更子表数据到原合同子表 begin */
        logger.info("更新变更表数据到主合同开始----------->" + contractEntity.getChangeStatus());
        ContractEntity contractChangeEntity = BeanMapper.map(changeEntity, ContractEntity.class);
        List<ChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        Map<Long,Long> changDetailIdMap = new HashMap<>();
		/*
			变更详情表和合同详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
			合同详情表里 变更子表主键 changeBid
		 */
		Map<Long, Long> changeParentIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailEntity -> {
                //设置id和来源子表主键对应map
                changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId() != null ? changeDetailEntity.getSrcTblId() : IdWorker.getId());
            });
            changeDetailList.forEach(changeDetailEntity -> {
                if (changeDetailEntity.getParentId() != null){
                    changeParentIdMap.put(changeDetailEntity.getId(), changDetailIdMap.get(changeDetailEntity.getParentId()));
                }
            });
        }

        List<ContractDetailEntity> contractDetailList = contractChangeEntity.getDetailList();
        Map<Long, ContractDetailEntity> oldContractDetailMap = new HashMap<>();
        //定标新增的合同需要回写定标相关数据
        if (null != contractVO.getTargetResultId()){
            List<ContractDetailEntity> oldContractDetailList = contractService.selectById(contractVO.getId()).getDetailList();
            if (CollectionUtils.isNotEmpty(oldContractDetailList)){
                oldContractDetailMap = oldContractDetailList.stream().collect(Collectors.toMap(ContractDetailEntity::getId, Function.identity(), (key1, key2) -> key2));
                logger.info("变更合同生效回写数据-旧子表数据-oldContractDetailList：{}", JSONObject.toJSONString(oldContractDetailList));
                logger.info("变更合同生效回写数据-旧子表数据-oldContractDetailMap：{}", JSONObject.toJSONString(oldContractDetailMap));
            }
        }
        if(CollectionUtils.isNotEmpty(contractDetailList)){
            Long contractBid = null;
            for(ContractDetailEntity contractDetailEntity : contractDetailList) {
                contractBid = changDetailIdMap.get(contractDetailEntity.getId());

                contractDetailEntity.setContractId(changeEntity.getContractId());
                //设置变更子表主键
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                //设置父级Id
                if(null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId(changDetailIdMap.get(contractDetailEntity.getParentId()));
                }

                //赋值招标相关字段
                if (null != oldContractDetailMap && oldContractDetailMap.containsKey(contractBid)){
                    contractDetailEntity.setDetailTargetResultNum(oldContractDetailMap.get(contractBid).getDetailTargetResultNum());
                    contractDetailEntity.setDetailTargetResultPrice(oldContractDetailMap.get(contractBid).getDetailTargetResultPrice());
                    contractDetailEntity.setDetailBaseTargetResultNum(oldContractDetailMap.get(contractBid).getDetailBaseTargetResultNum());
                    contractDetailEntity.setDetailTargetResultSellId(oldContractDetailMap.get(contractBid).getDetailTargetResultSellId());
                }

                //合同子表对应变更子表主键
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);
        logger.info("变更合同生效回写数据-新子表数据：{}", JSONObject.toJSONString(contractDetailList));

        //其他费用表
        List<ChangeOtherCostEntity> changeOtherCostList = changeEntity.getOtherCostList();
        Map<Long,Long> changOtherCostIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)){
            changeOtherCostList.forEach(changeOtherCostEntity -> {
                //设置id和来源子表主键对应map
                changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId());
            });
        }
        List<ContractOtherCostEntity> contractOtherCostList = contractChangeEntity.getOtherCostList();
        if(CollectionUtils.isNotEmpty(contractOtherCostList)){
            Long contractBid = null;
            for(ContractOtherCostEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = changOtherCostIdMap.get(contractOtherCostEntity.getId());
                //设置变更子表主键
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                //合同子表对应变更子表主键
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion(contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);

        //先删除合同条款表
        List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if(CollectionUtils.isNotEmpty(contractClauseList)){
            logger.info("删除合同条款子表数据: {}", JSONObject.toJSONString(contractClauseList));
            contractClauseService.deleteByIds(contractClauseList.stream().map(ContractClauseEntity::getId).collect(Collectors.toList()));

            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);

        //合同付款阶段
        List<ContractPaymentEntity> contractPayList = contractEntity.getPaymentList();
        List<ContractPaymentEntity> pList = contractChangeEntity.getPaymentList();
        if(CollectionUtils.isNotEmpty(contractPayList)){
            logger.info("删除合同付款阶段子表数据: {}", JSONObject.toJSONString(contractPayList));
            contractPaymentService.deleteByIds(contractPayList.stream().map(ContractPaymentEntity::getId).collect(Collectors.toList()));

            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);

        contractService.saveOrUpdate(contractEntity, false);
        // 推送合同池
        boolean pushContractRes = contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
        if (pushContractRes) {
            // 更新合同池数据的累计变更金额（含税、无税、税额）、累计变更比例
            this.updateTotalChangeDataByContractId(changeEntity, "approve");
        }
        logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

        /**更新变更子表数据到原合同子表 end */
        return CommonResponse.success("变更单生效，回写合同成功！");
    }

    // 更新合同池累计变更金额（含税、无税、税额）、累计变更比例
    @Override
    public void updateTotalChangeDataByContractId(ChangeEntity changeEntity, String type) {
        logger.info("合同变更" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计变更金额（含税、无税、税额）和累计变更比例，开始，changeEntity={}，type={}", JSONObject.toJSONString(changeEntity), type);
        QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0).eq("tenant_id", InvocationInfoProxy.getTenantid())
                .eq("contract_id", changeEntity.getContractId())
                .eq("performance_status", PerformanceStatusEnum.履约中.getCode());
        if ("back".equals(type)) {
            // 当前是变更单撤回后调用此方法，查询变更表中的本次变更金额的累加值时排除自己
            wrapper.ne("id", changeEntity.getId());
        }
        wrapper.select("sum(ifnull(change_mny, 0)) as totalChangeTaxMny, sum(ifnull(change_mny, 0) - ifnull(change_tax, 0)) as totalChangeMny, sum(ifnull(change_tax, 0)) as totalChangeTax");
        Map<String, Object> totalChangeMap = changeService.getMap(wrapper);
        logger.info("查询当前合同的本次变更金额（含税、无税、税额）的累加值作为累计变更金额（含税、无税、税额），查询结果：{}", totalChangeMap);
        BigDecimal totalChangeTaxMny = BigDecimal.ZERO;
        BigDecimal totalChangeMny = BigDecimal.ZERO;
        BigDecimal totalChangeTax = BigDecimal.ZERO;
        BigDecimal totalChangeRate = BigDecimal.ZERO;
        if (MapUtils.isNotEmpty(totalChangeMap)) {
            totalChangeTaxMny = totalChangeMap.get("totalChangeTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTaxMny").toString());
            totalChangeMny = totalChangeMap.get("totalChangeMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeMny").toString());
            totalChangeTax = totalChangeMap.get("totalChangeTax") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTax").toString());
            if (null != changeEntity.getBaseTaxMny() && changeEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
                totalChangeRate = (totalChangeTaxMny.divide(changeEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
            }
            logger.info("计算：累计变更比例 = 累计变更金额（含税） / 合同初始金额（含税） = {}", totalChangeRate);
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            // 累计变更金额
            contractPoolVO.setTotalChangeTaxMny(totalChangeTaxMny);
            contractPoolVO.setTotalChangeMny(totalChangeMny);
            contractPoolVO.setTotalChangeTax(totalChangeTax);
            contractPoolVO.setTaotalChangeScale(totalChangeRate);
            contractPoolVO.setSourceId(changeEntity.getContractId());
            CommonResponse<ContractPoolVO> saveAfterChangeRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("合同变更" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计变更金额（含税、无税、税额）和累计变更比例，结束，接口返回结果：{}", JSONObject.toJSONString(saveAfterChangeRes));
        }
    }

    @Override
    public List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList) {
        return changeMapper.selectUsefulByIds(srcTblIdList);
    }

    @Override
    public List<ChangeDetailVO> selectMinDetailNumByIds(List<Long> srcTblIdList) {
        return changeMapper.selectMinDetailNumByIds(srcTblIdList);
    }

    @Override
    public ExecutionVO targetCost(ChangeVO contractVO, String linkUrl, Integer contractType,
                                  String billTypeCode, boolean lastSourceId){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());

        //新增变更并且为控制校验时，将上一版本的Id传入
        if(lastSourceId) {
            if(null == contractVO.getId()) {
                totalVO.setLastSourceId(getLastExecutionVO(contractVO.getContractId()).getTotalVO().getSourceId());
            } else {
                ChangeEntity change = super.selectById(contractVO.getId());
                if(null == change) {
                    totalVO.setLastSourceId(getLastExecutionVO(contractVO.getContractId()).getTotalVO().getSourceId());
                }
            }
        }

        totalVO.setBillType(billTypeCode);
        //设置业务类型
        switch (contractType) {
            case 0:
                totalVO.setBussinessType(BussinessTypeEnum.劳务分包合同.getCode());
                break;
            case 1:
                totalVO.setBussinessType(BussinessTypeEnum.专业分包合同.getCode());
                break;
            case 2:
                totalVO.setBussinessType(BussinessTypeEnum.特种设备租赁合同.getCode());
                break;
            case 3:
                totalVO.setBussinessType(BussinessTypeEnum.其他分包合同.getCode());
                break;
            default:
                logger.error("合同id-{}推送目标成本失败，错误的合同类型:{}", contractVO.getId(), contractType);
                throw new BusinessException("错误的合同类型");
        }

        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny()); //合同总金额无税
        totalVO.setTaxMoney(contractVO.getContractTaxMny()); //合同总金额
        totalVO.setLinkUrl(linkUrl);
        if(contractVO.getContractType() != ContractVO.其他分包合同) {
            if (CollectionUtils.isNotEmpty(contractVO.getDetailList())){
                // Map<设备Id，设备信息>
                Map<Long, EquipmentVO> equipMap = new HashMap<>();
                EquipmentVO tmp = null;
                if(contractVO.getContractType() == ContractVO.特种设备租赁合同) {
                    //获取所有相关的设备Id
                    List<Long> equipIds =contractVO.getDetailList().stream().filter(detail -> !"del".equals(detail.getRowState()) && null != detail.getEquipmentId())
                            .map(ChangeDetailVO::getEquipmentId).collect(Collectors.toList());
                    if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(equipIds)) {
                        CommonResponse<List<EquipmentVO>> equipResp = equipmentApi.queryEquipmentItemByIds(equipIds);
                        if(!equipResp.isSuccess()) {
                            logger.error("根据设备Id-{}获取设备信息失败，{}", equipIds, JSONObject.toJSONString(equipResp));
                            throw new BusinessException("获取设备档案信息失败！");
                        }
                        equipResp.getData().forEach(e -> {
                            equipMap.put(e.getId(), e);
                        });
                    }
                }

                // 通过工程量判断是否是叶子结点：不空为叶子结点
                List<ChangeDetailVO> changeDetailVOS = contractVO.getDetailList().stream().filter(item -> item.getDetailNum() != null).collect(Collectors.toList());
                for (ChangeDetailVO contractDetailVO : changeDetailVOS){
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(contractDetailVO.getId());
                    detailExecutionVO.setSourceBillId(contractDetailVO.getChangeId());
                    detailExecutionVO.setCategoryId(contractDetailVO.getDocCategoryId()); // 档案分类ID
                    // 根据档案id判断是否是分类
                    if (contractDetailVO.getDocId()==null){
                        detailExecutionVO.setCategoryFlag(true);
                    }else {
                        detailExecutionVO.setCategoryFlag(false);
                    }
                    detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(false);

                    // 根据档案分类id查询档案分类信息
                    Assert.notNull(contractDetailVO.getDocCategoryId(), "档案分类id不能为空");
                    if (0 == contractType){
                        // 劳务分包
                        CommonResponse<LabsubCategoryVO> res = shareLabsubApi.queryLabSubByCategoryId(contractDetailVO.getDocCategoryId());
                        if (!res.isSuccess() || res.getData() == null) {
                            logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类ID:{}",contractDetailVO.getDocCategoryId());
                            throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                        }
                        LabsubCategoryVO categoryVO = res.getData();
                        if (categoryVO==null){
                            detailExecutionVO.setCategoryInnerCode(null);
                            detailExecutionVO.setCategoryCode(null);
                        }else {
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        }
                    } else if(1 == contractType) {
                        // 专业分包
                        CommonResponse<ProsubCategoryVO> res = shareLabsubApi.queryMajorSubByCategoryId(contractDetailVO.getDocCategoryId());
                        if (!res.isSuccess() || res.getData() == null) {
                            logger.error("根据档案分类id查询专业分包档案分类信息失败,档案分类ID:{}",contractDetailVO.getDocCategoryId());
                            throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
                        }
                        ProsubCategoryVO categoryVO = res.getData();
                        if (categoryVO==null){
                            detailExecutionVO.setCategoryInnerCode(null);
                            detailExecutionVO.setCategoryCode(null);
                        }else {
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        }
                    }

                    // 档案id
                    Assert.notNull(contractDetailVO.getDocId(), "档案id不能为空");
                    detailExecutionVO.setDocId(contractDetailVO.getDocId());

                    detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                    detailExecutionVO.setName(contractDetailVO.getDetailName());
                    // todo: 单位id
                    // detailExecutionVO.setUnitId(contractDetailVO.getUnitId());
                    detailExecutionVO.setUnitName(contractDetailVO.getDetailUnit());
                    detailExecutionVO.setNum(contractDetailVO.getDetailNum());
                    detailExecutionVO.setMoney(contractDetailVO.getDetailMny());
                    detailExecutionVO.setTaxMoney(contractDetailVO.getDetailTaxMny());
                    detailExecutionVO.setPrice(contractDetailVO.getDetailPrice());
                    detailExecutionVO.setTaxPrice(contractDetailVO.getDetailTaxPrice());

                    if(contractVO.getContractType() == ContractVO.特种设备租赁合同) {
                        if(null != contractDetailVO.getEquipmentId()) {
                            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                            tmp = equipMap.get(contractDetailVO.getEquipmentId());
                            if(null == tmp) {
                                throw new BusinessException("操作失败，未获取设备【"+(StringUtils.isNotBlank(contractDetailVO.getEquipmentCode()) ? "编码："+contractDetailVO.getEquipmentCode() + "，" : "")+"名称："+contractDetailVO.getEquipmentName()+"】档案信息！");
                            }

                            detailExecutionVO.setCategoryId(tmp.getCategoryId()); // 档案分类ID
                            detailExecutionVO.setCategoryCode(tmp.getCategoryCode()); // 档案分类ID
                            detailExecutionVO.setCategoryName(tmp.getCategoryName()); // 档案分类ID
                            detailExecutionVO.setDocId(tmp.getId());
                            detailExecutionVO.setCode(tmp.getCode());
                            detailExecutionVO.setName(tmp.getName());
                            detailExecutionVO.setUnitName(tmp.getUnitName());
                            detailExecutionVO.setSpec(contractDetailVO.getEquipmentSpec());
                        } else{
                            detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                        }
                    } else {
                        if (contractType==0){
                            detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                        }else {
                            detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                        }
                    }

                    detailList.add(detailExecutionVO);
                }
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(ChangeVO changeVO) {
        logger.info("prosub---ContractServiceImpl---historyPriceCtrlContractPrice()--- 历史价控合同价入参：{}", JSONObject.toJSONString(changeVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        // 分包价格库查询价格类型（云南建投不做处理，一建查询综合单价类型）
//        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(PRICE_LIB_CHECK_TYPE);
//        if (!response.isSuccess() || response.getData() == null) {
//            throw new BusinessException("获取分包价格库查询价格类型系统参数请求失败，失败原因：" + response.getMsg());
//        }
//        String valueData = response.getData().getValueData();
//        if (StringUtils.isNotBlank(valueData) && valueData.contains("全部")){
//            //全部不做校验
//            logger.info("获取分包价格库查询价格类型系统参数为全部，则不做价格库校验！");
//            return paramsCheckVOList;
//        }

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        Integer contractType = changeVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        List<ChangeDetailVO> detailList = changeVO.getDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("分包合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("分包合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (ChangeDetailVO  detailVO: detailList) {//遍历明细
                    //非综合单价的数据不进行校验
//                    if (null == detailVO.getDocPriceTypeName() || !"综合单价".equals(detailVO.getDocPriceTypeName())){
//                        continue;
//                    }
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDetailPrice()==null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("分包清单单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("分包清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                for (ChangeDetailVO  detailVO: detailList) {//遍历明细
                    //非综合单价的数据不进行校验
//                    if (null == detailVO.getDocPriceTypeName() || !"综合单价".equals(detailVO.getDocPriceTypeName())){
//                        continue;
//                    }
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDetailPrice()==null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("分包清单单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("分包清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }

    @Override
    public String getBillType(Long id, Integer contractType) {
        //设置业务类型
        switch (contractType) {
            case 0:
                return ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode();
            case 1:
                return ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode();
            case 2:
                return ProsubBillTypeEnum.特种设备租赁合同变更.getBillTypeCode();
            case 3:
                return ProsubBillTypeEnum.其他分包合同变更.getBillTypeCode();
            default:
                logger.error("合同变更id-{}错误的合同类型:{}", id, contractType);
                throw new BusinessException("错误的合同类型");
        }

    }

    @Override
    public Collection<? extends ParamsCheckVO> targetCostPriceCtrlContractPrice(ChangeVO changeVO) {
        logger.info("prosub---ContractServiceImpl---targetCostPriceCtrlContractPrice()--- 目标成本价控合同价入参：{}", JSONObject.toJSONString(changeVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        Integer contractType = changeVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        List<ChangeDetailVO> detailList = changeVO.getDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_TARGET_COST_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_TARGET_COST_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询目标成本价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数目标成本价查询结果：{}", JSONObject.toJSONString(maxParamByCode));
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果

        List<Long> docIds = detailList.stream().filter(item -> null != item.getDetailNum()).map(ChangeDetailVO::getDocId).collect(Collectors.toList());
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByDocIds(changeVO.getProjectId(), 0 == contractType ? DocTypeEnum.劳务分包档案.getCode() : DocTypeEnum.专业分包档案.getCode() , docIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVOList;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();

        logger.info("目标成本价参数控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        if (null == dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVOList;
        }
        logger.info("目标成本价map信息返回："+JSONObject.toJSONString(dutyMap));
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(maxParamVOS)){
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (ChangeDetailVO detailVO: detailList) {//遍历明细
                    if (null != detailVO.getDetailNum()){
                        BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : dutyMap.get(detailVO.getDocId());//获取目标成本价格
                        BigDecimal price = null == detailVO.getDetailPrice() ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//档案单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getDetailWorkContent() == null ? "" : "+" + detailVO.getDetailWorkContent()));
                            paramsCheckDsVO.setWarnName("合同单价大于目标成本单价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("合同单价：").append(price)
                                    .append("元，目标成本单价：(").append(maxPrice)
                                    .append("元),目标成本单价*").append(roleValueMax).append("%：").append(maxPriceParam)
                                    .append("元，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP)).append("元");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }


    /**
     * 文件复制
     *
     * @param srcBillId 源单据Id
     * @param srcBillTypeCode 源单据类型
     * @param targetBillId 目标单据Id
     * @param targetBillTypeCode 目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {

        //同步合同附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE);
        if (!copyContractAttachResp.isSuccess()){
            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    ,srcBillId, srcBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }

        if(copyContractFile) {
            //同步合同文件
            CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE,
                    targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE);
            if (!copyContractFileResp.isSuccess()){
                logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                        ,srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, copyContractFileResp.getMsg());
                return CommonResponse.error("审批失败，同步合同文件失败，错误信息：" + copyContractFileResp.getMsg());
            }
        }

        return null;
    }

    // 校验  劳务/专业分包合同-变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public List<ParamsCheckVO> changeMnyCtrl(ChangeVO changeVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务分包合同
        if (0 == changeVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHANGE_PARAM_CODE, changeVO.getOrgId());
        }
        // 专业分包合同
        if (1 == changeVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHANGE_PARAM_CODE, changeVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVOList;
        }
        List<BillParamVO> data = billParamByCode.getData();
        for (BillParamVO billParamVO : data){
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 为none时不需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                // 合同初始版本金额
                BigDecimal baseTaxMny = changeVO.getBaseTaxMny();
                // 当前变更单的合同金额
                BigDecimal contractTaxMny = changeVO.getContractTaxMny();
                // 计算 累计合同变更金额
                BigDecimal changeTaxMny = contractTaxMny.subtract(baseTaxMny);
                // 计算 本次变更金额
                BigDecimal changeTaxMnyTime = contractTaxMny.subtract(changeVO.getBeforeChangeTaxMny());
                // 计算 合同初始金额 * X%
                BigDecimal conTaxMny = baseTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                // 控制金额：变更金额 > 合同金额*X%
                if (changeTaxMny.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = changeTaxMny.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("变更超合同金额");
                    paramsCheckDsVO.setWarnName("累计变更金额大于合同金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次变更金额：").append(changeTaxMnyTime.setScale(2, RoundingMode.DOWN))
                            .append("，含本次累计变更金额：").append(changeTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(conTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("。超出金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    // 无需控制
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> planNumCtrlContractNum(ChangeVO vo) {
        logger.info("prosub---ChangeServiceImpl---planNumCtrlContractNum()---入参：{}", JSONObject.toJSONString(vo));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        Integer contractType = vo.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        Long projectIdSave = vo.getProjectId();// 合同所在项目id
        Long tenantid = InvocationInfoProxy.getTenantid();// 租户编码
        // 劳务
        if (0 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHANGE_PLAN_NUM_CTRL_CON_NUM, vo.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHANGE_PLAN_NUM_CTRL_CON_NUM, vo.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> data = billParamByCode.getData();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                List<Long> cdIdListSave = new ArrayList<>();
                HashMap<Long, Map<String, Object>> curConNumMap = new HashMap<>();
                List<ChangeDetailVO> cdListSave = new ArrayList<>();
                ParamCtrlUtil.treeToChanDetailVOList(cdListSave, vo.getDetailList());
                // 对合同子表数据相同清单的合同量累加，根据档案id
                if (CollectionUtils.isNotEmpty(cdListSave)) {
                    for (ChangeDetailVO cdVO : cdListSave) {
                        // 只要 末级且非删除 的清单
                        BigDecimal detailNum = cdVO.getDetailNum();
                        Long docId = cdVO.getDocId();
                        String rowState = cdVO.getRowState();
                        if (detailNum == null || "del".equals(rowState)) {
                            continue;
                        }
                        Long cdId = cdVO.getId();
                        if (cdId != null) {
                            cdIdListSave.add(cdId);
                        }
                        String detailName = cdVO.getDetailName();
                        String detailRule = cdVO.getDetailMeasurementRules();
                        // 按到之前存储的数据
                        Map<String, Object> mapOld = curConNumMap.get(docId);
                        BigDecimal conNumOld = BigDecimal.ZERO;
                        if (MapUtils.isEmpty(mapOld)) {
                            mapOld = new HashMap<>();
                        } else {
                            conNumOld = mapOld.get("conNum") == null ? BigDecimal.ZERO : new BigDecimal(mapOld.get("conNum").toString());
                        }
                        // 更新存储的数据并重新封装
                        mapOld.put("conNum", ComputeUtil.safeAdd(conNumOld, detailNum));
                        mapOld.put("detailName", StringUtils.isEmpty(detailName) ? "" : detailName);
                        mapOld.put("detailRule", StringUtils.isEmpty(detailRule) ? "" : detailRule);
                        curConNumMap.put(docId, mapOld);
                    }
                }

                logger.info("入参VO子表数据根据合同清单docId维度汇总合同量，汇总结果：{}", JSONObject.toJSONString(curConNumMap));
                // 查询当前项目下的当前分包类型的已生效（已提交或审批通过）的总计划的子表数据，并对计划量累加，根据子表清单编码（detail_code）分组
                QueryWrapper<PlanEntity> planWrapper = new QueryWrapper<>();
                Map<Long, BigDecimal> planNumMap = new HashMap<>();
                planWrapper
                        .eq("dr", 0)
                        .eq("tenant_id", tenantid)
                        .eq("sub_type", contractType)// 区分劳务还是专业
                        .eq("project_id", projectIdSave)// 当前项目下的
                        .in("bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));// 查询 已生效的
                PlanEntity pe = planService.getOne(planWrapper);
                logger.info("查询当前项目的总计划，查询结果：{}", JSONObject.toJSONString(pe));
                // 总计划子表同一清单编码下的计划量累加
                if (pe != null) {
                    // 查询总计划子表同一清单编码下的计划量累加
                    QueryWrapper<PlanDetailEntity> planDetailWrapper = new QueryWrapper<>();
                    planDetailWrapper.eq("dr", 0).eq("tenant_id", tenantid)
                            .eq("plan_id", pe.getId()).isNotNull("plan_num").groupBy("doc_id");
                    planDetailWrapper.select("sum(ifnull(plan_num, 0)) as planNumTotal, doc_id as docId");
                    List<Map<String, Object>> pdMapList = planDetailService.listMaps(planDetailWrapper);
                    if (CollectionUtils.isNotEmpty(pdMapList)) {
                        for (Map<String, Object> pdMap : pdMapList) {
                            Long docId = Long.parseLong(pdMap.get("docId").toString());
                            BigDecimal planNum = pdMap.get("planNumTotal") == null ? BigDecimal.ZERO : new BigDecimal(pdMap.get("planNumTotal").toString());
                            planNumMap.put(docId, planNum);
                        }
                    }
                }
                logger.info("总计划子表根据合同清单docId维度汇总计划量，汇总结果：{}", JSONObject.toJSONString(planNumMap));

                Map<Long, BigDecimal> conNumMap = new HashMap<>();
                List<Map<String, Object>> conMapList = contractMapper.queryCountConNum(contractType, tenantid, projectIdSave, CollectionUtils.isEmpty(cdIdListSave) ? null : cdIdListSave);
                if (CollectionUtils.isNotEmpty(conMapList)) {
                    logger.info("查询当前项目下合同的合同量（已排除本期），查询结果：{}", JSONObject.toJSONString(conMapList));
                    for (Map<String, Object> conMap : conMapList) {
                        conNumMap.put(Long.parseLong(conMap.get("docId").toString()), new BigDecimal(conMap.get("detailNumTotal") == null ? "0" : conMap.get("detailNumTotal").toString()));
                    }
                    logger.info("当前项目下合同的合同量（已排除本期）根据合同清单docId维度汇总合同量，汇总结果：{}", JSONObject.toJSONString(conNumMap));
                } else {
                    logger.info("查询当前项目下合同的合同量（已排除本期），未查询到数据");
                }

                // 开始控制
                if (MapUtils.isNotEmpty(curConNumMap) && curConNumMap.keySet().size() > 0) {
                    Set<Long> keySet = curConNumMap.keySet();
                    for (Long key : keySet) {
                        logger.info("当前docId={}", key);
                        // 当前合同清单的总计划量
                        BigDecimal planNumKey = planNumMap.get(key);
                        if (planNumKey == null) {
                            // 当当前清单在总计划量中不存在时不做控制
                            logger.info("当前docId的总计划量为空，无需控制");
                            continue;
                        }
                        logger.info("当前docId的总计划量：{}", planNumKey);

                        // 当前合同清单的本次合同量
                        Map<String, Object> curConMap = curConNumMap.get(key);
                        BigDecimal curConNum = BigDecimal.ZERO;
                        String detailName = "";
                        String detailRule = "";
                        if (MapUtils.isNotEmpty(curConMap)) {
                            logger.info("当前docId的本期合同量map：{}", JSONObject.toJSONString(curConMap));
                            // 本期合同量
                            Object conNumObj = curConMap.get("conNum");
                            curConNum = conNumObj == null ? BigDecimal.ZERO : new BigDecimal(conNumObj.toString());
                            // 清单名称
                            Object detailNameObj = curConMap.get("detailName");
                            detailName = detailNameObj == null ? "" : detailNameObj.toString();
                            // 计量规则
                            Object detailRuleObj = curConMap.get("detailRule");
                            detailRule = detailRuleObj == null ? "" : detailRuleObj.toString();
                        } else {
                            logger.info("当前docId的本期合同量map：null");
                        }

                        // 当前合同清单的不含本期量map
                        BigDecimal conNum = conNumMap.get(key);
                        conNum = conNum == null ? BigDecimal.ZERO : conNum;
                        logger.info("当前docId的不含本期合同量map：{}", JSONObject.toJSONString(conNum));

                        // 计算 当前合同清单的含本次累计合同量 = 不含本次 + 本次
                        conNum = conNum.add(curConNum);
                        logger.info("当前docId的含本期合同量 = 不含本期 + 本期，计算结果={}", conNum);

                        // 计算 总计划量*X%
                        BigDecimal planNum = planNumKey.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                        logger.info("计算：总计划量 *" + roleValue + "% = {}", planNum);

                        // 【总计划量】控【合同量】 合同量  > 总计划量*X%
                        if (conNum.compareTo(planNum) > 0) {
                            // 计算超出数量
                            BigDecimal overNum = conNum.subtract(planNum);
                            logger.info("超出数量={}", overNum);
                            // 封装预警信息
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(detailName + detailRule);
                            paramsCheckDsVO.setWarnName("合同数量大于总计划数量");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("本次合同数量：").append(curConNum.setScale(2, RoundingMode.DOWN))
                                    .append("，含本次累计合同数量：").append(conNum.setScale(2, RoundingMode.DOWN))
                                    .append("，总计划数量*").append(roleValue).append("%：").append(planNum.setScale(2, RoundingMode.DOWN))
                                    .append("。超出数量：").append(overNum.setScale(2, RoundingMode.DOWN));
                            paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            dataSource.add(paramsCheckDsVO);
                            paramsCheckVO.setDataSource(dataSource);
                        }
                    }
                }
            }
            logger.info("prosub---ChangeServiceImpl---planNumCtrlContractNum()---返回结果：{}", JSONObject.toJSONString(paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    // 劳务分包合同-变更 【总计划金额】控【合同金额】 合同金额  > 总计划金额*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public List<ParamsCheckVO> planMnyCtrlContractMny(ChangeVO changeVO) {
        logger.info("prosub---ChangeServiceImpl---planMnyCtrlContractMny()---入参：{}", JSONObject.toJSONString(changeVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        Integer contractType = changeVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        Long projectIdSave = changeVO.getProjectId();// 合同所在项目id
        Long tenantid = InvocationInfoProxy.getTenantid();// 租户编码
        Long saveId = changeVO.getId();
        // 劳务
        if (0 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHANGE_PLAN_MNY_CTRL_CON_MNY, changeVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHANGE_PLAN_MNY_CTRL_CON_MNY, changeVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));

        // 当前合同金额
        BigDecimal curConTaxMny = changeVO.getContractTaxMny();
        curConTaxMny = curConTaxMny == null ? BigDecimal.ZERO : curConTaxMny;
        logger.info("入参VO合同金额：{}", JSONObject.toJSONString(curConTaxMny));

        // 查询当前项目下的当前分包类型的已生效（已提交或审批通过）的总计划的总计划金额
        QueryWrapper<PlanEntity> planWrapper = new QueryWrapper<>();
        planWrapper
                .eq("dr", 0)
                .eq("tenant_id", tenantid)
                .eq("sub_type", contractType)// 区分劳务还是专业
                .eq("project_id", projectIdSave)// 当前项目下的
                .in("bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));// 查询 已生效的
        PlanEntity pe = planService.getOne(planWrapper);
        logger.info("查询当前项目的总计划，查询结果：{}", JSONObject.toJSONString(pe));
        BigDecimal totalPlanTaxMny = BigDecimal.ZERO;
        if (pe != null) {
            totalPlanTaxMny = pe.getTotalPlanTaxMny();
        }else {
            return paramsCheckVOList;
        }

        logger.info("查询当前项目的总计划金额：{}", JSONObject.toJSONString(totalPlanTaxMny));

        Map<String, Object> lastConTaxMnyMap = contractMapper.queryCountConTaxMny(contractType, tenantid, projectIdSave, saveId, changeVO.getContractId());
        logger.info("查询当前项目下合同的合同金额（已排除本期），查询结果：{}", JSONObject.toJSONString(lastConTaxMnyMap));


        // 不含本期合同金额
        BigDecimal lastConTaxMny = MapUtils.isEmpty(lastConTaxMnyMap) || lastConTaxMnyMap.get("lastConTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(lastConTaxMnyMap.get("lastConTaxMny").toString());
        // 含本期合同金额 = 不含本期 + 本期
        BigDecimal totalConTaxMny = lastConTaxMny.add(curConTaxMny);
        logger.info("含本期合同金额：{}", JSONObject.toJSONString(totalConTaxMny));

        List<BillParamVO> data = billParamByCode.getData();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();

            // 计算总计划金额 * X%
            totalPlanTaxMny = totalPlanTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
            logger.info("计算：总计划金额 *" + roleValue + "% = {}", totalPlanTaxMny);

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {

                // 【总计划金额】控【合同金额】 合同金额  > 总计划金额*X%
                if (totalPlanTaxMny != BigDecimal.ZERO && totalConTaxMny.compareTo(totalPlanTaxMny) > 0) {
                    // 计算超出数量
                    BigDecimal overMny = totalConTaxMny.subtract(totalPlanTaxMny);
                    logger.info("超出金额={}", overMny);
                    // 封装预警信息
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("合同金额超总计划金额");
                    paramsCheckDsVO.setWarnName("合同金额大于总计划金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次合同金额：").append(curConTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，含本次累计合同金额：").append(totalConTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，总计划金额*").append(roleValue).append("%：").append(totalPlanTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("。超出金额：").append(overMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    // 无需控制
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            logger.info("prosub---ChangeServiceImpl---planMnyCtrlContractMny()---返回结果：{}", JSONObject.toJSONString(paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }
}
