package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.MeasureDetailEntity;
import com.ejianc.business.process.bean.MeasureEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IMeasureDetailService;
import com.ejianc.business.process.service.IMeasureService;
import com.ejianc.business.process.vo.MeasureVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包计量实体
 *
 * @author generator
 */
@RestController
@RequestMapping("measure")
public class MeasureController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUB_MEA";//此处需要根据实际修改

    @Autowired
    private IMeasureService service;

    @Autowired
    private IMeasureDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IUserApi userApi;

    private final String billTypeCode = "BT211227000000002";

    @Autowired
    private IContractService contractService;

    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subMeasure/card";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<MeasureVO> saveOrUpdate(@RequestBody MeasureVO saveOrUpdateVO) {
        MeasureEntity entity = BeanMapper.map(saveOrUpdateVO, MeasureEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置签章状态
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
            //保存单据制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        List<MeasureDetailEntity> detailList = entity.getMeasureDetailList();

        // 校验清单计量
        BigDecimal total = BigDecimal.ZERO;
        if (!detailList.isEmpty()) {
            List<Integer> rows = new ArrayList<>();
            for (int i = 0, detailListSize = detailList.size(); i < detailListSize; i++) {
                MeasureDetailEntity detail = detailList.get(i);
                BigDecimal lastWorkNum = detailService.queryLastWorkNum(detail.getListId(), detail.getId());
                BigDecimal measure = detail.getMeasure();
                if (lastWorkNum != null && measure != null) {
                    if (lastWorkNum.add(measure).compareTo(detail.getWorkNum()) == 1) {
                        rows.add(i + 1);
                    }
                } else {
                    throw new BusinessException("请检查该清单历史计量和本次计量是否为空！");
                }
                total = total.add(detail.getListTaxMny());
            }
            if(CollectionUtils.isNotEmpty(rows)) {
                String rowIds = StringUtils.join(rows, ",");
                String warning = "本次计量不得超过合同剩余量，" + "请检查第" + rowIds + "行！";
                throw new BusinessException(warning);
            }
        }
        entity.setTotalTaxMny(total);
        service.saveOrUpdate(entity, false);
        MeasureVO vo = BeanMapper.map(entity, MeasureVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<MeasureVO> queryDetail(Long id) {
        MeasureEntity entity = service.selectById(id);
        MeasureVO vo = BeanMapper.map(entity, MeasureVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<MeasureVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MeasureVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MeasureVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<MeasureVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        List<MeasureEntity> dataList =new ArrayList<>();
        IPage<MeasureEntity> page = null;

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        //移动端查询
        if (StringUtils.isNotBlank(authOrgIds)) {
            //移动端有默认项目的存在，故传递默认项目对应项目部Id时，查询其本下数据，若未传递，则返回空数据
            if(null == param.getParams().get("orgId")) {
                page = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            } else {
                page = service.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            //pc端查询
            //查询本下范围内日的合同
            Long orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            page = service.queryPage(param, false);
            dataList = page.getRecords();
        }

        IPage<MeasureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(dataList, MeasureVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MeasureEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<MeasureVO> records = BeanMapper.mapList(list, MeasureVO.class);

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for(MeasureVO item : records) {
            item.setContractTypeStr(item.getContractType() == 0 ? "劳务分包" : "专业分包");
            item.setBillStateStr(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
            item.setCreateTimeStr(sdf.format(item.getCreateTime()));
        }

        beans.put("records", records);
        ExcelExport.getInstance().export("measureExport.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMeasureData", method = RequestMethod.GET)
    public CommonResponse<IPage<MeasureVO>> refMeasureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MeasureEntity> page = service.queryPage(param, false);
        IPage<MeasureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MeasureVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 查询历史清单计量
     *
     * @param listId 合同清单id
     * @return 历史清单计量
     */
    @GetMapping(path = "/queryLastWorkNum")
    public CommonResponse<BigDecimal> queryLastWorkNum(Long listId) {
        BigDecimal data = detailService.queryLastWorkNum(listId, null);
        return CommonResponse.success("清单历史计量查询成功！", data);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @PostMapping(value = "/testPushBill")
    public CommonResponse<String> testPushBill(@RequestBody Long id) {
        MeasureEntity entity = service.selectById(id);
        System.out.println(BASE_HOST);
        CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode("BT211227000000002");
        service.pushBillToSupCenter(entity, "BT211227000000002", cooperateResp.getData());

        return CommonResponse.success("推送成功！~");
    }

    @GetMapping(value = "/getBillShareLink")
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        MeasureEntity entity = service.selectById(id);

        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(BeanMapper.map(entity, MeasureEntity.class), billTypeCode, cooperateResp.getData());
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }

        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }

    @RequestMapping(value = "/mnyCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody MeasureVO measureVO) {
        ParamsCheckVO responseData = paramCheck(measureVO, false);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @RequestMapping(value = "/mnyCtrlById", method=RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value = "id") Long id) {
        MeasureEntity entity = service.selectById(id);
        if (entity == null) {
            return CommonResponse.error("单据不存在！");
        }
        MeasureVO measureVO = BeanMapper.map(entity, MeasureVO.class);
        ParamsCheckVO responseData = paramCheck(measureVO, true);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    /**
     * 劳务/专业分包合同-进度计量（移动端）  【合同金额】控【进度计量金额】  进度计量金额>合同金额*X*%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     * 1、当该合同变更金额超过合同金额时，系统自动按设定方式控制；
     * 2、合同变更金额计算方式：变更单变更后的合同含税金额 - 合同变更前金额；contractTaxMny - baseTaxMny
     * 3、合同金额：最初始版本本合同金额；
     *
     * @param measureVO
     * @param flag 是否是新增的数据：true是，false否
     * @return
     */
    private ParamsCheckVO paramCheck(@RequestBody MeasureVO measureVO, boolean flag) {
        // 校验  劳务/专业分包合同-进度计量（移动端）  【合同金额】控【进度计量金额】  进度计量金额>合同金额*X*%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
        ParamsCheckVO responseData = service.mnyCtrl(measureVO, flag);
        return responseData;
    }

    /**
     * @return
     * @param id 合同Id
     */
    @RequestMapping(value = "/contractMeasureRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> contractRegistrationRecord(@RequestParam Long id) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(id);

        QueryWrapper<MeasureEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contract.getId());
        query.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc("create_time");

        List<MeasureEntity> list = service.list(query);
        resp.put("measureList", BeanMapper.mapList(list, MeasureVO.class));

        BigDecimal totalMeasureTaxMny = BigDecimal.ZERO;
        for(MeasureEntity item : list) {
            totalMeasureTaxMny = totalMeasureTaxMny.add(item.getTotalTaxMny());
        }

        resp.put("contractTaxMny", contract.getContractTaxMny());
        resp.put("totalMeasureTaxMny", totalMeasureTaxMny);
        resp.put("measureRatio", totalMeasureTaxMny.multiply(new BigDecimal("100").divide(contract.getContractTaxMny(), 8, BigDecimal.ROUND_HALF_UP)));

        return CommonResponse.success("查询详情数据成功！", resp);
    }
}
