package com.ejianc.business.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contract.relieve.vo.ContractRelieveVO;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ImportContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.prosub.vo.ImportContractVO;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.api.ISalaryApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.prosub.bean.*;
import com.ejianc.business.prosub.enums.*;
import com.ejianc.business.prosub.mapper.ContractMapper;
import com.ejianc.business.prosub.service.*;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.*;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.swagger.models.Contact;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 分包合同实体
 *
 * @author generator
 *
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    @Autowired
    private IContractDetailService detailService;

    @Autowired
    private IContractOtherCostService otherCostService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    //劳务分包合同编码规则
    private static final String LABOR_SUB_BILL_CODE = "PROSUB_CONTRACT";

    private static final String LABSUB_CONTRACT_YNJT01 = "LABSUB_CONTRACT_YNJT01";
    private static final String LABSUB_CONTRACT_YNJT02 = "LABSUB_CONTRACT_YNJT02";
    //专业分包合同编码规则
    private static final String PROS_SUB_BILL_CODE = "PRO_SUB_CONTRACT";
    private static final String PRO_SUB_CONTRACT_YNJT_01 = "PRO_SUB_CONTRACT_YNJT_01";
    //特种设备租赁合同
    private static final String EQUIPMENT_SUB_BILL_CODE = "EQUIPMENT_SUB_BILL_CODE";
    //其他分包合同
    private static final String OTHER_SUB_BILL_CODE = "OTHER_SUB_BILL_CODE";


    // 劳务分包合同-补充协议  【合同金额】控【补充协议金额】
    private final String LAB_SUPPLEMENT_PARAM_CODE = "P-18rO1Y72";
    // 专业分包合同-补充协议  【合同金额】控【补充协议金额】
    private final String PRO_SUPPLEMENT_PARAM_CODE = "P-MK2Y0473";

    // 劳务分包合同-签订、变更、补充协议  【总计划量】控【合同量】
    private final String LAB_CON_PLAN_NUM_CTRL_CON_NUM = "P-29O92c0105";
    // 专业分包合同-签订、变更、补充协议  【总计划量】控【合同量】
    private final String PRO_CON_PLAN_NUM_CTRL_CON_NUM = "P-90sLe50106";

    // 劳务分包合同-签订、变更、补充协议  【总计划金额】控【合同金额】
    private final String LAB_CON_PLAN_MNY_CTRL_CON_MNY = "P-uOc2160107";
    // 专业分包合同-签订、变更、补充协议  【总计划金额】控【合同金额】
    private final String PRO_CON_PLAN_MNY_CTRL_CON_MNY = "P-66ZB8r0108";

    // 施工合同—劳务合同（包含补充协议)  【施工合同金额-专业合同金额】控【劳务合同金额】
    private final String LAB_CON_CONTRACTION_MNY_CTRL_CON_MNY = "P-4Avuf10109";

    // 归档参数控制
    private final String FILLING_TYPE_STATE = "P-eg7rBO0134";

    // 劳务分包合同-签订、变更、补充协议  【分包清单历史最高价】 控【劳务分包合同价格】
    private final String LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-51g2FF0175";
    // 专业分包合同-签订、变更、补充协议  【分包清单历史最高价】 控【专业分包合同价格】
    private final String PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-66o3LH0177";
    // 劳务分包合同-签订、变更、补充协议  【分包清单历史最低价】 控【劳务分包合同价格】
    private final String LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-sT2I640176";
    // 专业分包合同-签订、变更、补充协议  【分包清单历史最低价】 控【专业分包合同价格】
    private final String PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-1L8c900178";
    // 分包价格库查询类型 0、全部 1、综合单价
    private static final String PRICE_LIB_CHECK_TYPE = "P-5ukonG0162";
    // 劳务分包合同-签订、变更、补充协议  【目标成本价】 控【劳务分包合同价格】
    private final String LAB_TARGET_COST_PRICE_CTRL_CON_PRICE = "P-1A7To00217";
    // 专业分包合同-签订、变更、补充协议  【目标成本价】 控【专业分包合同价格】
    private final String PRO_TARGET_COST_PRICE_CTRL_CON_PRICE = "P-8YTKj60216";

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IContractService service;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    ContractMapper contractMapper;

    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private ITenderSubApi tenderApi;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Autowired
    private IPaymentApplyApi paymentApplyApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IPlanService planService;

    @Autowired
    private IChangeService changeService;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private IContractRelieveService contractRelieveService;

    @Autowired
    private ICommonSNAPI commonSNAPI;

    @Autowired
    private ISalaryApi salaryApi;

    @Autowired
    private IDutyApi dutyApi;

    @Autowired
    private IShareEquipmentApi equipmentApi;

    //定标结果未占用状态
   private final int unOccupyState = 0;
    //定标结果已占用状态
    private final int occupyState = 1;
    @Qualifier("com.ejianc.foundation.support.api.IDefdocApi")

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BaseHost;
    }

    @Override
    public boolean updatePerformanceStatusById(Long id) {
        return contractMapper.updatePerformanceStatusById(id) > 0;
    }

    @Override
    public ContractVO updatePerformanceStatusByContractId(ContractVO vo) {
        ContractEntity dbEntity = super.selectById(vo.getId());
        if (dbEntity != null) {
            dbEntity.setPerformanceStatus(vo.getPerformanceStatus());
            super.saveOrUpdate(dbEntity, false);
            return BeanMapper.map(dbEntity, ContractVO.class);
        }
        return new ContractVO();
    }

    /**
     * 新增或者修改合同
     *
     * @param contractVO
     * @return
     */
    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO, String authority, Boolean isControl) {
        ContractEntity entity = BeanMapper.map(contractVO, ContractEntity.class);
        ContractEntity oldContractEntity = null;
        if(entity.getId() == null){
            // 初始化主键
            entity.setId(IdWorker.getId());
            //设置合同初始状态
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            //设置归档状态
            if (entity.getFilingStatus()==null){
                entity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
            }else if (entity.getFilingStatus().equals(FilingStatusEnum.已归档.getTypeCode())){
                entity.setFilingRef(0);
            }


            //如果编码为空，就新增编码
            if (StringUtils.isBlank(entity.getBillCode())){
                if (Boolean.FALSE.equals(isControl)){
                    switch (GenerateBillCodeType) {
                        case "common":
                            //单据业务类型
                            Integer contractType = entity.getContractType();
                            String billCodeStr = getBillCodeStr(contractType);
                            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(billCodeStr,
                                    InvocationInfoProxy.getTenantid(), contractVO));
                            if(!billCode.isSuccess()) {
                                logger.error("保存合同失败，自动生成合同合同失败: {}", billCode.getMsg());
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }
                            entity.setBillCode(billCode.getData());
                            break;
                        case "ynjt":
                            CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(BillCodeParam.build(entity.getContractType() == 0 ? "机械承揽".equals(entity.getSubType()) ? LABSUB_CONTRACT_YNJT02 : LABSUB_CONTRACT_YNJT01 : PRO_SUB_CONTRACT_YNJT_01,
                                    InvocationInfoProxy.getTenantid(), contractVO));
                            if(!billCodeFirstPart.isSuccess()) {
                                logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }
                            //根据合同基层单位后三位查询查询流水号
                            CommonSNVO commonSNVO = new CommonSNVO();
                            //流水号长度
                            commonSNVO.setSnLength(4);
                            //租户Id
                            commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                            //流水依据
                            commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                            //单据业务类型
                            String billTypeCode = getBillTypeCodeString(entity.getContractType());

                            commonSNVO.setSourceType(billTypeCode);
                            CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                            if(!snResp.isSuccess()) {
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }
                            entity.setBillCode(billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + snResp.getData());
                            break;
                    }
                } else {
                    entity.setBillCode(entity.getId().toString());
                }

            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }

            entity.setSupplementFlag(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
        }else {
            oldContractEntity = super.selectById(entity.getId());
            //校验编码
            if (StringUtils.isBlank(entity.getBillCode())){
                entity.setBillCode(oldContractEntity.getBillCode());
            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }

        if (entity.getFilingStatus().equals(FilingStatusEnum.已归档.getTypeCode())){
            entity.setFilingRef(0);
        }
        //补充金额明细
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        //分包明细
        entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
        entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
        entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
        //其他费用
        entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
        entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
        entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
        //设置初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());

        if (entity.getContractFileId() != null){
            //合同旧数据
            ContractEntity contract = service.getById(entity.getId());
            if (contract != null
                    && (
                        //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                        !contract.getContractCategoryId().equals(entity.getContractCategoryId()) ||
                        //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                        !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) ||
                                DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
                    )
                    && (
                        DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                        DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
                    )
            ) {
                if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()){
                    delContractFile(contract.getContractFileId(), authority);
                }

                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }

        //保存前清空主键和父主键，重新生成
        resetPid(entity.getDetailList());

        //起草方式为使用合同模板时，将合同文件同步标识置为未同步
        if(DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }

        if (Boolean.FALSE.equals(isControl)){

            if (null != entity.getTargetResultId()){
                //校验合同定标量是否相加超出剩余定标量
                checkTargetResultNum(entity);
            }

            super.saveOrUpdate(entity, false);

            if (null != entity.getTargetResultId()){
                if (null != oldContractEntity){
                    //回写定标引用信息
                    writeBackTenderTarget(oldContractEntity, entity);
                }else {
                    writeBackTenderTarget(null, entity);
                }
            }

            //目标成本推送
            String linkUrl = this.getLinkUrl(BeanMapper.map(entity, ContractVO.class));
            //单据业务类型
            String billTypeCode = getBillTypeCodeString(entity.getContractType());
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class),linkUrl,entity.getContractType(), billTypeCode);
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        }
        return BeanMapper.map(entity, ContractVO.class);
    }

    private String getBillCodeStr(Integer contractType) {
        String billCodeStr = null;
        if (contractType == 0){
            billCodeStr = LABOR_SUB_BILL_CODE;
        }
        if (contractType == 1){
            billCodeStr = PROS_SUB_BILL_CODE;
        }
        if (contractType == 2){
            billCodeStr = EQUIPMENT_SUB_BILL_CODE;
        }
        if (contractType == 3){
            billCodeStr = OTHER_SUB_BILL_CODE;
        }
        return billCodeStr;
    }

    private String getBillTypeCodeString(Integer contractType) {
        String billTypeCode = null;
        if (contractType == 0){
            billTypeCode = ProsubBillTypeEnum.劳务分包合同.getBillTypeCode();
        }
        if (contractType == 1){
            billTypeCode = ProsubBillTypeEnum.专业分包合同.getBillTypeCode();
        }
        if (contractType == 2){
            billTypeCode = ProsubBillTypeEnum.特种设备租赁合同.getBillTypeCode();
        }
        if (contractType == 3){
            billTypeCode = ProsubBillTypeEnum.其他分包合同.getBillTypeCode();
        }
        return billTypeCode;
    }

    private void checkTargetResultNum(ContractEntity entity) {
        /*
            查询定标累积量是否超出
            查出不包含本合同的引用对应定标的合同明细集合
            相加初始定标量，如果超出则报错
         */
        if (null != entity.getTargetResultId()){
            QueryParam contractQuery = new QueryParam();
            contractQuery.getParams().put("targetResultId", new Parameter(QueryParam.EQ, entity.getTargetResultId()));
            contractQuery.getParams().put("id", new Parameter(QueryParam.NE, entity.getId()));
            List<ContractEntity> contractEntityList = super.queryList(contractQuery);
            if (CollectionUtils.isNotEmpty(contractEntityList)){
                List<Long> contractIds = contractEntityList.stream().map(ContractEntity::getId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(contractIds)){
                    List<Long> sourceIds = entity.getDetailList().stream().filter(item -> null != item.getDetailBaseTargetResultNum()).map(ContractDetailEntity::getSourceId).collect(Collectors.toList());
                    QueryParam contractDetailQuery = new QueryParam();
                    contractDetailQuery.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
                    contractDetailQuery.getParams().put("sourceId", new Parameter(QueryParam.IN, sourceIds));
                    List<ContractDetailEntity> contractDetailEntityList = detailService.queryList(contractDetailQuery);
                    logger.info("查询定标量是否超出-checkTargetResultNum-查询结果：{}", JSONObject.toJSONString(contractDetailEntityList));
                    //拿到含有定标量的 分组汇总 集合
                    if (CollectionUtils.isNotEmpty(contractDetailEntityList)){
                        Map<Long, BigDecimal> targetResultNumMap = contractDetailEntityList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getSourceId, Collectors.reducing(BigDecimal.ZERO,
                                ContractDetailEntity::getDetailBaseTargetResultNum,
                                BigDecimal::add)));

                        StringBuilder errMsg = new StringBuilder();
                        for (ContractDetailEntity detail : entity.getDetailList()) {
                            if (targetResultNumMap.containsKey(detail.getSourceId())){
                                BigDecimal targetResultNum = targetResultNumMap.get(detail.getSourceId()).add(detail.getDetailBaseTargetResultNum());
                                //如果累计定标量大于定标所来的量
                                if (targetResultNum.compareTo(detail.getDetailTargetResultNum()) == 1){
                                    errMsg.append("清单-" + detail.getDetailName() + "已签工程量【" + targetResultNumMap.get(detail.getSourceId()).setScale(4, BigDecimal.ROUND_HALF_UP) + "】 + 本期工程量【" + detail.getDetailBaseTargetResultNum().setScale(4, BigDecimal.ROUND_HALF_UP) + "】 超出工程量【" + targetResultNum.subtract(detail.getDetailTargetResultNum()).setScale(4, BigDecimal.ROUND_HALF_UP) + "】");
                                    errMsg.append("\r\n");
                                }
                            }
                        }
                        if (errMsg.length() > 0){
                            throw new BusinessException(errMsg.toString());
                        }
                    }
                }
            }
        }
    }

    private void writeBackTenderTarget(ContractEntity oldContractEntity, ContractEntity newContractEntity) {
        //全删全加 旧数据直接删除
        if (null != oldContractEntity){
            TenderPicketageVO delTenderPicketageVO = new TenderPicketageVO();
            delTenderPicketageVO.setId(oldContractEntity.getTargetResultId());
            delTenderPicketageVO.setContractMoney(oldContractEntity.getContractMny());
            delTenderPicketageVO.setContractMoneyTax(oldContractEntity.getContractTaxMny());

            //定标引用子表赋值
            List<TenderPicketageDetailVO> delTenderPicketageDetailList = new ArrayList<>();
            for (ContractDetailEntity oldDetail : oldContractEntity.getDetailList()) {
                TenderPicketageDetailVO tenderPicketageDetailVO = new TenderPicketageDetailVO();
                if (null != oldDetail.getDetailNum()){
                    tenderPicketageDetailVO.setId(oldDetail.getDetailTargetResultSellId());
                    tenderPicketageDetailVO.setSignNum(oldDetail.getDetailNum());
                    delTenderPicketageDetailList.add(tenderPicketageDetailVO);
                }
            }
            delTenderPicketageVO.setTenderPicketageDetailList(delTenderPicketageDetailList);
            //编辑单据，先删除旧的引用定标信息
            CommonResponse<String> delTenderResp = tenderApi.delUpdateStatus(delTenderPicketageVO);

            logger.info("分包合同删除定标引用信息-【{}】，结果-【{}】", JSONObject.toJSONString(delTenderPicketageVO), JSONObject.toJSONString(delTenderResp));
            if(!delTenderResp.isSuccess()) {
                throw new BusinessException("保存失败，删除定标引用信息失败！");
            }
        }

        //保存新的定标引用信息
        TenderPicketageVO saveTenderPicketageVO = new TenderPicketageVO();
        saveTenderPicketageVO.setId(newContractEntity.getTargetResultId()); //定标结果Id
        saveTenderPicketageVO.setContractMoney(newContractEntity.getContractMny());
        saveTenderPicketageVO.setContractMoneyTax(newContractEntity.getContractTaxMny());
        //定标引用子表赋值
        List<TenderPicketageDetailVO> saveTenderPicketageDetailList = new ArrayList<>();
        for (ContractDetailEntity newDetail : newContractEntity.getDetailList()) {
            TenderPicketageDetailVO tenderPicketageDetailVO = new TenderPicketageDetailVO();
            if (null != newDetail.getDetailNum() && !"del".equals(newDetail.getRowState())){
                tenderPicketageDetailVO.setId(newDetail.getDetailTargetResultSellId());
                tenderPicketageDetailVO.setSignNum(newDetail.getDetailNum());
                saveTenderPicketageDetailList.add(tenderPicketageDetailVO);
            }
        }
        saveTenderPicketageVO.setTenderPicketageDetailList(saveTenderPicketageDetailList);
        CommonResponse<String> saveTenderResp = tenderApi.updateStatus(saveTenderPicketageVO);
        logger.info("分包合同更新定标引用信息-【{}】，结果-【{}】", JSONObject.toJSONString(saveTenderPicketageVO), JSONObject.toJSONString(saveTenderResp));
        if(!saveTenderResp.isSuccess()) {
            throw new BusinessException("保存失败，更新定标引用信息失败！");
        }

    }

    @Override
    public String getLinkUrl(ContractVO entity) {
        String linkUrl;
        switch (entity.getContractType()) {
            case 0:
                // 劳务分包合同
                if (0 == entity.getAddType()){
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/laborSubList/card?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=laborSubCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  劳务分包  参照新增
                }else {
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/laborSubList/card?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=laborSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  劳务分包  手动新增
                }
                break;
            case 1:
                // 专业分包合同
                if (0 == entity.getAddType()){
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubList/card?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=proSubCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  专业分包  参照新增
                }else {
                    linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubList/card?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=proSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  专业分包  手动新增
                }
                break;
            case 2:
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/equipmentSubList/card?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=equipmentSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  特种设备分包直接新增;
                break;
            case 3:
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/otherSubList/card?id="+ entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&routeType=1" + "&cardType=otherSubDirectCard" + "&performanceStatus=" + entity.getPerformanceStatus(); //  其他分包直接新增;
                break;
            default:
                logger.error("合同id-{}错误的合同类型：{}",entity.getId(), entity.getContractType());
                throw new BusinessException("错误的合同类型");
        }
        return linkUrl;
    }

    @Override
    public String getLinkUrl(Long contractId) {
        String linkUrl = "";
        ContractEntity entity = super.selectById(contractId);
        if (entity == null) {
            return linkUrl;
        }
        return getLinkUrl(BeanMapper.map(entity, ContractVO.class));
    }


    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType, String billType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setBillType(billType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if(null != contractVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(contractVO.getCreateTime()));
        }


        //设置业务类型
        switch (contractType) {
            case 0:
                totalVO.setBussinessType(BussinessTypeEnum.劳务分包合同.getCode());
                break;
            case 1:
                totalVO.setBussinessType(BussinessTypeEnum.专业分包合同.getCode());
                break;
            case 2:
                totalVO.setBussinessType(BussinessTypeEnum.特种设备租赁合同.getCode());
                break;
            case 3:
                totalVO.setBussinessType(BussinessTypeEnum.其他分包合同.getCode());
                break;
            default:
                logger.error("合同id-{}推送目标成本失败，错误的合同类型:{}", contractVO.getId(), contractType);
                throw new BusinessException("错误的合同类型");
        }

        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        if (contractVO.getProjectId()==null){
            throw new BusinessException("项目信息为空，目标成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(contractVO.getProjectId());
        }
        if (contractVO.getOrgId()==null){
            throw new BusinessException("项目部信息为空，目标成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(contractVO.getOrgId());
        }
        totalVO.setMoney(contractVO.getContractMny()); //合同金额无税
        totalVO.setTaxMoney(contractVO.getContractTaxMny()); //合同金额
        totalVO.setLinkUrl(linkUrl);

        if(contractVO.getContractType() != ContractVO.其他分包合同) { //非其他分包合同
            if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
                // Map<设备Id，设备信息>
                Map<Long, EquipmentVO> equipMap = new HashMap<>();
                EquipmentVO tmp = null;
                if(contractVO.getContractType() == ContractVO.特种设备租赁合同) {
                    //获取所有相关的设备Id
                    List<Long> equipIds =contractVO.getDetailList().stream().filter(detail -> !"del".equals(detail.getRowState()) && null != detail.getEquipmentId())
                            .map(ContractDetailVO::getEquipmentId).collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(equipIds)) {
                        CommonResponse<List<EquipmentVO>> equipResp = equipmentApi.queryEquipmentItemByIds(equipIds);
                        if(!equipResp.isSuccess()) {
                            logger.error("根据设备Id-{}获取设备信息失败，{}", equipIds, JSONObject.toJSONString(equipResp));
                            throw new BusinessException("获取设备档案信息失败！");
                        }
                        equipResp.getData().forEach(e -> {
                            equipMap.put(e.getId(), e);
                        });
                    }
                }

                // 通过工程量判断是否是叶子结点：不空为叶子结点
//            logger.info("目标成本推送，合同明细信息：{}", JSON.toJSONString(contractVO.getDetailList(), SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                List<ContractDetailVO> contractDetailVOS = contractVO.getDetailList().stream()
                        .filter(item -> item.getDetailNum() != null && !"del".equals(item.getRowState())).collect(Collectors.toList());
                logger.info("目标成本推送，合同明细过滤后数量：{}", contractDetailVOS.size());
                for (ContractDetailVO contractDetailVO : contractDetailVOS){
                    if(null == contractDetailVO.getDetailNum()) {
                        //工程量为空说明是分类，不在推送范围内
                        continue;
                    }
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(contractDetailVO.getId());

                    // 清单明细为空取合同id
                    if(ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode().equals(billType) ||
                            ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode().equals(billType)
                    || ProsubBillTypeEnum.特种设备租赁合同变更.getBillTypeCode().equals(billType)
                            || ProsubBillTypeEnum.其他分包合同变更.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(contractDetailVO.getChangeId());
                    } else {
                        if (null != contractDetailVO.getContractId()) {
                            detailExecutionVO.setSourceBillId(contractDetailVO.getContractId());
                        } else {
                            detailExecutionVO.setSourceBillId(contractVO.getId());
                        }
                    }


                    // 根据档案id判断是否是分类
                    if (contractDetailVO.getDocId()==null){
                        detailExecutionVO.setCategoryFlag(true);
                    }else {
                        detailExecutionVO.setCategoryFlag(false);
                    }
                    detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(false);

                    // 档案id
//                Assert.notNull(contractDetailVO.getDocId(),"档案id不能为空");

                    detailExecutionVO.setCategoryId(contractDetailVO.getDocCategoryId()); // 档案分类ID
                    detailExecutionVO.setDocId(contractDetailVO.getDocId());
                    detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                    detailExecutionVO.setName(contractDetailVO.getDetailName());
                    detailExecutionVO.setUnitName(contractDetailVO.getDetailUnit());
                    detailExecutionVO.setSpec(contractDetailVO.getDetailMeasurementRules());

                    if(contractVO.getContractType() == ContractVO.特种设备租赁合同) {
                        if(null != contractDetailVO.getEquipmentId()) {
                            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                            tmp = equipMap.get(contractDetailVO.getEquipmentId());
                            if(null == tmp) {
                                throw new BusinessException("操作失败，未获取设备【编码："+contractDetailVO.getEquipmentCode()+"，名称："+contractDetailVO.getEquipmentName()+"】档案信息！");
                            }

                            detailExecutionVO.setCategoryId(tmp.getCategoryId()); // 档案分类ID
                            detailExecutionVO.setCategoryCode(tmp.getCategoryCode()); // 档案分类ID
                            detailExecutionVO.setCategoryName(tmp.getCategoryName()); // 档案分类ID
                            detailExecutionVO.setDocId(tmp.getId());
                            detailExecutionVO.setCode(tmp.getCode());
                            detailExecutionVO.setName(tmp.getName());
                            detailExecutionVO.setUnitName(tmp.getUnitName());
                            detailExecutionVO.setSpec(contractDetailVO.getEquipmentSpec());
                        } else{
                            detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                        }
                    } else {
                        if (contractType==0){
                            detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                        }else {
                            detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                        }
                    }

//                     detailExecutionVO.setUnitId(contractDetailVO.getUnitId());

                    detailExecutionVO.setNum(contractDetailVO.getDetailNum());
                    detailExecutionVO.setMoney(contractDetailVO.getDetailMny());
                    detailExecutionVO.setTaxMoney(contractDetailVO.getDetailTaxMny());
                    detailExecutionVO.setPrice(contractDetailVO.getDetailPrice());
                    detailExecutionVO.setTaxPrice(contractDetailVO.getDetailTaxPrice());
                    detailExecutionVO.setTaxRate(contractDetailVO.getDetailTaxRate());
                    detailExecutionVO.setMemo(contractDetailVO.getDetailMemo());
                    if(null != contractDetailVO.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(contractDetailVO.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
        }

        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null){
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (ContractVO contractVO : vos) {
                ContractEntity contractEntity = service.selectById(contractVO.getId());
                //单据业务类型
                String billTypeCode = getBillTypeCodeString(contractEntity.getContractType());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractEntity, ContractVO.class),"",contractEntity.getContractType(), billTypeCode);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        }
        vos.forEach(contractVO ->{
            ContractEntity contractEntity = super.getById(contractVO.getId());
            if (null != contractEntity.getTargetResultId()){
                TenderPicketageVO delTenderPicketageVO = new TenderPicketageVO();
                delTenderPicketageVO.setId(contractEntity.getTargetResultId());
                delTenderPicketageVO.setContractMoney(contractEntity.getContractMny());
                delTenderPicketageVO.setContractMoneyTax(contractEntity.getContractTaxMny());

                //定标引用子表赋值
                List<TenderPicketageDetailVO> delTenderPicketageDetailList = new ArrayList<>();
                for (ContractDetailEntity oldDetail : contractEntity.getDetailList()) {
                    TenderPicketageDetailVO tenderPicketageDetailVO = new TenderPicketageDetailVO();
                    if (null != oldDetail.getDetailNum()){
                        tenderPicketageDetailVO.setId(oldDetail.getDetailTargetResultSellId());
                        tenderPicketageDetailVO.setSignNum(oldDetail.getDetailNum());
                        delTenderPicketageDetailList.add(tenderPicketageDetailVO);
                    }
                }
                delTenderPicketageVO.setTenderPicketageDetailList(delTenderPicketageDetailList);
                //编辑单据，先删除旧的引用定标信息
                CommonResponse<String> delTenderResp = tenderApi.delUpdateStatus(delTenderPicketageVO);

                logger.info("分包合同删除定标引用信息-【{}】，结果-【{}】", JSONObject.toJSONString(delTenderPicketageVO), JSONObject.toJSONString(delTenderResp));
                if(!delTenderResp.isSuccess()) {
                    throw new BusinessException("保存失败，删除定标引用信息失败！");
                }
            }
        });
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public boolean pushContract(ContractVO vo) {
        logger.info("推送合同池 合同 对象：——————{}",JSONObject.toJSONString(vo));
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            //单据业务类型
            String billTypeCode = getBillTypeCodeString(vo.getContractType());
            data.setSourceType(billTypeCode);
            //走分支 区分是否参照定标结果
            String cardType = "";
            String routePath = "";
            String mobileRoutePath = "";


            if (vo.getAddType()==1){
                //直接新增
                switch (vo.getContractType()) {
                    case 0: //劳务分包合同
                        cardType = "laborSubDirectCard";
                        routePath = "laborSubList";
                        mobileRoutePath = "labContract";
                        break;
                    case 1: //专业分包合同
                        cardType = "proSubDirectCard";
                        routePath = "proSubList";
                        mobileRoutePath = "proContract";
                        break;
                    case 2: //其他分包
                        cardType="otherSubDirectCard";
                        routePath = "otherSubList";
                        mobileRoutePath = "otherContract";
                        break;
                    case 3: //特种设备
                        cardType="equipmentSubDirectCard";
                        routePath = "equipmentSubList";
                        mobileRoutePath = "equipmentContract";
                        break;
                    default:
                        logger.error("合同id-{}错误的合同类型：{}", vo.getId(), vo.getContractType());
                        throw new BusinessException("错误的合同类型");
                }

            }else if (vo.getAddType()==0){
                //参照定标结果
                switch (vo.getContractType()) {
                    case 0: //劳务分包合同
                        cardType ="proSubCard";
                        routePath = "proSubList";
                        mobileRoutePath = "labContract";
                        break;
                    case 1: //专业分包合同
                        cardType ="laborSubCard";
                        routePath = "laborSubList";
                        mobileRoutePath = "proContract";
                        break;
                    case 2: //其他分包
                        cardType="otherSubDirectCard";
                        routePath = "otherSubList";
                        mobileRoutePath = "otherContract";
                        break;
                    case 3: //特种设备
                        cardType="equipmentSubDirectCard";
                        routePath = "equipmentSubList";
                        mobileRoutePath = "equipmentContract";
                        break;
                    default:
                        logger.error("合同id-{}错误的合同类型：{}", vo.getId(), vo.getContractType());
                        throw new BusinessException("错误的合同类型");
                }
            }
            data.setMobileCardUrl("ejc-prosub-mobile/#/" + mobileRoutePath + "/card?id=" + vo.getId());
            data.setPcCardUrl("/ejc-prosub-frontend/#/"+routePath+"/contractMultiCards?id="+vo.getId()+"&supplementFlag="+vo.getSupplementFlag()+"&cardType="+cardType+"&performanceStatus="+vo.getPerformanceStatus());
            data.setAddType(0); //业务系统推送合同池
            logger.info("推送合同池 转换 对象：——————{}",JSONObject.toJSONString(data));

            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), JSONObject.toJSONString(transDataResp));
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return false;
    }

    @Override
    public String delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return null;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return StringUtils.isNotBlank(delDataResp.getMsg()) ? delDataResp.getMsg() : "网络问题，单据处理失败！";
    }

    @Override
    public Integer deleteContractFileById(Long id) {
        ContractEntity contractEntity = service.selectById(id);
        contractEntity.setContractFileId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileHighlightId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileVersion(null);
        contractEntity.setContractFileVersionId(null);
        Boolean deleteContractFileResult = service.saveOrUpdate(contractEntity, false);
        if(!deleteContractFileResult) {
            return -1;
        }
        return contractEntity.getVersion();
    }

    /**
     * 计算合同列表需要字段
     * @param param
     * @return
     */
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    /**
     * 查询合同详情
     * @param id
     * @return
     */
    @Override
    public ContractVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        ContractEntity contractEntity = super.selectById(id, orderMap);
        ContractVO contractVO = BeanMapper.map(contractEntity, ContractVO.class);

        if (null != contractVO.getTargetResultId()){
            //定标新增的合同查询明细前需要查一下可用多少量
            CommonResponse<List<SubDocumentSellVO>> res = tenderApi.queryTreeList(contractVO.getTargetResultId());
            logger.info("查询定标当前以前信息结果：{}", JSONObject.toJSONString(res));
            if (res.isSuccess()){
                List<SubDocumentSellVO> subDocumentSellVOList = res.getData();
                logger.info("prosub-分包合同-queryDetail—查询定标来源数据-targetResultId-{}", contractVO.getTargetResultId());
                logger.info("通过targetResultId使用-queryTreeList-查询结果-{}", JSONObject.toJSONString(res));
                logger.info("通过targetResultId查询出定标数据-{}", JSONObject.toJSONString(subDocumentSellVOList));
                if (CollectionUtils.isNotEmpty(subDocumentSellVOList)) {
                    Map<Long, BigDecimal> targetResultNumMap = subDocumentSellVOList.stream().collect(Collectors.toMap(SubDocumentSellVO::getSellId, SubDocumentSellVO::getSurplusNum, (key1, key2) -> key2));
                    for (ContractDetailVO detail : contractVO.getDetailList()) {
                        logger.info("prosub-分包合同-queryDetail-初始值{}-detailTargetResultSellId-{}", detail.getDetailBaseTargetResultNum(), detail.getDetailTargetResultSellId());
                        logger.info("targetResultNumMap数据------->{}", JSONObject.toJSONString(targetResultNumMap));
                        if (targetResultNumMap.containsKey(detail.getDetailTargetResultSellId())) {
                            //如果 定标来源的子表有该条数据，则把该条数据的定标数量上限 赋值为 当前数据占用的定标数量 + 定标来源的子表剩余定标量
                            detail.setDetailTargetResultRemainderNum(detail.getDetailBaseTargetResultNum().add(targetResultNumMap.get(detail.getDetailTargetResultSellId())));
                        } else {
                            //如果 定标来源的子表没有该条数据，则把该条数据的定标数量上限赋值为初始定标量
                            detail.setDetailTargetResultRemainderNum(detail.getDetailBaseTargetResultNum());
                        }
                    }
                } else {
                    for (ContractDetailVO detail : contractVO.getDetailList()) {
                        //如果 定标来源的子表没有该条数据，则把该条数据的定标数量上限赋值为初始定标量
                        detail.setDetailTargetResultRemainderNum(detail.getDetailBaseTargetResultNum());
                    }
                }
            }else {
                throw new BusinessException("查询定标数据失败，"+res.getMsg());
            }
        }

        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            for (ContractDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree(contractVO.getDetailList()));
        }

        return contractVO;
    }


    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO contractVO = new ContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());

        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("performance_status", PerformanceStatusEnum.履约中.getCode());
        query.orderByDesc("create_time");
        List<ContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, ContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(supplementEntities)){
            for (ContractEntity c : supplementEntities){
                if (c.getContractTaxMny() != null){
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus())))){
            //归档参数控制校验
            Boolean filingTypeFlag = checkFilingType(id, ContractFilingTypeEnum.分包合同补充协议.getTypeCode());
            if (this.addSupplementFlag(id) && filingTypeFlag){
                contractVO.setEditFlag(true);
            }else {
                contractVO.setEditFlag(false);
            }
        }else {
            contractVO.setEditFlag(false);
        }
        return contractVO;
    }

    /**
     * 新增或者修改补充协议
     * @param contractVO
     * @return
     */
    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVO, Boolean isControl) {
        ContractEntity entity = null;
        if (StringUtils.isNotBlank(contractVO.getBillCode()) && checkSameBillCode(contractVO)) {
            throw new BusinessException("编码重复，不允许保存!");
        }
        //主合同
        ContractEntity mainContract = service.selectById(contractVO.getMainContractId());
        if(null == mainContract) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }

        QueryParam param = new QueryParam();
        param.getParams().put("main_contract_id", new Parameter("eq", contractVO.getMainContractId()));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
        List<ContractEntity> supplementList = service.queryList(param, false);


        if (StringUtils.isBlank(contractVO.getBillCode())){
            String supplementNum = "";
            if (supplementList.size() < 9) {
                supplementNum += "0" + (supplementList.size() + 1);
            }else {
                supplementNum += (supplementList.size() + 1);
            }

            //设置补充协议编码
            contractVO.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }

        if(contractVO.getId() == null){
            //新增补充协议

            //校验：补充协议只能存在一条未生效的
            supplementList.stream().forEach(e -> {
                if(!(e.getSignatureStatus().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                        || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });
            entity = BeanMapper.map(mainContract, ContractEntity.class);
            entity.setBillCode(contractVO.getBillCode());

            //清空基础字段（清除主键冗余）
            clearBaseFields(entity);
            // 初始化主键，在清空基础字段之后，避免主键被清空
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());

            entity.setFilingStatus(contractVO.getFilingStatus());

            //基本信息
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setEmployeeId(contractVO.getEmployeeId());
            entity.setEmployeeName(contractVO.getEmployeeName());
            entity.setEmployeePhone(contractVO.getEmployeePhone());
            entity.setSupplierEmployee(contractVO.getSupplierEmployee());
            entity.setSupplierEmployeePhone(contractVO.getSupplierEmployeePhone());
            entity.setPerformanceStatus(contractVO.getPerformanceStatus());

            entity.setDraftType(contractVO.getDraftType());
            //设置文件路径
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());

            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());

            //补充金额明细
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            //分包明细
            entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
            entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
            entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
            //其他费用
            entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
            entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
            entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
            //子表
            entity.setDetailList(BeanMapper.mapList(contractVO.getDetailList(), ContractDetailEntity.class));
            entity.setOtherCostList(BeanMapper.mapList(contractVO.getOtherCostList(), ContractOtherCostEntity.class));
            entity.setClauseList(BeanMapper.mapList(contractVO.getClauseList(), ContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList(contractVO.getPaymentList(), ContractPaymentEntity.class));

            //初始化变更字段
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            //补充协议状态
            entity.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        } else {
            entity = BeanMapper.map(contractVO, ContractEntity.class);
        }

        //设置初始金额
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        //设置关联的附件Ids
        entity.setAttachIds(contractVO.getAttachIds());
        if (entity.getFilingStatus()==FilingStatusEnum.已归档.getTypeCode()){
            entity.setFilingRef(0);
        }
        //保存前清空主键和父主键，重新生成
        resetPid(entity.getDetailList());

        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        if (Boolean.FALSE.equals(isControl)) {
            service.saveOrUpdate(entity, false);

            //目标成本推送
//            String linkUrl = this.getSupplementLinkUrl(vo);
//            String billTypeCodeStr = ProsubBillTypeCodeEnum.getEnumByContractType(vo.getContractType()).getDescription();
//            ExecutionVO executionVO = service.targetCost(vo, linkUrl, vo.getContractType(), billTypeCodeStr);
//            logger.info("目标成本推送数据:{}", JSON.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
//            CommonResponse<String> response = executionApi.aggPush(executionVO);
//            if (!response.isSuccess()){
//                throw new BusinessException("目标成本推送失败,"+response.getMsg());
//            }

            return queryDetail(entity.getId());
        }

        return vo;
    }

    @Override
    public String getSupplementLinkUrl(ContractVO contractVO){
        String linkUrl;
        if (0 == contractVO.getContractType()) {
            // 劳务分包合同
            if (0 == contractVO.getAddType()) {
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/laborSubList/supplementCard?id="+ contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=laborSubCard";
            } else {
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/laborSubList/supplementCard?id="+ contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=laborSubDirectCard";
            }
        } else {
            // 专业分包合同
            if (0 == contractVO.getAddType()) {
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubList/supplementCard?id="+ contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=proSubCard";
            } else {
                linkUrl = getBaseHost()+"ejc-prosub-frontend/#/proSubList/supplementCard?id="+ contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&performanceStatus=" + contractVO.getPerformanceStatus() + "&cardType=proSubDirectCard";
            }
        }

        return linkUrl;
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(ContractEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(ContractEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    private void resetPid(List<ContractDetailEntity> detailList) {
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap=new HashMap<>();
            for(ContractDetailEntity cdEntity : detailList){
                if (!("del").equals(cdEntity.getRowState())){
                    if (cdEntity.getId() == null){
                        cdEntity.setId(IdWorker.getId());
                    }
//                    idMap.put(cdEntity.getTid().toString()+cdEntity.getSourceType(),cdEntity.getId());
//                    cdEntity.setParentId(null);
                }
            }
//            for(ContractDetailEntity cdEntity : detailList){
//                if (!("del").equals(cdEntity.getRowState())){
//                    if(StringUtils.isNotEmpty(cdEntity.getTpid())){
//                        cdEntity.setParentId(idMap.get(cdEntity.getTpid().toString()+cdEntity.getSourceType()));
//                    }
//                }
//            }
        }
    }


    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(ContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }


    /**
     * 查询补充协议代入的主合同信息
     * @param contractId
     * @return
     */
    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = super.selectById(contractId);
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());

        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
        return supplementVO;
    }


    @Override
    public String getFilingTypeConfig() {
        /*
            归档参数 filingTypeConfig 为
            o: 不做控制
            1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
            2： 合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
         */
        String filingTypeConfig = "0";
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(FILLING_TYPE_STATE);
        if (!response.isSuccess() || response.getData() == null) {
            logger.error("根据归档参数编码-{}，查询系统参数（合同归档控制）配置信息，失败原因：{}", FILLING_TYPE_STATE, response.getMsg());
        }else {
            if (null != response.getData().getValueData()){
                filingTypeConfig = response.getData().getValueData();
            }
        }
        return filingTypeConfig;
    }

    @Override
    public Boolean checkFilingType(Long contractId, String contractTypeCode) {
        /*
         *      0: 不做控制
         *      1: 合同未归档，不允变更、补充协议、结算、付款（结算、付款等业务过滤未归档合同）；
         *      2：合同未归档，限制所有业务（所有合同参照都过滤未归档合同）
         */
        Boolean addFlag = true;
        ContractEntity contractEntity = super.selectById(contractId);
        //未归档
        if (null != contractEntity && 1 != contractEntity.getFilingStatus()){
            String filingTypeConfig = this.getFilingTypeConfig();
            if ("1".equals(filingTypeConfig)){
                switch (ContractFilingTypeEnum.getEnumByCode(contractTypeCode)){
                    case 分包合同变更:
                        addFlag = false;
                        break;
                    case 分包合同补充协议:
                        addFlag = false;
                        break;
                    case 分包合同月度结算:
                        addFlag = false;
                        break;
                    case 分包合同节点结算:
                        addFlag = false;
                        break;
                    case 分包合同最终结算:
                        addFlag = false;
                        break;
                }
            }else if ("2".equals(filingTypeConfig)){
                addFlag = false;
            }else {
                addFlag = true;
            }
        }
        return addFlag;
    }

    /**
     * 历史价控合同价
     * @param contractVO
     * @return
     */
    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(ContractVO contractVO) {
        logger.info("prosub---ContractServiceImpl---historyPriceCtrlContractPrice()--- 历史价控合同价入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        // 分包价格库查询价格类型（云南建投不做处理，一建查询综合单价类型）
//        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(PRICE_LIB_CHECK_TYPE);
//        if (!response.isSuccess() || response.getData() == null) {
//            throw new BusinessException("获取分包价格库查询价格类型系统参数请求失败，失败原因：" + response.getMsg());
//        }
//        String valueData = response.getData().getValueData();
//        if (StringUtils.isNotBlank(valueData) && valueData.contains("全部")){
//            //全部不做校验
//            logger.info("获取分包价格库查询价格类型系统参数为全部，则不做价格库校验！");
//            return paramsCheckVOList;
//        }

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        Integer contractType = contractVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        List<ContractDetailVO> detailList = contractVO.getDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("分包合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("分包合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (ContractDetailVO  detailVO: detailList) {//遍历明细
                    //非综合单价的数据不进行校验
//                    if (null == detailVO.getDocPriceTypeName() || !"综合单价".equals(detailVO.getDocPriceTypeName())){
//                        continue;
//                    }
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDetailPrice()==null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("分包清单单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("分包清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                for (ContractDetailVO  detailVO: detailList) {//遍历明细
                    //非综合单价的数据不进行校验
//                    if (null == detailVO.getDocPriceTypeName() || !"综合单价".equals(detailVO.getDocPriceTypeName())){
//                        continue;
//                    }
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDetailPrice()==null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("分包清单单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("分包清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> targetCostPriceCtrlContractPrice(ContractVO contractVO) {
        logger.info("prosub---ContractServiceImpl---targetCostPriceCtrlContractPrice()--- 目标成本价控合同价入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        Integer contractType = contractVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        List<ContractDetailVO> detailList = contractVO.getDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_TARGET_COST_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_TARGET_COST_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询目标成本价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数目标成本价查询结果：{}", JSONObject.toJSONString(maxParamByCode));
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果

        List<Long> docIds = detailList.stream().filter(item -> null != item.getDetailNum()).map(ContractDetailVO::getDocId).collect(Collectors.toList());
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByDocIds(contractVO.getProjectId(), 0 == contractType ? DocTypeEnum.劳务分包档案.getCode() : DocTypeEnum.专业分包档案.getCode() , docIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVOList;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();

        logger.info("目标成本价参数控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        if (null == dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVOList;
        }
        logger.info("目标成本价map信息返回："+JSONObject.toJSONString(dutyMap));
        if(CollectionUtils.isNotEmpty(maxParamVOS)){
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (ContractDetailVO detailVO: detailList) {//遍历明细
                    if (null != detailVO.getDetailNum()){
                        BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : dutyMap.get(detailVO.getDocId()).setScale(4, BigDecimal.ROUND_HALF_UP);//获取目标成本价格
                        BigDecimal price = null == detailVO.getDetailPrice() ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//档案单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        logger.info("marpriceparam:{},price:{},maxprice:{}", maxPriceParam,price,maxPrice);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getDetailWorkContent() == null ? "" : "+" + detailVO.getDetailWorkContent()));
                            paramsCheckDsVO.setWarnName("合同单价大于目标成本单价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("合同单价：").append(price)
                                    .append("元，目标成本单价：(").append(maxPrice)
                                    .append("元),目标成本单价*").append(roleValueMax).append("%：").append(maxPriceParam)
                                    .append("元，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP)).append("元");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public String getBillType(Long id, Integer contractType) {
        //设置业务类型
        switch (contractType) {
            case 0:
                return ProsubBillTypeEnum.劳务分包合同.getBillTypeCode();
            case 1:
                return ProsubBillTypeEnum.专业分包合同.getBillTypeCode();
            case 2:
                return ProsubBillTypeEnum.特种设备租赁合同.getBillTypeCode();
            case 3:
                return ProsubBillTypeEnum.其他分包合同.getBillTypeCode();
            default:
                logger.error("合同id-{}错误的合同类型:{}", id, contractType);
                throw new BusinessException("错误的合同类型");
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response,Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同大类表查询到的数据，key为 当前行的 合同大类+&+合同类别，value为查询到的合同大类数据
        //Map<String, contractCategoryId> categoryMap = new HashMap<>();
        // 用于存储合同编码为空的数据查询到的合同数据，key为 当前行的合同名称
        Map<String, ContractEntity> contractPoolVoNoCodeMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();
//        Map<String, SyncContractEntity> syncContractEntityMap = new HashMap<>();
        // 用于存储从员工查询到的数据，key为 当前行的 经办人，value为查询到的经办人数据
        Map<String, EmployeeVO> employeeVOMap = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportContractVO> successList = new ArrayList<>();
            List<ImportContractVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 15) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                // 从自定义档案接口查询发票类型并封装成map
                Map<String, String> defMap = new HashMap<>();
                Map<String, Object> defParamMap = new HashMap<>();
                defParamMap.put("tenantId", tenantid);
                String defCondition = JSONObject.toJSONString(defParamMap);
                CommonResponse<List<Map<String, Object>>> defRes = defdocApi.queryDetailListByDefdocCode("tax-invoice-type", defCondition);
                if (defRes.isSuccess() && defRes.getData() != null) {
                    List<Map<String, Object>> defList = defRes.getData();
                    defMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }

                // 从自定义档案接口查询质量标准并封装成map
                Map<String, String> qualityMap = new HashMap<>();
                Map<String, Object> qualityParamMap = new HashMap<>();
                qualityParamMap.put("tenantId", tenantid);
                String qualityCondition = JSONObject.toJSONString(qualityParamMap);
                CommonResponse<List<Map<String, Object>>> qualityRes = defdocApi.queryDetailListByDefdocCode("quality-leave", qualityCondition);
                if (defRes.isSuccess() && defRes.getData() != null) {
                    List<Map<String, Object>> defList = defRes.getData();
                    qualityMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }


                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportContractVO detailVO = new ImportContractVO();
                    // 从Excel拿到的数据
                    String projectNameEx = datas.get(0);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String contractNameEx = datas.get(1);// 合同名称，必填项
                    detailVO.setContractName(contractNameEx);
                    String contractCategoryName = datas.get(2);// 合同类别，必填项，合同类别与合同大类必须匹配
                    detailVO.setContractCategoryName(contractCategoryName);
                    String firstPartyName = datas.get(3);// 甲方，必填项
                    detailVO.setFirstPartyName(firstPartyName);
                    String supplierName = datas.get(4);// 乙方，必填项
                    detailVO.setSupplierName(supplierName);
                    String signDateStrEx = datas.get(5);// 签订日期，必填项，日期
                    String signPlaceEx = datas.get(6);// 签订地点，非必填
                    detailVO.setSignPlace(signPlaceEx);
                    String contractStatus = datas.get(7); //合同履约状态，必填
                    detailVO.setPerformanceStatus(contractStatus);
                    String employeeName = datas.get(8); //甲方经办人,必填
                    detailVO.setEmployeeName(employeeName);
                    String emploeePhone = datas.get(9); //甲方电话,必填
                    detailVO.setEmployeePhone(emploeePhone);
                    String supplierEmployee = datas.get(10);// 乙方经办人,非必填
                    detailVO.setSupplierEmployee(supplierEmployee);
                    String supplierEmployeePhone = datas.get(11);// 乙方经办人电话,非必填
                    detailVO.setSupplierEmployeePhone(supplierEmployeePhone);
                    String projectPlace = datas.get(12); //项目地点 非必填
                    detailVO.setProjectAddress(projectPlace);
                    String taxRate = datas.get(13);// 税率，数值，必填项，大于等于0，保留2位小数
                    String pricingType = datas.get(14);//计价方式,必填
                    detailVO.setPricingType(pricingType);

                    if (org.apache.commons.lang3.StringUtils.isBlank(projectNameEx)) {
                        detailVO.setErrorMessage("项目名称不可为空");
                    } else {
                        // 优先查询缓存map
                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                            if (projectVOListRes.isSuccess()) {
                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
                                if (CollectionUtils.isEmpty(projectVOList)) {
                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                } else {
                                    if (projectVOList.size() == 1) {
                                        // 存储到缓存map
                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
                                        // 项目所在项目部
                                        Long projectDepartmentId = projectPoolSetVO.getProjectDepartmentId();
                                        if (MapUtils.isEmpty(projectOrgVoMap) || projectOrgVoMap.get(projectDepartmentId.toString()) == null) {
                                            // 缓存map为空或无当前行数据，调用接口查询
                                            CommonResponse<OrgVO> orgVOCommonResponse = orgApi.detailById(projectDepartmentId);
                                            if (orgVOCommonResponse.isSuccess()) {
                                                OrgVO orgVO = orgVOCommonResponse.getData();
                                                if (orgVO == null) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    // 存入缓存map
                                                    projectOrgVoMap.put(projectDepartmentId.toString(), orgVO);
                                                    // 封装数据
                                                    orgIdP = orgVO.getId();
                                                    String innerCode = orgVO.getInnerCode();
                                                    if (org.apache.commons.lang3.StringUtils.isEmpty(innerCode)) {
                                                        detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                                    } else {
                                                        List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                        if (!innerCodes.contains(orgIdP)) {
                                                            detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                        } else {
//                                                            detailVO.setProjectName(projectNameEx);
                                                            detailVO.setOrgId(orgVO.getId());
                                                            detailVO.setOrgCode(orgVO.getCode());
                                                            detailVO.setOrgName(orgVO.getName());
                                                        }
                                                    }
                                                }
                                            } else {
                                                detailVO.setErrorMessage("根据项目名称和编码查询所在项目部信息失败");
                                            }
                                        } else {
                                            // 缓存map有当前数据
                                            OrgVO orgVO = projectOrgVoMap.get(projectDepartmentId.toString());
                                            String innerCode = orgVO.getInnerCode();
                                            if (org.apache.commons.lang3.StringUtils.isEmpty(innerCode)) {
                                                detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                            } else {
                                                List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                if (!innerCodes.contains(orgIdP)) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    detailVO.setOrgId(orgVO.getId());
                                                    detailVO.setOrgCode(orgVO.getCode());
                                                    detailVO.setOrgName(orgVO.getName());
                                                }
                                            }
                                        }
                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                                        // 封装数据
                                        detailVO.setProjectId(projectPoolSetVO.getId());
                                        detailVO.setProjectCode(projectPoolSetVO.getCode());
                                        detailVO.setProjectName(projectPoolSetVO.getName());
                                    } else {
                                        detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("根据项目名称查询项目失败");
                            }
                        } else {
                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectCode(projectPoolSetVO.getCode());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                            detailVO.setOrgId(projectPoolSetVO.getOrgId());
                            detailVO.setOrgCode(projectPoolSetVO.getOrgCode());
                            detailVO.setOrgName(projectPoolSetVO.getOrgName());
                        }
                    }

                    //项目所属单位
//                    if (org.apache.commons.lang3.StringUtils.isNotBlank(parentOrgName)) {
//                        // 与【组织管理】“组织名称”进行匹配
//                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
//                        if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(parentOrgName) == null) {
//                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(parentOrgName, tenantid);
//                            if (orgVORes.isSuccess()) {
//                                OrgVO orgVO = orgVORes.getData();
//                                if (orgVO == null) {
//                                    detailVO.setErrorMessage("根据项目所属单位查询数据失败");
//                                } else {
//                                    // 将查询到的数据缓存到map中
//                                    orgVOMap.put(parentOrgName, orgVO);
//                                    // 封装数据
//                                    orgIdP = orgVO.getId();
//                                    detailVO.setParentOrgId(orgVO.getId());
//                                    detailVO.setParentOrgCode(orgVO.getCode());
//                                    detailVO.setParentOrgName(orgVO.getName());
//                                }
//                            } else {
//                                detailVO.setErrorMessage("根据项目所属单位查询数据失败");
//                            }
//                        } else {
//                            OrgVO orgVO = orgVOMap.get(parentOrgName);
//                            detailVO.setParentOrgId(orgVO.getId());
//                            detailVO.setParentOrgCode(orgVO.getCode());
//                            detailVO.setParentOrgName(orgVO.getName());
//                        }
//                    }

                    // 合同名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractNameEx)) {
                        detailVO.setErrorMessage("合同名称不可为空");
                    } else {
                        detailVO.setContractName(contractNameEx);
                    }

                    //合同类别
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractCategoryName)) {
                        detailVO.setErrorMessage("合同类别不能为空");
                    } else if (flag.equals(0)) {
                        if ("劳务".equals(contractCategoryName)){
                            detailVO.setContractCategoryId(1871018331562053633L);
                            detailVO.setContractCategoryName(contractCategoryName);
                        }else{
                            detailVO.setErrorMessage("合同类别错误");
                        }
                    }else if (flag.equals(1)){
                        if ("专业".equals(contractCategoryName)){
                            detailVO.setContractCategoryId(1871018377540014082L);
                            detailVO.setContractCategoryName(contractCategoryName);
                        }else{
                            detailVO.setErrorMessage("合同类别错误");
                        }
                    }

                    // 甲方
                    if (StringUtils.isBlank(firstPartyName)) {
                        detailVO.setErrorMessage("合同甲方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(firstPartyName) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(firstPartyName,tenantid);
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(firstPartyName, orgVO);
                                    // 封装数据
                                    detailVO.setFirstPartyId(orgVO.getId());
                                    detailVO.setFirstPartyName(orgVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同甲方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(firstPartyName);
                            detailVO.setFirstPartyId(orgVO.getId());
                            detailVO.setFirstPartyName(orgVO.getName());

                        }
                    }


                    //乙方
                    if (org.apache.commons.lang3.StringUtils.isBlank(supplierName)) {
                        detailVO.setErrorMessage("合同乙方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(supplierName) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(supplierName,tenantid);

                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(supplierName, orgVO);
                                    // 封装数据
                                    detailVO.setSupplierId(orgVO.getId());
                                    detailVO.setSupplierName(orgVO.getName());

                                }
                            } else {
                                detailVO.setErrorMessage("根据合同乙方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(supplierName);
                            detailVO.setSupplierId(orgVO.getId());
                            detailVO.setSupplierName(orgVO.getName());

                        }
                    }

                    //甲方经办人
                    if (org.apache.commons.lang3.StringUtils.isBlank(employeeName)) {
                        detailVO.setErrorMessage("甲方经办人不能为空");
                    } else {
                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(employeeName) == null) {
                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(employeeName));
                            if (map.isSuccess()) {
                                Map<String, EmployeeVO> data = map.getData();
                                if (data == null || data.size() == 0) {
                                    detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                                } else {
                                    EmployeeVO employeeVO = data.get(employeeName);
                                    employeeVOMap.put(employeeName, employeeVO);
                                    detailVO.setEmployeeId(employeeVO.getId());
                                    detailVO.setEmployeeName(employeeVO.getName());
                                }

                            } else {
                                detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                            }
                        } else {
                            EmployeeVO employeeVO = employeeVOMap.get(employeeName);
                            detailVO.setEmployeeId(employeeVO.getId());
                            detailVO.setEmployeeName(employeeVO.getName());
                        }
                    }

                    //甲方经办人电话
                    if (org.apache.commons.lang3.StringUtils.isBlank(emploeePhone)) {
                        detailVO.setErrorMessage("甲方经办人电话不能为空");
                    } else {
                        detailVO.setEmployeePhone(emploeePhone);
                    }


                    //乙方经办人
                    detailVO.setSupplierEmployee(supplierEmployee);
//                    if (org.apache.commons.lang3.StringUtils.isBlank(supplierEmployee)) {
//                        detailVO.setErrorMessage("乙方经办人不能为空");
//                    } else {
//                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(supplierEmployee) == null) {
//                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(supplierEmployee));
//                            if (map.isSuccess()) {
//                                Map<String, EmployeeVO> data = map.getData();
//                                if (data == null || data.size() == 0) {
//                                    detailVO.setErrorMessage("根据乙方经办人查询数据失败");
//                                } else {
//                                    EmployeeVO employeeVO = data.get(supplierEmployee);
//                                    employeeVOMap.put(supplierEmployee, employeeVO);
//                                    detailVO.setEmployeeId(employeeVO.getId());
//                                    detailVO.setSupplierEmployee(employeeVO.getName());
//                                }
//
//                            } else {
//                                detailVO.setErrorMessage("根据乙方经办人查询数据失败");
//                            }
//                        } else {
//                            EmployeeVO employeeVO = employeeVOMap.get(supplierEmployee);
//                            detailVO.setEmployeeId(employeeVO.getId());
//                            detailVO.setSupplierEmployee(employeeVO.getName());
//                        }
//                    }
                    //乙方经办人电话
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(supplierEmployeePhone)) {
                        detailVO.setSupplierEmployeePhone(supplierEmployeePhone);
                    }

                    // 签订日期
                    if (StringUtils.isBlank(signDateStrEx)) {
                        detailVO.setErrorMessage("签订日期不可为空");
                    } else {
                        try {
                            detailVO.setSignDate(HSSFDateUtil.getJavaDate(Double.parseDouble(signDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }
                    // 签约地点
                    detailVO.setSignPlace(signPlaceEx);

                    //计价方式
                    if (org.apache.commons.lang.StringUtils.isBlank(pricingType)){
                        detailVO.setErrorMessage("计价方式不可为空");
                    }else{
                        if (pricingType.equals("固定总价")){
                            detailVO.setPricingType("2");
                            detailVO.setPricingTypeId(1529281744145346561L);
                        }else if (pricingType.equals("费率合同")){
                            detailVO.setPricingType("3");
                            detailVO.setPricingTypeId(1529639863568429057L);

                        }else if (pricingType.equals("固定单价")){
                            detailVO.setPricingType("4");
                            detailVO.setPricingTypeId(1529639911836479490L);

                        }else if (pricingType.equals("可调单价")){
                            detailVO.setPricingTypeId(1529281382470512641L);
                            detailVO.setPricingType("1");
                        }else{
                            detailVO.setErrorMessage("计价方式填写不正确");
                        }
                    }

                    //项目地点
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(projectPlace)) {
                        detailVO.setProjectAddress(projectPlace);
                    }


                    // 税率
                    if (org.apache.commons.lang3.StringUtils.isBlank(taxRate)) {
                        detailVO.setErrorMessage("税率不可为空");
                    } else {
                        try {
                            BigDecimal taxRate1 = new BigDecimal(taxRate);
                            if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                            } else {
                                detailVO.setTaxRate(taxRate1);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                        }
                    }


                    //合同履约状态
                    if (StringUtils.isBlank(contractStatus)) {
                        detailVO.setErrorMessage("合同履约状态不可为空");
                    } else{
                        if (StringUtils.isBlank(contractStatus)){
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                        }
                        if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getCode());
                        } else {
                            detailVO.setErrorMessage("合同履约状态填写不正确");
                        }
                    }

                    // 封装返回的数据
                    if (StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
//                        detailVO.setHandleType(1);
//                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                    //归档状态
                    detailVO.setSupplementFlag(0);
//                    detailVO.setSupplementFlagName("否");
                    detailVO.setFilingStatus(0);
                    detailVO.setContractType(flag);
                    detailVO.setSignatureStatus("1");
                    detailVO.setDraftType("3");
                    detailVO.setAddType(1);
                    detailVO.setSupplementFlag(0);
//                    detailVO.setPurchaseType("1");
//                    if (flag.equals(0)){
//                        detailVO.setContractPropertyCode("proMaterial-1");
//                        detailVO.setContractPropertyName("大宗材");
//                    }else{
//                        detailVO.setContractPropertyCode("contractConcrete-1");
//                        detailVO.setContractPropertyName("混凝土");
//                    }

                }
            }
            // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);

            // 拼接入库数据并入库
            Date createTime = new Date();
            UserContext userContext = sessionManager.getUserContext();
            String userCode = "";
            if (userContext != null) {
                userCode = userContext.getUserCode();
            }
            List<ContractVO> sucVoList = BeanMapper.mapList(successList,ContractVO.class);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(sucVoList)) {
                for (ContractVO vo : sucVoList) {
                    vo.setCreateTime(createTime);
                    vo.setCreateUserCode(userCode);
                    long contractId = com.ejianc.support.idworker.util.IdWorker.getId();
                    //vo.setContractId(contractId);
//                    vo.setSourceId(contractId);
                    if (org.apache.commons.lang3.StringUtils.isBlank(vo.getBillCode())) {
//                        String contractBillCode = getContractBillCode(vo);
//                        vo.setBillCode(contractBillCode);
                        BillCodeParam billCodeParam = null;
                        if(flag == 0){
                            billCodeParam = BillCodeParam.build(LABOR_SUB_BILL_CODE, tenantid, vo);
                        }else{
                            billCodeParam = BillCodeParam.build(PROS_SUB_BILL_CODE, tenantid, vo);
                        }
                        CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
                        if(billCodeRes.isSuccess()) {
                            vo.setBillCode(billCodeRes.getData());
                        }else{
                            throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                        }
                    }
                }
                List<ContractEntity> sucEntityList = BeanMapper.mapList(sucVoList, ContractEntity.class);
                saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
            }
            return CommonResponse.success(json);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImportEquipment(HttpServletRequest request, HttpServletResponse response, Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同大类表查询到的数据，key为 当前行的 合同大类+&+合同类别，value为查询到的合同大类数据
        //Map<String, contractCategoryId> categoryMap = new HashMap<>();
        // 用于存储合同编码为空的数据查询到的合同数据，key为 当前行的合同名称
        Map<String, ContractEntity> contractPoolVoNoCodeMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();
//        Map<String, SyncContractEntity> syncContractEntityMap = new HashMap<>();
        // 用于存储从员工查询到的数据，key为 当前行的 经办人，value为查询到的经办人数据
        Map<String, EmployeeVO> employeeVOMap = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportContractVO> successList = new ArrayList<>();
            List<ImportContractVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 16) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                //查询税务-发票类型
                CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode("tax-invoice-type");
                if (!defDocByDefCode.isSuccess()){
                    throw new BusinessException("查询税务-发票类型自定义档案失败！");
                }
                List<DefdocDetailVO> defDocByDefCodeData = defDocByDefCode.getData();
                Map<String, DefdocDetailVO> defdocDetailVOMap = defDocByDefCodeData.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity()));
                //查询合同类别
                CommonResponse<List<TemplateCategoryVO>> querySelfAndChildById = templateCategoryApi.querySelfAndChildById(1479273825119621123L);
                if (!querySelfAndChildById.isSuccess()){
                    throw new BusinessException("查询合同类别失败！");
                }
                List<TemplateCategoryVO> querySelfAndChildByIdData = querySelfAndChildById.getData();
                Map<String, TemplateCategoryVO> categoryVOMap = querySelfAndChildByIdData.stream().filter(s->s.getPid() != null).collect(Collectors.toMap(TemplateCategoryVO::getCategoryName, Function.identity()));


                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportContractVO detailVO = new ImportContractVO();
                    // 从Excel拿到的数据
                    String projectNameEx = datas.get(0);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String contractNameEx = datas.get(1);// 合同名称，必填项
                    detailVO.setContractName(contractNameEx);
                    String contractCategoryName = datas.get(2);// 合同类别，必填项，合同类别与合同大类必须匹配
                    detailVO.setContractCategoryName(contractCategoryName);
                    String firstPartyName = datas.get(3);// 甲方，必填项
                    detailVO.setFirstPartyName(firstPartyName);
                    String supplierName = datas.get(4);// 乙方，必填项
                    detailVO.setSupplierName(supplierName);
                    String signDateStrEx = datas.get(5);// 签订日期，必填项，日期
                    String contractStatus = datas.get(6); //合同履约状态，必填
                    detailVO.setPerformanceStatus(contractStatus);
                    String employeeName = datas.get(7); //甲方经办人,必填
                    detailVO.setEmployeeName(employeeName);
                    String emploeePhone = datas.get(8); //甲方电话,必填
                    detailVO.setEmployeePhone(emploeePhone);
                    String supplierEmployee = datas.get(9);// 乙方经办人,非必填
                    detailVO.setSupplierEmployee(supplierEmployee);
                    String supplierEmployeePhone = datas.get(10);// 乙方经办人电话,非必填
                    detailVO.setSupplierEmployeePhone(supplierEmployeePhone);
                    String projectPlace = datas.get(11); //项目地点 非必填
                    detailVO.setProjectAddress(projectPlace);
                    String taxRate = datas.get(12);// 税率，数值，必填项，大于等于0，保留2位小数
                    //特种设备
                    String pricingType = datas.get(13);
                    if (flag == 2){
                        detailVO.setPricingType(pricingType);
                    }

                    //其他
                    if (flag == 3){
                        if ("未归档".equals(pricingType)){
                            detailVO.setFilingStatus(0);
                        }
                        if ("已归档".equals(pricingType)){
                            detailVO.setFilingStatus(1);
                        }
                        if ("归档中".equals(pricingType)){
                            detailVO.setFilingStatus(2);
                        }
                    }

                    String invoiceTypeName = datas.get(14);//发票类型
                    detailVO.setInvoiceTypeName(invoiceTypeName);
                    String payCommit = datas.get(15);//备注
                    detailVO.setPayCommit(payCommit);

                    if (org.apache.commons.lang3.StringUtils.isBlank(projectNameEx)) {
                        detailVO.setErrorMessage("项目名称不可为空");
                    } else {
                        // 优先查询缓存map
                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                            if (projectVOListRes.isSuccess()) {
                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
                                if (CollectionUtils.isEmpty(projectVOList)) {
                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                } else {
                                    if (projectVOList.size() == 1) {
                                        // 存储到缓存map
                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
                                        // 项目所在项目部
                                        Long projectDepartmentId = projectPoolSetVO.getProjectDepartmentId();
                                        if (MapUtils.isEmpty(projectOrgVoMap) || projectOrgVoMap.get(projectDepartmentId.toString()) == null) {
                                            // 缓存map为空或无当前行数据，调用接口查询
                                            CommonResponse<OrgVO> orgVOCommonResponse = orgApi.detailById(projectDepartmentId);
                                            if (orgVOCommonResponse.isSuccess()) {
                                                OrgVO orgVO = orgVOCommonResponse.getData();
                                                if (orgVO == null) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    // 存入缓存map
                                                    projectOrgVoMap.put(projectDepartmentId.toString(), orgVO);
                                                    // 封装数据
                                                    orgIdP = orgVO.getId();
                                                    String innerCode = orgVO.getInnerCode();
                                                    if (org.apache.commons.lang3.StringUtils.isEmpty(innerCode)) {
                                                        detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                                    } else {
                                                        List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                        if (!innerCodes.contains(orgIdP)) {
                                                            detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                        } else {
                                                            detailVO.setOrgId(orgVO.getId());
                                                            detailVO.setOrgCode(orgVO.getCode());
                                                            detailVO.setOrgName(orgVO.getName());
                                                            detailVO.setParentOrgId(projectPoolSetVO.getOrgId());
                                                            detailVO.setParentOrgName(projectPoolSetVO.getOrgName());
                                                            detailVO.setParentOrgCode(projectPoolSetVO.getOrgCode());
                                                        }
                                                    }
                                                }
                                            } else {
                                                detailVO.setErrorMessage("根据项目名称和编码查询所在项目部信息失败");
                                            }
                                        } else {
                                            // 缓存map有当前数据
                                            OrgVO orgVO = projectOrgVoMap.get(projectDepartmentId.toString());
                                            String innerCode = orgVO.getInnerCode();
                                            if (org.apache.commons.lang3.StringUtils.isEmpty(innerCode)) {
                                                detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                            } else {
                                                List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                if (!innerCodes.contains(orgIdP)) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    detailVO.setOrgId(orgVO.getId());
                                                    detailVO.setOrgCode(orgVO.getCode());
                                                    detailVO.setOrgName(orgVO.getName());
                                                    detailVO.setParentOrgId(projectPoolSetVO.getOrgId());
                                                    detailVO.setParentOrgName(projectPoolSetVO.getOrgName());
                                                    detailVO.setParentOrgCode(projectPoolSetVO.getOrgCode());
                                                }
                                            }
                                        }
                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                                        // 封装数据
                                        detailVO.setProjectId(projectPoolSetVO.getId());
                                        detailVO.setProjectCode(projectPoolSetVO.getCode());
                                        detailVO.setProjectName(projectPoolSetVO.getName());
                                    } else {
                                        detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("根据项目名称查询项目失败");
                            }
                        } else {
                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectCode(projectPoolSetVO.getCode());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                            detailVO.setOrgId(projectPoolSetVO.getOrgId());
                            detailVO.setOrgCode(projectPoolSetVO.getOrgCode());
                            detailVO.setOrgName(projectPoolSetVO.getOrgName());
                            detailVO.setParentOrgId(projectPoolSetVO.getOrgId());
                            detailVO.setParentOrgName(projectPoolSetVO.getOrgName());
                            detailVO.setParentOrgCode(projectPoolSetVO.getOrgCode());
                        }
                    }

                    // 合同名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractNameEx)) {
                        detailVO.setErrorMessage("合同名称不可为空");
                    } else {
                        detailVO.setContractName(contractNameEx);
                    }

                    //合同类别
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractCategoryName)) {
                        detailVO.setErrorMessage("合同类别不能为空");
                    } else{
                        if (categoryVOMap.containsKey(contractCategoryName)){
                            TemplateCategoryVO templateCategoryVO = categoryVOMap.get(contractCategoryName);
                            detailVO.setContractCategoryId(templateCategoryVO.getId());
                            detailVO.setContractCategoryName(templateCategoryVO.getCategoryName());
                        }
                    }
                    //发票类型
                    if (org.apache.commons.lang3.StringUtils.isBlank(invoiceTypeName)) {
                        detailVO.setErrorMessage("发票类型不能为空");
                    } else{
                        if (defdocDetailVOMap.containsKey(invoiceTypeName)){
                            DefdocDetailVO defdocDetailVO = defdocDetailVOMap.get(invoiceTypeName);
                            detailVO.setInvoiceTypeName(defdocDetailVO.getName());
                            detailVO.setInvoiceTypeId(defdocDetailVO.getId());
                        }
                    }

                    // 甲方
                    if (StringUtils.isBlank(firstPartyName)) {
                        detailVO.setErrorMessage("合同甲方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(firstPartyName) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(firstPartyName,tenantid);
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(firstPartyName, orgVO);
                                    // 封装数据
                                    detailVO.setFirstPartyId(orgVO.getId());
                                    detailVO.setFirstPartyName(orgVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同甲方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(firstPartyName);
                            detailVO.setFirstPartyId(orgVO.getId());
                            detailVO.setFirstPartyName(orgVO.getName());

                        }
                    }


                    //乙方
                    if (org.apache.commons.lang3.StringUtils.isBlank(supplierName)) {
                        detailVO.setErrorMessage("合同乙方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(supplierName) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(supplierName,tenantid);

                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(supplierName, orgVO);
                                    // 封装数据
                                    detailVO.setSupplierId(orgVO.getId());
                                    detailVO.setSupplierName(orgVO.getName());

                                }
                            } else {
                                detailVO.setErrorMessage("根据合同乙方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(supplierName);
                            detailVO.setSupplierId(orgVO.getId());
                            detailVO.setSupplierName(orgVO.getName());

                        }
                    }

                    //甲方经办人
                    if (org.apache.commons.lang3.StringUtils.isBlank(employeeName)) {
                        detailVO.setErrorMessage("甲方经办人不能为空");
                    } else {
                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(employeeName) == null) {
                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(employeeName));
                            if (map.isSuccess()) {
                                Map<String, EmployeeVO> data = map.getData();
                                if (data == null || data.size() == 0) {
                                    detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                                } else {
                                    EmployeeVO employeeVO = data.get(employeeName);
                                    employeeVOMap.put(employeeName, employeeVO);
                                    detailVO.setEmployeeId(employeeVO.getId());
                                    detailVO.setEmployeeName(employeeVO.getName());
                                }

                            } else {
                                detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                            }
                        } else {
                            EmployeeVO employeeVO = employeeVOMap.get(employeeName);
                            detailVO.setEmployeeId(employeeVO.getId());
                            detailVO.setEmployeeName(employeeVO.getName());
                        }
                    }

                    //甲方经办人电话
                    if (org.apache.commons.lang3.StringUtils.isBlank(emploeePhone)) {
                        detailVO.setErrorMessage("甲方经办人电话不能为空");
                    } else {
                        detailVO.setEmployeePhone(emploeePhone);
                    }


                    //乙方经办人
                    //乙方经办人
                    detailVO.setSupplierEmployee(supplierEmployee);
//                    if (org.apache.commons.lang3.StringUtils.isBlank(supplierEmployee)) {
//                        detailVO.setErrorMessage("乙方经办人不能为空");
//                    } else {
//                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(supplierEmployee) == null) {
//                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(supplierEmployee));
//                            if (map.isSuccess()) {
//                                Map<String, EmployeeVO> data = map.getData();
//                                if (data == null || data.size() == 0) {
//                                    detailVO.setErrorMessage("根据乙方经办人查询数据失败");
//                                } else {
//                                    EmployeeVO employeeVO = data.get(supplierEmployee);
//                                    employeeVOMap.put(supplierEmployee, employeeVO);
//                                    detailVO.setEmployeeId(employeeVO.getId());
//                                    detailVO.setSupplierEmployee(employeeVO.getName());
//                                }
//
//                            } else {
//                                detailVO.setErrorMessage("根据乙方经办人查询数据失败");
//                            }
//                        } else {
//                            EmployeeVO employeeVO = employeeVOMap.get(supplierEmployee);
//                            detailVO.setEmployeeId(employeeVO.getId());
//                            detailVO.setSupplierEmployee(employeeVO.getName());
//                        }
//                    }
                    //乙方经办人电话
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(supplierEmployeePhone)) {
                        detailVO.setSupplierEmployeePhone(supplierEmployeePhone);
                    }

                    // 签订日期
                    if (StringUtils.isBlank(signDateStrEx)) {
                        detailVO.setErrorMessage("签订日期不可为空");
                    } else {
                        try {
                            detailVO.setSignDate(HSSFDateUtil.getJavaDate(Double.parseDouble(signDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }
                    if (flag == 2){
                        //计价方式
                        if (org.apache.commons.lang.StringUtils.isBlank(pricingType)){
                            detailVO.setErrorMessage("计租方式不可为空");
                        }else{

                            if (pricingType.equals("月租")){
                                detailVO.setPricingType("1");
                            }else if (pricingType.equals("工程量租")){
                                detailVO.setPricingType("2");
                            }
                        }
                    }

                    //项目地点
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(projectPlace)) {
                        detailVO.setProjectAddress(projectPlace);
                    }


                    // 税率
                    if (org.apache.commons.lang3.StringUtils.isBlank(taxRate)) {
                        detailVO.setErrorMessage("税率不可为空");
                    } else {
                        try {
                            BigDecimal taxRate1 = new BigDecimal(taxRate);
                            if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                            } else {
                                detailVO.setTaxRate(taxRate1);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                        }
                    }


                    //合同履约状态
                    if (StringUtils.isBlank(contractStatus)) {
                        detailVO.setErrorMessage("合同履约状态不可为空");
                    } else{
                        if (StringUtils.isBlank(contractStatus)){
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                        }
                        if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getCode());
                        } else {
                            detailVO.setErrorMessage("合同履约状态填写不正确");
                        }
                    }

                    // 封装返回的数据
                    if (StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
//                        detailVO.setHandleType(1);
//                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                    //归档状态
                    detailVO.setSupplementFlag(0);
//                    detailVO.setSupplementFlagName("否");
                    detailVO.setFilingStatus(0);
                    detailVO.setContractType(flag);
                    detailVO.setSignatureStatus("1");
                    detailVO.setDraftType("3");
                    detailVO.setAddType(1);
                    detailVO.setSupplementFlag(0);
//                    detailVO.setPurchaseType("1");
//                    if (flag.equals(0)){
//                        detailVO.setContractPropertyCode("proMaterial-1");
//                        detailVO.setContractPropertyName("大宗材");
//                    }else{
//                        detailVO.setContractPropertyCode("contractConcrete-1");
//                        detailVO.setContractPropertyName("混凝土");
//                    }

                }
            }
            // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);

            // 拼接入库数据并入库
            Date createTime = new Date();
            UserContext userContext = sessionManager.getUserContext();
            String userCode = "";
            if (userContext != null) {
                userCode = userContext.getUserCode();
            }
            List<ContractVO> sucVoList = BeanMapper.mapList(successList,ContractVO.class);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(sucVoList)) {
                for (ContractVO vo : sucVoList) {
                    vo.setCreateTime(createTime);
                    vo.setCreateUserCode(userCode);
                    long contractId = com.ejianc.support.idworker.util.IdWorker.getId();
                    //vo.setContractId(contractId);
//                    vo.setSourceId(contractId);
                    if (org.apache.commons.lang3.StringUtils.isBlank(vo.getBillCode())) {
//                        String contractBillCode = getContractBillCode(vo);
//                        vo.setBillCode(contractBillCode);
                        BillCodeParam billCodeParam = null;
                        if(flag == 0){
                            billCodeParam = BillCodeParam.build(LABOR_SUB_BILL_CODE, tenantid, vo);
                        }else{
                            billCodeParam = BillCodeParam.build(PROS_SUB_BILL_CODE, tenantid, vo);
                        }
                        CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
                        if(billCodeRes.isSuccess()) {
                            vo.setBillCode(billCodeRes.getData());
                        }else{
                            throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                        }
                    }
                }
                List<ContractEntity> sucEntityList = BeanMapper.mapList(sucVoList, ContractEntity.class);
                saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
            }
            return CommonResponse.success(json);
        }
    }


    private String getCategoryBigCode(String categoryName) {
        String categoryCode = "";
        if (StringUtils.isBlank(categoryName)) {
            return categoryCode;
        }
        switch (categoryName) {
            case "周转材合同":
                categoryCode = "rmat";
                break;
            case "施工合同":
                categoryCode = "contraction";
                break;
            case "专业分包合同":
                categoryCode = "proSub";
                break;
            case "劳务分包合同":
                categoryCode = "laborSub";
                break;
            case "特种设备租赁合同":
                categoryCode = "equipmentSub";
                break;
            case "其他分包合同":
                categoryCode = "otherSub";
                break;
            case "物资采购合同":
                categoryCode = "contractMaterial";
                break;
            case "混凝土合同":
                categoryCode = "contractConcrete";
                break;
            case "收入合同":
                categoryCode = "contractIn";
                break;
            case "支出合同":
                categoryCode = "contractOut";
                break;
            case "其他收入合同":
                categoryCode = "otherIn";
                break;
            case "其他支出合同":
                categoryCode = "contractOther";
                break;
            case "设备租赁合同":
                categoryCode = "equipmentRent";
                break;
            case "设备采购合同":
                categoryCode = "equipmentPurchase";
                break;
            case "临时设备合同":
                categoryCode = "tempEquip";
                break;
            case "安拆合同":
                categoryCode = "contractAC";
                break;
            case "辅料中心周转材租赁合同":
                categoryCode = "assistrmat";
                break;
            case "辅料中心周转材采购合同":
                categoryCode = "assistmaterial";
                break;
            default:
                break;
        }
        return categoryCode;
    }

    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        logger.info("生成编码规则，GenerateBillCodeType=：{}", GenerateBillCodeType);
        switch (GenerateBillCodeType) {
            case "common":

                //单据业务类型
                Integer contractType = contractVo.getContractType();
                String billCodeStr = getBillCodeStr(contractType);
                BillCodeParam billCodeParam = BillCodeParam
                        .build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    contractBillCode = billCode.getData();
                }
                else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                break;
            case "ynjt":
                BillCodeParam billCodeParamYnjt = BillCodeParam
                        .build(LABSUB_CONTRACT_YNJT01, InvocationInfoProxy.getTenantid(), contractVo);
                CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(billCodeParamYnjt);
                if (!billCodeFirstPart.isSuccess()) {
                    logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                //根据合同基层单位后三位查询查询流水号
                String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                CommonSNVO commonSNVO = new CommonSNVO();
                commonSNVO.setSnLength(4);
                commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                commonSNVO.setDimension(orgSub);
                commonSNVO.setSourceType("YNJTCLCG");
                CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                if (!snResp.isSuccess()) {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                contractBillCode = billCodeFirstPart.getData() + orgSub + snResp.getData();
                break;
            default:
                throw new BusinessException("编码生成失败！");
        }
        return contractBillCode;
    }

    /**
     * 判断当前合同是否能新增补充协议
     * @param id
     * @return
     */
    @Override
    public Boolean addSupplementFlag(Long id) {
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode()))//不是已签章的
                .or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));//单据状态不是1和3的
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }


    // 查询合同下所有单项结算末级清单
    @Override
    public IPage<ContractSettleDetailsReportVO> queryLabProSettleDetails(QueryParam queryParam, boolean exportFlag) {
        Map<String, Object> queryMap = new HashMap<>();
        Page<ContractSettleDetailsReportVO> page = new Page<>(0, 10);
        // 组织隔离
        queryMap.put("orgId", null);
        queryMap.put("parentOrgIdList", null);
        // 结算时间
        queryMap.put("settleDataStart", null);
        queryMap.put("settleDataEnd", null);
        // 过程金额
        queryMap.put("processTaxMnyStart", null);
        queryMap.put("processTaxMnyEnd", null);
        // 节点金额
        queryMap.put("nodeTaxMnyStart", null);
        queryMap.put("nodeTaxMnyEnd", null);
        // 最终金额
        queryMap.put("finalTaxMnyStart", null);
        queryMap.put("finalTaxMnyEnd", null);
        // 最终超结金额
        queryMap.put("finalOverTaxMnyStart", null);
        queryMap.put("finalOverTaxMnyEnd", null);
        // 行内查询
        queryMap.put("contractCode", null);// 合同编码
        queryMap.put("contractName", null);// 合同名称
        queryMap.put("projectName", null);// 项目名称
        queryMap.put("parentOrgName", null);// 所属组织
        queryMap.put("detailCode", null);// 清单编码
        queryMap.put("detailName", null);// 清单名称
        queryMap.put("detailWorkContent", null);// 工作内容
        queryMap.put("detailRule", null);// 计量规则
        queryMap.put("detailUnit", null);// 单位
        // 行内查询条件
        Parameter contractCodeParam = queryParam.getParams().get("contractCode");
        if (contractCodeParam != null && contractCodeParam.getValue() != null) {
            queryMap.put("contractCode", contractCodeParam.getValue().toString());// 合同编码
        }
        Parameter contractNameParam = queryParam.getParams().get("contractName");
        if (contractNameParam != null && contractNameParam.getValue() != null) {
            queryMap.put("contractName", contractNameParam.getValue().toString());// 合同名称
        }
        Parameter projectNameParam = queryParam.getParams().get("projectName");
        if (projectNameParam != null && projectNameParam.getValue() != null) {
            queryMap.put("projectName", projectNameParam.getValue().toString());// 项目名称
        }
        Parameter parentOrgNameParam = queryParam.getParams().get("parentOrgName");
        if (parentOrgNameParam != null && parentOrgNameParam.getValue() != null) {
            queryMap.put("parentOrgName", parentOrgNameParam.getValue().toString());// 所属组织
        }
        Parameter detailCodeParam = queryParam.getParams().get("detailCode");
        if (detailCodeParam != null && detailCodeParam.getValue() != null) {
            queryMap.put("detailCode", detailCodeParam.getValue().toString());// 清单编码
        }
        Parameter detailNameParam = queryParam.getParams().get("detailName");
        if (detailNameParam != null && detailNameParam.getValue() != null) {
            queryMap.put("detailName", detailNameParam.getValue().toString());// 清单名称
        }
        Parameter detailWorkContentParam = queryParam.getParams().get("detailWorkContent");
        if (detailWorkContentParam != null && detailWorkContentParam.getValue() != null) {
            queryMap.put("detailWorkContent", detailWorkContentParam.getValue().toString());// 工作内容
        }
        Parameter detailRuleParam = queryParam.getParams().get("detailRule");
        if (detailRuleParam != null && detailRuleParam.getValue() != null) {
            queryMap.put("detailRule", detailRuleParam.getValue().toString());// 计量规则
        }
        Parameter detailUnitParam = queryParam.getParams().get("detailUnit");
        if (detailUnitParam != null && detailUnitParam.getValue() != null) {
            queryMap.put("detailUnit", detailUnitParam.getValue().toString());// 单位
        }
        // searchText查询条件
        queryMap.put("searchText", null);
        // 租户隔离
        queryMap.put("tenantId", InvocationInfoProxy.getTenantid());
        Parameter contractTypeParam = queryParam.getParams().get("contractType");
        // 分页参数封装
        if (!exportFlag) {
            // 查询
            queryMap.put("start", 0);
            queryMap.put("limit", 10);
            int pageIndex = queryParam.getPageIndex();
            int pageSize = queryParam.getPageSize();
            if (pageIndex > 0 && pageSize > 0) {
                queryMap.put("start", pageIndex - 1);
                queryMap.put("limit", pageSize);
                page.setCurrent(pageIndex - 1);
                page.setSize(pageSize);
            }
        } else {
            // 导出
            queryMap.put("start", null);
            queryMap.put("limit", null);
            page.setCurrent(0);
            page.setSize(-1);
        }
        // 合同类型参数封装-必传参数
        if (contractTypeParam == null) {
            return new Page<>();
        }
        queryMap.put("contractType", contractTypeParam.getValue());
        // 查询本下所有合同，并根据本下所有合同查询所有结算单
        Long orgId = InvocationInfoProxy.getOrgId();
        Parameter orgIdParam = queryParam.getParams().get("orgId");
        if (orgIdParam != null && orgIdParam.getValue() != null) {
            // 前端根据组织树查询，只查询所选组织本下的数据
            orgId = Long.parseLong(orgIdParam.getValue().toString());
            CommonResponse<OrgVO> orgRes = orgApi.detailById(orgId);
            if (orgRes.isSuccess() && orgRes.getData() != null) {
                OrgVO orgVO = orgRes.getData();
                Integer orgType = orgVO.getOrgType();
                if (setOrgParam(queryMap, orgId, orgType)) {
                    return new Page<>();
                }
            }
        } else {
            // 前端未根据组织树查询，此时查询当前登录人的本下所有数据
            if (orgId != null) {
                if (setOrgParam(queryMap, orgId, Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                    return new Page<>();
                }
            }
        }
        // 结算日期参数封装
        Parameter settleDate = queryParam.getParams().get("settleDate");
        if (settleDate != null) {
            String settleDateValue = settleDate.getValue().toString();
            if (StringUtils.isNotBlank(settleDateValue)) {
                String[] settleDateArr = settleDateValue.split(",");
                if (settleDateArr.length > 0) {
                    queryMap.put("settleDataStart", settleDateArr[0]);
                    queryMap.put("settleDataEnd", settleDateArr[1]);
                }
            }
        }
        // 模糊查询参数封装
        String searchText = queryParam.getSearchText();
        if (StringUtils.isNotBlank(searchText)) {
            queryMap.put("searchText", searchText);
        }
        // 月度结算金额
        Parameter processTaxMnyParam = queryParam.getParams().get("processTaxMny");
        // 节点结算金额
        Parameter nodeTaxMnyParam = queryParam.getParams().get("nodeTaxMny");
        // 最终结算金额
        Parameter finalTaxMnyParam = queryParam.getParams().get("finalTaxMny");
        // 最终超结金额
        Parameter finalOverTaxMnyParam = queryParam.getParams().get("finalOverTaxMny");
        // 月度结算金额参数封装
        if (processTaxMnyParam != null && processTaxMnyParam.getValue() != null) {
            String processTaxMny = processTaxMnyParam.getValue().toString();
            String processType = processTaxMnyParam.getType();
            if (StringUtils.isNotBlank(processType)) {
                switch (processType) {
                    case "ge":
                        // 大于等于
                        queryMap.put("processTaxMnyStart",  new BigDecimal(processTaxMny));
                        break;
                    case "le":
                        // 小于等于
                        queryMap.put("processTaxMnyEnd", new BigDecimal(processTaxMny));
                        break;
                    case "between":
                        // 在区间内
                        String[] processTaxMnyStrArr = processTaxMny.split(",");
                        queryMap.put("processTaxMnyStart", new BigDecimal(processTaxMnyStrArr[0]));
                        queryMap.put("processTaxMnyEnd", new BigDecimal(processTaxMnyStrArr[1]));
                        break;
                    default:
                        break;
                }
            }
        }
        // 节点结算金额参数封装
        if (nodeTaxMnyParam != null && nodeTaxMnyParam.getValue() != null) {
            String nodeTaxMny = nodeTaxMnyParam.getValue().toString();
            String nodeType = nodeTaxMnyParam.getType();
            if (StringUtils.isNotBlank(nodeType)) {
                switch (nodeType) {
                    case "ge":
                        // 大于等于
                        queryMap.put("nodeTaxMnyStart", new BigDecimal(nodeTaxMny));
                        break;
                    case "le":
                        // 小于等于
                        queryMap.put("nodeTaxMnyEnd", new BigDecimal(nodeTaxMny));
                        break;
                    case "between":
                        // 在区间内
                        String[] nodeTaxMnyStrArr = nodeTaxMny.split(",");
                        queryMap.put("nodeTaxMnyStart", new BigDecimal(nodeTaxMnyStrArr[0]));
                        queryMap.put("nodeTaxMnyEnd", new BigDecimal(nodeTaxMnyStrArr[1]));
                        break;
                    default:
                        break;
                }
            }
        }
        // 最终结算金额参数封装
        if (finalTaxMnyParam != null && finalTaxMnyParam.getValue() != null) {
            String finalTaxMny = finalTaxMnyParam.getValue().toString();
            String finalType = finalTaxMnyParam.getType();
            if (StringUtils.isNotBlank(finalType)) {
                switch (finalType) {
                    case "ge":
                        // 大于等于
                        queryMap.put("finalTaxMnyStart", new BigDecimal(finalTaxMny));
                        break;
                    case "le":
                        // 小于等于
                        queryMap.put("finalTaxMnyEnd", new BigDecimal(finalTaxMny));
                        break;
                    case "between":
                        // 在区间内
                        String[] finalTaxMnyStrArr = finalTaxMny.split(",");
                        queryMap.put("finalTaxMnyStart", new BigDecimal(finalTaxMnyStrArr[0]));
                        queryMap.put("finalTaxMnyEnd", new BigDecimal(finalTaxMnyStrArr[1]));
                        break;
                    default:
                        break;
                }
            }
        }
        // 最终超结金额参数封装
        if (finalOverTaxMnyParam != null && finalOverTaxMnyParam.getValue() != null) {
            String finalOverTaxMny = finalOverTaxMnyParam.getValue().toString();
            String finalOverType = finalOverTaxMnyParam.getType();
            if (StringUtils.isNotBlank(finalOverType)) {
                switch (finalOverType) {
                    case "ge":
                        // 大于等于
                        queryMap.put("finalOverTaxMnyStart", new BigDecimal(finalOverTaxMny));
                        break;
                    case "le":
                        // 小于等于
                        queryMap.put("finalOverTaxMnyEnd", new BigDecimal(finalOverTaxMny));
                        break;
                    case "between":
                        // 在区间内
                        String[] finalOverTaxMnyStrArr = finalOverTaxMny.split(",");
                        queryMap.put("finalOverTaxMnyStart", new BigDecimal(finalOverTaxMnyStrArr[0]));
                        queryMap.put("finalOverTaxMnyEnd", new BigDecimal(finalOverTaxMnyStrArr[1]));
                        break;
                    default:
                        break;
                }
            }
        }
        // 查数据
        List<ContractSettleDetailsReportVO> list = contractMapper.querySettleDetails(queryMap);
        // 查总条数
        Long count = contractMapper.querySettleDetailsCount(queryMap);
        NumberFormat percent = NumberFormat.getPercentInstance();
        percent.setMaximumFractionDigits(4);
        list.forEach(item -> {
            if (null != item.getFinalNum() && null != item.getContractNum()){
                logger.info("进入结算比例计算！");
                // 最终结算比例 （最终结算数量/清单合同数量*100%）
                BigDecimal finalRate = item.getFinalNum().divide(item.getContractNum(), 2, RoundingMode.HALF_UP);
                item.setFinalRate(finalRate);
                item.setFinalRateStr(percent.format(finalRate));
                logger.info("最终结算比例：{}，最终结算比例Str：{}，最终结算数量：{}，清单合同数量：{}", finalRate, item.getFinalRateStr(), item.getFinalNum(), item.getContractNum());
                // 最终超结比例
                BigDecimal finalOverRate = finalRate.subtract(BigDecimal.valueOf(1));
                item.setFinalOverRate(finalOverRate);
                item.setFinalOverRateStr(percent.format(finalOverRate));
                logger.info("最终超结比例：{}，最终超结比例Str：{}", finalOverRate, item.getFinalOverRateStr());
            }
            //拼接合同穿透URL 区分是否参照定标结果
            String cardType = "";
            Integer addType = item.getAddType();
            String contractType = contractTypeParam.getValue().toString();
            if (addType != null) {
                if (addType == 1) {
                    // 直接新增
                    if ("0".equals(contractType)) {
                        // 劳务
                        cardType = "laborSubDirectCard";
                    } else {
                        // 专业
                        cardType = "proSubDirectCard";
                    }
                } else if (addType == 0) {
                    // 参照定标结果
                    if ("0".equals(contractType)) {
                        // 劳务
                        cardType = "laborSubCard";
                    } else {
                        // 专业
                        cardType = "proSubCard";
                    }
                }
                item.setPcContractCardUrl("/ejc-prosub-frontend/#/laborSubList/contractMultiCards?id=" + item.getContractId() + "&supplementFlag=" + item.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + item.getPerformanceStatus());
            }
            BigDecimal finalOverNum = item.getFinalOverNum();
            if (finalOverNum == null || finalOverNum.compareTo(BigDecimal.ZERO) <= 0) {
                item.setFinalOverNum(null);
                item.setFinalOverTaxMny(null);
                item.setFinalOverRate(null);
                item.setFinalOverRateStr(null);
            }
        });
        page.setRecords(list);
        page.setTotal(count);
        return page;
    }

    @Override
    public IPage<ContractSettleDetailsReportVO> queryLabProSettleDetailsList(Integer pageNumber, Integer pageSize, Long contractDetailId, Integer settleType, Integer contractType, String detailWorkContent, String detailRule) {
        HashMap<String, Object> queryMap = new HashMap<>();
        Page<ContractSettleDetailsReportVO> page = new Page<>(pageNumber, pageSize);
        queryMap.put("contractDetailId", contractDetailId);
        queryMap.put("settleType", settleType);
        queryMap.put("contractType", contractType);
        queryMap.put("detailWorkContent", detailWorkContent);
        queryMap.put("detailRule", detailRule);
        queryMap.put("tenantId", InvocationInfoProxy.getTenantid());
        queryMap.put("start", pageNumber);
        queryMap.put("limit", pageSize);
        List<ContractSettleDetailsReportVO> list = contractMapper.queryLabProSettleDetailsList(queryMap);
        Long count = contractMapper.queryLabProSettleDetailsListCount(queryMap);
        for (ContractSettleDetailsReportVO vo : list) {
            if (vo == null) {
                continue;
            }
            String settleTypeUrl = "";
            String contractTypeUrl = "";
            if (contractType.equals(SettleTypeEnum.过程.getCode())) {
                settleTypeUrl = "processSettle";
            } else if (contractType.equals(SettleTypeEnum.完工.getCode())) {
                settleTypeUrl = "finishSettle";
            } else if (contractType.equals(SettleTypeEnum.节点.getCode())) {
                settleTypeUrl = "nodeSettle";
            }
            if (contractType == 0) {
                contractTypeUrl = "laborsub";
                //劳务
            } else if (contractType == 1) {
                //专业
                contractTypeUrl = "prosub";
            }
            // "/ejc-prosub-frontend/#/" + settleType + "/" + contractType + "/card?id=" + s.getId()
            vo.setPcSettleCardUrl("/ejc-prosub-frontend/#/" + settleTypeUrl + "/" + contractTypeUrl + "/card?id=" + vo.getSettleId());
        }
        page.setRecords(list);
        page.setTotal(count);
        return page;
    }

    // 封装orgId和parentOrgIdList
    private boolean setOrgParam(Map<String, Object> queryMap, Long orgId, Integer orgType) {
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
            // 按项目部过滤
            queryMap.put("orgId", orgId);
        } else {
            // 按组织过滤
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("查询当前本下组织信息失败，{}", orgResp.getMsg());
                return true;
            }
            queryMap.put("parentOrgIdList", orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        return false;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse<List<PaymentApplyVO>> resultData = paymentApplyApi.queryListByContractId(id);
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        if (resultData != null){
            List<PaymentApplyVO> paymentApplyVOList = resultData.getData();
            if (CollectionUtils.isNotEmpty(paymentApplyVOList)){
                resultVO.setTotalApplyMny(paymentApplyVOList.stream().filter(p -> p.getApplyMny() != null).map(PaymentApplyVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                resultVO.setTotalActualMny(paymentApplyVOList.stream().filter(p -> p.getActualMny() != null).map(PaymentApplyVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                resultVO.setTotalApprovalMny(paymentApplyVOList.stream().filter(p -> p.getApprovalMny() != null).map(PaymentApplyVO::getApprovalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                paymentApplyVOList.forEach(item -> {
                    item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                    item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                    item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
                });
                resultVO.setPaymentApplyList(paymentApplyVOList);
            }
        }

        ContractEntity contractEntity = service.selectById(id);
        if (null != contractEntity){
            resultVO.setContractId(id);
            resultVO.setAddType(contractEntity.getAddType());
            resultVO.setContractFlag(contractEntity.getSupplementFlag());
            resultVO.setContractMny(contractEntity.getContractTaxMny());

            resultVO.setTotalApplyMny(null != resultVO.getTotalApplyMny() ? resultVO.getTotalApplyMny() : BigDecimal.ZERO);
            resultVO.setTotalActualMny(null != resultVO.getTotalActualMny() ? resultVO.getTotalActualMny() : BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(null != resultVO.getTotalApprovalMny() ? resultVO.getTotalApprovalMny() : BigDecimal.ZERO);
        }

        //根据合同Id查询合同对应工人工资支付信息
        CommonResponse<com.ejianc.business.profinance.vo.ContractPaymentResultVO> salaryPayInfoResp = salaryApi.querySalaryApplyInfoByContractId(id);
        if(!salaryPayInfoResp.isSuccess()) {
            logger.error("根据合同Id-【{}】查询合同对应工人工资支付信息失败, {}！",id, JSONObject.toJSONString(salaryPayInfoResp));
        } else {
            com.ejianc.business.profinance.vo.ContractPaymentResultVO salaryPayInfo = salaryPayInfoResp.getData();
            resultVO.setTotalActualMny(resultVO.getTotalActualMny().add(salaryPayInfo.getTotalActualMny()));
            resultVO.setTotalApplyMny(resultVO.getTotalApplyMny().add(salaryPayInfo.getTotalApplyMny()));
            resultVO.setTotalApprovalMny(resultVO.getTotalApprovalMny().add(salaryPayInfo.getTotalApprovalMny()));

            if(null == resultVO.getPaymentApplyList()) {
                resultVO.setPaymentApplyList(new ArrayList<>());
            }

            resultVO.getPaymentApplyList().addAll(salaryPayInfo.getPaymentApplyList());
        }

        if (null != resultVO.getTotalActualMny()){
            resultVO.setPaymentRate((resultVO.getTotalActualMny().divide(resultVO.getContractMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100)));
        }else {
            resultVO.setPaymentRate(BigDecimal.ZERO);
        }

        CommonResponse<String> addFlagData = paymentApplyApi.queryAddFlagContractId(id);
        if (addFlagData != null && addFlagData.getData() != null){
            if (addFlagData.getData().equals("1")){
                resultVO.setAddFlag(true);
            }
        }
        return resultVO;
    }

    // 校验  劳务/专业分包合同-补充协议  【合同金额】控【补充协议金额】  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public List<ParamsCheckVO> supplementMnyCtrl(ContractVO contractVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务补充协议
        if (0 == contractVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_SUPPLEMENT_PARAM_CODE, contractVO.getOrgId());
        }
        // 专业补充协议
        if (1 == contractVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_SUPPLEMENT_PARAM_CODE, contractVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVOList;
        }
        // 查询当前补充协议所属主合同下的所有补充协议的含税合同金额的累加值--排除自己（如果当前数据已入库的话）
        QueryWrapper<ContractEntity> contractEntityQueryWrapper = new QueryWrapper<>();
        Long mainContractId = contractVO.getMainContractId();
        contractEntityQueryWrapper
                .eq("dr", 0)
                .eq("tenant_id", InvocationInfoProxy.getTenantid())
                .eq("main_contract_id", mainContractId)
                .eq("supplement_flag", 1);
        if (contractVO.getId() != null) {
            // 排除自己
            contractEntityQueryWrapper.notIn("id", Arrays.asList(contractVO.getId()));
        }
        contractEntityQueryWrapper.select("sum(contract_tax_mny) as contractTaxMnySupTotal");
        Map<String, Object> map = super.getMap(contractEntityQueryWrapper);
        BigDecimal contractTaxMnySupTotal = BigDecimal.ZERO;
        if (map != null) {
            // 查询到的不包含自己的所属主合同下的所有补充协议的含税合同金额的累加值
            contractTaxMnySupTotal = map.get("contractTaxMnySupTotal") != null ? new BigDecimal(map.get("contractTaxMnySupTotal").toString()) : BigDecimal.ZERO;
        }
        // 当前补充协议金额
        BigDecimal curDataContractTaxMny = contractVO.getContractTaxMny() != null ? contractVO.getContractTaxMny() : BigDecimal.ZERO;
        // 合同的补充协议金额（当前补充协议所属主合同下的所有补充协议的含税合同金额的累加值） = 查询到的含税合同金额累加值 + 当前数据的合同金额
        contractTaxMnySupTotal = contractTaxMnySupTotal.add(curDataContractTaxMny);
        // 查询当前补充协议所属诸恶合同的含税合同金额
        contractEntityQueryWrapper = new QueryWrapper<ContractEntity>();
        contractEntityQueryWrapper.eq("id", mainContractId);
        ContractEntity contractEntity = super.getOne(contractEntityQueryWrapper);
        if (contractEntity == null) {
            logger.info("查询主合同失败！");
            throw new BusinessException("查询主合同失败！");
        }
        // 计算 主合同金额 * X%
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny();
        contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
        List<BillParamVO> data = billParamByCode.getData();
        for (BillParamVO billParamVO : data){
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal conTaxMny = contractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 为none时不需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                // 控制金额：补充协议金额 > 合同金额*X%
                if (contractTaxMnySupTotal.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = contractTaxMnySupTotal.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                    paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次补充协议金额：").append(curDataContractTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，含本次补充协议金额：").append(contractTaxMnySupTotal.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(conTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("。超出金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    // 无需控制
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    // 劳务分包合同-签订（即保存时）、补充协议 【总计划量】控【合同量】 合同量  > 总计划量*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public List<ParamsCheckVO> planNumCtrlContractNum(ContractVO contractVO) {
        logger.info("prosub---ContractServiceImpl---planNumCtrlContractNum()---入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        Integer contractType = contractVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        Long projectIdSave = contractVO.getProjectId();// 合同所在项目id
        Long tenantid = InvocationInfoProxy.getTenantid();// 租户编码
        // 劳务
        if (0 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CON_PLAN_NUM_CTRL_CON_NUM, contractVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CON_PLAN_NUM_CTRL_CON_NUM, contractVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> data = billParamByCode.getData();
        // 查询当前项目下的当前分包类型的已生效（已提交或审批通过）的总计划的子表数据，并对计划量累加，根据子表清单编码（detail_code）分组
        QueryWrapper<PlanEntity> planWrapper = new QueryWrapper<>();
        planWrapper
                .eq("dr", 0)
                .eq("tenant_id", tenantid)
                .eq("sub_type", contractType)// 区分劳务还是专业
                .eq("project_id", projectIdSave)// 当前项目下的
                .in("bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));// 查询 已生效的
        PlanEntity pe = planService.getOne(planWrapper);
        logger.info("查询当前项目的总计划，查询结果：{}", JSONObject.toJSONString(pe));

        Map<Long, BigDecimal> planNumMap = new HashMap<>();
        // 总计划子表同一清单编码下的计划量累加
        if (pe != null) {
            // 查询总计划子表同一清单编码下的计划量累加
            QueryWrapper<PlanDetailEntity> planDetailWrapper = new QueryWrapper<>();
            planDetailWrapper.eq("dr", 0).eq("tenant_id", tenantid)
                    .eq("plan_id", pe.getId()).isNotNull("plan_num").groupBy("doc_id");
            planDetailWrapper.select("sum(ifnull(plan_num, 0)) as planNumTotal, doc_id as docId");
            List<Map<String, Object>> pdMapList = planDetailService.listMaps(planDetailWrapper);
            if (CollectionUtils.isNotEmpty(pdMapList)) {
                for (Map<String, Object> pdMap : pdMapList) {
                    Long docId = Long.parseLong(pdMap.get("docId").toString());
                    BigDecimal planNum = pdMap.get("planNumTotal") == null ? BigDecimal.ZERO : new BigDecimal(pdMap.get("planNumTotal").toString());
                    planNumMap.put(docId, planNum);
                }
            }
        }
        logger.info("总计划子表根据合同清单docId维度汇总计划量，汇总结果：{}", JSONObject.toJSONString(planNumMap));

        List<Long> cdIdListSave = new ArrayList<>();
        HashMap<Long, Map<String, Object>> curConNumMap = new HashMap<>();
        List<ContractDetailVO> cdListSave = new ArrayList<>();
        ParamCtrlUtil.treeToConDetailVOList(cdListSave, contractVO.getDetailList());
        // 对合同子表数据相同清单的合同量累加，根据档案id
        if (CollectionUtils.isNotEmpty(cdListSave)) {
            for (ContractDetailVO cdVO : cdListSave) {
                // 只要 末级且非删除 的清单
                BigDecimal detailNum = cdVO.getDetailNum();
                Long docId = cdVO.getDocId();
                String rowState = cdVO.getRowState();
                Long cdId = cdVO.getId();
                if (cdId != null) {
                    cdIdListSave.add(cdId);
                }
                if (detailNum == null || "del".equals(rowState)) {
                    continue;
                }
                String detailName = cdVO.getDetailName();
                String detailRule = cdVO.getDetailMeasurementRules();
                // 按到之前存储的数据
                Map<String, Object> mapOld = curConNumMap.get(docId);
                BigDecimal conNumOld = BigDecimal.ZERO;
                if (MapUtils.isEmpty(mapOld)) {
                    mapOld = new HashMap<>();
                } else {
                    conNumOld = mapOld.get("conNum") == null ? BigDecimal.ZERO : new BigDecimal(mapOld.get("conNum").toString());
                }
                // 更新存储的数据并重新封装
                mapOld.put("conNum", ComputeUtil.safeAdd(conNumOld, detailNum));
                mapOld.put("detailName", StringUtils.isEmpty(detailName) ? "" : detailName);
                mapOld.put("detailRule", StringUtils.isEmpty(detailRule) ? "" : detailRule);
                curConNumMap.put(docId, mapOld);
            }
        }
        logger.info("入参VO子表数据根据合同清单docId维度汇总合同量，汇总结果：{}", JSONObject.toJSONString(curConNumMap));

        Map<Long, BigDecimal> conNumMap = new HashMap<>();
        List<Map<String, Object>> conMapList = contractMapper.queryCountConNum(contractType, tenantid, projectIdSave, CollectionUtils.isEmpty(cdIdListSave) ? null : cdIdListSave);
        if (CollectionUtils.isNotEmpty(conMapList)) {
            logger.info("查询当前项目下合同的合同量（已排除本期），查询结果：{}", JSONObject.toJSONString(conMapList));
            for (Map<String, Object> conMap : conMapList) {
                conNumMap.put(Long.parseLong(conMap.get("docId").toString()), new BigDecimal(conMap.get("detailNumTotal") == null ? "0" : conMap.get("detailNumTotal").toString()));
            }
            logger.info("当前项目下合同的合同量（已排除本期）根据合同清单docId维度汇总合同量，汇总结果：{}", JSONObject.toJSONString(conNumMap));
        } else {
            logger.info("查询当前项目下合同的合同量（已排除本期），未查询到数据");
        }

        for (BillParamVO billParamVO : data){
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                // 开始控制
                if (MapUtils.isNotEmpty(curConNumMap) && curConNumMap.keySet().size() > 0) {
                    Set<Long> keySet = curConNumMap.keySet();
                    for (Long key : keySet) {
                        logger.info("当前docId={}", key);
                        // 当前合同清单的总计划量
                        BigDecimal planNumKey = planNumMap.get(key);
                        if (planNumKey == null) {
                            // 当当前清单在总计划量中不存在时不做控制
                            logger.info("当前docId的总计划量为空，无需控制");
                            continue;
                        }
                        logger.info("当前docId的总计划量：{}", planNumKey);

                        // 当前合同清单的本次合同量
                        Map<String, Object> curConMap = curConNumMap.get(key);
                        BigDecimal curConNum = BigDecimal.ZERO;
                        String detailName = "";
                        String detailRule = "";
                        if (MapUtils.isNotEmpty(curConMap)) {
                            logger.info("当前docId的本期合同量map：{}", JSONObject.toJSONString(curConMap));
                            // 本期合同量
                            Object conNumObj = curConMap.get("conNum");
                            curConNum = conNumObj == null ? BigDecimal.ZERO : new BigDecimal(conNumObj.toString());
                            // 清单名称
                            Object detailNameObj = curConMap.get("detailName");
                            detailName = detailNameObj == null ? "" : detailNameObj.toString();
                            // 计量规则
                            Object detailRuleObj = curConMap.get("detailRule");
                            detailRule = detailRuleObj == null ? "" : detailRuleObj.toString();
                        } else {
                            logger.info("当前docId的本期合同量map：null");
                        }

                        // 当前合同清单的不含本期量map
                        BigDecimal conNum = conNumMap.get(key);
                        conNum = conNum == null ? BigDecimal.ZERO : conNum;
                        logger.info("当前docId的不含本期合同量map：{}", JSONObject.toJSONString(conNum));

                        // 计算 当前合同清单的含本次累计合同量 = 不含本次 + 本次
                        conNum = conNum.add(curConNum);
                        logger.info("当前docId的含本期合同量 = 不含本期 + 本期，计算结果={}", conNum);

                        // 计算 总计划量*X%
                        BigDecimal planNum = planNumKey.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                        logger.info("计算：总计划量 *" + roleValue + "% = {}", planNum);

                        // 【总计划量】控【合同量】 合同量  > 总计划量*X%
                        if (conNum.compareTo(planNum) > 0) {
                            // 计算超出数量
                            BigDecimal overNum = conNum.subtract(planNum);
                            logger.info("超出数量={}", overNum);
                            // 封装预警信息
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(detailName + detailRule);
                            paramsCheckDsVO.setWarnName("合同数量大于总计划数量");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("本次合同数量：").append(curConNum.setScale(2, RoundingMode.DOWN))
                                    .append("，含本次累计合同数量：").append(conNum.setScale(2, RoundingMode.DOWN))
                                    .append("，总计划数量*").append(roleValue).append("%：").append(planNum.setScale(2, RoundingMode.DOWN))
                                    .append("。超出数量：").append(overNum.setScale(2, RoundingMode.DOWN));
                            paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            dataSource.add(paramsCheckDsVO);
                            paramsCheckVO.setDataSource(dataSource);
                        }
                    }
                }
            }
            logger.info("prosub---ContractServiceImpl---planNumCtrlContractNum()---返回结果：{}", JSONObject.toJSONString(paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    // 劳务分包合同-签订（即保存时）、补充协议 【总计划金额】控【合同金额】 合同金额  > 总计划金额*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public List<ParamsCheckVO> planMnyCtrlContractMny(ContractVO contractVO) {
        logger.info("prosub---ContractServiceImpl---planMnyCtrlContractMny()---入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        Integer contractType = contractVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        Long projectIdSave = contractVO.getProjectId();// 合同所在项目id
        Integer supplementFlag = contractVO.getSupplementFlag();// 是否补充协议(1:是，0：否)
        Long tenantid = InvocationInfoProxy.getTenantid();// 租户编码
        Long saveId = contractVO.getId();
        // 劳务
        if (0 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CON_PLAN_MNY_CTRL_CON_MNY, contractVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CON_PLAN_MNY_CTRL_CON_MNY, contractVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));

        // 查询当前项目下的当前分包类型的已生效（已提交或审批通过）的总计划的总计划金额
        QueryWrapper<PlanEntity> planWrapper = new QueryWrapper<>();
        planWrapper
                .eq("dr", 0)
                .eq("tenant_id", tenantid)
                .eq("sub_type", contractType)// 区分劳务还是专业
                .eq("project_id", projectIdSave)// 当前项目下的
                .in("bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));// 查询 已生效的
        PlanEntity pe = planService.getOne(planWrapper);
        logger.info("查询当前项目的总计划，查询结果：{}", JSONObject.toJSONString(pe));
        BigDecimal totalPlanTaxMny = BigDecimal.ZERO;
        if (pe != null) {
            totalPlanTaxMny = pe.getTotalPlanTaxMny();
        }else {
            return paramsCheckVOList;
        }
        logger.info("查询当前项目的总计划金额：{}", JSONObject.toJSONString(totalPlanTaxMny));

        Map<String, Object> lastConTaxMnyMap = contractMapper.queryCountConTaxMny(contractType, tenantid, projectIdSave, saveId, null);
        logger.info("查询当前项目下合同的合同金额（已排除本期），查询结果：{}", JSONObject.toJSONString(lastConTaxMnyMap));

        List<BillParamVO> data = billParamByCode.getData();
        for (BillParamVO billParamVO : data){
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();

            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                List<Long> cdIdListSave = new ArrayList<>();
                // 当前合同金额
                BigDecimal curConTaxMny = contractVO.getContractTaxMny();
                curConTaxMny = curConTaxMny == null ? BigDecimal.ZERO : curConTaxMny;
                logger.info("入参VO合同金额：{}", JSONObject.toJSONString(curConTaxMny));

                // 计算总计划金额 * X%
                BigDecimal totalPlanTaxMnyRoleValue = totalPlanTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                logger.info("计算：总计划金额 *" + roleValue + "% = {}", totalPlanTaxMnyRoleValue);

                // 不含本期合同金额
                BigDecimal lastConTaxMny = lastConTaxMnyMap.get("lastConTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(lastConTaxMnyMap.get("lastConTaxMny").toString());
                // 含本期合同金额 = 不含本期 + 本期
                BigDecimal totalConTaxMny = lastConTaxMny.add(curConTaxMny);
                logger.info("含本期合同金额：{}", JSONObject.toJSONString(totalConTaxMny));

                // 【总计划金额】控【合同金额】 合同金额  > 总计划金额*X%
                if (totalPlanTaxMny != BigDecimal.ZERO && totalConTaxMny.compareTo(totalPlanTaxMnyRoleValue) > 0) {
                    // 计算超出数量
                    BigDecimal overMny = totalConTaxMny.subtract(totalPlanTaxMnyRoleValue);
                    logger.info("超出金额={}", overMny);
                    // 封装预警信息
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("合同金额超总计划金额");
                    paramsCheckDsVO.setWarnName("合同金额大于总计划金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次合同金额：").append(curConTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，含本次累计合同金额：").append(totalConTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，总计划金额*").append(roleValue).append("%：").append(totalPlanTaxMnyRoleValue.setScale(2, RoundingMode.DOWN))
                            .append("。超出金额：").append(overMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    // 无需控制
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            logger.info("prosub---ContractServiceImpl---planMnyCtrlContractMny()---返回结果：{}", JSONObject.toJSONString(paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    // 劳务分包合同（含补充协议）  【施工合同金额-专业合同金额】控【劳务合同金额】
    @Override
    public List<ParamsCheckVO> contractionMnyCtrlLabConMny(ContractVO contractVO) {
        logger.info("prosub---ContractServiceImpl---contractionMnyCtrlLabConMny()---入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        Long projectIdSave = contractVO.getProjectId();// 合同所在项目id
        Integer supplementFlag = contractVO.getSupplementFlag();// 是否补充协议(1:是，0：否)
        Long tenantid = InvocationInfoProxy.getTenantid();// 租户编码
        Long saveId = contractVO.getId();
        // 当前合同金额
        BigDecimal curConTaxMny = contractVO.getContractTaxMny();
        curConTaxMny = curConTaxMny == null ? BigDecimal.ZERO : curConTaxMny;
        logger.info("入参VO合同金额：{}", JSONObject.toJSONString(curConTaxMny));
        billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CON_CONTRACTION_MNY_CTRL_CON_MNY, contractVO.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> data = billParamByCode.getData();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();

            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                // 查询施工合同金额 - 专业合同金额 的差值
                BigDecimal contractionSubtractTaxMny = BigDecimal.ZERO;// 初始化此差值
                CommonResponse<BigDecimal> subtractTaxMnyRes = contractPoolApi.queryContractionSubtractProTaxMny(projectIdSave);
                logger.info("项目id={}，查询此项目下(最新的施工合同金额 - 专业合同金额)，查询结果：{}", projectIdSave, JSONObject.toJSONString(subtractTaxMnyRes));
                if (subtractTaxMnyRes.isSuccess() && subtractTaxMnyRes.getData() != null) {
                    contractionSubtractTaxMny = subtractTaxMnyRes.getData();
                }
                // (最新的施工合同金额 - 专业合同金额) < 0 不控制
                if (contractionSubtractTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                    continue;
                }
                Map<String, Object> lastConTaxMnyMap = contractMapper.queryCountConTaxMny(0, tenantid, projectIdSave, saveId, null);
                logger.info("查询当前项目下合同的合同金额（已排除本期），查询结果：{}", JSONObject.toJSONString(lastConTaxMnyMap));
                // 计算 含本期合同金额 = 不含本期 + 本期
                // 不含本期合同金额
                BigDecimal lastConTaxMny = MapUtils.isEmpty(lastConTaxMnyMap) || lastConTaxMnyMap.get("lastConTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(lastConTaxMnyMap.get("lastConTaxMny").toString());
                // 含本期合同金额 = 不含本期 + 本期
                BigDecimal totalConTaxMny = lastConTaxMny.add(curConTaxMny);
                logger.info("含本期合同金额：{}", JSONObject.toJSONString(totalConTaxMny));
                // 计算 (施工合同金额 - 专业合同金额) * X%
                contractionSubtractTaxMny = contractionSubtractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                logger.info("计算：(施工合同金额 - 专业合同金额) *" + roleValue + "% = {}", contractionSubtractTaxMny);
                // 【施工合同金额 - 专业合同金额】控【劳务分包合同金额】 劳务分包合同金额  > (施工合同金额 - 专业合同金额)*X%
                if (contractionSubtractTaxMny != BigDecimal.ZERO && totalConTaxMny.compareTo(contractionSubtractTaxMny) > 0) {
                    // 计算超出数量
                    BigDecimal overMny = totalConTaxMny.subtract(contractionSubtractTaxMny);
                    logger.info("超出金额={}", overMny);
                    // 封装预警信息
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("合同金额超（施工合同金额-专业合同金额）");
                    paramsCheckDsVO.setWarnName("累计劳务合同金额大于（施工合同金额-专业合同金额）");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次劳务合同金额：").append(curConTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，含本次累计劳务合同金额：").append(totalConTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，（施工合同金额-专业合同金额）*").append(roleValue).append("%：").append(contractionSubtractTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("。超出金额：").append(overMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    // 无需控制
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            logger.info("prosub---ContractServiceImpl---contractionMnyCtrlLabConMny()---返回结果：{}", JSONObject.toJSONString(paramsCheckVO));
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }


    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }


    /**
     * 分包合同目标成本推送数据
     *
     * @param id 合同id
     */
    @Override
    public void pushTargetCost(Long id) {
        List<ExecutionVO> executionVOs = new ArrayList<>();
        ContractEntity contractEntity = service.selectById(id);

        QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", id).orderByDesc("create_time");
        List<ChangeEntity> list = changeService.list(wrapper);

        // 是否变更过
        if (!list.isEmpty()) {
            // 最新变更
            LambdaQueryWrapper<ChangeDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ChangeDetailEntity::getChangeId, list.get(0).getId());
            list.get(0).setDetailList(changeDetailService.list(queryWrapper));

            ChangeVO changeVO = BeanMapper.map(list.get(0), ChangeVO.class);
            String linkUrl = changeService.getLinkUrl(changeVO);
            executionVOs.add(changeService.targetCost(changeVO, linkUrl, changeVO.getContractType(),
                    changeService.getBillType(changeVO.getId(), changeVO.getContractType()), false));
        } else {
            // 原合同
            ContractVO contractVO = BeanMapper.map(contractEntity, ContractVO.class);
            String linkUrl = service.getLinkUrl(contractVO);
            executionVOs.add(service.targetCost(contractVO, linkUrl, contractEntity.getContractType(),
                    getBillType(contractVO.getId(), contractVO.getContractType())));
        }

        // 是否解除过
        if (PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getPerformanceStatus())) {
            LambdaQueryWrapper<ContractRelieveEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ContractRelieveEntity::getContractId, id);
            ContractRelieveEntity contractRelieveEntity = contractRelieveService.getOne(queryWrapper);

            // 是否生效
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractRelieveEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractRelieveEntity.getBillState())) {
                String linkUrl = getBaseHost() + "ejc-prosub-frontend/#/contractRelieve/Card?id=" + contractRelieveEntity.getId() + "&cardType=" + contractEntity.getContractType();
                executionVOs.add(contractRelieveService.targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class), linkUrl));
            }
        }

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(executionVOs)) {
            executionVOs.forEach(executionVO -> {
                //目标成本推送
//                logger.info("手动：分包合同目标成本推送数据： {}", JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
//                logger.info("手动：分包合同目标成本推送数据结果： {}", JSON.toJSONString(response));
            });
        }
    }

    @Override
    public String changePerformanceStatus(Long contractId, String stateCode) {
        ContractEntity contract = super.selectById(contractId);
        contract.setPerformanceStatus(stateCode);

        //更新合同池履约状态
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        contractPoolVO.setSourceId(contractId);
        contractPoolVO.setId(contractId);
        contractPoolVO.setPerformanceStatus(stateCode);
        contractPoolVO.setPerformanceStatusName(ContractPerformanceStateEnum.getByStateCode(stateCode).getStateName());
        CommonResponse<ContractPoolVO> updateResp = contractPoolApi.saveOrUpdateContract(contractPoolVO);
        if(!updateResp.isSuccess()) {
            logger.error("更新合同履约状态到合同池失败-【{}】, 响应信息：{}", JSONObject.toJSONString(contract), JSONObject.toJSONString(updateResp));
            return StringUtils.isNotBlank(updateResp.getMsg()) ? updateResp.getMsg() : "网络问题，更新合同履约状态失败！";
        }

        //更新合同状态
        super.saveOrUpdate(contract, false);


        return null;
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter(QueryParam.IN, targetResultIdList));
        List<ContractEntity> contractEntityList = super.queryList(queryParam);
        List<SignContractVo> signContractVoList = new ArrayList<>();
        logger.info("根据定标id集合参数查询到对应的定标新增合同信息：{}", JSONObject.toJSONString(contractEntityList));
        if (CollectionUtils.isNotEmpty(contractEntityList)){
            for (ContractEntity contractEntity : contractEntityList) {
                SignContractVo signContractVo = new SignContractVo();
                signContractVo.setBillCode(contractEntity.getBillCode());
                signContractVo.setBillState(contractEntity.getBillState());
                signContractVo.setContractId(contractEntity.getId());
                signContractVo.setContractTaxMny(contractEntity.getContractTaxMny());
                signContractVo.setContractMny(contractEntity.getContractMny());
                signContractVo.setContractName(contractEntity.getContractName());
                signContractVo.setSignDate(contractEntity.getSignDate());
                signContractVo.setSupplierId(contractEntity.getSupplierId());
                signContractVo.setSupplierName(contractEntity.getSupplierName());
                signContractVo.setLinkUrl(getLinkUrl(BeanMapper.map(contractEntity, ContractVO.class)));

                signContractVoList.add(signContractVo);
            }
        }
        return signContractVoList;
    }


}
