package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.mapper.ControlMapper;
import com.ejianc.business.control.service.*;
import com.ejianc.business.control.vo.*;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包招标控制价审核表
 * 
 * @author generator
 * 
 */
@Service("controlService")
public class ControlServiceImpl extends BaseServiceImpl<ControlMapper, ControlEntity> implements IControlService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;

    @Autowired
    private IShareProsubApi prosubApi;

    private static final String BILL_CODE = "SUB_CONTROL";//此处需要根据实际修改
    private static final String BILL_CODE_KJXY = "SUB_CONTROL_KJXY";//此处需要根据实际修改


    @Autowired
    private SessionManager sessionManager;

    private static final String CONTROL_COST_CODE = "P-i3X5840010";//无项目策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_DETAIL_CODE = "P-94k78t0012";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";//清单的分包招标控制价是否允许超过策划成本价
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;


    private final String PC_XM_URL = "ejc-prosub-frontend/#/subcontractPrice/card?id=";
    private final String PC_KJXY_URL = "ejc-prosub-frontend/#/subcontractPrice/cardKJXY?id=";

    @Autowired
    private IControlService service;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBuildDutyApi buildDutyApi;
    @Autowired
    private IControlDetailService controlDetailService;
    @Autowired
    private IControlDetailTwoService controlDetailTwoService;
    @Autowired
    private IControlDetailThreeService controlDetailThreeService;
    @Autowired
    private IControlDetailFourService controlDetailFourService;
    @Autowired
    private IControlChangeHisService controlChangeHisService;
    @Autowired
    private IControlChangeService controlChangeService;
    @Autowired
    private IControlDetailFiveService controlDetailFiveService;

    @Autowired
    private IExecutionApi executionApi;


    @Override
    public ControlVO saveOrUpdate(ControlVO saveOrUpdateVO, Boolean isControl) {
        ControlEntity entity = BeanMapper.map(saveOrUpdateVO, ControlEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            entity.setId(IdWorker.getId());
            entity.setId(IdWorker.getId());
            //设置为未变更
            entity.setChangeState(0);
            //设置为自由态
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            entity.setChangeVersion(1);

            if(Boolean.FALSE.equals(isControl)) {
                BillCodeParam billCodeParam;
                if (entity.getType().equals(1)){
                    billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                }else{
                    billCodeParam = BillCodeParam.build(BILL_CODE_KJXY,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                }
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            } else {
                //先生成一个非生效编码
                entity.setBillCode(entity.getId().toString());
            }
        }

        List<ControlDetailEntity> controlDetailList = entity.getControlDetailList();
        if(CollectionUtils.isNotEmpty(controlDetailList)){
            for (ControlDetailEntity detail : controlDetailList) {
                if(null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                detail.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        List<ControlDetailTwoEntity> controlDetailTwoList = entity.getControlDetailTwoList();
        if(CollectionUtils.isNotEmpty(controlDetailTwoList)){
            for (ControlDetailTwoEntity detail : controlDetailTwoList) {
                if(null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                if (!("del").equals(detail.getRowState())){
                    detail.setTwoChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailThreeEntity> controlDetailThreeList = entity.getControlDetailThreeList();
        if(CollectionUtils.isNotEmpty(controlDetailThreeList)){
            for (ControlDetailThreeEntity detail : controlDetailThreeList) {
                if(null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                if (!("del").equals(detail.getRowState())){
                    detail.setThreeChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailFourEntity> controlDetailFourList = entity.getControlDetailFourList();
        if(CollectionUtils.isNotEmpty(controlDetailFourList)){
            for (ControlDetailFourEntity detail : controlDetailFourList) {
                if(null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                if (!("del").equals(detail.getRowState())){
                    detail.setFourChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }

        List<ControlDetailFiveEntity> controlDetailFiveList = entity.getControlDetailFiveList();
        if(CollectionUtils.isNotEmpty(controlDetailFiveList)){
            for (ControlDetailFiveEntity detail : controlDetailFiveList) {
                if(null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                if (!("del").equals(detail.getRowState())){
                    detail.setChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        if(Boolean.FALSE.equals(isControl)) {
            //保存入库
            super.saveOrUpdate(entity, false);

            //目标成本推送
            if(ControlVO.招标方式_项目招标.equals(entity.getType())) {
                //框架协议不推送目标成本
                String linkUrl = getLinkUrl(entity.getId(), entity.getType());
                //单据业务类型
                String billTypeCode = ProsubBillTypeEnum.分包招标控制价.getBillTypeCode();
                ExecutionVO executionVO = this.targetCost(BeanMapper.map(entity, ControlVO.class),linkUrl,entity.getSubType(), billTypeCode);
                logger.info("目标成本推送数据:{}",JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本推送失败,"+response.getMsg());
                }
                logger.info("单据id-{}目标成本推送成功！", entity.getId());
            }

        }

        ControlVO vo = BeanMapper.map(entity, ControlVO.class);
        return vo;
    }

    @Override
    public String getLinkUrl(Long id, Integer type) {
        return getBaseHost()+(ControlVO.招标方式_项目招标.equals(type) ? PC_XM_URL : PC_KJXY_URL)+id;
    }


    /**
     * @description: 组装推送目标成本数据：
     *      表头字段：
     *          组织、项目名称、编制日期、各标段无税控制价、各标段含税控制价
     *      表体-标段1/标段2/标段3/标段4：
     *          项目(主表)、组织(主表)、分类ID、分类编号、分类名称、档案ID、清单编号、
     *          清单名称、单位、工程量、控制价金额-无税合价、控制价金额含税合价
     * @author: CJ
     * @create: 2025/5/27 17:05
     * @Version 1.0
     **/
    @Override
    public ExecutionVO targetCost(ControlVO controlVO, String linkUrl, Integer subType, String billType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(controlVO.getId());
        totalVO.setTenantId(controlVO.getTenantId());
        totalVO.setBillCode(controlVO.getBillCode());
        totalVO.setOrgId(controlVO.getOrgId());
        totalVO.setBillType(billType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if(null != controlVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(controlVO.getCreateTime()));
        }

        //业务类型
        switch (subType) {
            case 1:
                totalVO.setBussinessType(BussinessTypeEnum.分包招标控制价_专业.getCode());
                break;
            case 2:
                totalVO.setBussinessType(BussinessTypeEnum.分包招标控制价_劳务.getCode());
                break;
            case 3:
                totalVO.setBussinessType(BussinessTypeEnum.分包招标控制价_其他.getCode());
                break;
            case 4:
                totalVO.setBussinessType(BussinessTypeEnum.分包招标控制价_特种设备租赁.getCode());
                break;
            default:
                throw new BusinessException("招标控制价id-["+String.valueOf(controlVO.getId())+"]错误的分包类别：["+controlVO.getSubType()+"]");
        }

        //单据分类
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());

        if(ControlVO.招标方式_项目招标.equals(controlVO.getType())) {
            if (controlVO.getProjectId()==null){
                throw new BusinessException("项目信息为空，目标成本推送失败,请更换项目");
            }else {
                totalVO.setProjectId(controlVO.getProjectId());
            }
        }

        if (controlVO.getOrgId()==null){
            throw new BusinessException(ControlVO.招标方式_项目招标.equals(controlVO.getType()) ? "项目部信息为空，目标成本推送失败,请更换项目" : "分公司名称为空，目标成本推送失败");
        }else {
            totalVO.setOrgId(controlVO.getOrgId());
        }
        totalVO.setMoney(controlVO.getControlMny()); //各标段含税控制价
        totalVO.setTaxMoney(controlVO.getControlTaxMny()); //各标段含税策划成本
        totalVO.setLinkUrl(linkUrl);

        //子表处理
        if(!ControlVO.分包类别_其他分包.equals(controlVO.getSubType())) {
            if(CollectionUtils.isNotEmpty(controlVO.getControlDetailList())) {
                for(ControlDetailVO detail : controlVO.getControlDetailList()) {
                    if("del".equals(detail.getRowState())) {
                        continue;
                    }
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());

                    //来源主表ID
                    if(ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.分包招标控制价框架协议变更.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }

                    // 档案分类ID
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    detailExecutionVO.setCategoryFlag(false);
                    //档案分类编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //档案类型
                    if (ControlVO.分包类别_专业分包.equals(subType)){
                        detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                    }else {
                        detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                    }
                    //档案Id
                    detailExecutionVO.setDocId(detail.getDocId());
                    //档案编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    //档案名称
                    detailExecutionVO.setName(detail.getDetailName());
                    //单位Id
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    //单位名称
                    detailExecutionVO.setUnitName(detail.getUnit());
                    //工程量
                    detailExecutionVO.setNum(detail.getProjectNum());
                    //控制价金额-无税合价
                    detailExecutionVO.setMoney(detail.getControlMny());
                    //控制价金额含税合价
                    detailExecutionVO.setTaxMoney(detail.getControlTaxMny());
                    //工作计量规则
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    //控制价不含税单价
                    detailExecutionVO.setPrice(detail.getControlPrice());
                    //控制价含税单价
                    detailExecutionVO.setTaxPrice(detail.getControlTaxPrice());
                    //控制价税率
                    detailExecutionVO.setTaxRate(detail.getControlTaxRate());
                    //备注
                    detailExecutionVO.setMemo(detail.getMemo());
                    if(null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
            if(CollectionUtils.isNotEmpty(controlVO.getControlDetailTwoList())) {
                for(ControlDetailTwoVO detail : controlVO.getControlDetailTwoList()) {
                    if("del".equals(detail.getRowState())) {
                        continue;
                    }
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());
                    detailExecutionVO.setCategoryFlag(false);

                    //来源主表ID
                    if(ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.分包招标控制价框架协议变更.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }

                    // 档案分类ID
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    //档案分类编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //档案类型
                    if (ControlVO.分包类别_专业分包.equals(subType)){
                        detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                    }else {
                        detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                    }
                    //档案Id
                    detailExecutionVO.setDocId(detail.getDocId());
                    //档案编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    //档案名称
                    detailExecutionVO.setName(detail.getDetailName());
                    //单位Id
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    //单位名称
                    detailExecutionVO.setUnitName(detail.getUnit());
                    //工程量
                    detailExecutionVO.setNum(detail.getTwoProjectNum());
                    //控制价金额-无税合价
                    detailExecutionVO.setMoney(detail.getTwoControlMny());
                    //控制价金额含税合价
                    detailExecutionVO.setTaxMoney(detail.getTwoControlTaxMny());
                    //工作计量规则
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    //控制价不含税单价
                    detailExecutionVO.setPrice(detail.getTwoControlPrice());
                    //控制价含税单价
                    detailExecutionVO.setTaxPrice(detail.getTwoControlTaxPrice());
                    //控制价税率
                    detailExecutionVO.setTaxRate(detail.getTwoControlTaxRate());
                    //备注
                    detailExecutionVO.setMemo(detail.getTwoMemo());
                    if(null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
            if(CollectionUtils.isNotEmpty(controlVO.getControlDetailThreeList())) {
                for(ControlDetailThreeVO detail : controlVO.getControlDetailThreeList()) {
                    if("del".equals(detail.getRowState())) {
                        continue;
                    }
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());
                    detailExecutionVO.setCategoryFlag(false);

                    //来源主表ID
                    if(ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.分包招标控制价框架协议变更.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }

                    // 档案分类ID
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    //档案分类编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //档案类型
                    if (ControlVO.分包类别_专业分包.equals(subType)){
                        detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                    }else {
                        detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                    }
                    //档案Id
                    detailExecutionVO.setDocId(detail.getDocId());
                    //档案编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    //档案名称
                    detailExecutionVO.setName(detail.getDetailName());
                    //单位Id
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    //单位名称
                    detailExecutionVO.setUnitName(detail.getUnit());
                    //工程量
                    detailExecutionVO.setNum(detail.getThreeProjectNum());
                    //控制价金额-无税合价
                    detailExecutionVO.setMoney(detail.getThreeControlMny());
                    //控制价金额含税合价
                    detailExecutionVO.setTaxMoney(detail.getThreeControlTaxMny());
                    //工作计量规则
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    //控制价不含税单价
                    detailExecutionVO.setPrice(detail.getThreeControlPrice());
                    //控制价含税单价
                    detailExecutionVO.setTaxPrice(detail.getThreeControlTaxPrice());
                    //控制价税率
                    detailExecutionVO.setTaxRate(detail.getThreeControlTaxRate());
                    //备注
                    detailExecutionVO.setMemo(detail.getThreeMemo());
                    if(null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
            if(CollectionUtils.isNotEmpty(controlVO.getControlDetailFourList())) {
                for(ControlDetailFourVO detail : controlVO.getControlDetailFourList()) {
                    if("del".equals(detail.getRowState())) {
                        continue;
                    }
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());
                    detailExecutionVO.setCategoryFlag(false);

                    //来源主表ID
                    if(ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.分包招标控制价框架协议变更.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }

                    // 档案分类ID
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    //档案分类编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //档案类型
                    if (ControlVO.分包类别_专业分包.equals(subType)){
                        detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                    }else {
                        detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                    }
                    //档案Id
                    detailExecutionVO.setDocId(detail.getDocId());
                    //档案编码
                    detailExecutionVO.setCode(detail.getDetailCode());
                    //档案名称
                    detailExecutionVO.setName(detail.getDetailName());
                    //单位Id
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    //单位名称
                    detailExecutionVO.setUnitName(detail.getUnit());
                    //工程量
                    detailExecutionVO.setNum(detail.getFourProjectNum());
                    //控制价金额-无税合价
                    detailExecutionVO.setMoney(detail.getFourControlMny());
                    //控制价金额含税合价
                    detailExecutionVO.setTaxMoney(detail.getFourControlTaxMny());
                    //工作计量规则
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    //控制价不含税单价
                    detailExecutionVO.setPrice(detail.getFourControlPrice());
                    //控制价含税单价
                    detailExecutionVO.setTaxPrice(detail.getFourControlTaxPrice());
                    //控制价税率
                    detailExecutionVO.setTaxRate(detail.getFourControlTaxRate());
                    //备注
                    detailExecutionVO.setMemo(detail.getFourMemo());
                    if(null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
        }

        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    private String getBaseHost(){
        return org.apache.commons.lang3.StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BaseHost;
    }

    @Override
    public ParamsCheckVO checkParams(ControlVO vo, Object o) {

        //无项目策划成本时是否可提交分包招标控制价审核表
        String status = responseIsCost(vo);
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
//        if (status.equals("1")){
//            return paramsCheckVO;
//        }
        paramsCheckVOS.addAll(checkControlAllMny(vo));
        responseDetailIsCost(vo);
        paramsCheckVOS.addAll(checkControlDetailMny(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public ControlVO queryDetail(Long id) {
        ControlEntity controlEntity = super.selectById(id);
        ControlVO controlVO =  BeanMapper.map(controlEntity, ControlVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailEntity> detailEntityListDb = controlDetailService.queryList(queryParam, false);
        List<ControlDetailEntity> detailEntityList = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(ControlDetailEntity cdEntity : detailEntityList){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ControlDetailVO.class);
            controlVO.setControlDetailList(resultMapList);

        } else {
            controlVO.setControlDetailList(BeanMapper.mapList(detailEntityList, ControlDetailVO.class));
        }
        //标段2
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailTwoEntity> detailEntityListDb2 = controlDetailTwoService.queryList(queryParam, false);
        List<ControlDetailTwoEntity> detailEntityList2 = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb2)) {
            detailEntityListDb2.forEach(entity ->{
                if(null == entity.getTwoChangeType() || ChangeTypeEnum.中止.getCode() != entity.getTwoChangeType()){
                    detailEntityList2.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList2)) {
            for(ControlDetailTwoEntity cdEntity : detailEntityList2){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailTwoVO> resultMapList = BeanMapper.mapList(detailEntityList2, ControlDetailTwoVO.class);
            controlVO.setControlDetailTwoList(resultMapList);

        } else {
            controlVO.setControlDetailTwoList(BeanMapper.mapList(detailEntityList2, ControlDetailTwoVO.class));

        }
            
        //标段3
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailThreeEntity> detailEntityListDb3 = controlDetailThreeService.queryList(queryParam, false);
        List<ControlDetailThreeEntity> detailEntityList3 = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb3)) {
            detailEntityListDb3.forEach(entity ->{
                if(null == entity.getThreeChangeType() || ChangeTypeEnum.中止.getCode() != entity.getThreeChangeType()){
                    detailEntityList3.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList3)) {
            for(ControlDetailThreeEntity cdEntity : detailEntityList3){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailThreeVO> resultMapList = BeanMapper.mapList(detailEntityList3, ControlDetailThreeVO.class);
            controlVO.setControlDetailThreeList(resultMapList);

        } else {
            controlVO.setControlDetailThreeList(BeanMapper.mapList(detailEntityList3, ControlDetailThreeVO.class));
        }
        
        //标段4
        QueryParam queryParam4 = new QueryParam();
        queryParam4.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailFourEntity> detailEntityListDb4 = controlDetailFourService.queryList(queryParam, false);
        List<ControlDetailFourEntity> detailEntityList4 = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb4)) {
            detailEntityListDb4.forEach(entity ->{
                if(null == entity.getFourChangeType() || ChangeTypeEnum.中止.getCode() != entity.getFourChangeType()){
                    detailEntityList4.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList4)) {
            for(ControlDetailFourEntity cdEntity : detailEntityList4){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailFourVO> resultMapList = BeanMapper.mapList(detailEntityList4, ControlDetailFourVO.class);
            controlVO.setControlDetailFourList(resultMapList);

        } else {
            controlVO.setControlDetailFourList(BeanMapper.mapList(detailEntityList4, ControlDetailFourVO.class));
        }


        QueryParam queryParam5 = new QueryParam();
        queryParam5.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailFiveEntity> detailEntityListDb5 = controlDetailFiveService.queryList(queryParam, false);
        List<ControlDetailFiveEntity> detailEntityList5 = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb5)) {
            detailEntityListDb5.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList5.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList5)) {
            for(ControlDetailFiveEntity cdEntity : detailEntityList5){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailFiveVO> resultMapList = BeanMapper.mapList(detailEntityList5, ControlDetailFiveVO.class);
            controlVO.setControlDetailFiveList(resultMapList);

        } else {
            controlVO.setControlDetailFiveList(BeanMapper.mapList(detailEntityList5, ControlDetailFiveVO.class));
        }
        
        

        if(null != controlEntity.getChangeVersion() && controlEntity.getChangeVersion() > 0){
            controlVO.setChangeHisVOList(controlChangeService.queryDetailRecord(controlEntity.getId()));
        }
        
        return controlVO;
    }


    //校验是否有项目策划成本
    private String responseIsCost(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)

        //无项目策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的系统参数不能为空!");
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();

        // 是否限制： 0:限制，1:不限制
        if ("1".equals(valueData)) {
            return "1";
        }
        if ("0".equals(valueData)) {
            if (buildDutyVO == null || (buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)){
                throw new BusinessException("项目未做项目策划成本，不允许保存!");
            }
        }

        return "1";
    }
    ////校验是否有项目策划成本明细
    private String responseDetailIsCost(ControlVO controlVO) {

        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, Long> costMap = new HashMap<>();
        if (subType == 1){
            if (buildDutyVO != null){
                List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
                if(CollectionUtils.isNotEmpty(proSubDetailList)){
                    costMap = proSubDetailList.stream().filter(s->s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getId));
                }
            }

        }
        if (subType == 2){
            if (buildDutyVO != null){
                List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
                if(CollectionUtils.isNotEmpty(laborDetailList)){
                    costMap = laborDetailList.stream().filter(s->s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getId));
                }
            }
        }

        // 清单无策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> responseDetail = paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE);
        if (!responseDetail.isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + responseDetail.getMsg());
        }
        String valueDataDetail = responseDetail.getData().getValueData();
        Assert.hasText(valueDataDetail, "获取系统参数不能为空!");

        // 是否限制： 0:限制，1:不限制
        if ("1".equals(valueDataDetail)) {
            return "1";
        }
        if ("0".equals(valueDataDetail)) {
            //标段1
            List<ControlDetailVO> controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty(controlDetailList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().filter(s->!"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段1清单没有策划成本，不允许保存!");
                }
            }
            //标段2
            List<ControlDetailTwoVO> controlDetailTwoList = controlVO.getControlDetailTwoList();
            if (CollectionUtils.isNotEmpty(controlDetailTwoList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().filter(s->!"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段2清单没有策划成本，不允许保存!");
                }
            }
            //标段3
            List<ControlDetailThreeVO> controlDetailThreeList = controlVO.getControlDetailThreeList();
            if (CollectionUtils.isNotEmpty(controlDetailThreeList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().filter(s->!"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段3清单没有策划成本，不允许保存!");
                }
            }
            //标段4
            List<ControlDetailFourVO> controlDetailFourList = controlVO.getControlDetailFourList();
            if (CollectionUtils.isNotEmpty(controlDetailFourList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().filter(s->!"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段4清单没有策划成本，不允许保存!");
                }
            }
        }

        return "1";
    }
//分包招标控制总价是否允许超过策划成本总价
    private List<ParamsCheckVO> checkControlAllMny(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        Map<Long, BigDecimal> numMasterPlanMap = new HashMap<>();
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null){
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }

        //分包招标控制总价>策划成本总价*X%
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info(" 分包招标控制总价>策划成本总价*X%：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply(planedTotalCostTaxMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(controlVO.getControlTaxMny(),compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("分包招标控制总价大于策划成本总价");
                            paramsCheckDsVO.setWarnName("分包招标控制总价大于策划成本总价");

                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制总价为:").append(ComputeUtil.nullToZero(controlVO.getControlTaxMny()).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("，策划成本总价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(controlVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        List<ControlDetailVO> controlDetailList = controlVO.getControlDetailList();

        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, BigDecimal> costMap = new HashMap<>();
        if (subType == 1 && buildDutyVO != null){
            List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
            if(CollectionUtils.isNotEmpty(proSubDetailList)){
                costMap = proSubDetailList.stream().filter(s->s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
            }
        }
        if (subType == 2 && buildDutyVO != null){
            List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
            if(CollectionUtils.isNotEmpty(laborDetailList)){
                costMap = laborDetailList.stream().filter(s->s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info("清单的分包招标控制价是否允许超过策划成本价：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (ControlDetailVO detailVO : controlVO.getControlDetailList()) {
                    if("del".equals(detailVO.getRowState())){
                       continue;
                    }

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getControlTaxMny()).setScale(3,                                     BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段2
                for (ControlDetailTwoVO detailVO : controlVO.getControlDetailTwoList()) {
                    if("del".equals(detailVO.getRowState())){
                        continue;
                    }
                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getTwoControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段2清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getTwoControlTaxMny()).setScale(3,                                BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getTwoControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
                //标段3
                for (ControlDetailThreeVO detailVO : controlVO.getControlDetailThreeList()) {
                    if("del".equals(detailVO.getRowState())){
                        continue;
                    }
                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getThreeControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段3清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getThreeControlTaxMny()).setScale(3,                              BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getThreeControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段4
                for (ControlDetailFourVO detailVO : controlVO.getControlDetailFourList()) {
                    if("del".equals(detailVO.getRowState())){
                        continue;
                    }
                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getFourControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段4清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getFourControlTaxMny()).setScale(3,                               BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getFourControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<Object> importData(Integer type, String tabKey,HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ControlDetailSubVo> successList = new ArrayList<>();
        List<ControlDetailSubVo> errorList = new ArrayList<>();
        Map<String, ControlDetailSubVo> map = new HashMap<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        Map<String, List<LabsubItemVO>> codeMap = new HashMap<>();
        Map<String,List<ProsubItemVO>> codeMap1 = new HashMap<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); i++) {
                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailCode = datas.get(0);//清单编号
                logger.info("detailCode--" + detailCode);
                logger.info("int----" + i);
                String detailName = datas.get(1);//清单名称
                String detailNum = datas.get(2);//工程量
                String detailTaxRate = datas.get(3);//税率
                String detailTaxPrice = datas.get(4);//含税单价
                String detailTaxMny = datas.get(5);//含税合价
                ControlDetailSubVo detailVO = new ControlDetailSubVo();
                if (StringUtils.isBlank(detailCode)) {
                    detailVO.setErrorMessage("清单编号不能为空");
                }else{
                    CommonResponse<List<LabsubItemVO>> listCommonResponse = null;
                    CommonResponse<List<ProsubItemVO>> listCommonResponse1 = null;
                    if (type == 2 || type==4) {
                        if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                            listCommonResponse = labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                            if (listCommonResponse.isSuccess()) {
                                List<LabsubItemVO> data = listCommonResponse.getData();
                                if (data == null) {
                                    detailVO.setErrorMessage("根据清单编号查询失败");
                                    errorsMsgBuilder.append("根据清单编号查询失败！");
                                    detailVO.setIsMatch("未匹配");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    codeMap.put(detailCode, data);
                                    // 封装数据
                                    for (LabsubItemVO labsubItemVO : data) {
                                        if (labsubItemVO.getTrawlingCode().equals(detailCode)  && labsubItemVO.getTrawlingName().equals(detailName)) {

                                            detailVO.setWorkContent(labsubItemVO.getJobContent());
                                            detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                            detailVO.setUnit(labsubItemVO.getUnitName());
                                            detailVO.setDetailCode(detailCode);
                                            detailVO.setDetailName(detailName);
                                            detailVO.setIsMatch("已匹配");
                                        } else {
                                            detailVO.setIsMatch("未匹配");
                                            detailVO.setErrorMessage("清单编码与清单名称未匹配");
                                            errorsMsgBuilder.append("未匹配");
                                        }
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("根据清单编号查询失败");
                                errorsMsgBuilder.append("根据清单编号查询失败！");
                            }
                        }else {
                            detailVO.setErrorMessage("根据清单编号查询失败");
                            errorsMsgBuilder.append("根据清单编号查询失败！");
                        }
                    }else if(type == 1){
                        if (MapUtils.isEmpty(codeMap1) || codeMap1.get(detailCode) == null) {
                            listCommonResponse1 = prosubApi.queryItemListByCodes(Arrays.asList(detailCode));
                            if (listCommonResponse1.isSuccess()) {
                                List<ProsubItemVO> data = listCommonResponse1.getData();
                                if (data == null) {
                                    detailVO.setErrorMessage("根据清单编号查询失败");
                                    errorsMsgBuilder.append("根据清单编号查询失败！");
                                    detailVO.setIsMatch("未匹配");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    codeMap1.put(detailCode, data);
                                    // 封装数据
                                    for (ProsubItemVO labsubItemVO : data) {
                                        if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                            detailVO.setWorkContent(labsubItemVO.getJobContent());
                                            detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                            detailVO.setUnit(labsubItemVO.getUnitName());
                                            detailVO.setDetailCode(detailCode);
                                            detailVO.setDetailName(detailName);
                                            detailVO.setIsMatch("已匹配");
                                        } else {
                                            detailVO.setIsMatch("未匹配");
                                            errorsMsgBuilder.append("未匹配");
                                        }
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("根据清单编号查询失败");
                                errorsMsgBuilder.append("根据清单编号查询失败！");
                            }
                        }else {
                            detailVO.setErrorMessage("根据清单编号查询失败");
                            errorsMsgBuilder.append("根据清单编号查询失败！");
                        }
                    }else if(type == 3){
                        detailVO.setDetailCode(detailCode);
                    }
                }
                //

                if(type == 3){
                    if (StringUtils.isBlank(detailName)) {
                        detailVO.setErrorMessage("清单名称不能为空");
                        errorsMsgBuilder.append("清单名称不能为空");
                    }else{
                        detailVO.setDetailName(detailName);
                    }
                }
                if (StringUtils.isBlank(detailNum)) {
                    detailVO.setErrorMessage("工程量不能为空");
                    errorsMsgBuilder.append("工程量不能为空！");
                }else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailNum);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("工程量不可小于0");
                            errorsMsgBuilder.append("工程量不可小于0！");
                        } else {
                            forSetProjectNum(detailVO,taxRate1,tabKey);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("工程量必须为数字");
                        errorsMsgBuilder.append("工程量必须为数字！");
                    }
                }
                // 税率
                if (StringUtils.isBlank(detailTaxRate)) {
                    detailVO.setErrorMessage("税率不可为空");
                    errorsMsgBuilder.append("税率不能为空！");
                }else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("税率不可小于0");
                            errorsMsgBuilder.append("税率不可小于0！");
                        } else {
                            forSetTaxRate(detailVO,taxRate1,tabKey);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("税率必须为数字");
                        errorsMsgBuilder.append("税率必须为数字！");
                    }
                }
                //税率
                BigDecimal tax = ComputeUtil.safeDiv(new BigDecimal(detailTaxRate),new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                //工程量
                BigDecimal num = new BigDecimal(detailNum);
                // 综合单价
                if (StringUtils.isNotBlank(detailTaxPrice)) {
                    //综合单价
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setFinalTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalPrice(price);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeMultiply(num,price);
                    detailVO.setFinalMny(mny);
                    //含税金额
                    BigDecimal taxMny = ComputeUtil.safeMultiply(mny, ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalTaxMny(taxMny);
                    forSetMoneyData(detailVO,tabKey,taxPrice,price,mny,taxMny);
                    //综合税额
                    BigDecimal tax1 = ComputeUtil.safeMultiply(mny, tax);
                    detailVO.setControlTax(tax1);
//                    detailVO.setFinalTax

                    detailVO.setFinalTax(tax1);
                }
                if (StringUtils.isNotBlank(detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setFinalTaxMny(taxMny);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeDiv(taxMny,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalMny(mny);
                    //含税单价
                    BigDecimal taxPrice = ComputeUtil.safeDiv(taxMny, num);
                    detailVO.setFinalTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalPrice(price);
                    forSetMoneyData(detailVO,tabKey,taxPrice,price,mny,taxMny);
//                    //综合税额
//                    BigDecimal detailTax = ComputeUtil.safeMultiply(tax,mny);
//                    detailVO.setDetailTax(detailTax);
//                    detailVO.setcontrolTax
                    BigDecimal detailTax = ComputeUtil.safeMultiply(tax,mny);
                    detailVO.setControlTax(detailTax);
                    detailVO.setFinalTax(detailTax);

                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                } else {
                    successList.add(detailVO);
                }

            }
        }


        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @Override
    public CommonResponse<Object> importOtherData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ControlDetailSubVo> successList = new ArrayList<>();
        List<ControlDetailSubVo> errorList = new ArrayList<>();
        Map<String, ControlDetailSubVo> map = new HashMap<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        Map<String, List<LabsubItemVO>> codeMap = new HashMap<>();
        Map<String,List<ProsubItemVO>> codeMap1 = new HashMap<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); i++) {

                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();

                String detailName = datas.get(0);//清单名称
                String detailWorkContent = datas.get(1);//工作内容
                String detailMeasurementRules = datas.get(2);//计量规则
                String detailUnit = datas.get(3);//计量单位
                String detailNum = datas.get(4);//工程量
                String detailTaxRate = datas.get(5);//税率
                String detailTaxPrice = datas.get(6);//综合单价
                String detailTaxMny = datas.get(7);//综合金额

                ControlDetailSubVo detailVO = new ControlDetailSubVo();

                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank(detailName)) {
                    detailVO.setErrorMessage("清单名称不能为空");
                    errorsMsgBuilder.append("清单名称不能为空");
                }else{
                    detailVO.setDetailName(detailName);
                }

                if (StringUtils.isBlank(detailWorkContent)) {
                    detailVO.setErrorMessage("工作内容不能为空");
                    errorsMsgBuilder.append("工作内容不能为空");
                }else{
                    detailVO.setWorkContent(detailWorkContent);
                }

                if (StringUtils.isBlank(detailMeasurementRules)) {
                    detailVO.setErrorMessage("计量规则不能为空");
                    errorsMsgBuilder.append("计量规则不能为空");
                }else{
                    detailVO.setDetailMeasurementRules(detailMeasurementRules);
                }

                if (StringUtils.isBlank(detailUnit)) {
                    detailVO.setErrorMessage("计量单位不能为空");
                    errorsMsgBuilder.append("计量单位不能为空");
                }else{
                    detailVO.setUnit(detailUnit);
                }

                // 工程量
                if (StringUtils.isBlank(detailNum)) {
                    detailVO.setErrorMessage("工程量不能为空");
                    errorsMsgBuilder.append("工程量不能为空！");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailNum);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("工程量不可小于0");
                            errorsMsgBuilder.append("工程量不可小于0！");
                        } else {
                            forSetProjectNum(detailVO,  taxRate1,tabKey);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("工程量必须为数字");
                        errorsMsgBuilder.append("工程量必须为数字！");
                    }
                }


                // 税率
                if (StringUtils.isBlank(detailTaxRate)) {
                    detailVO.setErrorMessage("税率不可为空");
                    errorsMsgBuilder.append("税率不能为空！");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("税率不可小于0");
                            errorsMsgBuilder.append("税率不可小于0！");
                        } else {
                            forSetTaxRate(detailVO, taxRate1,tabKey);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("税率必须为数字");
                        errorsMsgBuilder.append("税率必须为数字！");
                    }
                }

                //税率
                BigDecimal tax = ComputeUtil.safeDiv(new BigDecimal(detailTaxRate),new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                //工程量
                BigDecimal num = new BigDecimal(detailNum);

                // 综合单价
                if (StringUtils.isNotBlank(detailTaxPrice)) {
                    //综合单价
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setFinalTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalPrice(price);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeMultiply(num,price);
                    detailVO.setFinalMny(mny);
                    //含税金额
                    BigDecimal taxMny = ComputeUtil.safeMultiply(mny, ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalTaxMny(taxMny);

                    forSetMoneyData(detailVO,tabKey,taxPrice,price,mny,taxMny);
                    //综合税额
                    BigDecimal tax1 = ComputeUtil.safeMultiply(mny, tax);
//                    detailVO.setDetailTax(tax1);
                    detailVO.setFinalTax(tax1);
                    detailVO.setControlTax(tax1);


                }
                // 综合金额
                if (StringUtils.isNotBlank(detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setFinalTaxMny(taxMny);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeDiv(taxMny,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalMny(mny);
                    //含税单价
                    BigDecimal taxPrice = ComputeUtil.safeDiv(taxMny, num);
                    detailVO.setFinalTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalPrice(price);
                    forSetMoneyData(detailVO,tabKey,taxPrice,price,mny,taxMny);
                    //综合税额
                    BigDecimal detailTax = ComputeUtil.safeMultiply(tax,mny);
                    detailVO.setFinalTax(detailTax);
                    detailVO.setControlTax(detailTax);

                }

                //备注
//                if(StringUtils.isNotBlank(memo)){
//                    detailVO.setDetailMemo(memo);
//                }

                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                } else {
                    successList.add(detailVO);
                }
            }

        }

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @Override
    public CommonResponse<Object> importEquipmentData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ControlDetailSubVo> successList = new ArrayList<>();
        List<ControlDetailSubVo> errorList = new ArrayList<>();
        Map<String, ControlDetailSubVo> map = new HashMap<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        Map<String, List<LabsubItemVO>> codeMap = new HashMap<>();
        Map<String,List<ProsubItemVO>> codeMap1 = new HashMap<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); i++) {

                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();

                String detailCode = datas.get(0);//清单编号
                String detailName = datas.get(1);//清单名称
                String detailNewNum = datas.get(2);//工程量-新
                String useTime = datas.get(3);//使用时间（月）
                String detailTaxRate = datas.get(4);//税率
                String detailTaxPrice = datas.get(5);//综合单价
                String detailTaxMny = datas.get(6);//综合金额

                ControlDetailSubVo detailVO = new ControlDetailSubVo();

                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank(detailCode)) {
                    detailVO.setErrorMessage("清单编号不能为空");
                } else {
                    CommonResponse<List<LabsubItemVO>> listCommonResponse = null;
                    CommonResponse<List<ProsubItemVO>> listCommonResponse1 = null;
                    // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                    // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数

                    if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                        listCommonResponse = labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                        if (listCommonResponse.isSuccess()) {
                            List<LabsubItemVO> data = listCommonResponse.getData();
                            if (data == null) {
                                detailVO.setErrorMessage("根据清单编号查询失败");
                                errorsMsgBuilder.append("根据清单编号查询失败！");
                                detailVO.setIsMatch("未匹配");
                            } else {
                                // 将查询到的数据缓存到map中
                                codeMap.put(detailCode, data);
                                // 封装数据
                                for (LabsubItemVO labsubItemVO : data) {
                                    if (labsubItemVO.getTrawlingCode().equals(detailCode)  && labsubItemVO.getTrawlingName().equals(detailName)) {
                                        detailVO.setWorkContent(labsubItemVO.getJobContent());
                                        detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                        detailVO.setUnit(labsubItemVO.getUnitName());
                                        detailVO.setDetailCode(detailCode);
                                        detailVO.setDetailName(detailName);
                                        detailVO.setIsMatch("已匹配");
                                    } else {
                                        detailVO.setIsMatch("未匹配");
                                        detailVO.setErrorMessage("清单编码与清单名称未匹配");
                                        errorsMsgBuilder.append("未匹配");
                                    }
                                }
                            }
                        } else {
                            detailVO.setErrorMessage("根据清单编号查询失败");
                            errorsMsgBuilder.append("根据清单编号查询失败！");
                        }
                    }else {
                        detailVO.setErrorMessage("根据清单编号查询失败");
                        errorsMsgBuilder.append("根据清单编号查询失败！");
                    }
                }


                // 工程量
                if (StringUtils.isBlank(detailNewNum)) {
                    detailVO.setErrorMessage("工程量不能为空");
                    errorsMsgBuilder.append("工程量不能为空！");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailNewNum);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("工程量不可小于0");
                            errorsMsgBuilder.append("工程量不可小于0！");
                        } else {
                            forSetNewProjectNum(detailVO, taxRate1,tabKey);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("工程量必须为数字");
                        errorsMsgBuilder.append("工程量必须为数字！");
                    }
                }

                // 使用时间（月）
                BigDecimal useTimeData = null;
                if (StringUtils.isBlank(useTime)) {
                    detailVO.setErrorMessage("使用时间（月）不能为空");
                    errorsMsgBuilder.append("使用时间（月）不能为空！");
                } else {
                    try {
                        useTimeData = new BigDecimal(useTime);
                        if (useTimeData.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("使用时间（月）不可小于0");
                            errorsMsgBuilder.append("使用时间（月）不可小于0！");
                        } else {
                            forSetUseTime(detailVO, useTimeData,tabKey);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("使用时间（月）必须为数字");
                        errorsMsgBuilder.append("使用时间（月）必须为数字！");
                    }
                }

                // 税率
                if (StringUtils.isBlank(detailTaxRate)) {
                    detailVO.setErrorMessage("税率不可为空");
                    errorsMsgBuilder.append("税率不能为空！");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("税率不可小于0");
                            errorsMsgBuilder.append("税率不可小于0！");
                        } else {
                            forSetTaxRate(detailVO, taxRate1,tabKey);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("税率必须为数字");
                        errorsMsgBuilder.append("税率必须为数字！");
                    }
                }

                //税率
                BigDecimal tax = ComputeUtil.safeDiv(new BigDecimal(detailTaxRate),new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                //综合工程量
                BigDecimal detailNewNumData = new BigDecimal(detailNewNum);
                BigDecimal num = ComputeUtil.safeMultiply(detailNewNumData, useTimeData);
                forSetProjectNum(detailVO, num,tabKey);


                // 综合单价
                if (StringUtils.isNotBlank(detailTaxPrice)) {
                    //综合单价
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setFinalTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalPrice(price);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeMultiply(num,price);
                    detailVO.setFinalMny(mny);
                    //含税金额
                    BigDecimal taxMny = ComputeUtil.safeMultiply(mny, ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalTaxMny(taxMny);
                    //综合税额
                    BigDecimal tax1 = ComputeUtil.safeMultiply(mny, tax);
                    detailVO.setControlTax(tax1);
                    detailVO.setFinalTax(tax1);
                    forSetMoneyData(detailVO,tabKey,taxPrice,price,mny,taxMny);
                }


                // 综合金额
                if (StringUtils.isNotBlank(detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setFinalTaxMny(taxMny);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeDiv(taxMny,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalMny(mny);
                    //含税单价
                    BigDecimal taxPrice = ComputeUtil.safeDiv(taxMny, num);
                    detailVO.setFinalTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setFinalPrice(price);
                    //综合税额
                    BigDecimal detailTax = ComputeUtil.safeMultiply(tax,mny);
                    detailVO.setControlTax(detailTax);
                    detailVO.setFinalTax(detailTax);
                    forSetMoneyData(detailVO,tabKey,taxPrice,price,mny,taxMny);

                }

                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                } else {
                    successList.add(detailVO);
                }
            }

        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    private void forSetUseTime(ControlDetailSubVo detailVO, BigDecimal useTimeData, String tabKey) {
        if (tabKey.equals("tabOne")){
            detailVO.setUseDateMonth(useTimeData);
        }else if (tabKey.equals("tabTwo")){
            detailVO.setTwoUseDateMonth(useTimeData);
        }else if (tabKey.equals("tabThree")){
            detailVO.setThreeUseDateMonth(useTimeData);
        }else if (tabKey.equals("tabFour")){
            detailVO.setFourUseDateMonth(useTimeData);
        }
    }

    private void forSetNewProjectNum(ControlDetailSubVo detailVO, BigDecimal taxRate1, String tabKey) {
        if (tabKey.equals("tabOne")){
            detailVO.setNewNum(taxRate1);
        }else if (tabKey.equals("tabTwo")){
            detailVO.setTwoNewNum(taxRate1);
        }else if (tabKey.equals("tabThree")){
            detailVO.setThreeNewNum(taxRate1);
        }else if (tabKey.equals("tabFour")){
            detailVO.setFourNewNum(taxRate1);
        }
    }

    private void forSetMoneyData(ControlDetailSubVo detailVO, String tabKey, BigDecimal taxPrice, BigDecimal price, BigDecimal mny, BigDecimal taxMny) {
        if (tabKey.equals("tabOne")){
            detailVO.setControlPrice(price);
            detailVO.setControlTaxPrice(taxPrice);
            detailVO.setControlMny(mny);
            detailVO.setControlTaxMny(taxMny);
        }else if (tabKey.equals("tabTwo")){
            detailVO.setTwoControlPrice(price);
            detailVO.setTwoControlTaxPrice(taxPrice);
            detailVO.setTwoControlMny(mny);
            detailVO.setTwoControlTaxMny(taxMny);
        }else if (tabKey.equals("tabThree")){
            detailVO.setThreeControlPrice(price);
            detailVO.setThreeControlTaxPrice(taxPrice);
            detailVO.setThreeControlMny(mny);
            detailVO.setThreeControlTaxMny(taxMny);
        }else if (tabKey.equals("tabFour")){
            detailVO.setFourControlPrice(price);
            detailVO.setFourControlTaxPrice(taxPrice);
            detailVO.setFourControlMny(mny);
            detailVO.setFourControlTaxMny(taxMny);
        }

    }
    private void forSetTaxRate(ControlDetailSubVo detailVO, BigDecimal taxRate1, String tabKey) {
        if (tabKey.equals("tabOne")){
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setControlTaxRate(taxRate1);
        }else if (tabKey.equals("tabTwo")){
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setTwoControlTaxRate(taxRate1);
        }else if (tabKey.equals("tabThree")){
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setThreeControlTaxRate(taxRate1);
        }else if (tabKey.equals("tabFour")){
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setFourControlTaxRate(taxRate1);
        }
    }

    private void forSetProjectNum(ControlDetailSubVo detailVO,  BigDecimal taxRate1, String tabKey) {
        if (tabKey.equals("tabOne")){
            detailVO.setProjectNum(taxRate1);
        }else if (tabKey.equals("tabTwo")){
            detailVO.setTwoProjectNum(taxRate1);
        }else if (tabKey.equals("tabThree")){
            detailVO.setThreeProjectNum(taxRate1);
        }else if (tabKey.equals("tabFour")){
            detailVO.setFourProjectNum(taxRate1);
        }
    }


}
