package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.mapper.ControlChangeHisMapper;
import com.ejianc.business.control.mapper.ControlChangeMapper;
import com.ejianc.business.control.service.IControlChangeService;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.*;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包招标控制价审核表-变更
 * 
 * @author generator
 * 
 */
@Service("controlChangeService")
public class ControlChangeServiceImpl extends BaseServiceImpl<ControlChangeMapper, ControlChangeEntity> implements IControlChangeService{

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IControlChangeService controlChangeService;
    @Autowired
    private IControlService controlService;
    private static final String BILL_CODE = "SUB_CONTROL_CHANGE";//此处需要根据实际修改
    private static final String CONTROL_COST_CODE = "P-i3X5840010";//无项目策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_DETAIL_CODE = "P-94k78t0012";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";//清单的分包招标控制价是否允许超过策划成本价
    @Autowired
    private IBuildDutyApi buildDutyApi;

    @Autowired
    private ControlChangeMapper controlChangeMapper;
    @Autowired
    private ControlChangeHisMapper controlChangeHisMapper;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExecutionApi executionApi;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    private final String PC_XM_CHANGE_URL = "ejc-prosub-frontend/#/subcontractPrice/changeCard?id=";
    private final String PC_KJXY_CHANGE_URL = "ejc-prosub-frontend/#/subcontractPriceChangeHisKJXY/card?id=";



    @Override
    public ControlChangeVO saveOrUpdate(ControlChangeVO saveOrUpdateVO, Boolean isControl) {

        //校验项目是否存在未完成的变更计划单存在
        ControlChangeEntity controlChangeEntity = controlChangeService.getUnFinishedChange(saveOrUpdateVO.getSourceControlId());

        if(null !=controlChangeEntity && (null == saveOrUpdateVO.getId() || !controlChangeEntity.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的变更分包招标控制价审核表！");
        }

        ControlEntity masterPlan = controlService.getById(saveOrUpdateVO.getSourceControlId());
        UserContext userContext = sessionManager.getUserContext();
        ControlChangeEntity saveEntity = null;
        saveEntity = BeanMapper.map(saveOrUpdateVO, ControlChangeEntity.class);
        if(null == saveOrUpdateVO.getId()) {
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);

            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            //生成Id用于成本控制
            saveEntity.setId(IdWorker.getId());
        }

        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeEntity> controlDetailList = saveEntity.getControlDetailList();

        if (CollectionUtils.isNotEmpty(controlDetailList) && null == saveOrUpdateVO.getId()) {
            for (ControlDetailChangeEntity cdEntity : controlDetailList) {
                cdEntity.setId(IdWorker.getId());
                cdEntity.setParentId(null);
            }
        }

        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeTwoEntity> controlDetailTwoList = saveEntity.getControlDetailTwoList();
        if (CollectionUtils.isNotEmpty(controlDetailTwoList) && null == saveOrUpdateVO.getId()) {
            for (ControlDetailChangeTwoEntity cdEntity : controlDetailTwoList) {
                cdEntity.setId(IdWorker.getId());
                cdEntity.setParentId(null);
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeThreeEntity> controlDetailThreeList = saveEntity.getControlDetailThreeList();
        if (CollectionUtils.isNotEmpty(controlDetailThreeList) && null == saveOrUpdateVO.getId()) {
            for (ControlDetailChangeThreeEntity cdEntity : controlDetailThreeList) {
                cdEntity.setId(IdWorker.getId());
                cdEntity.setParentId(null);
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeFourEntity> controlDetailFourList = saveEntity.getControlDetailFourList();
        if (CollectionUtils.isNotEmpty(controlDetailFourList) && null == saveOrUpdateVO.getId()) {
            for (ControlDetailChangeFourEntity cdEntity : controlDetailFourList) {
                cdEntity.setId(IdWorker.getId());
                cdEntity.setParentId(null);
            }
        }
        List<ControlDetailChangeFiveEntity> controlDetailFiveList = saveEntity.getControlDetailFiveList();
        if (CollectionUtils.isNotEmpty(controlDetailFiveList) && null == saveOrUpdateVO.getId()) {
            for (ControlDetailChangeFiveEntity cdEntity : controlDetailFiveList) {
                cdEntity.setId(IdWorker.getId());
                cdEntity.setParentId(null);
            }
        }

        if(Boolean.FALSE.equals(isControl)) {
            saveEntity = controlChangeService.saveOrUpdateControlChange(saveEntity);

            if(ControlVO.招标方式_项目招标.equals(saveEntity.getType())) {
                /**
                 * 变更保存 删除原有数据,推送变更数据
                 * 1、先根据合同Id查询合同最近一次变更单记录
                 * 若存在变更记录，则将最近一次变更记录删除，将当前变更单信息推送策划成本
                 * 如不存在变更记录，则删除合同策划成本数据，将当前变更单信息推送策划成本
                 */
                //判断是否新增变更记录
                boolean delFlag = false;
                if(saveOrUpdateVO.getId() == null) {
                    delFlag = true;
                } else {
                    ControlChangeEntity dbEntity = super.selectById(saveOrUpdateVO.getId());
                    delFlag = dbEntity == null;
                }
                if(delFlag) {
                    List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                    ExecutionVO executionVO1 = getLastExecutionVO(saveEntity.getSourceControlId(),  saveEntity.getId());
                    //策划成本推送
                    totalExecutionVOList.add(executionVO1.getTotalVO());
                    logger.info("策划成本推送数据：{}", JSON.toJSONString(totalExecutionVOList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                    CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                    if (!response.isSuccess()) {
                        throw new BusinessException("策划成本推送失败," + response.getMsg());
                    }
                }

                //策划成本推送
                String linkUrl = this.getLinkUrl(saveEntity.getId(), saveEntity.getType());
                ExecutionVO executionVO = controlService.targetCost(BeanMapper.map(saveEntity, ControlVO.class),
                        linkUrl, saveEntity.getSubType(),
                        ControlVO.招标方式_项目招标.equals(saveEntity.getType()) ?
                                ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode() : ProsubBillTypeEnum.分包招标控制价框架协议变更.getBillTypeCode());
                logger.info("合同变更保存，策划成本推送数据： {}", JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                logger.info("合同变更保存，策划成本推送数据结果：{}", JSONObject.toJSONString(response));
                if (!response.isSuccess()){
                    throw new BusinessException("策划成本推送失败,"+response.getMsg());
                }
            }
        }
        ControlChangeVO controlChangeVO = BeanMapper.map(saveEntity, ControlChangeVO.class);

        return controlChangeVO;
    }

    private ExecutionVO getLastExecutionVO(Long sourceControlId, Long curChangeId) {
        QueryWrapper<ControlChangeEntity> wrapper = new QueryWrapper<>();
        if(null != curChangeId) {
            wrapper.ne("id", curChangeId);
        }
        wrapper.eq("source_control_id", sourceControlId).orderByDesc("create_time");
        List<ControlChangeEntity> list = super.list(wrapper);

        ControlChangeEntity tmp = null;
        String linkUrl = null;
        //判断是否有过变更
        if (!list.isEmpty()){
            tmp = list.get(0);

            tmp = super.selectById(tmp.getId());
            linkUrl = getLinkUrl(tmp.getId(), tmp.getType());
            // 变更取原总计划id
            return controlService.targetCost(BeanMapper.map(tmp, ControlVO.class), linkUrl, tmp.getSubType(),
                    ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode());
        }else {
            ControlEntity controlEntity = controlService.selectById(sourceControlId);
            linkUrl = controlService.getLinkUrl(controlEntity.getId(), controlEntity.getType());
            return controlService.targetCost(BeanMapper.map(controlEntity, ControlVO.class), linkUrl, controlEntity.getSubType(),
                    ProsubBillTypeEnum.分包招标控制价.getBillTypeCode());
        }
    }

    @Override
    public String getLinkUrl(Long id, Integer type) {
        return getBaseHost()+(ControlVO.招标方式_项目招标.equals(type) ? PC_XM_CHANGE_URL : PC_KJXY_CHANGE_URL)+id;
    }

    private String getBaseHost(){
        return org.apache.commons.lang3.StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BaseHost;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ControlChangeEntity saveOrUpdateControlChange(ControlChangeEntity saveEntity) {

        super.saveOrUpdate(saveEntity, false);

        ControlEntity controlEntity = controlService.selectById(saveEntity.getSourceControlId());
        if (1 != controlEntity.getChangeState()) {
            controlEntity.setChangeState(1);
            controlEntity.setChangeId(saveEntity.getId());
            controlService.saveOrUpdate(controlEntity, false);
        }
        return saveEntity;
    }


    @Override
    public ControlChangeEntity getUnFinishedChange(Long sourceControlId) {
        QueryWrapper<ControlChangeEntity> query = new QueryWrapper<>();
        query.eq("source_control_id", sourceControlId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return controlChangeMapper.selectOne(query);
    }

    @Override
    public List<ControlChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<ControlChangeEntity> lambda = Wrappers.<ControlChangeEntity>lambdaQuery();
        lambda.eq(ControlChangeEntity::getSourceControlId, id);
        lambda.in(ControlChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(ControlChangeEntity::getCreateTime);
        List<ControlChangeEntity> entities = super.list(lambda);
        List<ControlChangeHisVO> recordVOList = BeanMapper.mapList(entities, ControlChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
                    if (recordVO.getChangeVersion() < 10) {
                        recordVO.setHistoryCode(recordVO.getControlCode() + "-0" + recordVO.getChangeVersion());
                    }else {
                        recordVO.setHistoryCode(recordVO.getControlCode() + "-" + recordVO.getChangeVersion());
                    }
                    recordVO.setChangeCode(recordVO.getControlCode());
                }
        );
        return recordVOList;
    }

    private String responseIsCost(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)

        //无项目策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的系统参数不能为空!");
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, Long> costMap = new HashMap<>();
        if (subType == 1){
            if (buildDutyVO != null){
                List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
                if(CollectionUtils.isNotEmpty(proSubDetailList)){
                    costMap = proSubDetailList.stream().filter(s->s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getId));
                }
            }

        }
        if (subType == 2){
            if (buildDutyVO != null){
                List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
                if(CollectionUtils.isNotEmpty(laborDetailList)){
                    costMap = laborDetailList.stream().filter(s->s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getId));
                }
            }
        }

        // 是否限制： 0:限制，1:不限制
        if ("1".equals(valueData)) {
            return "1";
        }
        if ("0".equals(valueData)) {
            if (buildDutyVO == null || (buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)){
                throw new BusinessException("项目未做项目策划成本，不允许保存!");
            }
        }

        return "1";
    }
    private String responseDetailIsCost(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)

        //无项目策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的系统参数不能为空!");
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null){
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, Long> costMap = new HashMap<>();
        if (subType == 1){
            if (buildDutyVO != null){
                List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
                if(CollectionUtils.isNotEmpty(proSubDetailList)){
                    costMap = proSubDetailList.stream().filter(s->s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getId));
                }
            }

        }
        if (subType == 2){
            if (buildDutyVO != null){
                List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
                if(CollectionUtils.isNotEmpty(laborDetailList)){
                    costMap = laborDetailList.stream().filter(s->s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getId));
                }
            }
        }

        // 清单无策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> responseDetail = paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE);
        if (!responseDetail.isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + responseDetail.getMsg());
        }
        String valueDataDetail = responseDetail.getData().getValueData();
        Assert.hasText(valueDataDetail, "获取系统参数不能为空!");

        // 是否限制： 0:限制，1:不限制
        if ("1".equals(valueDataDetail)) {
            return "1";
        }
        if ("0".equals(valueDataDetail)) {
            //标段1
            List<ControlDetailChangeVO> controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty(controlDetailList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().filter(s->s.getChangeType() == null || s.getChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段1清单没有策划成本，不允许保存!");
                }
            }
            //标段2
            List<ControlDetailChangeTwoVO> controlDetailTwoList = controlVO.getControlDetailTwoList();
            if (CollectionUtils.isNotEmpty(controlDetailTwoList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().filter(s->s.getTwoChangeType() == null || s.getTwoChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段2清单没有策划成本，不允许保存!");
                }
            }
            //标段3
            List<ControlDetailChangeThreeVO> controlDetailThreeList = controlVO.getControlDetailThreeList();
            if (CollectionUtils.isNotEmpty(controlDetailThreeList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().filter(s->s.getThreeChangeType() == null || s.getThreeChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段3清单没有策划成本，不允许保存!");
                }
            }
            //标段4
            List<ControlDetailChangeFourVO> controlDetailFourList = controlVO.getControlDetailFourList();
            if (CollectionUtils.isNotEmpty(controlDetailFourList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().filter(s->s.getFourChangeType() == null || s.getFourChangeType() != 2).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("标段4清单没有策划成本，不允许保存!");
                }
            }
        }

        return "1";
    }

    //分包招标控制总价是否允许超过策划成本总价
    private List<ParamsCheckVO> checkControlAllMny(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        Map<Long, BigDecimal> numMasterPlanMap = new HashMap<>();
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null){
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }

//        分包招标控制总价>策划成本总价*X%

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info(" 分包招标控制总价>策划成本总价*X%：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal compareNum = ComputeUtil.safeMultiply(planedTotalCostTaxMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                    if (ComputeUtil.isGreaterThan(controlVO.getControlTaxMny(), compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("分包招标控制总价大于策划成本总价");
                        paramsCheckDsVO.setWarnName("分包招标控制总价大于策划成本总价");

                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("当前分包招标控制总价为:").append(ComputeUtil.nullToZero(controlVO.getControlTaxMny()).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("，策划成本总价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("。超出量：").append(ComputeUtil.safeSub(controlVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }



    @Override
    public ParamsCheckVO checkParams(ControlChangeVO vo, Object o) {

        //无项目策划成本时是否可提交分包招标控制价审核表
        String status = responseIsCost(vo);
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
//        if (status.equals("0")){
//            return paramsCheckVO;
//        }

        paramsCheckVOS.addAll(checkControlAllMny(vo));
        responseDetailIsCost(vo);
        paramsCheckVOS.addAll(checkControlDetailMny(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public void deleteChangeControl(List<Long> changeIds) {
        List<ControlChangeEntity> changeList = controlChangeMapper.selectBatchIds(changeIds);
        List<Long> controlIds = changeList.stream().map(ControlChangeEntity::getSourceControlId).collect(Collectors.toList());

        QueryWrapper<ControlEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", controlIds);
        List<ControlEntity> controlEntities = controlService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<ControlChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_control_id as planId");
        query.in("source_control_id", controlIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_control_id");

        List<Map<String, Object>> queryResult = controlChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        Map<Long, Long> sourceControlIdsMap = new HashMap<>();
        for (ControlEntity control : controlEntities) {
            control.setChangeState((null != hisCountNumMap.get(control.getId()) && hisCountNumMap.get(control.getId()) > 0) ? 2 : 0); //未变更
            control.setChangeId(null);

            //变更删除 删除变更单据，删除推送数据，推送上一版数据
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();

            for (Long changeId : changeIds) {
                ControlChangeEntity changeEntity = super.selectById(changeId);
                if(ControlVO.招标方式_项目招标.equals(changeEntity.getType())){
                    ExecutionVO executionVO = controlService.targetCost(BeanMapper.map(changeEntity, ControlVO.class),
                            getLinkUrl(changeEntity.getId(), changeEntity.getType()),changeEntity.getSubType(),
                            ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode());
                    totalExecutionVOList.add(executionVO.getTotalVO());
                    sourceControlIdsMap.put(changeEntity.getSourceControlId(), changeEntity.getId());
                }
            }

            logger.info("合同变更删除，删除策划成本删除数据:{}", JSON.toJSONString(totalExecutionVOList));
            if(CollectionUtils.isNotEmpty(totalExecutionVOList)) {
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                logger.info("合同变更删除，策划成本删除数据结果:{}", JSON.toJSONString(response));
                if (!response.isSuccess()) {
                    throw new BusinessException("策划成本推送失败," + response.getMsg());
                }
            }
        }

        //策划成本推送
        if(!sourceControlIdsMap.isEmpty()) {
            ExecutionVO executionVO = null;
            //推送上一版数据
            for(Long controlId : sourceControlIdsMap.keySet()) {
                executionVO = getLastExecutionVO(controlId, sourceControlIdsMap.get(controlId));
                logger.info("合同变更删除，策划成本推送旧版本数据: {}", JSON.toJSONString(executionVO));
                CommonResponse<String> responses = executionApi.aggPush(executionVO);
                logger.info("合同变更删除，策划成本推送旧版本数据: {}", JSON.toJSONString(responses));
                if (!responses.isSuccess()) {
                    throw new BusinessException("策划成本推送失败," + responses.getMsg());
                }
            }
        }

        controlService.saveOrUpdateBatch(controlEntities, controlEntities.size());

        super.removeByIds(changeList.stream().map(ControlChangeEntity::getId).collect(Collectors.toList()), false);

    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlChangeVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        List<ControlDetailChangeVO> controlDetailList = controlVO.getControlDetailList();


        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, BigDecimal> costMap = new HashMap<>();
        if (subType == 1 && buildDutyVO != null){
            List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
            if(CollectionUtils.isNotEmpty(proSubDetailList)){
                costMap = proSubDetailList.stream().filter(s -> s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
            }
        }
        if (subType == 2 && buildDutyVO != null){
            List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
            if(CollectionUtils.isNotEmpty(laborDetailList)){
                costMap = laborDetailList.stream().filter(s -> s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info("清单的分包招标控制价是否允许超过策划成本价：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (ControlDetailChangeVO detailVO : controlVO.getControlDetailList()) {
                    if("del".equals(detailVO.getRowState())){
                        continue;
                    }
                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额: ").append(ComputeUtil.nullToZero(detailVO.getControlTaxMny()).setScale(3,                                     BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段2
                for (ControlDetailChangeTwoVO detailVO : controlVO.getControlDetailTwoList()) {
                    if("del".equals(detailVO.getRowState())){
                        continue;
                    }
                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getTwoControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段2清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getTwoControlTaxMny()).setScale(3,                                BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getTwoControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
            //标段3
            for (ControlDetailChangeThreeVO detailVO : controlVO.getControlDetailThreeList()) {
                if("del".equals(detailVO.getRowState())){
                    continue;
                }
                BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    //清单的分包招标控制价>清单的策划成本价*X%
                    BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                    if (ComputeUtil.isGreaterThan(detailVO.getThreeControlTaxMny(), compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                        paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("当前分包招标控制价 标段3清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getThreeControlTaxMny()).setScale(3,                              BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getThreeControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
            //标段4
            for (ControlDetailChangeFourVO detailVO : controlVO.getControlDetailFourList()) {
                if("del".equals(detailVO.getRowState())){
                    continue;
                }
                BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    //清单的分包招标控制价>清单的策划成本价*X%
                    BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                    if (ComputeUtil.isGreaterThan(detailVO.getFourControlTaxMny(), compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                        paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("当前分包招标控制价 标段4清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getFourControlTaxMny()).setScale(3,                               BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getFourControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

}
