/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.control.bean.ControlDetailEntity;
import com.ejianc.business.control.bean.ControlDetailFiveEntity;
import com.ejianc.business.control.bean.ControlDetailFourEntity;
import com.ejianc.business.control.bean.ControlDetailThreeEntity;
import com.ejianc.business.control.bean.ControlDetailTwoEntity;
import com.ejianc.business.control.bean.ControlEntity;
import com.ejianc.business.control.mapper.ControlMapper;
import com.ejianc.business.control.service.IControlChangeHisService;
import com.ejianc.business.control.service.IControlChangeService;
import com.ejianc.business.control.service.IControlDetailFiveService;
import com.ejianc.business.control.service.IControlDetailFourService;
import com.ejianc.business.control.service.IControlDetailService;
import com.ejianc.business.control.service.IControlDetailThreeService;
import com.ejianc.business.control.service.IControlDetailTwoService;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.ControlDetailFiveVO;
import com.ejianc.business.control.vo.ControlDetailFourVO;
import com.ejianc.business.control.vo.ControlDetailSubVo;
import com.ejianc.business.control.vo.ControlDetailThreeVO;
import com.ejianc.business.control.vo.ControlDetailTwoVO;
import com.ejianc.business.control.vo.ControlDetailVO;
import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="controlService")
public class ControlServiceImpl
extends BaseServiceImpl<ControlMapper, ControlEntity>
implements IControlService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IShareProsubApi prosubApi;
    private static final String BILL_CODE = "SUB_CONTROL";
    private static final String BILL_CODE_KJXY = "SUB_CONTROL_KJXY";
    @Autowired
    private SessionManager sessionManager;
    private static final String CONTROL_COST_CODE = "P-i3X5840010";
    private static final String CONTROL_COST_DETAIL_CODE = "P-94k78t0012";
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private final String PC_XM_URL = "ejc-prosub-frontend/#/subcontractPrice/card?id=";
    private final String PC_KJXY_URL = "ejc-prosub-frontend/#/subcontractPrice/cardKJXY?id=";
    @Autowired
    private IControlService service;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBuildDutyApi buildDutyApi;
    @Autowired
    private IControlDetailService controlDetailService;
    @Autowired
    private IControlDetailTwoService controlDetailTwoService;
    @Autowired
    private IControlDetailThreeService controlDetailThreeService;
    @Autowired
    private IControlDetailFourService controlDetailFourService;
    @Autowired
    private IControlChangeHisService controlChangeHisService;
    @Autowired
    private IControlChangeService controlChangeService;
    @Autowired
    private IControlDetailFiveService controlDetailFiveService;
    @Autowired
    private IExecutionApi executionApi;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ControlVO saveOrUpdate(ControlVO saveOrUpdateVO, Boolean isControl) {
        List<ControlDetailFiveEntity> list;
        List<ControlDetailFourEntity> list2;
        List<ControlDetailThreeEntity> list3;
        List<ControlDetailTwoEntity> controlDetailTwoList;
        List<ControlDetailEntity> controlDetailList;
        ControlEntity entity = (ControlEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setId(IdWorker.getId());
            entity.setId(IdWorker.getId());
            entity.setChangeState(0);
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setChangeVersion(1);
            if (Boolean.FALSE.equals(isControl)) {
                BillCodeParam billCodeParam = entity.getType().equals(1) ? BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO) : BillCodeParam.build((String)BILL_CODE_KJXY, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setBillCode((String)billCode.getData());
            } else {
                entity.setBillCode(entity.getId().toString());
            }
        }
        if (CollectionUtils.isNotEmpty(controlDetailList = entity.getControlDetailList())) {
            for (ControlDetailEntity controlDetailEntity : controlDetailList) {
                if (null == controlDetailEntity.getId()) {
                    controlDetailEntity.setId(IdWorker.getId());
                }
                controlDetailEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(controlDetailTwoList = entity.getControlDetailTwoList())) {
            for (ControlDetailTwoEntity controlDetailTwoEntity : controlDetailTwoList) {
                if (null == controlDetailTwoEntity.getId()) {
                    controlDetailTwoEntity.setId(IdWorker.getId());
                }
                if ("del".equals(controlDetailTwoEntity.getRowState())) continue;
                controlDetailTwoEntity.setTwoChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(list3 = entity.getControlDetailThreeList())) {
            for (ControlDetailThreeEntity controlDetailThreeEntity : list3) {
                if (null == controlDetailThreeEntity.getId()) {
                    controlDetailThreeEntity.setId(IdWorker.getId());
                }
                if ("del".equals(controlDetailThreeEntity.getRowState())) continue;
                controlDetailThreeEntity.setThreeChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(list2 = entity.getControlDetailFourList())) {
            for (ControlDetailFourEntity controlDetailFourEntity : list2) {
                if (null == controlDetailFourEntity.getId()) {
                    controlDetailFourEntity.setId(IdWorker.getId());
                }
                if ("del".equals(controlDetailFourEntity.getRowState())) continue;
                controlDetailFourEntity.setFourChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(list = entity.getControlDetailFiveList())) {
            for (ControlDetailFiveEntity detail : list) {
                if (null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                if ("del".equals(detail.getRowState())) continue;
                detail.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (!Boolean.FALSE.equals(isControl)) return (ControlVO)BeanMapper.map((Object)((Object)entity), ControlVO.class);
        super.saveOrUpdate((Object)entity, false);
        if (!ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(entity.getType())) return (ControlVO)BeanMapper.map((Object)((Object)entity), ControlVO.class);
        String string = this.getLinkUrl(entity.getId(), entity.getType());
        String billTypeCode = ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7.getBillTypeCode();
        ExecutionVO executionVO = this.targetCost((ControlVO)BeanMapper.map((Object)((Object)entity), ControlVO.class), string, entity.getSubType(), billTypeCode);
        this.logger.info("\u7b56\u5212\u6210\u672c\u63a8\u9001\u6570\u636e:{}", (Object)JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u7b56\u5212\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        this.logger.info("\u5355\u636eid-{}\u7b56\u5212\u6210\u672c\u63a8\u9001\u6210\u529f\uff01", (Object)entity.getId());
        return (ControlVO)BeanMapper.map((Object)((Object)entity), ControlVO.class);
    }

    @Override
    public String getLinkUrl(Long id, Integer type) {
        return this.getBaseHost() + (ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(type) ? "ejc-prosub-frontend/#/subcontractPrice/card?id=" : "ejc-prosub-frontend/#/subcontractPrice/cardKJXY?id=") + id;
    }

    @Override
    public ExecutionVO targetCost(ControlVO controlVO, String linkUrl, Integer subType, String billType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(controlVO.getId());
        totalVO.setTenantId(controlVO.getTenantId());
        totalVO.setBillCode(controlVO.getBillCode());
        totalVO.setOrgId(controlVO.getOrgId());
        totalVO.setBillType(billType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != controlVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(controlVO.getCreateTime()));
        }
        switch (subType) {
            case 1: {
                totalVO.setBussinessType(BussinessTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7_\u4e13\u4e1a.getCode());
                break;
            }
            case 2: {
                totalVO.setBussinessType(BussinessTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7_\u52b3\u52a1.getCode());
                break;
            }
            case 3: {
                totalVO.setBussinessType(BussinessTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7_\u5176\u4ed6.getCode());
                break;
            }
            case 4: {
                totalVO.setBussinessType(BussinessTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7_\u7279\u79cd\u8bbe\u5907\u79df\u8d41.getCode());
                break;
            }
            default: {
                throw new BusinessException("\u62db\u6807\u63a7\u5236\u4ef7id-[" + String.valueOf(controlVO.getId()) + "]\u9519\u8bef\u7684\u5206\u5305\u7c7b\u522b\uff1a[" + controlVO.getSubType() + "]");
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        if (ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(controlVO.getType())) {
            if (controlVO.getProjectId() == null) {
                throw new BusinessException("\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7b56\u5212\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
            }
            totalVO.setProjectId(controlVO.getProjectId());
        }
        if (controlVO.getOrgId() == null) {
            throw new BusinessException(ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(controlVO.getType()) ? "\u9879\u76ee\u90e8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7b56\u5212\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee" : "\u5206\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a\uff0c\u7b56\u5212\u6210\u672c\u63a8\u9001\u5931\u8d25");
        }
        totalVO.setOrgId(controlVO.getOrgId());
        totalVO.setMoney(controlVO.getControlMny());
        totalVO.setTaxMoney(controlVO.getControlTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (!ControlVO.\u5206\u5305\u7c7b\u522b_\u5176\u4ed6\u5206\u5305.equals(controlVO.getSubType())) {
            DetailExecutionVO detailExecutionVO;
            if (CollectionUtils.isNotEmpty((Collection)controlVO.getControlDetailList())) {
                for (ControlDetailVO detail : controlVO.getControlDetailList()) {
                    if ("del".equals(detail.getRowState())) continue;
                    detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());
                    if (ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    if (ControlVO.\u5206\u5305\u7c7b\u522b_\u4e13\u4e1a\u5206\u5305.equals(subType)) {
                        detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                    } else {
                        detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    }
                    detailExecutionVO.setDocId(detail.getDocId());
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setName(detail.getDetailName());
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    detailExecutionVO.setUnitName(detail.getUnit());
                    detailExecutionVO.setNum(detail.getProjectNum());
                    detailExecutionVO.setMoney(detail.getControlMny());
                    detailExecutionVO.setTaxMoney(detail.getControlTaxMny());
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    detailExecutionVO.setPrice(detail.getControlPrice());
                    detailExecutionVO.setTaxPrice(detail.getControlTaxPrice());
                    detailExecutionVO.setTaxRate(detail.getControlTaxRate());
                    detailExecutionVO.setMemo(detail.getMemo());
                    if (null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)controlVO.getControlDetailTwoList())) {
                for (ControlDetailVO detail : controlVO.getControlDetailTwoList()) {
                    if ("del".equals(detail.getRowState())) continue;
                    detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    if (ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    if (ControlVO.\u5206\u5305\u7c7b\u522b_\u4e13\u4e1a\u5206\u5305.equals(subType)) {
                        detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                    } else {
                        detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    }
                    detailExecutionVO.setDocId(detail.getDocId());
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setName(detail.getDetailName());
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    detailExecutionVO.setUnitName(detail.getUnit());
                    detailExecutionVO.setNum(detail.getTwoProjectNum());
                    detailExecutionVO.setMoney(detail.getTwoControlMny());
                    detailExecutionVO.setTaxMoney(detail.getTwoControlTaxMny());
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    detailExecutionVO.setPrice(detail.getTwoControlPrice());
                    detailExecutionVO.setTaxPrice(detail.getTwoControlTaxPrice());
                    detailExecutionVO.setTaxRate(detail.getTwoControlTaxRate());
                    detailExecutionVO.setMemo(detail.getTwoMemo());
                    if (null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)controlVO.getControlDetailThreeList())) {
                for (ControlDetailVO detail : controlVO.getControlDetailThreeList()) {
                    if ("del".equals(detail.getRowState())) continue;
                    detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    if (ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    if (ControlVO.\u5206\u5305\u7c7b\u522b_\u4e13\u4e1a\u5206\u5305.equals(subType)) {
                        detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                    } else {
                        detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    }
                    detailExecutionVO.setDocId(detail.getDocId());
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setName(detail.getDetailName());
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    detailExecutionVO.setUnitName(detail.getUnit());
                    detailExecutionVO.setNum(detail.getThreeProjectNum());
                    detailExecutionVO.setMoney(detail.getThreeControlMny());
                    detailExecutionVO.setTaxMoney(detail.getThreeControlTaxMny());
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    detailExecutionVO.setPrice(detail.getThreeControlPrice());
                    detailExecutionVO.setTaxPrice(detail.getThreeControlTaxPrice());
                    detailExecutionVO.setTaxRate(detail.getThreeControlTaxRate());
                    detailExecutionVO.setMemo(detail.getThreeMemo());
                    if (null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)controlVO.getControlDetailFourList())) {
                for (ControlDetailVO detail : controlVO.getControlDetailFourList()) {
                    if ("del".equals(detail.getRowState())) continue;
                    detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(detail.getId());
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    if (ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u53d8\u66f4.getBillTypeCode().equals(billType) || ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae\u53d8\u66f4.getBillTypeCode().equals(billType)) {
                        detailExecutionVO.setSourceBillId(detail.getControlId());
                    } else {
                        detailExecutionVO.setSourceBillId(controlVO.getId());
                    }
                    detailExecutionVO.setCategoryId(detail.getDocCategoryId());
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    if (ControlVO.\u5206\u5305\u7c7b\u522b_\u4e13\u4e1a\u5206\u5305.equals(subType)) {
                        detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                    } else {
                        detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    }
                    detailExecutionVO.setDocId(detail.getDocId());
                    detailExecutionVO.setCode(detail.getDetailCode());
                    detailExecutionVO.setName(detail.getDetailName());
                    detailExecutionVO.setUnitId(detail.getUnitId());
                    detailExecutionVO.setUnitName(detail.getUnit());
                    detailExecutionVO.setNum(detail.getFourProjectNum());
                    detailExecutionVO.setMoney(detail.getFourControlMny());
                    detailExecutionVO.setTaxMoney(detail.getFourControlTaxMny());
                    detailExecutionVO.setSpec(detail.getDetailMeasurementRules());
                    detailExecutionVO.setPrice(detail.getFourControlPrice());
                    detailExecutionVO.setTaxPrice(detail.getFourControlTaxPrice());
                    detailExecutionVO.setTaxRate(detail.getFourControlTaxRate());
                    detailExecutionVO.setMemo(detail.getFourMemo());
                    if (null != detail.getCreateTime()) {
                        detailExecutionVO.setBillDate(sdf.format(detail.getCreateTime()));
                    }
                    detailList.add(detailExecutionVO);
                }
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    private String getBaseHost() {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
    }

    @Override
    public ParamsCheckVO checkParams(ControlVO vo, Object o) {
        String status = this.responseIsCost(vo);
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkControlAllMny(vo));
        this.responseDetailIsCost(vo);
        paramsCheckVOS.addAll(this.checkControlDetailMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ControlVO queryDetail(Long id) {
        ControlEntity controlEntity = (ControlEntity)((Object)super.selectById((Serializable)id));
        ControlVO controlVO = (ControlVO)BeanMapper.map((Object)((Object)controlEntity), ControlVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("controlId", new Parameter("eq", (Object)id));
        List detailEntityListDb = this.controlDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (ControlDetailEntity cdEntity : detailEntityList) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, ControlDetailVO.class);
            controlVO.setControlDetailList(resultMapList);
        } else {
            controlVO.setControlDetailList(BeanMapper.mapList(detailEntityList, ControlDetailVO.class));
        }
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("controlId", new Parameter("eq", (Object)id));
        List detailEntityListDb2 = this.controlDetailTwoService.queryList(queryParam, false);
        ArrayList detailEntityList2 = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb2)) {
            detailEntityListDb2.forEach(entity -> {
                if (null == entity.getTwoChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getTwoChangeType()) {
                    detailEntityList2.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList2)) {
            for (ControlDetailTwoEntity cdEntity : detailEntityList2) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList2, ControlDetailTwoVO.class);
            controlVO.setControlDetailTwoList(resultMapList);
        } else {
            controlVO.setControlDetailTwoList(BeanMapper.mapList(detailEntityList2, ControlDetailTwoVO.class));
        }
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("controlId", new Parameter("eq", (Object)id));
        List detailEntityListDb3 = this.controlDetailThreeService.queryList(queryParam, false);
        ArrayList detailEntityList3 = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb3)) {
            detailEntityListDb3.forEach(entity -> {
                if (null == entity.getThreeChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getThreeChangeType()) {
                    detailEntityList3.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList3)) {
            for (ControlDetailThreeEntity cdEntity : detailEntityList3) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList3, ControlDetailThreeVO.class);
            controlVO.setControlDetailThreeList(resultMapList);
        } else {
            controlVO.setControlDetailThreeList(BeanMapper.mapList(detailEntityList3, ControlDetailThreeVO.class));
        }
        QueryParam queryParam4 = new QueryParam();
        queryParam4.getParams().put("controlId", new Parameter("eq", (Object)id));
        List detailEntityListDb4 = this.controlDetailFourService.queryList(queryParam, false);
        ArrayList detailEntityList4 = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb4)) {
            detailEntityListDb4.forEach(entity -> {
                if (null == entity.getFourChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getFourChangeType()) {
                    detailEntityList4.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList4)) {
            for (ControlDetailFourEntity cdEntity : detailEntityList4) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList4, ControlDetailFourVO.class);
            controlVO.setControlDetailFourList(resultMapList);
        } else {
            controlVO.setControlDetailFourList(BeanMapper.mapList(detailEntityList4, ControlDetailFourVO.class));
        }
        QueryParam queryParam5 = new QueryParam();
        queryParam5.getParams().put("controlId", new Parameter("eq", (Object)id));
        List detailEntityListDb5 = this.controlDetailFiveService.queryList(queryParam, false);
        ArrayList detailEntityList5 = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb5)) {
            detailEntityListDb5.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList5.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList5)) {
            for (ControlDetailFiveEntity cdEntity : detailEntityList5) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList5, ControlDetailFiveVO.class);
            controlVO.setControlDetailFiveList(resultMapList);
        } else {
            controlVO.setControlDetailFiveList(BeanMapper.mapList(detailEntityList5, ControlDetailFiveVO.class));
        }
        if (null != controlEntity.getChangeVersion() && controlEntity.getChangeVersion() > 0) {
            controlVO.setChangeHisVOList(this.controlChangeService.queryDetailRecord(controlEntity.getId()));
        }
        return controlVO;
    }

    private String responseIsCost(ControlVO controlVO) {
        CommonResponse response = this.paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        if ("1".equals(valueData)) {
            return "1";
        }
        if ("0".equals(valueData) && (buildDutyVO == null || buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)) {
            throw new BusinessException("\u9879\u76ee\u672a\u505a\u9879\u76ee\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        return "1";
    }

    private String responseDetailIsCost(ControlVO controlVO) {
        CommonResponse responseDetail;
        List laborDetailList;
        List proSubDetailList;
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        Integer subType = controlVO.getSubType();
        Map<Object, Object> costMap = new HashMap();
        if (subType == 1 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(proSubDetailList = buildDutyVO.getProSubDetailList()))) {
            costMap = proSubDetailList.stream().filter(s -> s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BaseVO::getId));
        }
        if (subType == 2 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(laborDetailList = buildDutyVO.getLaborDetailList()))) {
            costMap = laborDetailList.stream().filter(s -> s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BaseVO::getId));
        }
        if (!(responseDetail = this.paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE)).isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + responseDetail.getMsg());
        }
        String valueDataDetail = ((ParamRegisterSetVO)responseDetail.getData()).getValueData();
        Assert.hasText((String)valueDataDetail, (String)"\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("1".equals(valueDataDetail)) {
            return "1";
        }
        if ("0".equals(valueDataDetail)) {
            List controlDetailFourList;
            List controlDetailThreeList;
            List controlDetailTwoList;
            List controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty((Collection)controlDetailList)) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().filter(s -> !"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb51\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailTwoList = controlVO.getControlDetailTwoList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().filter(s -> !"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb52\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailThreeList = controlVO.getControlDetailThreeList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().filter(s -> !"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb53\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailFourList = controlVO.getControlDetailFourList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().filter(s -> !"del".equals(s.getRowState())).anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6807\u6bb54\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
        }
        return "1";
    }

    private List<ParamsCheckVO> checkControlAllMny(ControlVO controlVO) {
        CommonResponse billParamByCode;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        HashMap numMasterPlanMap = new HashMap();
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = BigDecimal.ZERO;
        if (buildDutyVO != null) {
            planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info(" \u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7>\u7b56\u5212\u6210\u672c\u603b\u4ef7*X%\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal compareNum = ComputeUtil.safeMultiply((BigDecimal)planedTotalCostTaxMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)controlVO.getControlTaxMny(), (BigDecimal)compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u5927\u4e8e\u7b56\u5212\u6210\u672c\u603b\u4ef7");
                        paramsCheckDsVO.setWarnName("\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u5927\u4e8e\u7b56\u5212\u6210\u672c\u603b\u4ef7");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u4e3a:").append(ComputeUtil.nullToZero((BigDecimal)controlVO.getControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u603b\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)controlVO.getControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlVO controlVO) {
        CommonResponse billParamByCode;
        List laborDetailList;
        List proSubDetailList;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        List controlDetailList = controlVO.getControlDetailList();
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        Integer subType = controlVO.getSubType();
        Map<Object, Object> costMap = new HashMap();
        if (subType == 1 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(proSubDetailList = buildDutyVO.getProSubDetailList()))) {
            costMap = proSubDetailList.stream().filter(s -> s.getProSubDocId() != null).collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
        }
        if (subType == 2 && buildDutyVO != null && CollectionUtils.isNotEmpty((Collection)(laborDetailList = buildDutyVO.getLaborDetailList()))) {
            costMap = laborDetailList.stream().filter(s -> s.getLaborDocId() != null).collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId())).isSuccess() && null != billParamByCode.getData()) {
            StringBuffer stringBuffer;
            ParamsCheckDsVO paramsCheckDsVO;
            BigDecimal compareNum;
            BigDecimal roleValue;
            ArrayList<ParamsCheckDsVO> checkDsVOS;
            ParamsCheckVO paramsCheckVO;
            BigDecimal costMny;
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (ControlDetailVO detailVO : controlVO.getControlDetailList()) {
                    if ("del".equals(detailVO.getRowState())) continue;
                    costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        paramsCheckVO = new ParamsCheckVO();
                        checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getControlTaxMny(), (BigDecimal)compareNum)) {
                            paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb51\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                for (ControlDetailVO detailVO : controlVO.getControlDetailTwoList()) {
                    if ("del".equals(detailVO.getRowState())) continue;
                    costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        paramsCheckVO = new ParamsCheckVO();
                        checkDsVOS = new ArrayList();
                        roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getTwoControlTaxMny(), (BigDecimal)compareNum)) {
                            paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb52\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getTwoControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getTwoControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
            for (ControlDetailVO detailVO : controlVO.getControlDetailThreeList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    paramsCheckVO = new ParamsCheckVO();
                    checkDsVOS = new ArrayList();
                    roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getThreeControlTaxMny(), (BigDecimal)compareNum)) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb53\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getThreeControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getThreeControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
            for (ControlDetailVO detailVO : controlVO.getControlDetailFourList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    paramsCheckVO = new ParamsCheckVO();
                    checkDsVOS = new ArrayList();
                    roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getFourControlTaxMny(), (BigDecimal)compareNum)) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb54\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getFourControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getFourControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<Object> importData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ControlDetailSubVo> successList = new ArrayList<ControlDetailSubVo>();
        ArrayList<ControlDetailSubVo> errorList = new ArrayList<ControlDetailSubVo>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap<String, List> codeMap = new HashMap<String, List>();
        HashMap<String, List> codeMap1 = new HashMap<String, List>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 6) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal taxRate1;
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailCode = (String)datas.get(0);
                this.logger.info("detailCode--" + detailCode);
                this.logger.info("int----" + i);
                String detailName = (String)datas.get(1);
                String detailNum = (String)datas.get(2);
                String detailTaxRate = (String)datas.get(3);
                String detailTaxPrice = (String)datas.get(4);
                String detailTaxMny = (String)datas.get(5);
                ControlDetailSubVo detailVO = new ControlDetailSubVo();
                detailVO.setDetailName(detailName);
                detailVO.setDetailCode(detailCode);
                if (StringUtils.isBlank((String)detailCode)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    List data;
                    CommonResponse listCommonResponse = null;
                    CommonResponse listCommonResponse1 = null;
                    if (type == 2 || type == 4) {
                        if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                            listCommonResponse = this.labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                            if (listCommonResponse.isSuccess()) {
                                data = (List)listCommonResponse.getData();
                                if (data == null) {
                                    detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                    errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                    detailVO.setIsMatch("\u672a\u5339\u914d");
                                } else {
                                    codeMap.put(detailCode, data);
                                    for (LabsubItemVO labsubItemVO : data) {
                                        if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                            detailVO.setWorkContent(labsubItemVO.getJobContent());
                                            detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                            detailVO.setUnit(labsubItemVO.getUnitName());
                                            detailVO.setDetailCode(detailCode);
                                            detailVO.setDetailName(detailName);
                                            detailVO.setIsMatch("\u5df2\u5339\u914d");
                                            detailVO.setDocId(labsubItemVO.getId());
                                            detailVO.setDocCategoryId(labsubItemVO.getCategoryId());
                                            continue;
                                        }
                                        detailVO.setIsMatch("\u672a\u5339\u914d");
                                        detailVO.setErrorMessage("\u6e05\u5355\u7f16\u7801\u4e0e\u6e05\u5355\u540d\u79f0\u672a\u5339\u914d");
                                        errorsMsgBuilder.append("\u672a\u5339\u914d");
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                        }
                    } else if (type == 1) {
                        if (MapUtils.isEmpty(codeMap1) || codeMap1.get(detailCode) == null) {
                            listCommonResponse1 = this.prosubApi.queryItemListByCodes(Arrays.asList(detailCode));
                            if (listCommonResponse1.isSuccess()) {
                                data = (List)listCommonResponse1.getData();
                                if (data == null) {
                                    detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                    errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                    detailVO.setIsMatch("\u672a\u5339\u914d");
                                } else {
                                    codeMap1.put(detailCode, data);
                                    for (LabsubItemVO labsubItemVO : data) {
                                        if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                            detailVO.setWorkContent(labsubItemVO.getJobContent());
                                            detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                            detailVO.setUnit(labsubItemVO.getUnitName());
                                            detailVO.setDetailCode(detailCode);
                                            detailVO.setDetailName(detailName);
                                            detailVO.setIsMatch("\u5df2\u5339\u914d");
                                            continue;
                                        }
                                        detailVO.setIsMatch("\u672a\u5339\u914d");
                                        errorsMsgBuilder.append("\u672a\u5339\u914d");
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                        }
                    } else if (type == 3) {
                        detailVO.setDetailCode(detailCode);
                    }
                }
                if (type == 3) {
                    if (StringUtils.isBlank((String)detailName)) {
                        detailVO.setErrorMessage("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                        errorsMsgBuilder.append("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    } else {
                        detailVO.setDetailName(detailName);
                    }
                }
                if (StringUtils.isBlank((String)detailNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailNum);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            this.forSetProjectNum(detailVO, taxRate1, tabKey);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            this.forSetTaxRate(detailVO, taxRate1, tabKey);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal num = new BigDecimal(detailNum);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setFinalTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setFinalMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalTaxMny(taxMny);
                    this.forSetMoneyData(detailVO, tabKey, taxPrice, price, mny, taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setControlTax(tax1);
                    detailVO.setFinalTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setFinalTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setFinalTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalPrice(price);
                    this.forSetMoneyData(detailVO, tabKey, taxPrice, price, mny, taxMny);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setControlTax(detailTax);
                    detailVO.setFinalTax(detailTax);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<Object> importOtherData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ControlDetailSubVo> successList = new ArrayList<ControlDetailSubVo>();
        ArrayList<ControlDetailSubVo> errorList = new ArrayList<ControlDetailSubVo>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap codeMap = new HashMap();
        HashMap codeMap1 = new HashMap();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 8) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal taxRate1;
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailName = (String)datas.get(0);
                String detailWorkContent = (String)datas.get(1);
                String detailMeasurementRules = (String)datas.get(2);
                String detailUnit = (String)datas.get(3);
                String detailNum = (String)datas.get(4);
                String detailTaxRate = (String)datas.get(5);
                String detailTaxPrice = (String)datas.get(6);
                String detailTaxMny = (String)datas.get(7);
                ControlDetailSubVo detailVO = new ControlDetailSubVo();
                detailVO.setDetailName(detailName);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank((String)detailName)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailName(detailName);
                }
                if (StringUtils.isBlank((String)detailWorkContent)) {
                    detailVO.setErrorMessage("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setWorkContent(detailWorkContent);
                }
                if (StringUtils.isBlank((String)detailMeasurementRules)) {
                    detailVO.setErrorMessage("\u8ba1\u91cf\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailMeasurementRules(detailMeasurementRules);
                }
                if (StringUtils.isBlank((String)detailUnit)) {
                    detailVO.setErrorMessage("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setUnit(detailUnit);
                }
                if (StringUtils.isBlank((String)detailNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailNum);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            this.forSetProjectNum(detailVO, taxRate1, tabKey);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            this.forSetTaxRate(detailVO, taxRate1, tabKey);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal num = new BigDecimal(detailNum);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setFinalTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setFinalMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalTaxMny(taxMny);
                    this.forSetMoneyData(detailVO, tabKey, taxPrice, price, mny, taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setFinalTax(tax1);
                    detailVO.setControlTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setFinalTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setFinalTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalPrice(price);
                    this.forSetMoneyData(detailVO, tabKey, taxPrice, price, mny, taxMny);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setFinalTax(detailTax);
                    detailVO.setControlTax(detailTax);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<Object> importEquipmentData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ControlDetailSubVo> successList = new ArrayList<ControlDetailSubVo>();
        ArrayList<ControlDetailSubVo> errorList = new ArrayList<ControlDetailSubVo>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap<String, List> codeMap = new HashMap<String, List>();
        HashMap codeMap1 = new HashMap();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 7) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailCode = (String)datas.get(0);
                String detailName = (String)datas.get(1);
                String detailNewNum = (String)datas.get(2);
                String useTime = (String)datas.get(3);
                String detailTaxRate = (String)datas.get(4);
                String detailTaxPrice = (String)datas.get(5);
                String detailTaxMny = (String)datas.get(6);
                ControlDetailSubVo detailVO = new ControlDetailSubVo();
                detailVO.setDetailName(detailName);
                detailVO.setDetailCode(detailCode);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank((String)detailCode)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    CommonResponse listCommonResponse = null;
                    Object listCommonResponse1 = null;
                    if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                        listCommonResponse = this.labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                        if (listCommonResponse.isSuccess()) {
                            List data = (List)listCommonResponse.getData();
                            if (data == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                detailVO.setIsMatch("\u672a\u5339\u914d");
                            } else {
                                codeMap.put(detailCode, data);
                                for (LabsubItemVO labsubItemVO : data) {
                                    if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                        detailVO.setWorkContent(labsubItemVO.getJobContent());
                                        detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                        detailVO.setUnit(labsubItemVO.getUnitName());
                                        detailVO.setDetailCode(detailCode);
                                        detailVO.setDetailName(detailName);
                                        detailVO.setDocId(labsubItemVO.getId());
                                        detailVO.setDocCategoryId(labsubItemVO.getCategoryId());
                                        detailVO.setIsMatch("\u5df2\u5339\u914d");
                                        continue;
                                    }
                                    detailVO.setIsMatch("\u672a\u5339\u914d");
                                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u7801\u4e0e\u6e05\u5355\u540d\u79f0\u672a\u5339\u914d");
                                    errorsMsgBuilder.append("\u672a\u5339\u914d");
                                }
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                        errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailNewNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailNewNum);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            this.forSetNewProjectNum(detailVO, taxRate1, tabKey);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal useTimeData = null;
                if (StringUtils.isBlank((String)useTime)) {
                    detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        useTimeData = new BigDecimal(useTime);
                        if (useTimeData.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            this.forSetUseTime(detailVO, useTimeData, tabKey);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            this.forSetTaxRate(detailVO, taxRate1, tabKey);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal detailNewNumData = new BigDecimal(detailNewNum);
                BigDecimal num = ComputeUtil.safeMultiply((BigDecimal)detailNewNumData, (BigDecimal)useTimeData);
                this.forSetProjectNum(detailVO, num, tabKey);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setFinalTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setFinalMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalTaxMny(taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setControlTax(tax1);
                    detailVO.setFinalTax(tax1);
                    this.forSetMoneyData(detailVO, tabKey, taxPrice, price, mny, taxMny);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setFinalTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setFinalTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setFinalPrice(price);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setControlTax(detailTax);
                    detailVO.setFinalTax(detailTax);
                    this.forSetMoneyData(detailVO, tabKey, taxPrice, price, mny, taxMny);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private void forSetUseTime(ControlDetailSubVo detailVO, BigDecimal useTimeData, String tabKey) {
        if (tabKey.equals("tabOne")) {
            detailVO.setUseDateMonth(useTimeData);
        } else if (tabKey.equals("tabTwo")) {
            detailVO.setTwoUseDateMonth(useTimeData);
        } else if (tabKey.equals("tabThree")) {
            detailVO.setThreeUseDateMonth(useTimeData);
        } else if (tabKey.equals("tabFour")) {
            detailVO.setFourUseDateMonth(useTimeData);
        }
    }

    private void forSetNewProjectNum(ControlDetailSubVo detailVO, BigDecimal taxRate1, String tabKey) {
        if (tabKey.equals("tabOne")) {
            detailVO.setNewNum(taxRate1);
        } else if (tabKey.equals("tabTwo")) {
            detailVO.setTwoNewNum(taxRate1);
        } else if (tabKey.equals("tabThree")) {
            detailVO.setThreeNewNum(taxRate1);
        } else if (tabKey.equals("tabFour")) {
            detailVO.setFourNewNum(taxRate1);
        }
    }

    private void forSetMoneyData(ControlDetailSubVo detailVO, String tabKey, BigDecimal taxPrice, BigDecimal price, BigDecimal mny, BigDecimal taxMny) {
        if (tabKey.equals("tabOne")) {
            detailVO.setControlPrice(price);
            detailVO.setControlTaxPrice(taxPrice);
            detailVO.setControlMny(mny);
            detailVO.setControlTaxMny(taxMny);
        } else if (tabKey.equals("tabTwo")) {
            detailVO.setTwoControlPrice(price);
            detailVO.setTwoControlTaxPrice(taxPrice);
            detailVO.setTwoControlMny(mny);
            detailVO.setTwoControlTaxMny(taxMny);
        } else if (tabKey.equals("tabThree")) {
            detailVO.setThreeControlPrice(price);
            detailVO.setThreeControlTaxPrice(taxPrice);
            detailVO.setThreeControlMny(mny);
            detailVO.setThreeControlTaxMny(taxMny);
        } else if (tabKey.equals("tabFour")) {
            detailVO.setFourControlPrice(price);
            detailVO.setFourControlTaxPrice(taxPrice);
            detailVO.setFourControlMny(mny);
            detailVO.setFourControlTaxMny(taxMny);
        }
        detailVO.setFinalDiffPrice(ComputeUtil.convertToMinusNumber((BigDecimal)mny));
        detailVO.setFinalDiffTaxPrice(ComputeUtil.convertToMinusNumber((BigDecimal)taxMny));
    }

    private void forSetTaxRate(ControlDetailSubVo detailVO, BigDecimal taxRate1, String tabKey) {
        if (tabKey.equals("tabOne")) {
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setControlTaxRate(taxRate1);
        } else if (tabKey.equals("tabTwo")) {
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setTwoControlTaxRate(taxRate1);
        } else if (tabKey.equals("tabThree")) {
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setThreeControlTaxRate(taxRate1);
        } else if (tabKey.equals("tabFour")) {
            detailVO.setFinalTaxRate(taxRate1);
            detailVO.setFourControlTaxRate(taxRate1);
        }
    }

    private void forSetProjectNum(ControlDetailSubVo detailVO, BigDecimal taxRate1, String tabKey) {
        if (tabKey.equals("tabOne")) {
            detailVO.setProjectNum(taxRate1);
        } else if (tabKey.equals("tabTwo")) {
            detailVO.setTwoProjectNum(taxRate1);
        } else if (tabKey.equals("tabThree")) {
            detailVO.setThreeProjectNum(taxRate1);
        } else if (tabKey.equals("tabFour")) {
            detailVO.setFourProjectNum(taxRate1);
        }
    }
}

