package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.control.vo.ControlDetailSubVo;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.AdjustVO;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.process.mapper.AdjustMapper;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 分包价格调整与增补
 * 
 * @author generator
 * 
 */
@Service("adjustService")
public class AdjustServiceImpl extends BaseServiceImpl<AdjustMapper, AdjustEntity> implements IAdjustService{


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ADJUST_CODE";//此处需要根据实际修改
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;
    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public AdjustVO insertOrUpdate(AdjustVO saveOrUpdateVO) {
        AdjustEntity entity = BeanMapper.map(saveOrUpdateVO, AdjustEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getAdjustDetailList())){
            Set useTypeSet = new HashSet();
            List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
            for (AdjustDetailEntity detailEntity : detailList) {
                if(!"del".equals(detailEntity.getRowState()) && StringUtils.isNotBlank(detailEntity.getDetailUseTypeName())) {
                    useTypeSet.add(detailEntity.getDetailUseTypeName());
                }
            }
            if (CollectionUtils.isNotEmpty(useTypeSet)) {
                entity.setUseType(String.join(",", useTypeSet));
            }
        }

        service.saveOrUpdate(entity, false);
//        List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
//        if (CollectionUtils.isNotEmpty(detailList)) {
//            Map<String, Long> idMap = new HashMap<>();
//            for (AdjustDetailEntity cdEntity : detailList) {
//                idMap.put(cdEntity.getTid(), cdEntity.getId());
//            }
//            for (AdjustDetailEntity cdEntity : detailList) {
//                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
//                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
//                }
//            }
//            detailService.saveOrUpdateBatch(detailList);
//        }
        return BeanMapper.map(entity, AdjustVO.class);
    }

    @Override
    public AdjustVO queryDetail(Long id) {
        AdjustEntity entity = service.selectById(id);
        AdjustVO vo = BeanMapper.map(entity, AdjustVO.class);
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("treeIndex", "asc");
//        List<AdjustDetailEntity> detailEntityListDb = detailService.queryList(queryParam, false);
//        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
//            for (AdjustDetailEntity cdEntity : detailEntityListDb) {
//                cdEntity.setTid(cdEntity.getId().toString());
//                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
//                cdEntity.setRowState("edit");
//            }
//            List<AdjustDetailVO> resultMapList = BeanMapper.mapList(detailEntityListDb, AdjustDetailVO.class);
//            sortIntMethod(resultMapList);
//            vo.setAdjustDetailList(TreeNodeBUtil.buildTree(resultMapList));
//
//        } else {
//            vo.setAdjustDetailList(BeanMapper.mapList(detailEntityListDb, AdjustDetailVO.class));
//        }
        return vo;
    }

    @Override
    public CommonResponse<Object> importData(Integer type, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<AdjustDetailVO> successList = new ArrayList<>();
        List<AdjustDetailVO> errorList = new ArrayList<>();
        Map<String, ContractDetailVO> map = new HashMap<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            Map<String, List<LabsubItemVO>> codeMap = new HashMap<>();
            Map<String,List<ProsubItemVO>> codeMap1 = new HashMap<>();

            List<List<String>> result = ExcelReader.readExcel(mf);
            DecimalFormat decimalFormat = new DecimalFormat("0.00000000");

            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 7) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 1; i < result.size(); i++) {

                    List<String> datas = result.get(i);
//                    logger.info("detailCode222");
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String detailCode = datas.get(0);//清单编号
                    logger.info("detailCode--" + detailCode);
                    logger.info("int----" + i);
                    String detailName = datas.get(1);//清单名称
                    //分包报送数据
                    String detailNum = datas.get(2);//工程量
                    String detailTaxRate = datas.get(3);//税率
                    String detailTaxPrice = datas.get(4);//综合单价
                    String detailTaxMny = datas.get(5);//综合金额
                    String memo = datas.get(6);//备注
                    AdjustDetailVO detailVO = new AdjustDetailVO();
                    detailVO.setDetailName(detailName);
                    detailVO.setDetailCode(detailCode);

                    detailVO.setTreeIndex(String.valueOf(i));
                    if (org.apache.commons.lang.StringUtils.isBlank(detailCode)) {
                        detailVO.setErrorMessage("清单编号不能为空");
                    } else {
                        CommonResponse<List<LabsubItemVO>> listCommonResponse = null;
                        CommonResponse<List<ProsubItemVO>> listCommonResponse1 = null;
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数

                        if (type == 0 || type == 2) {
                            if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                                listCommonResponse = labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                                if (listCommonResponse.isSuccess()) {
                                    List<LabsubItemVO> data = listCommonResponse.getData();
                                    if (data == null) {
                                        detailVO.setErrorMessage("根据清单编号查询失败");
                                        errorsMsgBuilder.append("根据清单编号查询失败！");
                                        detailVO.setIsMatch("未匹配");
                                    } else {
                                        // 将查询到的数据缓存到map中
                                        codeMap.put(detailCode, data);
                                        // 封装数据
                                        for (LabsubItemVO labsubItemVO : data) {
                                            if (labsubItemVO.getTrawlingCode().equals(detailCode)  && labsubItemVO.getTrawlingName().equals(detailName)) {
                                                detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                                detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                                detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                                detailVO.setDetailCode(detailCode);
                                                detailVO.setDetailName(detailName);
                                                detailVO.setIsMatch("已匹配");
                                            } else {
                                                detailVO.setIsMatch("未匹配");
                                                detailVO.setErrorMessage("清单编码与档案编码未匹配");

                                                errorsMsgBuilder.append("未匹配");
                                            }
                                        }
                                    }
                                } else {
                                    detailVO.setErrorMessage("根据清单编号查询失败");
                                    errorsMsgBuilder.append("根据清单编号查询失败！");
                                }
                            }else {
                                detailVO.setErrorMessage("根据清单编号查询失败");
                                errorsMsgBuilder.append("根据清单编号查询失败！");
                            }
                        }else if(type == 1){
                            if (MapUtils.isEmpty(codeMap1) || codeMap1.get(detailCode) == null) {
                                listCommonResponse1 = prosubApi.queryItemListByCodes(Arrays.asList(detailCode));
                                if (listCommonResponse1.isSuccess()) {
                                    List<ProsubItemVO> data = listCommonResponse1.getData();
                                    if (data == null) {
                                        detailVO.setErrorMessage("根据清单编号查询失败");
                                        errorsMsgBuilder.append("根据清单编号查询失败！");
                                        detailVO.setIsMatch("未匹配");
                                    } else {
                                        // 将查询到的数据缓存到map中
                                        codeMap1.put(detailCode, data);
                                        // 封装数据
                                        for (ProsubItemVO labsubItemVO : data) {
                                            if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                                detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                                detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                                detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                                detailVO.setDetailCode(detailCode);
                                                detailVO.setDetailName(detailName);
                                                detailVO.setDocId(labsubItemVO.getId());
                                                detailVO.setIsMatch("已匹配");
                                            } else {
                                                detailVO.setIsMatch("未匹配");
                                                errorsMsgBuilder.append("未匹配");
                                            }
                                        }
                                    }
                                } else {
                                    detailVO.setErrorMessage("根据清单编号查询失败");
                                    errorsMsgBuilder.append("根据清单编号查询失败！");
                                }
                            }else {
                                detailVO.setErrorMessage("根据清单编号查询失败");
                                errorsMsgBuilder.append("根据清单编号查询失败！");
                            }
                        }else if(type == 3){
                            detailVO.setDetailCode(detailCode);
                        }
                    }
                    //

                    if(type == 3){
                        if (org.apache.commons.lang.StringUtils.isBlank(detailName)) {
                            detailVO.setErrorMessage("清单名称不能为空");
                            errorsMsgBuilder.append("清单名称不能为空");
                        }else{
                            detailVO.setDetailName(detailName);
                        }
                    }



//                    //必填项校验
//                    if (detailCode == null || TextUtils.isEmpty(detailCode)) {
//                        detailVO.setErrorMessage("清单编号不能为空！");
//                        errorsMsgBuilder.append("清单编号不能为空！");
//                    }
//
//                    if (detailName == null || TextUtils.isEmpty(detailName)) {
//                        detailVO.setErrorMessage("清单名称不能为空！");
//                        errorsMsgBuilder.append("清单名称不能为空！");
//                    }

                    // 工程量
                    if (org.apache.commons.lang.StringUtils.isBlank(detailNum)) {
                        detailVO.setErrorMessage("工程量不能为空");
                        errorsMsgBuilder.append("工程量不能为空！");
                    } else {
                        try {
                            BigDecimal detailNum1 = new BigDecimal(detailNum);
                            if (detailNum1.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("工程量不可小于0");
                                errorsMsgBuilder.append("工程量不可小于0！");
                            } else {
                                detailVO.setDetailSubNum(detailNum1);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("工程量必须为数字");
                            errorsMsgBuilder.append("工程量必须为数字！");
                        }
                    }


                    // 税率
                    if (org.apache.commons.lang.StringUtils.isBlank(detailTaxRate)) {
                        detailVO.setErrorMessage("税率不可为空");
                        errorsMsgBuilder.append("税率不能为空！");
                    } else {
                        try {
                            BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                            if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                                errorsMsgBuilder.append("税率不可小于0！");
                            } else {
                                detailVO.setDetailTaxRate(taxRate1);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                            errorsMsgBuilder.append("税率必须为数字！");
                        }
                    }

                    //税率
                    BigDecimal tax = ComputeUtil.safeDiv(new BigDecimal(detailTaxRate),new BigDecimal("100"));
                    BigDecimal one = new BigDecimal("1.0");
                    //工程量
                    BigDecimal num = new BigDecimal(detailNum);

                    // 综合单价
                    if (org.apache.commons.lang.StringUtils.isNotBlank(detailTaxPrice)) {
                        //综合单价
                        BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                        detailVO.setDetailSubTaxPrice(taxPrice);
                        //无税单价
                        BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                        detailVO.setDetailSubPrice(price);
                        //无税金额
                        BigDecimal mny = ComputeUtil.safeMultiply(num,price);
                        detailVO.setDetailSubMny(mny);
                        //含税金额
                        BigDecimal taxMny = ComputeUtil.safeMultiply(mny, ComputeUtil.safeAdd(one, tax));
                        detailVO.setDetailSubTaxMny(taxMny);
                        //综合税额
                        BigDecimal tax1 = ComputeUtil.safeMultiply(mny, tax);
                        detailVO.setDetailSubTax(tax1);


                    }
//                    if (StringUtils.isBlank(detailTaxPrice)) {
//                        detailVO.setErrorMessage("综合单价不能为空");
//                        errorsMsgBuilder.append("综合单价不能为空！");
//
//                    } else {
//                        try {
//                            BigDecimal taxRate1 = new BigDecimal(detailTaxPrice);
//                            if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
//                                detailVO.setErrorMessage("综合单价不能小于0");
//                                errorsMsgBuilder.append("综合单价不能小于0！");
//                            } else {
//                                detailVO.setDetailTaxPrice(taxRate1);
//                            }
//                        } catch (Exception e) {
//                            detailVO.setErrorMessage("综合单价必须为数字");
//                            errorsMsgBuilder.append("综合单价必须为数字！");
//                        }
//                    }

                    // 综合金额
                    if (org.apache.commons.lang.StringUtils.isNotBlank(detailTaxMny)) {
                        BigDecimal taxMny = new BigDecimal(detailTaxMny);
                        detailVO.setDetailSubTaxMny(taxMny);
                        //无税金额
                        BigDecimal mny = ComputeUtil.safeDiv(taxMny,ComputeUtil.safeAdd(one, tax));
                        detailVO.setDetailSubMny(mny);
                        //含税单价
                        BigDecimal taxPrice = ComputeUtil.safeDiv(taxMny, num);
                        detailVO.setDetailSubTaxPrice(taxPrice);
                        //无税单价
                        BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                        detailVO.setDetailSubPrice(price);
                        //综合税额
                        BigDecimal detailTax = ComputeUtil.safeMultiply(tax,mny);
                        detailVO.setDetailSubTax(detailTax);

                    }
//                    if (StringUtils.isBlank(detailTaxMny)) {
//                        detailVO.setErrorMessage(" 综合金额不能为空");
//                        errorsMsgBuilder.append(" 综合金额不能为空！");
//
//                    } else {
//                        try {
//                            BigDecimal taxRate1 = new BigDecimal(detailTaxMny);
//                            if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
//                                detailVO.setErrorMessage(" 综合金额不能小于0");
//                                errorsMsgBuilder.append(" 综合金额不能小于0！");
//                            } else {
//                                detailVO.setDetailTaxMny(taxRate1);
//                            }
//                        } catch (Exception e) {
//                            detailVO.setErrorMessage("综合金额必须为数字");
//                            errorsMsgBuilder.append("综合金额必须为数字！");
//                        }
//                    }

                    //备注
                    if(org.apache.commons.lang.StringUtils.isNotBlank(memo)){
                        detailVO.setDetailMemo(memo);
                    }

                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(detailVO);
                    } else {
                        successList.add(detailVO);
                    }
                }

            }
        }


        //填充往期数据
//        getLastDetail(selectContractId,successList,id);



        //构建树
//        resList = createTreeData(resList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);

    }

    @Override
    public CommonResponse<Object> importOtherData(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<AdjustDetailVO> successList = new ArrayList<>();
        List<AdjustDetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        Map<String, List<LabsubItemVO>> codeMap = new HashMap<>();
        Map<String,List<ProsubItemVO>> codeMap1 = new HashMap<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            if (result.get(0).size() != 9) {
                throw new BusinessException("请按照导入模板导入数据");
            }
            for (int i = 1; i < result.size(); i++) {

                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();

                String detailName = datas.get(0);//清单名称
                String detailWorkContent = datas.get(1);//工作内容
                String detailMeasurementRules = datas.get(2);//计量规则
                String detailUnit = datas.get(3);//计量单位
                String detailNum = datas.get(4);//工程量
                String detailTaxRate = datas.get(5);//税率
                String detailTaxPrice = datas.get(6);//综合单价
                String detailTaxMny = datas.get(7);//综合金额
                String memo = datas.get(8);//备注

                AdjustDetailVO detailVO = new AdjustDetailVO();
                detailVO.setDetailName(detailName);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank(detailName)) {
                    detailVO.setErrorMessage("清单名称不能为空");
                    errorsMsgBuilder.append("清单名称不能为空");
                }else{
                    detailVO.setDetailName(detailName);
                }

                if (StringUtils.isBlank(detailWorkContent)) {
                    detailVO.setErrorMessage("工作内容不能为空");
                    errorsMsgBuilder.append("工作内容不能为空");
                }else{
                    detailVO.setDetailWorkContent(detailWorkContent);
                }

                if (StringUtils.isBlank(detailMeasurementRules)) {
                    detailVO.setErrorMessage("计量规则不能为空");
                    errorsMsgBuilder.append("计量规则不能为空");
                }else{
                    detailVO.setDetailMeasurementRules(detailMeasurementRules);
                }

                if (StringUtils.isBlank(detailUnit)) {
                    detailVO.setErrorMessage("计量单位不能为空");
                    errorsMsgBuilder.append("计量单位不能为空");
                }else{
                    detailVO.setDetailUnit(detailUnit);
                }

                // 工程量
                if (StringUtils.isBlank(detailNum)) {
                    detailVO.setErrorMessage("工程量不能为空");
                    errorsMsgBuilder.append("工程量不能为空！");
                } else {
                    try {
                        BigDecimal detailNum1 = new BigDecimal(detailNum);
                        if (detailNum1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("工程量不可小于0");
                            errorsMsgBuilder.append("工程量不可小于0！");
                        } else {
                            detailVO.setDetailSubNum(detailNum1);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("工程量必须为数字");
                        errorsMsgBuilder.append("工程量必须为数字！");
                    }
                }


                // 税率
                if (StringUtils.isBlank(detailTaxRate)) {
                    detailVO.setErrorMessage("税率不可为空");
                    errorsMsgBuilder.append("税率不能为空！");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("税率不可小于0");
                            errorsMsgBuilder.append("税率不可小于0！");
                        } else {
                            detailVO.setDetailTaxRate(taxRate1);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("税率必须为数字");
                        errorsMsgBuilder.append("税率必须为数字！");
                    }
                }

                //税率
                BigDecimal tax = ComputeUtil.safeDiv(new BigDecimal(detailTaxRate),new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                //工程量
                BigDecimal num = new BigDecimal(detailNum);

                // 综合单价
                if (StringUtils.isNotBlank(detailTaxPrice)) {
                    //综合单价
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubPrice(price);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeMultiply(num,price);
                    detailVO.setDetailSubMny(mny);
                    //含税金额
                    BigDecimal taxMny = ComputeUtil.safeMultiply(mny, ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubTaxMny(taxMny);

                    //综合税额
                    BigDecimal tax1 = ComputeUtil.safeMultiply(mny, tax);
//                    detailVO.setDetailTax(tax1);
                    detailVO.setDetailSubTax(tax1);

                }
                // 综合金额
                if (StringUtils.isNotBlank(detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailSubTaxMny(taxMny);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeDiv(taxMny,ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubMny(mny);
                    //含税单价
                    BigDecimal taxPrice = ComputeUtil.safeDiv(taxMny, num);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubPrice(price);
                    //综合税额
                    BigDecimal detailTax = ComputeUtil.safeMultiply(tax,mny);
                    detailVO.setDetailSubTax(detailTax);

                }

                //备注
                if(StringUtils.isNotBlank(memo)){
                    detailVO.setDetailMemo(memo);
                }

                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                } else {
                    successList.add(detailVO);
                }
            }

        }

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @Override
    public CommonResponse<Object> importEquipmentData( HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<AdjustDetailVO> successList = new ArrayList<>();
        List<AdjustDetailVO> errorList = new ArrayList<>();
        Map<String, AdjustDetailVO> map = new HashMap<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        Map<String, List<LabsubItemVO>> codeMap = new HashMap<>();
        Map<String,List<ProsubItemVO>> codeMap1 = new HashMap<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.get(0).size() != 8) {
                throw new BusinessException("请按照导入模板导入数据");
            }
            for (int i = 1; i < result.size(); i++) {

                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();

                String detailCode = datas.get(0);//清单编号
                String detailName = datas.get(1);//清单名称
                String detailNewNum = datas.get(2);//工程量-新
                String useTime = datas.get(3);//使用时间（月）
                String detailTaxRate = datas.get(4);//税率
                String detailTaxPrice = datas.get(5);//综合单价
                String detailTaxMny = datas.get(6);//综合金额
                String memo = datas.get(7);//备注

                AdjustDetailVO detailVO = new AdjustDetailVO();
                detailVO.setDetailName(detailName);
                detailVO.setDetailCode(detailCode);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank(detailCode)) {
                    detailVO.setErrorMessage("清单编号不能为空");
                } else {
                    CommonResponse<List<LabsubItemVO>> listCommonResponse = null;
                    CommonResponse<List<ProsubItemVO>> listCommonResponse1 = null;
                    // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                    // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数

                    if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                        listCommonResponse = labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                        if (listCommonResponse.isSuccess()) {
                            List<LabsubItemVO> data = listCommonResponse.getData();
                            if (data == null) {
                                detailVO.setErrorMessage("根据清单编号查询失败");
                                errorsMsgBuilder.append("根据清单编号查询失败！");
                                detailVO.setIsMatch("未匹配");
                            } else {
                                // 将查询到的数据缓存到map中
                                codeMap.put(detailCode, data);
                                // 封装数据
                                for (LabsubItemVO labsubItemVO : data) {
                                    if (labsubItemVO.getTrawlingCode().equals(detailCode)  && labsubItemVO.getTrawlingName().equals(detailName)) {
                                        detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                        detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                        detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                        detailVO.setDetailCode(detailCode);
                                        detailVO.setDetailName(detailName);
                                        detailVO.setDocId(labsubItemVO.getId());
                                        detailVO.setIsMatch("已匹配");
                                    } else {
                                        detailVO.setIsMatch("未匹配");
                                        detailVO.setErrorMessage("清单编码与清单名称未匹配");
                                        errorsMsgBuilder.append("未匹配");
                                    }
                                }
                            }
                        } else {
                            detailVO.setErrorMessage("根据清单编号查询失败");
                            errorsMsgBuilder.append("根据清单编号查询失败！");
                        }
                    }else {
                        detailVO.setErrorMessage("根据清单编号查询失败");
                        errorsMsgBuilder.append("根据清单编号查询失败！");
                    }
                }


                // 工程量
                if (StringUtils.isBlank(detailNewNum)) {
                    detailVO.setErrorMessage("工程量不能为空");
                    errorsMsgBuilder.append("工程量不能为空！");
                } else {
                    try {
                        BigDecimal detailNewNum1 = new BigDecimal(detailNewNum);
                        if (detailNewNum1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("工程量不可小于0");
                            errorsMsgBuilder.append("工程量不可小于0！");
                        } else {
                            detailVO.setDetailSubNum(detailNewNum1);
                            detailVO.setDetailSubNewNum(detailNewNum1);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("工程量必须为数字");
                        errorsMsgBuilder.append("工程量必须为数字！");
                    }
                }

                // 使用时间（月）
                BigDecimal useTimeData = null;
                if (StringUtils.isBlank(useTime)) {
                    detailVO.setErrorMessage("使用时间（月）不能为空");
                    errorsMsgBuilder.append("使用时间（月）不能为空！");
                } else {
                    try {
                        useTimeData = new BigDecimal(useTime);
                        if (useTimeData.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("使用时间（月）不可小于0");
                            errorsMsgBuilder.append("使用时间（月）不可小于0！");
                        } else {
                            detailVO.setDetailSubUseDate(useTimeData);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("使用时间（月）必须为数字");
                        errorsMsgBuilder.append("使用时间（月）必须为数字！");
                    }
                }

                // 税率
                if (StringUtils.isBlank(detailTaxRate)) {
                    detailVO.setErrorMessage("税率不可为空");
                    errorsMsgBuilder.append("税率不能为空！");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("税率不可小于0");
                            errorsMsgBuilder.append("税率不可小于0！");
                        } else {
                            detailVO.setDetailTaxRate(taxRate1);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("税率必须为数字");
                        errorsMsgBuilder.append("税率必须为数字！");
                    }
                }

                //税率
                BigDecimal tax = ComputeUtil.safeDiv(new BigDecimal(detailTaxRate),new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                //综合工程量
                BigDecimal detailNewNumData = new BigDecimal(detailNewNum);
                BigDecimal num = ComputeUtil.safeMultiply(detailNewNumData, useTimeData);

                // 综合单价
                if (StringUtils.isNotBlank(detailTaxPrice)) {
                    //综合单价
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubPrice(price);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeMultiply(num,price);
                    detailVO.setDetailSubMny(mny);
                    //含税金额
                    BigDecimal taxMny = ComputeUtil.safeMultiply(mny, ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubTaxMny(taxMny);
                    //综合税额
                    BigDecimal tax1 = ComputeUtil.safeMultiply(mny, tax);
                    detailVO.setDetailSubTax(tax1);
                }


                // 综合金额
                if (StringUtils.isNotBlank(detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailSubTaxMny(taxMny);
                    //无税金额
                    BigDecimal mny = ComputeUtil.safeDiv(taxMny,ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubMny(mny);
                    //含税单价
                    BigDecimal taxPrice = ComputeUtil.safeDiv(taxMny, num);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    //无税单价
                    BigDecimal price = ComputeUtil.safeDiv(taxPrice,ComputeUtil.safeAdd(one, tax));
                    detailVO.setDetailSubPrice(price);
                    //综合税额
                    BigDecimal detailTax = ComputeUtil.safeMultiply(tax,mny);
                    detailVO.setDetailSubTax(detailTax);

                }
                //备注
                if(StringUtils.isNotBlank(memo)){
                    detailVO.setDetailMemo(memo);
                }

                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                } else {
                    successList.add(detailVO);
                }
            }

        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    private static void sortIntMethod(List<AdjustDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                AdjustDetailVO o1Detail = objectMapper.convertValue(o1, AdjustDetailVO.class);
                AdjustDetailVO o2Detail = objectMapper.convertValue(o2, AdjustDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }


}
