/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ProsubBillTypeChangeCodeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeCodeEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractAsyncService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
@RequestMapping(value={"contractAsync"})
public class ContractAsyncController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/getWatermarkAttachment"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> getWatermarkAttachment(Long id, String contractType) {
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            if ("contract".equals(contractType)) {
                ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
                if (null == contractEntity) {
                    throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5408\u540cid\u662f\u5426\u6b63\u786e\uff01");
                }
                String billTypeCodeStr = ProsubBillTypeCodeEnum.getEnumByContractType((Integer)contractEntity.getContractType()).getDescription();
                WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(), contractEntity.getBillCode(), billTypeCodeStr, "proSubContract");
                Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
                this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO, "contract");
            } else if ("changeContract".equals(contractType)) {
                ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(id));
                if (null == changeEntity) {
                    throw new BusinessException("\u83b7\u53d6\u53d8\u66f4\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53d8\u66f4\u5408\u540cid\u662f\u5426\u6b63\u786e\uff01");
                }
                String changeBillTypeCodeStr = ProsubBillTypeChangeCodeEnum.getEnumByContractType((Integer)changeEntity.getContractType()).getDescription();
                WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(), changeEntity.getBillCode(), changeBillTypeCodeStr, "proSubChangeContract");
                Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
                this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO, "changeContract");
            }
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u5408\u540c\u6c34\u5370\u6587\u4ef6\u6210\u529f\uff01");
    }
}

