package com.ejianc.business.prosub.warn;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.base.annotation.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class DateUtil {

    public final static String CURRENT_YEAR = getCurrentYear();

    /**
     * 两个日期相差的天数，正数+1，负数-1
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getSubDay(Date startDate, Date endDate) {
        if(startDate == null || endDate == null){
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(sdf.format(startDate)));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(sdf.format(endDate)));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time1 - time2) / (1000 * 3600 * 24);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Integer days = Integer.parseInt(String.valueOf(betweenDays));
        return days < 0 ? days - 1 : days + 1;
    }

    /**
     * 两个日期相差的天数
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getBetweenDays(Date startDate, Date endDate) {
        if(startDate == null || endDate == null){
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(sdf.format(startDate)));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(sdf.format(endDate)));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time1 - time2) / (1000 * 3600 * 24);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /***
     * @Author mrsir_wxp
     * @Date 2021/2/1 比较两个日期大小，
     * @Description compareDate
     * @Param [dt1, dt2]
     * @Return 1：dt1>dt2,-1：dt1<dt2, 0相等
     */
    public static int compareDate(Date dt1, Date dt2) {
        try {
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            } else if (dt1.getTime() < dt2.getTime()) {
                return -1;
            } else {
                return 0;
            }
        } catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    /***
     * @Author mrsir_wxp
     * @Date 2021/2/1 比较两个日期大小，
     * @Description compareDate
     * @Param [dt1, dt2]
     * @Return 1：dt1>dt2,-1：dt1<dt2, 0相等
     */
    public static int compareDay(Date dt1, Date dt2) {
        dt1 = parseDate(formatDate(dt1));
        dt2 = parseDate(formatDate(dt2));
        return compareDate(dt1, dt2);
    }

    /**
     * 是否同一天
     * @param date1
     * @param date2
     * @return
     */
    public static boolean isSameDay(final Date date1, final Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return formatDate(date1).equals(formatDate(date2));
    }

    /**
     * 比较两个日期并取最大值或最小值
     * @param date1
     * @param date2
     * @param flag false-最小值，true-最大值
     * @return
     */
    public static Date maxDate(Date date1, Date date2, Boolean flag) {
        if(date1 == null) {
            return date2;
        }
        if(date2 == null){
            return date1;
        }
        if(flag){
            if(compareDate(date1, date2) < 0){
                return date2;
            }
            return date1;
        } else {
            if(compareDate(date1, date2) < 0){
                return date1;
            }
            return date2;
        }
    }

    /**
     * 比较两个日期并取最大值或最小值
     * @param date1
     * @param date2
     * @param flag false-最小值，true-最大值
     * @return
     */
    public static Date maxDay(Date date1, Date date2, Boolean flag) {
        if(date1 == null) {
            return date2;
        }
        if(date2 == null){
            return date1;
        }
        if(flag){
            if(compareDay(date1, date2) < 0){
                return date2;
            }
            return date1;
        } else {
            if(compareDay(date1, date2) < 0){
                return date1;
            }
            return date2;
        }
    }

    /**
     * 比较日期大小,如2020-10-23格式
     *
     * @param t1
     * @param t2
     * @return
     */
    public static int compareDateStr(String t1, String t2) {
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        int trr2 = Integer.parseInt(t2.replaceAll("-", ""));
        if (trr1 > trr2) {
            return 1;
        } else if (trr1 < trr2) {
            return -1;
        }
        return 0;
    }

    /**
     * 获取日期月份字符串，如01，02...
     * @description 这里使用了String.format（）方法，作用就是格式化输出参数. “%02d”是指定输出格式，%作先导标记，0表示自动补0, 2的意思是最小长度为2（如果用4，则1输出0001），d表示整数
     * @param date
     * @return
     */
    public static String getMonthStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(Calendar.MONTH) + 1;
        return String.format("%02d",month);
    }

    /**
     * 获取日期年份字符串，如2021，2022...
     * @description 这里使用了String.format（）方法，作用就是格式化输出参数. “%02d”是指定输出格式，%作先导标记，0表示自动补0, 2的意思是最小长度为2（如果用4，则1输出0001），d表示整数
     * @param date
     * @return
     */
    public static String getYearStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String year = String.valueOf(cal.get(Calendar.YEAR));// 当前年
        return year;
    }

    /**
     * 获取当前年
     * @return
     */
    public static String getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String year = String.valueOf(cal.get(Calendar.YEAR));// 当前年
        return year;
    }

    /**
     * 将中文环境下的1-周一，...，7-周日，改为西方习惯的2-周一，...，7-周六，1-周日
     * @param day
     * @return
     */
    public static Integer turnZnDayOfWeek(Integer day) {
        day = day + 1;
        return day > 7 ? day - 6 : day;
    }

    /**
     * 将中文环境下的1-28及最后一天，改为对应日期
     * @param day
     * @return
     */
    public static Integer turnZnDayOfMonth(Integer day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if(day > cal.getActualMaximum(Calendar.DAY_OF_MONTH)){// 月末加1天，2月29日或者31、32特殊处理
            cal.add(Calendar.DATE, 1);
            day = cal.get(Calendar.DAY_OF_MONTH );
            return day;
        }
        return day == 30 ? cal.getActualMaximum(Calendar.DAY_OF_MONTH) : day;
    }

    /**
     * 将任意日期格式字符串，重新翻译为标准日期格式
     * @param str
     * @return
     * @throws ParseException
     */
    public static String formatDateString(String str) {
        if(StringUtils.isEmpty(str)){
            return str;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat bsdf = new SimpleDateFormat(getDateFormat(str));
        String dateStr = null;
        try {
            dateStr = sdf.format(bsdf.parse(str));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    /**
     * 常规自动日期格式识别
     * @param str 时间字符串
     * @return Date
     * @author dc
     */
    public static String getDateFormat(String str) {
        boolean year = false;
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if(pattern.matcher(str.substring(0, 4)).matches()) {
            year = true;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        if(!year) {
            if(str.contains("月") || str.contains("-") || str.contains("/")) {
                if(Character.isDigit(str.charAt(0))) {
                    index = 1;
                }
            }else {
                index = 3;
            }
        }
        for (int i = 0; i < str.length(); i++) {
            char chr = str.charAt(i);
            if(Character.isDigit(chr)) {
                if(index==0) {
                    sb.append("y");
                }
                if(index==1) {
                    sb.append("M");
                }
                if(index==2) {
                    sb.append("d");
                }
                if(index==3) {
                    sb.append("H");
                }
                if(index==4) {
                    sb.append("m");
                }
                if(index==5) {
                    sb.append("s");
                }
                if(index==6) {
                    sb.append("S");
                }
            }else {
                if(i>0) {
                    char lastChar = str.charAt(i-1);
                    if(Character.isDigit(lastChar)) {
                        index++;
                    }
                }
                sb.append(chr);
            }
        }
        return sb.toString();
    }

    /**
     * 转换成标准日期格式
     * @param date
     * @return
     */
    public static String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    /**
     * 转换成标准日期格式
     * @param date
     * @return
     */
    public static String formatSeconds(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    /**
     * 转换成标准日期格式
     * @param date
     * @return
     */
    public static Date parseDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return new Date();
    }

    /**
     * 转换成标准日期格式
     * @param date
     * @return
     */
    public static Date parseSeconds(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return new Date();
    }

    /**
     * 计算两个日期的月份之差
     *
     * @param t1
     * @param t2
     * @return
     */
    public static int subMonth(String t1, String t2,SimpleDateFormat sdf) {
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = sdf.parse(t1);
            d2 = sdf.parse(t2);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(d1);
        end.setTime(d2);
        int result = end.get(Calendar.MONTH) - start.get(Calendar.MONTH);
        int month = (end.get(Calendar.YEAR) - start.get(Calendar.YEAR)) * 12;
        return Math.abs(month + result);
    }

    /**
     * 2016-11-10 07:33:23, 则返回2016-11-10 00:00:00
     */
    public static Date beginOfDate(@NotNull final Date date) {
        return DateUtils.truncate(date, Calendar.DATE);
    }

    /**
     * 2017-1-23 07:33:23, 则返回2017-1-23 23:59:59.999
     */
    public static Date endOfDate(@NotNull final Date date) {
        return new Date(nextDate(date).getTime() - 1);
    }

    /**
     * 2016-11-10 07:33:23, 则返回2016-11-11 00:00:00
     */
    public static Date nextDate(@NotNull final Date date) {
        return DateUtils.ceiling(date, Calendar.DATE);
    }

    public static Date addMonths(@NotNull final Date date, int amount) {
        return DateUtils.addMonths(date, amount);
    }

    public static Date addDays(@NotNull final Date date, final int amount) {
        return DateUtils.addDays(date, amount);
    }

    public static Date addHours(@NotNull final Date date, final int amount) {
        return DateUtils.addHours(date, amount);
    }

    public static Date setHours(final Date date, final int amount) {
        if(date == null){
            return date;
        }
        return DateUtils.setHours(date, amount);
    }
    /**
     * 根据月结算日计算日期
     * 例如月结算日为15，日期为2022/05/13，则创建时间2022/05/15
     *
     * @param date            日期
     * @param day 月结算日
     * @return 返回结果
     */
    public static Date monthDay(Date date, Integer day) {
        Calendar from = Calendar.getInstance();
        from.setTime(date);
        int fromYear = from.get(Calendar.YEAR);
        int fromMonth = from.get(Calendar.MONTH);
        Calendar myCalendar = new GregorianCalendar(fromYear, fromMonth, day);
        return myCalendar.getTime();
    }

    /**
     * 日期加一天
     *
     * @param date 需要计算的日期
     * @return 计算后结果
     */
    public static Date dayAddOne(Date date) {
        return addDays(date, 1);
    }

    /**
     * 日期减一天
     *
     * @param date 需要计算的日期
     * @return 计算后结果
     */
    public static Date daySubOne(Date date) {
        return addDays(date, -1);
    }

    /**
     * 月份加一月
     *
     * @param date 需要计算的日期
     * @return 计算结果
     */
    public static Date monthAddOne(Date date) {
        return addMonths(date, 1);
    }

    /**
     * 计算2个日期之间相差的  以年、月、日为单位，各自计算结果是多少
     * 比如：2011-02-02 到  2017-03-03
     * 计算结果为 1,1  一个月零一天
     *
     * @param fromDate 开始日期
     * @param toDate   结束日期
     * @return 计算结果
     */
    public static int[] dayCompare(Date fromDate, Date toDate) {
        toDate = dayAddOne(toDate);// 结束日期加一，2022-05-08到2022-06-07为1，0
        Instant instant = fromDate.toInstant();
        Instant instant1 = toDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate one = instant.atZone(zoneId).toLocalDate();
        LocalDate two = instant1.atZone(zoneId).toLocalDate();
        int year = Period.between(one, two).getYears();
        int month = Period.between(one, two).getMonths();
        int day = Period.between(one, two).getDays();
        month = year * 12 + month;
        return new int[]{month, day};
    }


    /**
     * 两个日期拼接
     * @param date1
     * @param date2
     * @return
     */
    public static Date concatDate(Date date1, Date date2) {
        String date = DateUtil.formatSeconds(date1).substring(0,10) + DateUtil.formatSeconds(date2).substring(10);
        return parseSeconds(date);
    }

    public static void main(String[] args) {
        String date1 = "2022-10-07 23:59:59";
        String date2 = "2022-11-06 00:00:01";
        System.out.println(date1.substring(0,10) + date2.substring(10));

        System.out.println(JSONObject.toJSONString(dayCompare(parseSeconds(date1), parseSeconds(date2))));
    }

    /**
     * 获取某月的第一天
     * @param date
     * @return
     */
    public static Date getMonthFirstDate(Date date){

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(date).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month = Integer.valueOf(split[1]);

        //获取某月的第一天
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(Calendar.YEAR,year);
        c1.set(Calendar.MONTH,Month-1);
        int firstDay = c1.getActualMinimum(Calendar.DAY_OF_MONTH);
        c1.set(Calendar.DAY_OF_MONTH,firstDay);
        Date monthFirstDate = c1.getTime();

        return monthFirstDate;
    }

    /**
     * 获取某月的最后一天
     * @param date
     * @return
     */
    public static Date getMonthLastDate(Date date){

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(date).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month = Integer.valueOf(split[1]);

        //获取某月的最后一天
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(Calendar.YEAR,year);
        c2.set(Calendar.MONTH,Month-1);
        int lastDay = c2.getActualMaximum(Calendar.DAY_OF_MONTH);
        c2.set(Calendar.DAY_OF_MONTH,lastDay);
        Date monthLastDate = c2.getTime();

        return monthLastDate;
    }

}
